/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters.BodyDamage;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import zombie.FliesSound;
import zombie.GameTime;
import zombie.GameWindow;
import zombie.Lua.LuaEventManager;
import zombie.SandboxOptions;
import zombie.WorldSoundManager;
import zombie.ZomboidGlobals;
import zombie.audio.parameters.ParameterZombieState;
import zombie.characterTextures.BloodBodyPartType;
import zombie.characters.BodyDamage.BodyPart;
import zombie.characters.BodyDamage.BodyPartLast;
import zombie.characters.BodyDamage.BodyPartType;
import zombie.characters.BodyDamage.Metabolics;
import zombie.characters.BodyDamage.Thermoregulator;
import zombie.characters.ClothingWetness;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoSurvivor;
import zombie.characters.IsoZombie;
import zombie.characters.Moodles.MoodleType;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.SpriteRenderer;
import zombie.core.math.PZMath;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.debug.DebugType;
import zombie.inventory.InventoryItem;
import zombie.inventory.types.Drainable;
import zombie.inventory.types.Food;
import zombie.inventory.types.HandWeapon;
import zombie.inventory.types.Literature;
import zombie.iso.IsoGridSquare;
import zombie.iso.weather.ClimateManager;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.ServerOptions;
import zombie.util.StringUtils;
import zombie.vehicles.BaseVehicle;
import zombie.vehicles.VehiclePart;
import zombie.vehicles.VehicleWindow;

public final class BodyDamage {
    public final ArrayList<BodyPart> BodyParts = new ArrayList(18);
    public final ArrayList<BodyPartLast> BodyPartsLastState = new ArrayList(18);
    public int DamageModCount = 60;
    public float InfectionGrowthRate = 0.001f;
    public float InfectionLevel = 0.0f;
    public boolean IsInfected;
    public float InfectionTime = -1.0f;
    public float InfectionMortalityDuration = -1.0f;
    public float FakeInfectionLevel = 0.0f;
    public boolean IsFakeInfected;
    public float OverallBodyHealth = 100.0f;
    public float StandardHealthAddition = 0.002f;
    public float ReducedHealthAddition = 0.0013f;
    public float SeverlyReducedHealthAddition = 8.0E-4f;
    public float SleepingHealthAddition = 0.02f;
    public float HealthFromFood = 0.015f;
    public float HealthReductionFromSevereBadMoodles = 0.0165f;
    public int StandardHealthFromFoodTime = 1600;
    public float HealthFromFoodTimer = 0.0f;
    public float BoredomLevel = 0.0f;
    public float BoredomDecreaseFromReading = 0.5f;
    public float InitialThumpPain = 14.0f;
    public float InitialScratchPain = 18.0f;
    public float InitialBitePain = 25.0f;
    public float InitialWoundPain = 80.0f;
    public float ContinualPainIncrease = 0.001f;
    public float PainReductionFromMeds = 30.0f;
    public float StandardPainReductionWhenWell = 0.01f;
    public int OldNumZombiesVisible = 0;
    public int CurrentNumZombiesVisible = 0;
    public float PanicIncreaseValue = 7.0f;
    public float PanicIncreaseValueFrame = 0.035f;
    public float PanicReductionValue = 0.06f;
    public float DrunkIncreaseValue = 20.5f;
    public float DrunkReductionValue = 0.0042f;
    public boolean IsOnFire = false;
    public boolean BurntToDeath = false;
    public float Wetness = 0.0f;
    public float CatchACold = 0.0f;
    public boolean HasACold = false;
    public float ColdStrength = 0.0f;
    public float ColdProgressionRate = 0.0112f;
    public int TimeToSneezeOrCough = 0;
    public int MildColdSneezeTimerMin = 600;
    public int MildColdSneezeTimerMax = 800;
    public int ColdSneezeTimerMin = 300;
    public int ColdSneezeTimerMax = 600;
    public int NastyColdSneezeTimerMin = 200;
    public int NastyColdSneezeTimerMax = 300;
    public int SneezeCoughActive = 0;
    public int SneezeCoughTime = 0;
    public int SneezeCoughDelay = 25;
    public float UnhappynessLevel = 0.0f;
    public float ColdDamageStage = 0.0f;
    public IsoGameCharacter ParentChar;
    private float FoodSicknessLevel = 0.0f;
    private int RemotePainLevel;
    private float Temperature = 37.0f;
    private float lastTemperature = 37.0f;
    private float PoisonLevel = 0.0f;
    private boolean reduceFakeInfection = false;
    private float painReduction = 0.0f;
    private float coldReduction = 0.0f;
    private Thermoregulator thermoregulator;
    public static final float InfectionLevelToZombify = 0.001f;
    static String behindStr = "BEHIND";
    static String leftStr = "LEFT";
    static String rightStr = "RIGHT";

    public BodyDamage(IsoGameCharacter isoGameCharacter) {
        this.BodyParts.add(new BodyPart(BodyPartType.Hand_L, isoGameCharacter));
        this.BodyParts.add(new BodyPart(BodyPartType.Hand_R, isoGameCharacter));
        this.BodyParts.add(new BodyPart(BodyPartType.ForeArm_L, isoGameCharacter));
        this.BodyParts.add(new BodyPart(BodyPartType.ForeArm_R, isoGameCharacter));
        this.BodyParts.add(new BodyPart(BodyPartType.UpperArm_L, isoGameCharacter));
        this.BodyParts.add(new BodyPart(BodyPartType.UpperArm_R, isoGameCharacter));
        this.BodyParts.add(new BodyPart(BodyPartType.Torso_Upper, isoGameCharacter));
        this.BodyParts.add(new BodyPart(BodyPartType.Torso_Lower, isoGameCharacter));
        this.BodyParts.add(new BodyPart(BodyPartType.Head, isoGameCharacter));
        this.BodyParts.add(new BodyPart(BodyPartType.Neck, isoGameCharacter));
        this.BodyParts.add(new BodyPart(BodyPartType.Groin, isoGameCharacter));
        this.BodyParts.add(new BodyPart(BodyPartType.UpperLeg_L, isoGameCharacter));
        this.BodyParts.add(new BodyPart(BodyPartType.UpperLeg_R, isoGameCharacter));
        this.BodyParts.add(new BodyPart(BodyPartType.LowerLeg_L, isoGameCharacter));
        this.BodyParts.add(new BodyPart(BodyPartType.LowerLeg_R, isoGameCharacter));
        this.BodyParts.add(new BodyPart(BodyPartType.Foot_L, isoGameCharacter));
        this.BodyParts.add(new BodyPart(BodyPartType.Foot_R, isoGameCharacter));
        for (BodyPart bodyPart : this.BodyParts) {
            this.BodyPartsLastState.add(new BodyPartLast());
        }
        this.RestoreToFullHealth();
        this.ParentChar = isoGameCharacter;
        if (this.ParentChar instanceof IsoPlayer) {
            this.thermoregulator = new Thermoregulator(this);
        }
        this.setBodyPartsLastState();
    }

    public BodyPart getBodyPart(BodyPartType bodyPartType) {
        return this.BodyParts.get(BodyPartType.ToIndex(bodyPartType));
    }

    public BodyPartLast getBodyPartsLastState(BodyPartType bodyPartType) {
        return this.BodyPartsLastState.get(BodyPartType.ToIndex(bodyPartType));
    }

    public void setBodyPartsLastState() {
        for (int i = 0; i < this.getBodyParts().size(); ++i) {
            BodyPart bodyPart = this.getBodyParts().get(i);
            BodyPartLast bodyPartLast = this.BodyPartsLastState.get(i);
            bodyPartLast.copy(bodyPart);
        }
    }

    public void load(ByteBuffer byteBuffer, int n) throws IOException {
        Object object;
        for (int i = 0; i < this.getBodyParts().size(); ++i) {
            object = this.getBodyParts().get(i);
            ((BodyPart)object).SetBitten(byteBuffer.get() == 1);
            ((BodyPart)object).setScratched(byteBuffer.get() == 1, false);
            ((BodyPart)object).setBandaged(byteBuffer.get() == 1, 0.0f);
            ((BodyPart)object).setBleeding(byteBuffer.get() == 1);
            ((BodyPart)object).setDeepWounded(byteBuffer.get() == 1);
            ((BodyPart)object).SetFakeInfected(byteBuffer.get() == 1);
            ((BodyPart)object).SetInfected(byteBuffer.get() == 1);
            ((BodyPart)object).SetHealth(byteBuffer.getFloat());
            if (n >= 37 && n <= 43) {
                byteBuffer.getInt();
            }
            if (n < 44) continue;
            if (((BodyPart)object).bandaged()) {
                ((BodyPart)object).setBandageLife(byteBuffer.getFloat());
            }
            ((BodyPart)object).setInfectedWound(byteBuffer.get() == 1);
            if (((BodyPart)object).isInfectedWound()) {
                ((BodyPart)object).setWoundInfectionLevel(byteBuffer.getFloat());
            }
            ((BodyPart)object).setBiteTime(byteBuffer.getFloat());
            ((BodyPart)object).setScratchTime(byteBuffer.getFloat());
            ((BodyPart)object).setBleedingTime(byteBuffer.getFloat());
            ((BodyPart)object).setAlcoholLevel(byteBuffer.getFloat());
            ((BodyPart)object).setAdditionalPain(byteBuffer.getFloat());
            ((BodyPart)object).setDeepWoundTime(byteBuffer.getFloat());
            ((BodyPart)object).setHaveGlass(byteBuffer.get() == 1);
            ((BodyPart)object).setGetBandageXp(byteBuffer.get() == 1);
            if (n >= 48) {
                ((BodyPart)object).setStitched(byteBuffer.get() == 1);
                ((BodyPart)object).setStitchTime(byteBuffer.getFloat());
            }
            ((BodyPart)object).setGetStitchXp(byteBuffer.get() == 1);
            ((BodyPart)object).setGetSplintXp(byteBuffer.get() == 1);
            ((BodyPart)object).setFractureTime(byteBuffer.getFloat());
            ((BodyPart)object).setSplint(byteBuffer.get() == 1, 0.0f);
            if (((BodyPart)object).isSplint()) {
                ((BodyPart)object).setSplintFactor(byteBuffer.getFloat());
            }
            ((BodyPart)object).setHaveBullet(byteBuffer.get() == 1, 0);
            ((BodyPart)object).setBurnTime(byteBuffer.getFloat());
            ((BodyPart)object).setNeedBurnWash(byteBuffer.get() == 1);
            ((BodyPart)object).setLastTimeBurnWash(byteBuffer.getFloat());
            ((BodyPart)object).setSplintItem(GameWindow.ReadString(byteBuffer));
            ((BodyPart)object).setBandageType(GameWindow.ReadString(byteBuffer));
            ((BodyPart)object).setCutTime(byteBuffer.getFloat());
            if (n >= 153) {
                ((BodyPart)object).setWetness(byteBuffer.getFloat());
            }
            if (n < 167) continue;
            ((BodyPart)object).setStiffness(byteBuffer.getFloat());
        }
        this.setBodyPartsLastState();
        this.setInfectionLevel(byteBuffer.getFloat());
        this.setFakeInfectionLevel(byteBuffer.getFloat());
        this.setWetness(byteBuffer.getFloat());
        this.setCatchACold(byteBuffer.getFloat());
        this.setHasACold(byteBuffer.get() == 1);
        this.setColdStrength(byteBuffer.getFloat());
        this.setUnhappynessLevel(byteBuffer.getFloat());
        this.setBoredomLevel(byteBuffer.getFloat());
        this.setFoodSicknessLevel(byteBuffer.getFloat());
        this.PoisonLevel = byteBuffer.getFloat();
        float f = byteBuffer.getFloat();
        this.setTemperature(f);
        this.setReduceFakeInfection(byteBuffer.get() == 1);
        this.setHealthFromFoodTimer(byteBuffer.getFloat());
        this.painReduction = byteBuffer.getFloat();
        this.coldReduction = byteBuffer.getFloat();
        this.InfectionTime = byteBuffer.getFloat();
        this.InfectionMortalityDuration = byteBuffer.getFloat();
        this.ColdDamageStage = byteBuffer.getFloat();
        this.calculateOverallHealth();
        if (n >= 153 && byteBuffer.get() == 1) {
            if (this.thermoregulator != null) {
                this.thermoregulator.load(byteBuffer, n);
            } else {
                object = new Thermoregulator(this);
                ((Thermoregulator)object).load(byteBuffer, n);
                DebugLog.log("Couldnt load Thermoregulator, == null");
            }
        }
    }

    public void save(ByteBuffer byteBuffer) throws IOException {
        for (int i = 0; i < this.getBodyParts().size(); ++i) {
            BodyPart bodyPart = this.getBodyParts().get(i);
            byteBuffer.put(bodyPart.bitten() ? (byte)1 : 0);
            byteBuffer.put(bodyPart.scratched() ? (byte)1 : 0);
            byteBuffer.put(bodyPart.bandaged() ? (byte)1 : 0);
            byteBuffer.put(bodyPart.bleeding() ? (byte)1 : 0);
            byteBuffer.put(bodyPart.deepWounded() ? (byte)1 : 0);
            byteBuffer.put(bodyPart.IsFakeInfected() ? (byte)1 : 0);
            byteBuffer.put(bodyPart.IsInfected() ? (byte)1 : 0);
            byteBuffer.putFloat(bodyPart.getHealth());
            if (bodyPart.bandaged()) {
                byteBuffer.putFloat(bodyPart.getBandageLife());
            }
            byteBuffer.put(bodyPart.isInfectedWound() ? (byte)1 : 0);
            if (bodyPart.isInfectedWound()) {
                byteBuffer.putFloat(bodyPart.getWoundInfectionLevel());
            }
            byteBuffer.putFloat(bodyPart.getBiteTime());
            byteBuffer.putFloat(bodyPart.getScratchTime());
            byteBuffer.putFloat(bodyPart.getBleedingTime());
            byteBuffer.putFloat(bodyPart.getAlcoholLevel());
            byteBuffer.putFloat(bodyPart.getAdditionalPain());
            byteBuffer.putFloat(bodyPart.getDeepWoundTime());
            byteBuffer.put(bodyPart.haveGlass() ? (byte)1 : 0);
            byteBuffer.put(bodyPart.isGetBandageXp() ? (byte)1 : 0);
            byteBuffer.put(bodyPart.stitched() ? (byte)1 : 0);
            byteBuffer.putFloat(bodyPart.getStitchTime());
            byteBuffer.put(bodyPart.isGetStitchXp() ? (byte)1 : 0);
            byteBuffer.put(bodyPart.isGetSplintXp() ? (byte)1 : 0);
            byteBuffer.putFloat(bodyPart.getFractureTime());
            byteBuffer.put(bodyPart.isSplint() ? (byte)1 : 0);
            if (bodyPart.isSplint()) {
                byteBuffer.putFloat(bodyPart.getSplintFactor());
            }
            byteBuffer.put(bodyPart.haveBullet() ? (byte)1 : 0);
            byteBuffer.putFloat(bodyPart.getBurnTime());
            byteBuffer.put(bodyPart.isNeedBurnWash() ? (byte)1 : 0);
            byteBuffer.putFloat(bodyPart.getLastTimeBurnWash());
            GameWindow.WriteString(byteBuffer, bodyPart.getSplintItem());
            GameWindow.WriteString(byteBuffer, bodyPart.getBandageType());
            byteBuffer.putFloat(bodyPart.getCutTime());
            byteBuffer.putFloat(bodyPart.getWetness());
            byteBuffer.putFloat(bodyPart.getStiffness());
        }
        byteBuffer.putFloat(this.InfectionLevel);
        byteBuffer.putFloat(this.getFakeInfectionLevel());
        byteBuffer.putFloat(this.getWetness());
        byteBuffer.putFloat(this.getCatchACold());
        byteBuffer.put(this.isHasACold() ? (byte)1 : 0);
        byteBuffer.putFloat(this.getColdStrength());
        byteBuffer.putFloat(this.getUnhappynessLevel());
        byteBuffer.putFloat(this.getBoredomLevel());
        byteBuffer.putFloat(this.getFoodSicknessLevel());
        byteBuffer.putFloat(this.PoisonLevel);
        byteBuffer.putFloat(this.Temperature);
        byteBuffer.put(this.isReduceFakeInfection() ? (byte)1 : 0);
        byteBuffer.putFloat(this.HealthFromFoodTimer);
        byteBuffer.putFloat(this.painReduction);
        byteBuffer.putFloat(this.coldReduction);
        byteBuffer.putFloat(this.InfectionTime);
        byteBuffer.putFloat(this.InfectionMortalityDuration);
        byteBuffer.putFloat(this.ColdDamageStage);
        byteBuffer.put(this.thermoregulator != null ? (byte)1 : 0);
        if (this.thermoregulator != null) {
            this.thermoregulator.save(byteBuffer);
        }
    }

    public boolean IsFakeInfected() {
        return this.isIsFakeInfected();
    }

    public void OnFire(boolean bl) {
        this.setIsOnFire(bl);
    }

    public boolean IsOnFire() {
        return this.isIsOnFire();
    }

    public boolean WasBurntToDeath() {
        return this.isBurntToDeath();
    }

    public void IncreasePanicFloat(float f) {
        float f2 = 1.0f;
        if (this.getParentChar().getBetaEffect() > 0.0f) {
            if ((f2 -= this.getParentChar().getBetaDelta()) > 1.0f) {
                f2 = 1.0f;
            }
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
        }
        if (this.getParentChar().getCharacterTraits().Cowardly.isSet()) {
            f2 *= 2.0f;
        }
        if (this.getParentChar().getCharacterTraits().Brave.isSet()) {
            f2 *= 0.3f;
        }
        if (this.getParentChar().getCharacterTraits().Desensitized.isSet()) {
            f2 = 0.0f;
        }
        this.ParentChar.getStats().Panic += this.getPanicIncreaseValueFrame() * f * f2;
        if (this.getParentChar().getStats().Panic > 100.0f) {
            this.ParentChar.getStats().Panic = 100.0f;
        }
    }

    public void IncreasePanic(int n) {
        if (this.getParentChar().getVehicle() != null) {
            n /= 2;
        }
        float f = 1.0f;
        if (this.getParentChar().getBetaEffect() > 0.0f) {
            if ((f -= this.getParentChar().getBetaDelta()) > 1.0f) {
                f = 1.0f;
            }
            if (f < 0.0f) {
                f = 0.0f;
            }
        }
        if (this.getParentChar().getCharacterTraits().Cowardly.isSet()) {
            f *= 2.0f;
        }
        if (this.getParentChar().getCharacterTraits().Brave.isSet()) {
            f *= 0.3f;
        }
        if (this.getParentChar().getCharacterTraits().Desensitized.isSet()) {
            f = 0.0f;
        }
        this.ParentChar.getStats().Panic += this.getPanicIncreaseValue() * (float)n * f;
        if (this.getParentChar().getStats().Panic > 100.0f) {
            this.ParentChar.getStats().Panic = 100.0f;
        }
    }

    public void ReducePanic() {
        if (this.ParentChar.getStats().Panic <= 0.0f) {
            return;
        }
        float f = this.getPanicReductionValue() * (GameTime.getInstance().getMultiplier() / 1.6f);
        int n = (int)Math.floor(new Double(GameTime.instance.getNightsSurvived()) / 30.0);
        if (n > 5) {
            n = 5;
        }
        f += this.getPanicReductionValue() * (float)n;
        if (this.ParentChar.isAsleep()) {
            f *= 2.0f;
        }
        this.ParentChar.getStats().Panic -= f;
        if (this.getParentChar().getStats().Panic < 0.0f) {
            this.ParentChar.getStats().Panic = 0.0f;
        }
    }

    public void UpdatePanicState() {
        int n = this.getParentChar().getStats().NumVisibleZombies;
        if (n > this.getOldNumZombiesVisible()) {
            this.IncreasePanic(n - this.getOldNumZombiesVisible());
        } else {
            this.ReducePanic();
        }
        this.setOldNumZombiesVisible(n);
    }

    public void JustDrankBooze(Food food, float f) {
        float f2 = 1.0f;
        if (this.getParentChar().Traits.HeavyDrinker.isSet()) {
            f2 = 0.3f;
        }
        if (this.getParentChar().Traits.LightDrinker.isSet()) {
            f2 = 4.0f;
        }
        if (food.getBaseHunger() != 0.0f) {
            f = food.getHungChange() * f / food.getBaseHunger() * 2.0f;
        }
        f2 *= f;
        if (food.getName().toLowerCase().contains("beer") || food.hasTag("LowAlcohol")) {
            f2 *= 0.25f;
        }
        if ((double)this.getParentChar().getStats().hunger > 0.8) {
            f2 = (float)((double)f2 * 1.25);
        } else if ((double)this.getParentChar().getStats().hunger > 0.6) {
            f2 = (float)((double)f2 * 1.1);
        }
        this.ParentChar.getStats().Drunkenness += this.getDrunkIncreaseValue() * f2;
        if (this.getParentChar().getStats().Drunkenness > 100.0f) {
            this.ParentChar.getStats().Drunkenness = 100.0f;
        }
        this.getParentChar().SleepingTablet(0.02f * f);
        this.getParentChar().BetaAntiDepress(0.4f * f);
        this.getParentChar().BetaBlockers(0.2f * f);
        this.getParentChar().PainMeds(0.2f * f);
    }

    public void JustTookPill(InventoryItem inventoryItem) {
        if ("PillsBeta".equals(inventoryItem.getType())) {
            if (this.getParentChar() != null && this.getParentChar().getStats().Drunkenness > 10.0f) {
                this.getParentChar().BetaBlockers(0.15f);
            } else {
                this.getParentChar().BetaBlockers(0.3f);
            }
            inventoryItem.Use();
        } else if ("PillsAntiDep".equals(inventoryItem.getType())) {
            if (this.getParentChar() != null && this.getParentChar().getStats().Drunkenness > 10.0f) {
                this.getParentChar().BetaAntiDepress(0.15f);
            } else {
                this.getParentChar().BetaAntiDepress(0.3f);
            }
            inventoryItem.Use();
        } else if ("PillsSleepingTablets".equals(inventoryItem.getType())) {
            inventoryItem.Use();
            this.getParentChar().SleepingTablet(0.1f);
            if (this.getParentChar() instanceof IsoPlayer) {
                ((IsoPlayer)this.getParentChar()).setSleepingPillsTaken(((IsoPlayer)this.getParentChar()).getSleepingPillsTaken() + 1);
            }
        } else if ("Pills".equals(inventoryItem.getType())) {
            inventoryItem.Use();
            if (this.getParentChar() != null && this.getParentChar().getStats().Drunkenness > 10.0f) {
                this.getParentChar().PainMeds(0.15f);
            } else {
                this.getParentChar().PainMeds(0.45f);
            }
        } else if ("PillsVitamins".equals(inventoryItem.getType())) {
            inventoryItem.Use();
            this.getParentChar().getStats().fatigue = this.getParentChar() != null && this.getParentChar().getStats().Drunkenness > 10.0f ? (this.getParentChar().getStats().fatigue += inventoryItem.getFatigueChange() / 2.0f) : (this.getParentChar().getStats().fatigue += inventoryItem.getFatigueChange());
        }
    }

    public void JustAteFood(Food food, float f) {
        float f2;
        if (food.getPoisonPower() > 0) {
            f2 = (float)food.getPoisonPower() * f;
            if (this.getParentChar().Traits.IronGut.isSet()) {
                f2 /= 2.0f;
            }
            if (this.getParentChar().Traits.WeakStomach.isSet()) {
                f2 *= 2.0f;
            }
            this.PoisonLevel += f2;
            this.ParentChar.getStats().Pain += (float)food.getPoisonPower() * f / 6.0f;
        }
        if (food.isTaintedWater()) {
            this.PoisonLevel += 20.0f * f;
            this.ParentChar.getStats().Pain += 10.0f * f / 6.0f;
        }
        if (food.getReduceInfectionPower() > 0.0f) {
            this.getParentChar().setReduceInfectionPower(food.getReduceInfectionPower());
        }
        this.setBoredomLevel(this.getBoredomLevel() + food.getBoredomChange() * f);
        if (this.getBoredomLevel() < 0.0f) {
            this.setBoredomLevel(0.0f);
        }
        this.setUnhappynessLevel(this.getUnhappynessLevel() + food.getUnhappyChange() * f);
        if (this.getUnhappynessLevel() < 0.0f) {
            this.setUnhappynessLevel(0.0f);
        }
        if (food.isAlcoholic()) {
            this.JustDrankBooze(food, f);
        }
        if (this.getParentChar().getStats().hunger <= 0.0f) {
            f2 = Math.abs(food.getHungerChange()) * f;
            this.setHealthFromFoodTimer((int)(this.getHealthFromFoodTimer() + f2 * this.getHealthFromFoodTimeByHunger()));
            if (food.isCooked()) {
                this.setHealthFromFoodTimer((int)(this.getHealthFromFoodTimer() + f2 * this.getHealthFromFoodTimeByHunger()));
            }
            if (this.getHealthFromFoodTimer() > 11000.0f) {
                this.setHealthFromFoodTimer(11000.0f);
            }
        }
        if ("Tutorial".equals(Core.getInstance().getGameMode())) {
            return;
        }
        if (!food.isCooked() && food.isbDangerousUncooked()) {
            this.setHealthFromFoodTimer(0.0f);
            int n = 75;
            if (food.hasTag("Egg")) {
                n = 5;
            }
            if (this.getParentChar().Traits.IronGut.isSet()) {
                n /= 2;
                if (food.hasTag("Egg")) {
                    n = 0;
                }
            }
            if (this.getParentChar().Traits.WeakStomach.isSet()) {
                n *= 2;
            }
            if (n > 0 && Rand.Next(100) < n && !this.isInfected()) {
                this.PoisonLevel += 15.0f * f;
            }
        }
        if (food.getAge() >= (float)food.getOffAgeMax()) {
            float f3 = food.getAge() - (float)food.getOffAgeMax();
            if (f3 == 0.0f) {
                f3 = 1.0f;
            }
            if (f3 > 5.0f) {
                f3 = 5.0f;
            }
            int n = food.getOffAgeMax() > food.getOffAge() ? (int)(f3 / (float)(food.getOffAgeMax() - food.getOffAge()) * 100.0f) : 100;
            if (this.getParentChar().Traits.IronGut.isSet()) {
                n /= 2;
            }
            if (this.getParentChar().Traits.WeakStomach.isSet()) {
                n *= 2;
            }
            if (Rand.Next(100) < n && !this.isInfected()) {
                this.PoisonLevel += 5.0f * Math.abs(food.getHungChange() * 10.0f) * f;
            }
        }
    }

    public void JustAteFood(Food food) {
        this.JustAteFood(food, 100.0f);
    }

    private float getHealthFromFoodTimeByHunger() {
        return 13000.0f;
    }

    public void JustReadSomething(Literature literature) {
        this.setBoredomLevel(this.getBoredomLevel() + literature.getBoredomChange());
        if (this.getBoredomLevel() < 0.0f) {
            this.setBoredomLevel(0.0f);
        }
        this.setUnhappynessLevel(this.getUnhappynessLevel() + literature.getUnhappyChange());
        if (this.getUnhappynessLevel() < 0.0f) {
            this.setUnhappynessLevel(0.0f);
        }
    }

    public void JustTookPainMeds() {
        this.ParentChar.getStats().Pain -= this.getPainReductionFromMeds();
        if (this.getParentChar().getStats().Pain < 0.0f) {
            this.ParentChar.getStats().Pain = 0.0f;
        }
    }

    public void UpdateWetness() {
        VehicleWindow vehicleWindow;
        VehiclePart vehiclePart;
        boolean bl;
        IsoGridSquare isoGridSquare = this.getParentChar().getCurrentSquare();
        BaseVehicle baseVehicle = this.getParentChar().getVehicle();
        IsoGameCharacter isoGameCharacter = this.getParentChar();
        boolean bl2 = bl = isoGridSquare == null || !isoGridSquare.isInARoom() && !isoGridSquare.haveRoof;
        if (baseVehicle != null && baseVehicle.hasRoof(baseVehicle.getSeat(this.getParentChar()))) {
            bl = false;
        }
        ClothingWetness clothingWetness = this.getParentChar().getClothingWetness();
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (baseVehicle != null && ClimateManager.getInstance().isRaining() && (vehiclePart = baseVehicle.getPartById("Windshield")) != null && (vehicleWindow = vehiclePart.getWindow()) != null && vehicleWindow.isDestroyed()) {
            float f4 = ClimateManager.getInstance().getRainIntensity();
            f4 *= f4;
            if ((f4 *= baseVehicle.getCurrentSpeedKmHour() / 50.0f) < 0.1f) {
                f4 = 0.0f;
            }
            if (f4 > 1.0f) {
                f4 = 1.0f;
            }
            f3 = f4 * 3.0f;
            f = f4;
        }
        if (bl && isoGameCharacter.isAsleep() && isoGameCharacter.getBed() != null && "Tent".equals(isoGameCharacter.getBed().getName())) {
            bl = false;
        }
        if (bl && ClimateManager.getInstance().isRaining()) {
            float f5 = ClimateManager.getInstance().getRainIntensity();
            if ((double)f5 < 0.1) {
                f5 = 0.0f;
            }
            f = f5;
        } else if (!bl || !ClimateManager.getInstance().isRaining()) {
            float f6 = ClimateManager.getInstance().getAirTemperatureForCharacter(this.getParentChar());
            float f7 = 0.1f;
            if (f6 > 5.0f) {
                f7 += (f6 - 5.0f) / 10.0f;
            }
            if ((f7 -= f3) < 0.0f) {
                f7 = 0.0f;
            }
            f2 = f7;
        }
        if (clothingWetness != null) {
            clothingWetness.updateWetness(f, f2);
        }
        float f8 = 0.0f;
        if (this.BodyParts.size() > 0) {
            for (int i = 0; i < this.BodyParts.size(); ++i) {
                f8 += this.BodyParts.get(i).getWetness();
            }
            f8 /= (float)this.BodyParts.size();
        }
        this.Wetness = PZMath.clamp(f8, 0.0f, 100.0f);
        float f9 = 0.0f;
        if (this.thermoregulator != null) {
            f9 = this.thermoregulator.getCatchAColdDelta();
        }
        if (!this.isHasACold() && f9 > 0.1f) {
            if (this.getParentChar().Traits.ProneToIllness.isSet()) {
                f9 *= 1.7f;
            }
            if (this.getParentChar().Traits.Resilient.isSet()) {
                f9 *= 0.45f;
            }
            if (this.getParentChar().Traits.Outdoorsman.isSet()) {
                f9 *= 0.1f;
            }
            this.setCatchACold(this.getCatchACold() + (float)ZomboidGlobals.CatchAColdIncreaseRate * f9 * GameTime.instance.getMultiplier());
            if (this.getCatchACold() >= 100.0f) {
                this.setCatchACold(0.0f);
                this.setHasACold(true);
                this.setColdStrength(20.0f);
                this.setTimeToSneezeOrCough(0);
            }
        }
        if (f9 <= 0.1f) {
            this.setCatchACold(this.getCatchACold() - (float)ZomboidGlobals.CatchAColdDecreaseRate);
            if (this.getCatchACold() <= 0.0f) {
                this.setCatchACold(0.0f);
            }
        }
    }

    public void TriggerSneezeCough() {
        if (this.getSneezeCoughActive() > 0) {
            return;
        }
        if (Rand.Next(100) > 50) {
            this.setSneezeCoughActive(1);
        } else {
            this.setSneezeCoughActive(2);
        }
        if (this.getParentChar().getMoodles().getMoodleLevel(MoodleType.HasACold) == 2) {
            this.setSneezeCoughActive(1);
        }
        this.setSneezeCoughTime(this.getSneezeCoughDelay());
        if (this.getParentChar().getMoodles().getMoodleLevel(MoodleType.HasACold) == 2) {
            this.setTimeToSneezeOrCough(this.getMildColdSneezeTimerMin() + Rand.Next(this.getMildColdSneezeTimerMax() - this.getMildColdSneezeTimerMin()));
        }
        if (this.getParentChar().getMoodles().getMoodleLevel(MoodleType.HasACold) == 3) {
            this.setTimeToSneezeOrCough(this.getColdSneezeTimerMin() + Rand.Next(this.getColdSneezeTimerMax() - this.getColdSneezeTimerMin()));
        }
        if (this.getParentChar().getMoodles().getMoodleLevel(MoodleType.HasACold) == 4) {
            this.setTimeToSneezeOrCough(this.getNastyColdSneezeTimerMin() + Rand.Next(this.getNastyColdSneezeTimerMax() - this.getNastyColdSneezeTimerMin()));
        }
        boolean bl = false;
        if (this.getParentChar().getPrimaryHandItem() != null && (this.getParentChar().getPrimaryHandItem().getType().equals("Tissue") || this.getParentChar().getPrimaryHandItem().getType().equals("ToiletPaper"))) {
            if (((Drainable)((Object)this.getParentChar().getPrimaryHandItem())).getUsedDelta() > 0.0f) {
                ((Drainable)((Object)this.getParentChar().getPrimaryHandItem())).setUsedDelta(((Drainable)((Object)this.getParentChar().getPrimaryHandItem())).getUsedDelta() - 0.1f);
                if (((Drainable)((Object)this.getParentChar().getPrimaryHandItem())).getUsedDelta() <= 0.0f) {
                    this.getParentChar().getPrimaryHandItem().Use();
                }
                bl = true;
            }
        } else if (this.getParentChar().getSecondaryHandItem() != null && (this.getParentChar().getSecondaryHandItem().getType().equals("Tissue") || this.getParentChar().getSecondaryHandItem().getType().equals("ToiletPaper")) && ((Drainable)((Object)this.getParentChar().getSecondaryHandItem())).getUsedDelta() > 0.0f) {
            ((Drainable)((Object)this.getParentChar().getSecondaryHandItem())).setUsedDelta(((Drainable)((Object)this.getParentChar().getSecondaryHandItem())).getUsedDelta() - 0.1f);
            if (((Drainable)((Object)this.getParentChar().getSecondaryHandItem())).getUsedDelta() <= 0.0f) {
                this.getParentChar().getSecondaryHandItem().Use();
            }
            bl = true;
        }
        if (bl) {
            this.setSneezeCoughActive(this.getSneezeCoughActive() + 2);
        } else {
            int n = 20;
            int n2 = 20;
            if (this.getSneezeCoughActive() == 1) {
                n = 20;
                n2 = 25;
            }
            if (this.getSneezeCoughActive() == 2) {
                n = 35;
                n2 = 40;
            }
            WorldSoundManager.instance.addSound(this.getParentChar(), (int)this.getParentChar().getX(), (int)this.getParentChar().getY(), (int)this.getParentChar().getZ(), n, n2, true);
        }
    }

    public int IsSneezingCoughing() {
        return this.getSneezeCoughActive();
    }

    public void UpdateCold() {
        if (this.isHasACold()) {
            boolean bl = true;
            IsoGridSquare isoGridSquare = this.getParentChar().getCurrentSquare();
            if (isoGridSquare == null || !isoGridSquare.isInARoom() || this.getParentChar().getMoodles().getMoodleLevel(MoodleType.Wet) > 0 || this.getParentChar().getMoodles().getMoodleLevel(MoodleType.Hypothermia) >= 1 || this.getParentChar().getStats().fatigue > 0.5f || this.getParentChar().getStats().hunger > 0.25f || this.getParentChar().getStats().thirst > 0.25f) {
                bl = false;
            }
            if (this.getColdReduction() > 0.0f) {
                bl = true;
                this.setColdReduction(this.getColdReduction() - 0.005f * GameTime.instance.getMultiplier());
                if (this.getColdReduction() < 0.0f) {
                    this.setColdReduction(0.0f);
                }
            }
            if (bl) {
                float f = 1.0f;
                if (this.getParentChar().Traits.ProneToIllness.isSet()) {
                    f = 0.5f;
                }
                if (this.getParentChar().Traits.Resilient.isSet()) {
                    f = 1.5f;
                }
                this.setColdStrength(this.getColdStrength() - this.getColdProgressionRate() * f * GameTime.instance.getMultiplier());
                if (this.getColdReduction() > 0.0f) {
                    this.setColdStrength(this.getColdStrength() - this.getColdProgressionRate() * f * GameTime.instance.getMultiplier());
                }
                if (this.getColdStrength() < 0.0f) {
                    this.setColdStrength(0.0f);
                    this.setHasACold(false);
                    this.setCatchACold(0.0f);
                }
            } else {
                float f = 1.0f;
                if (this.getParentChar().Traits.ProneToIllness.isSet()) {
                    f = 1.2f;
                }
                if (this.getParentChar().Traits.Resilient.isSet()) {
                    f = 0.8f;
                }
                this.setColdStrength(this.getColdStrength() + this.getColdProgressionRate() * f * GameTime.instance.getMultiplier());
                if (this.getColdStrength() > 100.0f) {
                    this.setColdStrength(100.0f);
                }
            }
            if (this.getSneezeCoughTime() > 0) {
                this.setSneezeCoughTime(this.getSneezeCoughTime() - 1);
                if (this.getSneezeCoughTime() == 0) {
                    this.setSneezeCoughActive(0);
                }
            }
            if (this.getParentChar().getMoodles().getMoodleLevel(MoodleType.HasACold) > 1 && this.getTimeToSneezeOrCough() >= 0 && !this.ParentChar.IsSpeaking()) {
                this.setTimeToSneezeOrCough(this.getTimeToSneezeOrCough() - 1);
                if (this.getTimeToSneezeOrCough() <= 0) {
                    this.TriggerSneezeCough();
                }
            }
        }
    }

    public float getColdStrength() {
        if (this.isHasACold()) {
            return this.ColdStrength;
        }
        return 0.0f;
    }

    public float getWetness() {
        return this.Wetness;
    }

    public void AddDamage(BodyPartType bodyPartType, float f) {
        this.getBodyParts().get(BodyPartType.ToIndex(bodyPartType)).AddDamage(f);
    }

    public void AddGeneralHealth(float f) {
        int n = 0;
        for (int i = 0; i < BodyPartType.ToIndex(BodyPartType.MAX); ++i) {
            if (!(this.getBodyParts().get(i).getHealth() < 100.0f)) continue;
            ++n;
        }
        if (n > 0) {
            float f2 = f / (float)n;
            for (int i = 0; i < BodyPartType.ToIndex(BodyPartType.MAX); ++i) {
                if (!(this.getBodyParts().get(i).getHealth() < 100.0f)) continue;
                this.getBodyParts().get(i).AddHealth(f2);
            }
        }
    }

    public void ReduceGeneralHealth(float f) {
        if (this.getOverallBodyHealth() <= 10.0f) {
            this.getParentChar().forceAwake();
        }
        if (f <= 0.0f) {
            return;
        }
        float f2 = f / (float)BodyPartType.ToIndex(BodyPartType.MAX);
        for (int i = 0; i < BodyPartType.ToIndex(BodyPartType.MAX); ++i) {
            this.getBodyParts().get(i).ReduceHealth(f2 / BodyPartType.getDamageModifyer(i));
        }
    }

    public void AddDamage(int n, float f) {
        this.getBodyParts().get(n).AddDamage(f);
    }

    public void splatBloodFloorBig() {
        this.getParentChar().splatBloodFloorBig();
        this.getParentChar().splatBloodFloorBig();
        this.getParentChar().splatBloodFloorBig();
    }

    public void DamageFromWeapon(HandWeapon handWeapon) {
        if (GameServer.bServer) {
            if (handWeapon != null) {
                this.getParentChar().sendObjectChange("DamageFromWeapon", "weapon", handWeapon.getFullType());
            }
            return;
        }
        if (this.getParentChar() instanceof IsoPlayer && !((IsoPlayer)this.getParentChar()).isLocalPlayer()) {
            return;
        }
        int n = 0;
        int n2 = 1;
        boolean bl = true;
        n = Rand.Next(BodyPartType.ToIndex(BodyPartType.Hand_L), BodyPartType.ToIndex(BodyPartType.MAX));
        if (DebugOptions.instance.MultiplayerTorsoHit.getValue()) {
            n = Rand.Next(BodyPartType.ToIndex(BodyPartType.Torso_Upper), BodyPartType.ToIndex(BodyPartType.Head));
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = true;
        boolean bl6 = true;
        if (handWeapon.getCategories().contains("Blunt") || handWeapon.getCategories().contains("SmallBlunt")) {
            bl6 = false;
            n2 = 0;
            bl2 = true;
        } else if (!handWeapon.isAimedFirearm()) {
            n2 = 1;
            bl3 = true;
        } else {
            bl4 = true;
            n2 = 2;
        }
        BodyPart bodyPart = this.getBodyPart(BodyPartType.FromIndex(n));
        float f = this.getParentChar().getBodyPartClothingDefense(bodyPart.getIndex(), bl3, bl4);
        if ((float)Rand.Next(100) < f) {
            bl = false;
            this.getParentChar().addHoleFromZombieAttacks(BloodBodyPartType.FromIndex(n), false);
        }
        if (!bl) {
            return;
        }
        this.getParentChar().addHole(BloodBodyPartType.FromIndex(n));
        this.getParentChar().splatBloodFloorBig();
        this.getParentChar().splatBloodFloorBig();
        this.getParentChar().splatBloodFloorBig();
        if (bl3) {
            if (Rand.NextBool(6)) {
                bodyPart.generateDeepWound();
            } else if (Rand.NextBool(3)) {
                bodyPart.setCut(true);
            } else {
                bodyPart.setScratched(true, true);
            }
        } else if (bl2) {
            if (Rand.NextBool(4)) {
                bodyPart.setCut(true);
            } else {
                bodyPart.setScratched(true, true);
            }
        } else if (bl4) {
            bodyPart.setHaveBullet(true, 0);
        }
        float f2 = Rand.Next(handWeapon.getMinDamage(), handWeapon.getMaxDamage()) * 15.0f;
        if (n == BodyPartType.ToIndex(BodyPartType.Head)) {
            f2 *= 4.0f;
        }
        if (n == BodyPartType.ToIndex(BodyPartType.Neck)) {
            f2 *= 4.0f;
        }
        if (n == BodyPartType.ToIndex(BodyPartType.Torso_Upper)) {
            f2 *= 2.0f;
        }
        if (GameClient.bClient) {
            f2 = handWeapon.isRanged() ? (float)((double)f2 * ServerOptions.getInstance().PVPFirearmDamageModifier.getValue()) : (float)((double)f2 * ServerOptions.getInstance().PVPMeleeDamageModifier.getValue());
        }
        this.AddDamage(n, f2);
        switch (n2) {
            case 0: {
                this.ParentChar.getStats().Pain += this.getInitialThumpPain() * BodyPartType.getPainModifyer(n);
                break;
            }
            case 1: {
                this.ParentChar.getStats().Pain += this.getInitialScratchPain() * BodyPartType.getPainModifyer(n);
                break;
            }
            case 2: {
                this.ParentChar.getStats().Pain += this.getInitialBitePain() * BodyPartType.getPainModifyer(n);
            }
        }
        if (this.getParentChar().getStats().Pain > 100.0f) {
            this.ParentChar.getStats().Pain = 100.0f;
        }
        if (this.ParentChar instanceof IsoPlayer && GameClient.bClient && ((IsoPlayer)this.ParentChar).isLocalPlayer()) {
            IsoPlayer isoPlayer = (IsoPlayer)this.ParentChar;
            isoPlayer.updateMovementRates();
            GameClient.sendPlayerInjuries(isoPlayer);
            GameClient.sendPlayerDamage(isoPlayer);
        }
    }

    public boolean AddRandomDamageFromZombie(IsoZombie isoZombie, String string) {
        Serializable serializable;
        boolean bl;
        int n;
        float f;
        if (StringUtils.isNullOrEmpty(string)) {
            string = "Bite";
        }
        this.getParentChar().setVariable("hitpvp", false);
        if (GameServer.bServer) {
            this.getParentChar().sendObjectChange("AddRandomDamageFromZombie", "zombie", isoZombie.OnlineID);
            return true;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 15 + this.getParentChar().getMeleeCombatMod();
        int n5 = 85;
        int n6 = 65;
        String string2 = this.getParentChar().testDotSide(isoZombie);
        boolean bl2 = string2.equals(behindStr);
        boolean bl3 = string2.equals(leftStr) || string2.equals(rightStr);
        int n7 = this.getParentChar().getSurroundingAttackingZombies();
        n7 = Math.max(n7, 1);
        n4 -= (n7 - 1) * 10;
        n5 -= (n7 - 1) * 30;
        n6 -= (n7 - 1) * 15;
        int n8 = 3;
        if (SandboxOptions.instance.Lore.Strength.getValue() == 1) {
            n8 = 2;
        }
        if (SandboxOptions.instance.Lore.Strength.getValue() == 3) {
            n8 = 6;
        }
        if (this.ParentChar.Traits.ThickSkinned.isSet()) {
            n4 = (int)((double)n4 * 1.3);
        }
        if (this.ParentChar.Traits.ThinSkinned.isSet()) {
            n4 = (int)((double)n4 / 1.3);
        }
        if (!"EndDeath".equals(this.getParentChar().getHitReaction())) {
            if (!this.getParentChar().isGodMod() && n7 >= n8 && SandboxOptions.instance.Lore.ZombiesDragDown.getValue() && !this.getParentChar().isSitOnGround()) {
                n5 = 0;
                n6 = 0;
                n4 = 0;
                this.getParentChar().setHitReaction("EndDeath");
                this.getParentChar().setDeathDragDown(true);
            } else {
                this.getParentChar().setHitReaction(string);
            }
        }
        if (bl2) {
            n4 -= 15;
            n5 -= 25;
            n6 -= 35;
            if (SandboxOptions.instance.RearVulnerability.getValue() == 1) {
                n4 += 15;
                n5 += 25;
                n6 += 35;
            }
            if (SandboxOptions.instance.RearVulnerability.getValue() == 2) {
                n4 += 7;
                n5 += 17;
                n6 += 23;
            }
            if (n7 > 2) {
                n5 -= 15;
                n6 -= 15;
            }
        }
        if (bl3) {
            n4 -= 30;
            n5 -= 7;
            n6 -= 27;
            if (SandboxOptions.instance.RearVulnerability.getValue() == 1) {
                n4 += 30;
                n5 += 7;
                n6 += 27;
            }
            if (SandboxOptions.instance.RearVulnerability.getValue() == 2) {
                n4 += 15;
                n5 += 4;
                n6 += 15;
            }
        }
        if (!isoZombie.bCrawling) {
            n3 = Rand.Next(10) == 0 ? Rand.Next(BodyPartType.ToIndex(BodyPartType.Hand_L), BodyPartType.ToIndex(BodyPartType.Groin) + 1) : Rand.Next(BodyPartType.ToIndex(BodyPartType.Hand_L), BodyPartType.ToIndex(BodyPartType.Neck) + 1);
            f = 10.0f * (float)n7;
            if (bl2) {
                f += 5.0f;
            }
            if (bl3) {
                f += 2.0f;
            }
            if (bl2 && (float)Rand.Next(100) < f) {
                n3 = BodyPartType.ToIndex(BodyPartType.Neck);
            }
            if (n3 == BodyPartType.ToIndex(BodyPartType.Head) || n3 == BodyPartType.ToIndex(BodyPartType.Neck)) {
                n = 70;
                if (bl2) {
                    n = 90;
                }
                if (bl3) {
                    n = 80;
                }
                if (Rand.Next(100) > n) {
                    bl = false;
                    while (!bl) {
                        bl = true;
                        n3 = Rand.Next(BodyPartType.ToIndex(BodyPartType.Torso_Lower) + 1);
                        if (n3 != BodyPartType.ToIndex(BodyPartType.Head) && n3 != BodyPartType.ToIndex(BodyPartType.Neck) && n3 != BodyPartType.ToIndex(BodyPartType.Groin)) continue;
                        bl = false;
                    }
                }
            }
        } else if (Rand.Next(2) == 0) {
            n3 = Rand.Next(10) == 0 ? Rand.Next(BodyPartType.ToIndex(BodyPartType.Groin), BodyPartType.ToIndex(BodyPartType.MAX)) : Rand.Next(BodyPartType.ToIndex(BodyPartType.UpperLeg_L), BodyPartType.ToIndex(BodyPartType.MAX));
        } else {
            return false;
        }
        if (isoZombie.inactive) {
            n4 += 20;
            n5 += 20;
            n6 += 20;
        }
        f = (float)Rand.Next(1000) / 1000.0f;
        f *= (float)(Rand.Next(10) + 10);
        if (GameServer.bServer && this.ParentChar instanceof IsoPlayer || Core.bDebug && this.ParentChar instanceof IsoPlayer) {
            DebugLog.log(DebugType.Combat, "zombie did " + f + " dmg to " + ((IsoPlayer)this.ParentChar).getDisplayName() + " on body part " + BodyPartType.getDisplayName(BodyPartType.FromIndex(n3)));
        }
        n = 0;
        bl = true;
        if (Rand.Next(100) > n4) {
            isoZombie.scratch = true;
            this.getParentChar().helmetFall(n3 == BodyPartType.ToIndex(BodyPartType.Neck) || n3 == BodyPartType.ToIndex(BodyPartType.Head));
            if (Rand.Next(100) > n6) {
                isoZombie.scratch = false;
                isoZombie.laceration = true;
            }
            if (Rand.Next(100) > n5) {
                isoZombie.scratch = false;
                isoZombie.laceration = false;
                bl = false;
            }
            if (isoZombie.scratch) {
                serializable = Float.valueOf(this.getParentChar().getBodyPartClothingDefense(n3, false, false));
                isoZombie.parameterZombieState.setState(ParameterZombieState.State.AttackScratch);
                if (this.getHealth() > 0.0f) {
                    this.getParentChar().getEmitter().playSoundImpl("ZombieScratch", null);
                }
                if ((float)Rand.Next(100) < ((Float)serializable).floatValue()) {
                    this.getParentChar().addHoleFromZombieAttacks(BloodBodyPartType.FromIndex(n3), bl);
                    return false;
                }
                boolean bl4 = this.getParentChar().addHole(BloodBodyPartType.FromIndex(n3), true);
                if (bl4) {
                    this.getParentChar().getEmitter().playSoundImpl("ZombieRipClothing", null);
                }
                n = 1;
                this.AddDamage(n3, f);
                this.SetScratched(n3, true);
                this.getParentChar().addBlood(BloodBodyPartType.FromIndex(n3), true, false, true);
                n2 = 1;
                if (GameServer.bServer && this.ParentChar instanceof IsoPlayer) {
                    DebugLog.log(DebugType.Combat, "zombie scratched " + ((IsoPlayer)this.ParentChar).username);
                }
            } else if (isoZombie.laceration) {
                serializable = Float.valueOf(this.getParentChar().getBodyPartClothingDefense(n3, false, false));
                isoZombie.parameterZombieState.setState(ParameterZombieState.State.AttackLacerate);
                if (this.getHealth() > 0.0f) {
                    this.getParentChar().getEmitter().playSoundImpl("ZombieScratch", null);
                }
                if ((float)Rand.Next(100) < ((Float)serializable).floatValue()) {
                    this.getParentChar().addHoleFromZombieAttacks(BloodBodyPartType.FromIndex(n3), bl);
                    return false;
                }
                boolean bl5 = this.getParentChar().addHole(BloodBodyPartType.FromIndex(n3), true);
                if (bl5) {
                    this.getParentChar().getEmitter().playSoundImpl("ZombieRipClothing", null);
                }
                n = 1;
                this.AddDamage(n3, f);
                this.SetCut(n3, true);
                this.getParentChar().addBlood(BloodBodyPartType.FromIndex(n3), true, false, true);
                n2 = 1;
                if (GameServer.bServer && this.ParentChar instanceof IsoPlayer) {
                    DebugLog.log(DebugType.Combat, "zombie laceration " + ((IsoPlayer)this.ParentChar).username);
                }
            } else {
                serializable = Float.valueOf(this.getParentChar().getBodyPartClothingDefense(n3, true, false));
                isoZombie.parameterZombieState.setState(ParameterZombieState.State.AttackBite);
                if (this.getHealth() > 0.0f) {
                    this.getParentChar().getEmitter().playSoundImpl("ZombieBite", null);
                }
                if ((float)Rand.Next(100) < ((Float)serializable).floatValue()) {
                    this.getParentChar().addHoleFromZombieAttacks(BloodBodyPartType.FromIndex(n3), bl);
                    return false;
                }
                boolean bl6 = this.getParentChar().addHole(BloodBodyPartType.FromIndex(n3), true);
                if (bl6) {
                    this.getParentChar().getEmitter().playSoundImpl("ZombieRipClothing", null);
                }
                n = 1;
                this.AddDamage(n3, f);
                this.SetBitten(n3, true);
                if (n3 == BodyPartType.ToIndex(BodyPartType.Neck)) {
                    this.getParentChar().addBlood(BloodBodyPartType.FromIndex(n3), false, true, true);
                    this.getParentChar().addBlood(BloodBodyPartType.FromIndex(n3), false, true, true);
                    this.getParentChar().addBlood(BloodBodyPartType.Torso_Upper, false, true, false);
                }
                this.getParentChar().addBlood(BloodBodyPartType.FromIndex(n3), false, true, true);
                if (GameServer.bServer && this.ParentChar instanceof IsoPlayer) {
                    DebugLog.log(DebugType.Combat, "zombie bite " + ((IsoPlayer)this.ParentChar).username);
                }
                n2 = 2;
                this.getParentChar().splatBloodFloorBig();
                this.getParentChar().splatBloodFloorBig();
                this.getParentChar().splatBloodFloorBig();
            }
        }
        if (n == 0) {
            this.getParentChar().addHoleFromZombieAttacks(BloodBodyPartType.FromIndex(n3), bl);
        }
        switch (n2) {
            case 0: {
                this.ParentChar.getStats().Pain += this.getInitialThumpPain() * BodyPartType.getPainModifyer(n3);
                break;
            }
            case 1: {
                this.ParentChar.getStats().Pain += this.getInitialScratchPain() * BodyPartType.getPainModifyer(n3);
                break;
            }
            case 2: {
                this.ParentChar.getStats().Pain += this.getInitialBitePain() * BodyPartType.getPainModifyer(n3);
            }
        }
        if (this.getParentChar().getStats().Pain > 100.0f) {
            this.ParentChar.getStats().Pain = 100.0f;
        }
        if (this.ParentChar instanceof IsoPlayer && GameClient.bClient && ((IsoPlayer)this.ParentChar).isLocalPlayer()) {
            serializable = (IsoPlayer)this.ParentChar;
            ((IsoPlayer)serializable).updateMovementRates();
            GameClient.sendPlayerInjuries((IsoPlayer)serializable);
            GameClient.sendPlayerDamage((IsoPlayer)serializable);
        }
        return true;
    }

    public boolean doesBodyPartHaveInjury(BodyPartType bodyPartType) {
        return this.getBodyParts().get(BodyPartType.ToIndex(bodyPartType)).HasInjury();
    }

    public boolean doBodyPartsHaveInjuries(BodyPartType bodyPartType, BodyPartType bodyPartType2) {
        return this.doesBodyPartHaveInjury(bodyPartType) || this.doesBodyPartHaveInjury(bodyPartType2);
    }

    public boolean isBodyPartBleeding(BodyPartType bodyPartType) {
        return this.getBodyPart(bodyPartType).getBleedingTime() > 0.0f;
    }

    public boolean areBodyPartsBleeding(BodyPartType bodyPartType, BodyPartType bodyPartType2) {
        return this.isBodyPartBleeding(bodyPartType) || this.isBodyPartBleeding(bodyPartType2);
    }

    public void DrawUntexturedQuad(int n, int n2, int n3, int n4, float f, float f2, float f3, float f4) {
        SpriteRenderer.instance.renderi(null, n, n2, n3, n4, f, f2, f3, f4, null);
    }

    public float getBodyPartHealth(BodyPartType bodyPartType) {
        return this.getBodyParts().get(BodyPartType.ToIndex(bodyPartType)).getHealth();
    }

    public float getBodyPartHealth(int n) {
        return this.getBodyParts().get(n).getHealth();
    }

    public String getBodyPartName(BodyPartType bodyPartType) {
        return BodyPartType.ToString(bodyPartType);
    }

    public String getBodyPartName(int n) {
        return BodyPartType.ToString(BodyPartType.FromIndex(n));
    }

    public float getHealth() {
        return this.getOverallBodyHealth();
    }

    public float getInfectionLevel() {
        return this.InfectionLevel;
    }

    public float getApparentInfectionLevel() {
        float f;
        float f2 = f = this.getFakeInfectionLevel() > this.InfectionLevel ? this.getFakeInfectionLevel() : this.InfectionLevel;
        if (this.getFoodSicknessLevel() > f) {
            return this.getFoodSicknessLevel();
        }
        return f;
    }

    public int getNumPartsBleeding() {
        int n = 0;
        for (int i = 0; i < BodyPartType.ToIndex(BodyPartType.MAX); ++i) {
            if (!this.getBodyParts().get(i).bleeding()) continue;
            ++n;
        }
        return n;
    }

    public int getNumPartsScratched() {
        int n = 0;
        for (int i = 0; i < BodyPartType.ToIndex(BodyPartType.MAX); ++i) {
            if (!this.getBodyParts().get(i).scratched()) continue;
            ++n;
        }
        return n;
    }

    public int getNumPartsBitten() {
        int n = 0;
        for (int i = 0; i < BodyPartType.ToIndex(BodyPartType.MAX); ++i) {
            if (!this.getBodyParts().get(i).bitten()) continue;
            ++n;
        }
        return n;
    }

    public boolean HasInjury() {
        for (int i = 0; i < BodyPartType.ToIndex(BodyPartType.MAX); ++i) {
            if (!this.getBodyParts().get(i).HasInjury()) continue;
            return true;
        }
        return false;
    }

    public boolean IsBandaged(BodyPartType bodyPartType) {
        return this.getBodyParts().get(BodyPartType.ToIndex(bodyPartType)).bandaged();
    }

    public boolean IsDeepWounded(BodyPartType bodyPartType) {
        return this.getBodyParts().get(BodyPartType.ToIndex(bodyPartType)).deepWounded();
    }

    public boolean IsBandaged(int n) {
        return this.getBodyParts().get(n).bandaged();
    }

    public boolean IsBitten(BodyPartType bodyPartType) {
        return this.getBodyParts().get(BodyPartType.ToIndex(bodyPartType)).bitten();
    }

    public boolean IsBitten(int n) {
        return this.getBodyParts().get(n).bitten();
    }

    public boolean IsBleeding(BodyPartType bodyPartType) {
        return this.getBodyParts().get(BodyPartType.ToIndex(bodyPartType)).bleeding();
    }

    public boolean IsBleeding(int n) {
        return this.getBodyParts().get(n).bleeding();
    }

    public boolean IsBleedingStemmed(BodyPartType bodyPartType) {
        return this.getBodyParts().get(BodyPartType.ToIndex(bodyPartType)).IsBleedingStemmed();
    }

    public boolean IsBleedingStemmed(int n) {
        return this.getBodyParts().get(n).IsBleedingStemmed();
    }

    public boolean IsCortorised(BodyPartType bodyPartType) {
        return this.getBodyParts().get(BodyPartType.ToIndex(bodyPartType)).IsCortorised();
    }

    public boolean IsCortorised(int n) {
        return this.getBodyParts().get(n).IsCortorised();
    }

    public boolean IsInfected() {
        return this.IsInfected;
    }

    public boolean IsInfected(BodyPartType bodyPartType) {
        return this.getBodyParts().get(BodyPartType.ToIndex(bodyPartType)).IsInfected();
    }

    public boolean IsInfected(int n) {
        return this.getBodyParts().get(n).IsInfected();
    }

    public boolean IsFakeInfected(int n) {
        return this.getBodyParts().get(n).IsFakeInfected();
    }

    public void DisableFakeInfection(int n) {
        this.getBodyParts().get(n).DisableFakeInfection();
    }

    public boolean IsScratched(BodyPartType bodyPartType) {
        return this.getBodyParts().get(BodyPartType.ToIndex(bodyPartType)).scratched();
    }

    public boolean IsCut(BodyPartType bodyPartType) {
        return this.getBodyParts().get(BodyPartType.ToIndex(bodyPartType)).getCutTime() > 0.0f;
    }

    public boolean IsScratched(int n) {
        return this.getBodyParts().get(n).scratched();
    }

    public boolean IsStitched(BodyPartType bodyPartType) {
        return this.getBodyParts().get(BodyPartType.ToIndex(bodyPartType)).stitched();
    }

    public boolean IsStitched(int n) {
        return this.getBodyParts().get(n).stitched();
    }

    public boolean IsWounded(BodyPartType bodyPartType) {
        return this.getBodyParts().get(BodyPartType.ToIndex(bodyPartType)).deepWounded();
    }

    public boolean IsWounded(int n) {
        return this.getBodyParts().get(n).deepWounded();
    }

    public void RestoreToFullHealth() {
        for (int i = 0; i < BodyPartType.ToIndex(BodyPartType.MAX); ++i) {
            this.getBodyParts().get(i).RestoreToFullHealth();
        }
        if (this.getParentChar() != null && this.getParentChar().getStats() != null) {
            this.getParentChar().getStats().resetStats();
        }
        this.setInfected(false);
        this.setIsFakeInfected(false);
        this.setOverallBodyHealth(100.0f);
        this.setInfectionLevel(0.0f);
        this.setFakeInfectionLevel(0.0f);
        this.setBoredomLevel(0.0f);
        this.setWetness(0.0f);
        this.setCatchACold(0.0f);
        this.setHasACold(false);
        this.setColdStrength(0.0f);
        this.setSneezeCoughActive(0);
        this.setSneezeCoughTime(0);
        this.setTemperature(37.0f);
        this.setUnhappynessLevel(0.0f);
        this.PoisonLevel = 0.0f;
        this.setFoodSicknessLevel(0.0f);
        this.lastTemperature = this.Temperature = 37.0f;
        this.setInfectionTime(-1.0f);
        this.setInfectionMortalityDuration(-1.0f);
        if (this.thermoregulator != null) {
            this.thermoregulator.reset();
        }
    }

    public void SetBandaged(int n, boolean bl, float f, boolean bl2, String string) {
        this.getBodyParts().get(n).setBandaged(bl, f, bl2, string);
    }

    public void SetBitten(BodyPartType bodyPartType, boolean bl) {
        this.getBodyParts().get(BodyPartType.ToIndex(bodyPartType)).SetBitten(bl);
    }

    public void SetBitten(int n, boolean bl) {
        this.getBodyParts().get(n).SetBitten(bl);
    }

    public void SetBitten(int n, boolean bl, boolean bl2) {
        this.getBodyParts().get(n).SetBitten(bl, bl2);
    }

    public void SetBleeding(BodyPartType bodyPartType, boolean bl) {
        this.getBodyParts().get(BodyPartType.ToIndex(bodyPartType)).setBleeding(bl);
    }

    public void SetBleeding(int n, boolean bl) {
        this.getBodyParts().get(n).setBleeding(bl);
    }

    public void SetBleedingStemmed(BodyPartType bodyPartType, boolean bl) {
        this.getBodyParts().get(BodyPartType.ToIndex(bodyPartType)).SetBleedingStemmed(bl);
    }

    public void SetBleedingStemmed(int n, boolean bl) {
        this.getBodyParts().get(n).SetBleedingStemmed(bl);
    }

    public void SetCortorised(BodyPartType bodyPartType, boolean bl) {
        this.getBodyParts().get(BodyPartType.ToIndex(bodyPartType)).SetCortorised(bl);
    }

    public void SetCortorised(int n, boolean bl) {
        this.getBodyParts().get(n).SetCortorised(bl);
    }

    public BodyPart setScratchedWindow() {
        int n = Rand.Next(BodyPartType.ToIndex(BodyPartType.Hand_L), BodyPartType.ToIndex(BodyPartType.ForeArm_R) + 1);
        this.getBodyPart(BodyPartType.FromIndex(n)).AddDamage(10.0f);
        this.getBodyPart(BodyPartType.FromIndex(n)).SetScratchedWindow(true);
        return this.getBodyPart(BodyPartType.FromIndex(n));
    }

    public void SetScratched(BodyPartType bodyPartType, boolean bl) {
        this.getBodyParts().get(BodyPartType.ToIndex(bodyPartType)).setScratched(bl, false);
    }

    public void SetScratched(int n, boolean bl) {
        this.getBodyParts().get(n).setScratched(bl, false);
    }

    public void SetScratchedFromWeapon(int n, boolean bl) {
        this.getBodyParts().get(n).SetScratchedWeapon(bl);
    }

    public void SetCut(int n, boolean bl) {
        this.getBodyParts().get(n).setCut(bl, false);
    }

    public void SetWounded(BodyPartType bodyPartType, boolean bl) {
        this.getBodyParts().get(BodyPartType.ToIndex(bodyPartType)).setDeepWounded(bl);
    }

    public void SetWounded(int n, boolean bl) {
        this.getBodyParts().get(n).setDeepWounded(bl);
    }

    public void ShowDebugInfo() {
        if (this.getDamageModCount() > 0) {
            this.setDamageModCount(this.getDamageModCount() - 1);
        }
    }

    public void UpdateBoredom() {
        if (this.getParentChar() instanceof IsoSurvivor) {
            return;
        }
        if (this.getParentChar() instanceof IsoPlayer && ((IsoPlayer)this.getParentChar()).Asleep) {
            return;
        }
        if (this.getParentChar().getCurrentSquare().isInARoom()) {
            if (!this.getParentChar().isReading()) {
                this.setBoredomLevel((float)((double)this.getBoredomLevel() + ZomboidGlobals.BoredomIncreaseRate * (double)GameTime.instance.getMultiplier()));
            } else {
                this.setBoredomLevel((float)((double)this.getBoredomLevel() + ZomboidGlobals.BoredomIncreaseRate / 5.0 * (double)GameTime.instance.getMultiplier()));
            }
            if (this.getParentChar().IsSpeaking() && !this.getParentChar().callOut) {
                this.setBoredomLevel((float)((double)this.getBoredomLevel() - ZomboidGlobals.BoredomDecreaseRate * (double)GameTime.instance.getMultiplier()));
            }
            if (this.getParentChar().getNumSurvivorsInVicinity() > 0) {
                this.setBoredomLevel((float)((double)this.getBoredomLevel() - ZomboidGlobals.BoredomDecreaseRate * (double)0.1f * (double)GameTime.instance.getMultiplier()));
            }
        } else if (this.getParentChar().getVehicle() != null) {
            float f = this.getParentChar().getVehicle().getCurrentSpeedKmHour();
            if (Math.abs(f) <= 0.1f) {
                if (this.getParentChar().isReading()) {
                    this.setBoredomLevel((float)((double)this.getBoredomLevel() + ZomboidGlobals.BoredomIncreaseRate / 5.0 * (double)GameTime.instance.getMultiplier()));
                } else {
                    this.setBoredomLevel((float)((double)this.getBoredomLevel() + ZomboidGlobals.BoredomIncreaseRate * (double)GameTime.instance.getMultiplier()));
                }
            } else {
                this.setBoredomLevel((float)((double)this.getBoredomLevel() - ZomboidGlobals.BoredomDecreaseRate * 0.5 * (double)GameTime.instance.getMultiplier()));
            }
        } else {
            this.setBoredomLevel((float)((double)this.getBoredomLevel() - ZomboidGlobals.BoredomDecreaseRate * (double)0.1f * (double)GameTime.instance.getMultiplier()));
        }
        if (this.getParentChar().getStats().Drunkenness > 20.0f) {
            this.setBoredomLevel((float)((double)this.getBoredomLevel() - ZomboidGlobals.BoredomDecreaseRate * 2.0 * (double)GameTime.instance.getMultiplier()));
        }
        if (this.getParentChar().getStats().Panic > 5.0f) {
            this.setBoredomLevel(0.0f);
        }
        if (this.getBoredomLevel() > 100.0f) {
            this.setBoredomLevel(100.0f);
        }
        if (this.getBoredomLevel() < 0.0f) {
            this.setBoredomLevel(0.0f);
        }
        if (this.getUnhappynessLevel() > 100.0f) {
            this.setUnhappynessLevel(100.0f);
        }
        if (this.getUnhappynessLevel() < 0.0f) {
            this.setUnhappynessLevel(0.0f);
        }
        if (this.getParentChar().getMoodles().getMoodleLevel(MoodleType.Bored) > 1 && !this.getParentChar().isReading()) {
            this.setUnhappynessLevel((float)((double)this.getUnhappynessLevel() + ZomboidGlobals.UnhappinessIncrease * (double)this.getParentChar().getMoodles().getMoodleLevel(MoodleType.Bored) * (double)GameTime.instance.getMultiplier()));
        }
        if (this.getParentChar().getMoodles().getMoodleLevel(MoodleType.Stress) > 1 && !this.getParentChar().isReading()) {
            this.setUnhappynessLevel((float)((double)this.getUnhappynessLevel() + ZomboidGlobals.UnhappinessIncrease / 2.0 * (double)this.getParentChar().getMoodles().getMoodleLevel(MoodleType.Stress) * (double)GameTime.instance.getMultiplier()));
        }
        if (this.getParentChar().Traits.Smoker.isSet()) {
            this.getParentChar().setTimeSinceLastSmoke(this.getParentChar().getTimeSinceLastSmoke() + 1.0E-4f * GameTime.instance.getMultiplier());
            if (this.getParentChar().getTimeSinceLastSmoke() > 1.0f) {
                double d = Math.floor(this.getParentChar().getTimeSinceLastSmoke() / 10.0f) + 1.0;
                if (d > 10.0) {
                    d = 10.0;
                }
                this.getParentChar().getStats().setStressFromCigarettes((float)((double)this.getParentChar().getStats().getStressFromCigarettes() + ZomboidGlobals.StressFromBiteOrScratch / 8.0 * d * (double)GameTime.instance.getMultiplier()));
            }
        }
    }

    public float getUnhappynessLevel() {
        return this.UnhappynessLevel;
    }

    public float getBoredomLevel() {
        return this.BoredomLevel;
    }

    public void UpdateStrength() {
        if (this.getParentChar() != this.getParentChar()) {
            return;
        }
        int n = 0;
        if (this.getParentChar().getMoodles().getMoodleLevel(MoodleType.Hungry) == 2) {
            ++n;
        }
        if (this.getParentChar().getMoodles().getMoodleLevel(MoodleType.Hungry) == 3) {
            n += 2;
        }
        if (this.getParentChar().getMoodles().getMoodleLevel(MoodleType.Hungry) == 4) {
            n += 2;
        }
        if (this.getParentChar().getMoodles().getMoodleLevel(MoodleType.Thirst) == 2) {
            ++n;
        }
        if (this.getParentChar().getMoodles().getMoodleLevel(MoodleType.Thirst) == 3) {
            n += 2;
        }
        if (this.getParentChar().getMoodles().getMoodleLevel(MoodleType.Thirst) == 4) {
            n += 2;
        }
        if (this.getParentChar().getMoodles().getMoodleLevel(MoodleType.Sick) == 2) {
            ++n;
        }
        if (this.getParentChar().getMoodles().getMoodleLevel(MoodleType.Sick) == 3) {
            n += 2;
        }
        if (this.getParentChar().getMoodles().getMoodleLevel(MoodleType.Sick) == 4) {
            n += 3;
        }
        if (this.getParentChar().getMoodles().getMoodleLevel(MoodleType.Bleeding) == 2) {
            ++n;
        }
        if (this.getParentChar().getMoodles().getMoodleLevel(MoodleType.Bleeding) == 3) {
            ++n;
        }
        if (this.getParentChar().getMoodles().getMoodleLevel(MoodleType.Bleeding) == 4) {
            ++n;
        }
        if (this.getParentChar().getMoodles().getMoodleLevel(MoodleType.Injured) == 2) {
            ++n;
        }
        if (this.getParentChar().getMoodles().getMoodleLevel(MoodleType.Injured) == 3) {
            n += 2;
        }
        if (this.getParentChar().getMoodles().getMoodleLevel(MoodleType.Injured) == 4) {
            n += 3;
        }
        this.getParentChar().setMaxWeight((int)((float)this.getParentChar().getMaxWeightBase() * this.getParentChar().getWeightMod()) - n);
        if (this.getParentChar().getMaxWeight() < 0) {
            this.getParentChar().setMaxWeight(0);
        }
        if (this.getParentChar().getMoodles().getMoodleLevel(MoodleType.FoodEaten) > 0) {
            this.getParentChar().setMaxWeight(this.getParentChar().getMaxWeight() + 2);
        }
        if (this.getParentChar() instanceof IsoPlayer) {
            this.getParentChar().setMaxWeight((int)((float)this.getParentChar().getMaxWeight() * ((IsoPlayer)this.getParentChar()).getMaxWeightDelta()));
        }
    }

    public float pickMortalityDuration() {
        float f = 1.0f;
        if (this.getParentChar().Traits.Resilient.isSet()) {
            f = 1.25f;
        }
        if (this.getParentChar().Traits.ProneToIllness.isSet()) {
            f = 0.75f;
        }
        switch (SandboxOptions.instance.Lore.Mortality.getValue()) {
            case 1: {
                return 0.0f;
            }
            case 2: {
                return Rand.Next(0.0f, 30.0f) / 3600.0f * f;
            }
            case 3: {
                return Rand.Next(0.5f, 1.0f) / 60.0f * f;
            }
            case 4: {
                return Rand.Next(3.0f, 12.0f) * f;
            }
            case 5: {
                return Rand.Next(2.0f, 3.0f) * 24.0f * f;
            }
            case 6: {
                return Rand.Next(1.0f, 2.0f) * 7.0f * 24.0f * f;
            }
            case 7: {
                return -1.0f;
            }
        }
        return -1.0f;
    }

    public void Update() {
        int n;
        float f;
        if (this.getParentChar() instanceof IsoZombie) {
            return;
        }
        if (GameServer.bServer) {
            this.RestoreToFullHealth();
            byte by = ((IsoPlayer)this.getParentChar()).bleedingLevel;
            if (by > 0) {
                float f2 = 1.0f / (float)by * 200.0f * GameTime.instance.getInvMultiplier();
                if ((float)Rand.Next((int)f2) < f2 * 0.3f) {
                    this.getParentChar().splatBloodFloor();
                }
                if (Rand.Next((int)f2) == 0) {
                    this.getParentChar().splatBloodFloor();
                }
            }
            return;
        }
        if (GameClient.bClient && this.getParentChar() instanceof IsoPlayer && ((IsoPlayer)this.getParentChar()).bRemote) {
            if (this.getParentChar().isAlive()) {
                this.RestoreToFullHealth();
                byte by = ((IsoPlayer)this.getParentChar()).bleedingLevel;
                if (by > 0) {
                    float f3 = 1.0f / (float)by * 200.0f * GameTime.instance.getInvMultiplier();
                    if ((float)Rand.Next((int)f3) < f3 * 0.3f) {
                        this.getParentChar().splatBloodFloor();
                    }
                    if (Rand.Next((int)f3) == 0) {
                        this.getParentChar().splatBloodFloor();
                    }
                }
            }
            return;
        }
        if (this.getParentChar().isGodMod()) {
            this.RestoreToFullHealth();
            ((IsoPlayer)this.getParentChar()).bleedingLevel = 0;
            return;
        }
        if (this.getParentChar().isInvincible()) {
            this.setOverallBodyHealth(100.0f);
            for (int i = 0; i < BodyPartType.MAX.index(); ++i) {
                this.getBodyPart(BodyPartType.FromIndex(i)).SetHealth(100.0f);
            }
            return;
        }
        float f4 = this.ParentChar.getStats().Pain;
        int n2 = this.getNumPartsBleeding() * 2;
        n2 += this.getNumPartsScratched();
        if (this.getHealth() >= 60.0f && (n2 += this.getNumPartsBitten() * 6) <= 3) {
            n2 = 0;
        }
        ((IsoPlayer)this.getParentChar()).bleedingLevel = (byte)n2;
        if (n2 > 0) {
            f = 1.0f / (float)n2 * 200.0f * GameTime.instance.getInvMultiplier();
            if ((float)Rand.Next((int)f) < f * 0.3f) {
                this.getParentChar().splatBloodFloor();
            }
            if (Rand.Next((int)f) == 0) {
                this.getParentChar().splatBloodFloor();
            }
        }
        if (this.thermoregulator != null) {
            this.thermoregulator.update();
        }
        this.UpdateWetness();
        this.UpdateCold();
        this.UpdateBoredom();
        this.UpdateStrength();
        this.UpdatePanicState();
        this.UpdateTemperatureState();
        this.UpdateIllness();
        if (this.getOverallBodyHealth() == 0.0f) {
            return;
        }
        if (this.PoisonLevel == 0.0f && this.getFoodSicknessLevel() > 0.0f) {
            this.setFoodSicknessLevel(this.getFoodSicknessLevel() - (float)(ZomboidGlobals.FoodSicknessDecrease * (double)GameTime.instance.getMultiplier()));
        }
        if (!this.isInfected()) {
            for (int i = 0; i < BodyPartType.ToIndex(BodyPartType.MAX); ++i) {
                if (!this.IsInfected(i)) continue;
                this.setInfected(true);
                if (!this.IsFakeInfected(i)) continue;
                this.DisableFakeInfection(i);
                this.setInfectionLevel(this.getFakeInfectionLevel());
                this.setFakeInfectionLevel(0.0f);
                this.setIsFakeInfected(false);
                this.setReduceFakeInfection(false);
            }
            if (this.isInfected() && this.getInfectionTime() < 0.0f && SandboxOptions.instance.Lore.Mortality.getValue() != 7) {
                this.setInfectionTime(this.getCurrentTimeForInfection());
                this.setInfectionMortalityDuration(this.pickMortalityDuration());
            }
        }
        if (!this.isInfected() && !this.isIsFakeInfected()) {
            for (int i = 0; i < BodyPartType.ToIndex(BodyPartType.MAX); ++i) {
                if (!this.IsFakeInfected(i)) continue;
                this.setIsFakeInfected(true);
                break;
            }
        }
        if (this.isIsFakeInfected() && !this.isReduceFakeInfection() && this.getParentChar().getReduceInfectionPower() == 0.0f) {
            this.setFakeInfectionLevel(this.getFakeInfectionLevel() + this.getInfectionGrowthRate() * GameTime.instance.getMultiplier());
            if (this.getFakeInfectionLevel() > 100.0f) {
                this.setFakeInfectionLevel(100.0f);
                this.setReduceFakeInfection(true);
            }
        }
        this.ParentChar.getStats().Drunkenness -= this.getDrunkReductionValue() * GameTime.instance.getMultiplier();
        if (this.getParentChar().getStats().Drunkenness < 0.0f) {
            this.ParentChar.getStats().Drunkenness = 0.0f;
        }
        f = 0.0f;
        if (this.getHealthFromFoodTimer() > 0.0f) {
            f += this.getHealthFromFood() * GameTime.instance.getMultiplier();
            this.setHealthFromFoodTimer(this.getHealthFromFoodTimer() - 1.0f * GameTime.instance.getMultiplier());
        }
        int n3 = 0;
        if (this.getParentChar() == this.getParentChar() && (this.getParentChar().getMoodles().getMoodleLevel(MoodleType.Hungry) == 2 || this.getParentChar().getMoodles().getMoodleLevel(MoodleType.Sick) == 2 || this.getParentChar().getMoodles().getMoodleLevel(MoodleType.Thirst) == 2)) {
            n3 = 1;
        }
        if (this.getParentChar() == this.getParentChar() && (this.getParentChar().getMoodles().getMoodleLevel(MoodleType.Hungry) == 3 || this.getParentChar().getMoodles().getMoodleLevel(MoodleType.Sick) == 3 || this.getParentChar().getMoodles().getMoodleLevel(MoodleType.Thirst) == 3)) {
            n3 = 2;
        }
        if (this.getParentChar() == this.getParentChar() && (this.getParentChar().getMoodles().getMoodleLevel(MoodleType.Hungry) == 4 || this.getParentChar().getMoodles().getMoodleLevel(MoodleType.Thirst) == 4)) {
            n3 = 3;
        }
        if (this.getParentChar().isAsleep()) {
            n3 = -1;
        }
        switch (n3) {
            case 0: {
                f += this.getStandardHealthAddition() * GameTime.instance.getMultiplier();
                break;
            }
            case 1: {
                f += this.getReducedHealthAddition() * GameTime.instance.getMultiplier();
                break;
            }
            case 2: {
                f += this.getSeverlyReducedHealthAddition() * GameTime.instance.getMultiplier();
                break;
            }
            case 3: {
                f += 0.0f;
            }
        }
        if (this.getParentChar().isAsleep()) {
            f = GameClient.bClient ? (f += 15.0f * GameTime.instance.getGameWorldSecondsSinceLastUpdate() / 3600.0f) : (f += this.getSleepingHealthAddition() * GameTime.instance.getMultiplier());
            if (this.getParentChar().getMoodles().getMoodleLevel(MoodleType.Hungry) == 4 || this.getParentChar().getMoodles().getMoodleLevel(MoodleType.Thirst) == 4) {
                f = 0.0f;
            }
        }
        this.AddGeneralHealth(f);
        f = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        if (this.PoisonLevel > 0.0f) {
            if (this.PoisonLevel > 10.0f && this.getParentChar().getMoodles().getMoodleLevel(MoodleType.Sick) >= 1) {
                f5 = 0.0035f * Math.min(this.PoisonLevel / 10.0f, 3.0f) * GameTime.instance.getMultiplier();
                f += f5;
            }
            float f11 = 0.0f;
            if (this.getParentChar().getMoodles().getMoodleLevel(MoodleType.FoodEaten) > 0) {
                f11 = 1.5E-4f * (float)this.getParentChar().getMoodles().getMoodleLevel(MoodleType.FoodEaten);
            }
            this.PoisonLevel = (float)((double)this.PoisonLevel - ((double)f11 + ZomboidGlobals.PoisonLevelDecrease * (double)GameTime.instance.getMultiplier()));
            if (this.PoisonLevel < 0.0f) {
                this.PoisonLevel = 0.0f;
            }
            this.setFoodSicknessLevel(this.getFoodSicknessLevel() + this.getInfectionGrowthRate() * (float)(2 + Math.round(this.PoisonLevel / 10.0f)) * GameTime.instance.getMultiplier());
            if (this.getFoodSicknessLevel() > 100.0f) {
                this.setFoodSicknessLevel(100.0f);
            }
        }
        if (this.getParentChar().getMoodles().getMoodleLevel(MoodleType.Hungry) == 4) {
            f6 = this.getHealthReductionFromSevereBadMoodles() / 50.0f * GameTime.instance.getMultiplier();
            f += f6;
        }
        if (this.getParentChar().getMoodles().getMoodleLevel(MoodleType.Sick) == 4 && this.FoodSicknessLevel > this.InfectionLevel) {
            f7 = this.getHealthReductionFromSevereBadMoodles() * GameTime.instance.getMultiplier();
            f += f7;
        }
        if (this.getParentChar().getMoodles().getMoodleLevel(MoodleType.Bleeding) == 4) {
            f8 = this.getHealthReductionFromSevereBadMoodles() * GameTime.instance.getMultiplier();
            f += f8;
        }
        if (this.getParentChar().getMoodles().getMoodleLevel(MoodleType.Thirst) == 4) {
            f9 = this.getHealthReductionFromSevereBadMoodles() / 10.0f * GameTime.instance.getMultiplier();
            f += f9;
        }
        if (this.getParentChar().getMoodles().getMoodleLevel(MoodleType.HeavyLoad) > 2 && this.getParentChar().getVehicle() == null && !this.getParentChar().isAsleep() && !this.getParentChar().isSitOnGround() && this.getThermoregulator().getMetabolicTarget() != Metabolics.SeatedResting.getMet() && this.getHealth() > 75.0f && Rand.Next(Rand.AdjustForFramerate(10)) == 0) {
            f10 = this.getHealthReductionFromSevereBadMoodles() / ((float)(5 - this.getParentChar().getMoodles().getMoodleLevel(MoodleType.HeavyLoad)) / 10.0f) * GameTime.instance.getMultiplier();
            f += f10;
        }
        this.ReduceGeneralHealth(f);
        IsoGameCharacter isoGameCharacter = this.getParentChar();
        if (f5 > 0.0f) {
            LuaEventManager.triggerEvent("OnPlayerGetDamage", isoGameCharacter, "POISON", Float.valueOf(f5));
        }
        if (f6 > 0.0f) {
            LuaEventManager.triggerEvent("OnPlayerGetDamage", isoGameCharacter, "HUNGRY", Float.valueOf(f6));
        }
        if (f7 > 0.0f) {
            LuaEventManager.triggerEvent("OnPlayerGetDamage", isoGameCharacter, "SICK", Float.valueOf(f7));
        }
        if (f8 > 0.0f) {
            LuaEventManager.triggerEvent("OnPlayerGetDamage", isoGameCharacter, "BLEEDING", Float.valueOf(f8));
        }
        if (f9 > 0.0f) {
            LuaEventManager.triggerEvent("OnPlayerGetDamage", isoGameCharacter, "THIRST", Float.valueOf(f9));
        }
        if (f10 > 0.0f) {
            LuaEventManager.triggerEvent("OnPlayerGetDamage", isoGameCharacter, "HEAVYLOAD", Float.valueOf(f10));
        }
        if (this.ParentChar.getPainEffect() > 0.0f) {
            this.ParentChar.getStats().Pain -= 0.023333333f * (GameTime.getInstance().getMultiplier() / 1.6f);
            this.ParentChar.setPainEffect(this.ParentChar.getPainEffect() - GameTime.getInstance().getMultiplier() / 1.6f);
        } else {
            this.ParentChar.setPainDelta(0.0f);
            f = 0.0f;
            for (int i = 0; i < BodyPartType.ToIndex(BodyPartType.MAX); ++i) {
                f += this.getBodyParts().get(i).getPain() * BodyPartType.getPainModifyer(i);
            }
            this.ParentChar.getStats().Pain = (f -= this.getPainReduction()) > this.ParentChar.getStats().Pain ? (this.ParentChar.getStats().Pain += (f - this.ParentChar.getStats().Pain) / 500.0f) : f;
        }
        this.setPainReduction(this.getPainReduction() - 0.005f * GameTime.getInstance().getMultiplier());
        if (this.getPainReduction() < 0.0f) {
            this.setPainReduction(0.0f);
        }
        if (this.getParentChar().getStats().Pain > 100.0f) {
            this.ParentChar.getStats().Pain = 100.0f;
        }
        if (this.isInfected()) {
            int n4 = SandboxOptions.instance.Lore.Mortality.getValue();
            if (n4 == 1) {
                this.ReduceGeneralHealth(110.0f);
                LuaEventManager.triggerEvent("OnPlayerGetDamage", this.ParentChar, "INFECTION", 110);
                this.setInfectionLevel(100.0f);
            } else if (n4 != 7) {
                float f12 = this.getCurrentTimeForInfection();
                if (this.InfectionMortalityDuration < 0.0f) {
                    this.InfectionMortalityDuration = this.pickMortalityDuration();
                }
                if (this.InfectionTime < 0.0f) {
                    this.InfectionTime = f12;
                }
                if (this.InfectionTime > f12) {
                    this.InfectionTime = f12;
                }
                f6 = (f12 - this.InfectionTime) / this.InfectionMortalityDuration;
                f6 = Math.min(f6, 1.0f);
                this.setInfectionLevel(f6 * 100.0f);
                if (f6 == 1.0f) {
                    this.ReduceGeneralHealth(110.0f);
                    LuaEventManager.triggerEvent("OnPlayerGetDamage", this.ParentChar, "INFECTION", 110);
                } else {
                    f6 *= f6;
                    f6 *= f6;
                    f7 = (1.0f - f6) * 100.0f;
                    f8 = this.getOverallBodyHealth() - f7;
                    if (f8 > 0.0f && f7 <= 99.0f) {
                        this.ReduceGeneralHealth(f8);
                        LuaEventManager.triggerEvent("OnPlayerGetDamage", this.ParentChar, "INFECTION", Float.valueOf(f8));
                    }
                }
            }
        }
        for (n = 0; n < BodyPartType.ToIndex(BodyPartType.MAX); ++n) {
            this.getBodyParts().get(n).DamageUpdate();
        }
        this.calculateOverallHealth();
        if (this.getOverallBodyHealth() <= 0.0f) {
            if (GameClient.bClient && this.getParentChar() instanceof IsoPlayer && !((IsoPlayer)this.getParentChar()).bRemote) {
                GameClient.sendPlayerDamage((IsoPlayer)this.getParentChar());
            }
            if (this.isIsOnFire()) {
                this.setBurntToDeath(true);
                for (n = 0; n < BodyPartType.ToIndex(BodyPartType.MAX); ++n) {
                    this.getBodyParts().get(n).SetHealth(Rand.Next(90));
                }
            } else {
                this.setBurntToDeath(false);
            }
        }
        if (this.isReduceFakeInfection() && this.getOverallBodyHealth() > 0.0f) {
            this.setFakeInfectionLevel(this.getFakeInfectionLevel() - this.getInfectionGrowthRate() * GameTime.instance.getMultiplier() * 2.0f);
        }
        if (this.getParentChar().getReduceInfectionPower() > 0.0f && this.getOverallBodyHealth() > 0.0f) {
            this.setFakeInfectionLevel(this.getFakeInfectionLevel() - this.getInfectionGrowthRate() * GameTime.instance.getMultiplier());
            this.getParentChar().setReduceInfectionPower(this.getParentChar().getReduceInfectionPower() - this.getInfectionGrowthRate() * GameTime.instance.getMultiplier());
            if (this.getParentChar().getReduceInfectionPower() < 0.0f) {
                this.getParentChar().setReduceInfectionPower(0.0f);
            }
        }
        if (this.getFakeInfectionLevel() <= 0.0f) {
            for (n = 0; n < BodyPartType.ToIndex(BodyPartType.MAX); ++n) {
                this.getBodyParts().get(n).SetFakeInfected(false);
            }
            this.setIsFakeInfected(false);
            this.setFakeInfectionLevel(0.0f);
            this.setReduceFakeInfection(false);
        }
        if (f4 == this.ParentChar.getStats().Pain) {
            this.ParentChar.getStats().Pain = (float)((double)this.ParentChar.getStats().Pain - 0.25 * (double)(GameTime.getInstance().getMultiplier() / 1.6f));
        }
        if (this.ParentChar.getStats().Pain < 0.0f) {
            this.ParentChar.getStats().Pain = 0.0f;
        }
    }

    private void calculateOverallHealth() {
        float f = 0.0f;
        for (int i = 0; i < BodyPartType.ToIndex(BodyPartType.MAX); ++i) {
            BodyPart bodyPart = this.getBodyParts().get(i);
            f += (100.0f - bodyPart.getHealth()) * BodyPartType.getDamageModifyer(i);
        }
        if ((f += this.getDamageFromPills()) > 100.0f) {
            f = 100.0f;
        }
        this.setOverallBodyHealth(100.0f - f);
    }

    public static float getSicknessFromCorpsesRate(int n) {
        if (SandboxOptions.instance.DecayingCorpseHealthImpact.getValue() == 1) {
            return 0.0f;
        }
        if (n > 5) {
            float f = (float)ZomboidGlobals.FoodSicknessDecrease * 0.07f;
            switch (SandboxOptions.instance.DecayingCorpseHealthImpact.getValue()) {
                case 2: {
                    f = (float)ZomboidGlobals.FoodSicknessDecrease * 0.01f;
                    break;
                }
                case 4: {
                    f = (float)ZomboidGlobals.FoodSicknessDecrease * 0.11f;
                }
            }
            int n2 = Math.min(n - 5, 20);
            return f * (float)n2;
        }
        return 0.0f;
    }

    private void UpdateIllness() {
        if (SandboxOptions.instance.DecayingCorpseHealthImpact.getValue() == 1) {
            return;
        }
        int n = FliesSound.instance.getCorpseCount(this.getParentChar());
        float f = BodyDamage.getSicknessFromCorpsesRate(n);
        if (f > 0.0f) {
            this.setFoodSicknessLevel(this.getFoodSicknessLevel() + f * GameTime.getInstance().getMultiplier());
        }
    }

    private void UpdateTemperatureState() {
        float f = 0.06f;
        if (this.getParentChar() instanceof IsoPlayer) {
            float f2;
            if (this.ColdDamageStage > 0.0f && this.OverallBodyHealth > (f2 = 100.0f - this.ColdDamageStage * 100.0f)) {
                this.ReduceGeneralHealth(this.OverallBodyHealth - f2);
            }
            ((IsoPlayer)this.getParentChar()).setMoveSpeed(f);
        }
    }

    private float getDamageFromPills() {
        if (this.getParentChar() instanceof IsoPlayer) {
            IsoPlayer isoPlayer = (IsoPlayer)this.getParentChar();
            if (isoPlayer.getSleepingPillsTaken() == 10) {
                return 40.0f;
            }
            if (isoPlayer.getSleepingPillsTaken() == 11) {
                return 80.0f;
            }
            if (isoPlayer.getSleepingPillsTaken() >= 12) {
                return 100.0f;
            }
        }
        return 0.0f;
    }

    public boolean UseBandageOnMostNeededPart() {
        int n = 0;
        BodyPart bodyPart = null;
        for (int i = 0; i < this.getBodyParts().size(); ++i) {
            int n2 = 0;
            if (this.getBodyParts().get(i).bandaged()) continue;
            if (this.getBodyParts().get(i).bleeding()) {
                n2 += 100;
            }
            if (this.getBodyParts().get(i).scratched()) {
                n2 += 50;
            }
            if (this.getBodyParts().get(i).bitten()) {
                n2 += 50;
            }
            if (n2 <= n) continue;
            n = n2;
            bodyPart = this.getBodyParts().get(i);
        }
        if (n > 0 && bodyPart != null) {
            bodyPart.setBandaged(true, 10.0f);
            return true;
        }
        return false;
    }

    public ArrayList<BodyPart> getBodyParts() {
        return this.BodyParts;
    }

    public int getDamageModCount() {
        return this.DamageModCount;
    }

    public void setDamageModCount(int n) {
        this.DamageModCount = n;
    }

    public float getInfectionGrowthRate() {
        return this.InfectionGrowthRate;
    }

    public void setInfectionGrowthRate(float f) {
        this.InfectionGrowthRate = f;
    }

    public void setInfectionLevel(float f) {
        this.InfectionLevel = f;
    }

    public boolean isInfected() {
        return this.IsInfected;
    }

    public void setInfected(boolean bl) {
        this.IsInfected = bl;
    }

    public float getInfectionTime() {
        return this.InfectionTime;
    }

    public void setInfectionTime(float f) {
        this.InfectionTime = f;
    }

    public float getInfectionMortalityDuration() {
        return this.InfectionMortalityDuration;
    }

    public void setInfectionMortalityDuration(float f) {
        this.InfectionMortalityDuration = f;
    }

    private float getCurrentTimeForInfection() {
        if (this.getParentChar() instanceof IsoPlayer) {
            return (float)((IsoPlayer)this.getParentChar()).getHoursSurvived();
        }
        return (float)GameTime.getInstance().getWorldAgeHours();
    }

    @Deprecated
    public boolean isInf() {
        return this.IsInfected;
    }

    @Deprecated
    public void setInf(boolean bl) {
        this.IsInfected = bl;
    }

    public float getFakeInfectionLevel() {
        return this.FakeInfectionLevel;
    }

    public void setFakeInfectionLevel(float f) {
        this.FakeInfectionLevel = f;
    }

    public boolean isIsFakeInfected() {
        return this.IsFakeInfected;
    }

    public void setIsFakeInfected(boolean bl) {
        this.IsFakeInfected = bl;
        this.getBodyParts().get(0).SetFakeInfected(bl);
    }

    public float getOverallBodyHealth() {
        return this.OverallBodyHealth;
    }

    public void setOverallBodyHealth(float f) {
        this.OverallBodyHealth = f;
    }

    public float getStandardHealthAddition() {
        return this.StandardHealthAddition;
    }

    public void setStandardHealthAddition(float f) {
        this.StandardHealthAddition = f;
    }

    public float getReducedHealthAddition() {
        return this.ReducedHealthAddition;
    }

    public void setReducedHealthAddition(float f) {
        this.ReducedHealthAddition = f;
    }

    public float getSeverlyReducedHealthAddition() {
        return this.SeverlyReducedHealthAddition;
    }

    public void setSeverlyReducedHealthAddition(float f) {
        this.SeverlyReducedHealthAddition = f;
    }

    public float getSleepingHealthAddition() {
        return this.SleepingHealthAddition;
    }

    public void setSleepingHealthAddition(float f) {
        this.SleepingHealthAddition = f;
    }

    public float getHealthFromFood() {
        return this.HealthFromFood;
    }

    public void setHealthFromFood(float f) {
        this.HealthFromFood = f;
    }

    public float getHealthReductionFromSevereBadMoodles() {
        return this.HealthReductionFromSevereBadMoodles;
    }

    public void setHealthReductionFromSevereBadMoodles(float f) {
        this.HealthReductionFromSevereBadMoodles = f;
    }

    public int getStandardHealthFromFoodTime() {
        return this.StandardHealthFromFoodTime;
    }

    public void setStandardHealthFromFoodTime(int n) {
        this.StandardHealthFromFoodTime = n;
    }

    public float getHealthFromFoodTimer() {
        return this.HealthFromFoodTimer;
    }

    public void setHealthFromFoodTimer(float f) {
        this.HealthFromFoodTimer = f;
    }

    public void setBoredomLevel(float f) {
        this.BoredomLevel = f;
    }

    public float getBoredomDecreaseFromReading() {
        return this.BoredomDecreaseFromReading;
    }

    public void setBoredomDecreaseFromReading(float f) {
        this.BoredomDecreaseFromReading = f;
    }

    public float getInitialThumpPain() {
        return this.InitialThumpPain;
    }

    public void setInitialThumpPain(float f) {
        this.InitialThumpPain = f;
    }

    public float getInitialScratchPain() {
        return this.InitialScratchPain;
    }

    public void setInitialScratchPain(float f) {
        this.InitialScratchPain = f;
    }

    public float getInitialBitePain() {
        return this.InitialBitePain;
    }

    public void setInitialBitePain(float f) {
        this.InitialBitePain = f;
    }

    public float getInitialWoundPain() {
        return this.InitialWoundPain;
    }

    public void setInitialWoundPain(float f) {
        this.InitialWoundPain = f;
    }

    public float getContinualPainIncrease() {
        return this.ContinualPainIncrease;
    }

    public void setContinualPainIncrease(float f) {
        this.ContinualPainIncrease = f;
    }

    public float getPainReductionFromMeds() {
        return this.PainReductionFromMeds;
    }

    public void setPainReductionFromMeds(float f) {
        this.PainReductionFromMeds = f;
    }

    public float getStandardPainReductionWhenWell() {
        return this.StandardPainReductionWhenWell;
    }

    public void setStandardPainReductionWhenWell(float f) {
        this.StandardPainReductionWhenWell = f;
    }

    public int getOldNumZombiesVisible() {
        return this.OldNumZombiesVisible;
    }

    public void setOldNumZombiesVisible(int n) {
        this.OldNumZombiesVisible = n;
    }

    public int getCurrentNumZombiesVisible() {
        return this.CurrentNumZombiesVisible;
    }

    public void setCurrentNumZombiesVisible(int n) {
        this.CurrentNumZombiesVisible = n;
    }

    public float getPanicIncreaseValue() {
        return this.PanicIncreaseValue;
    }

    public float getPanicIncreaseValueFrame() {
        return this.PanicIncreaseValueFrame;
    }

    public void setPanicIncreaseValue(float f) {
        this.PanicIncreaseValue = f;
    }

    public float getPanicReductionValue() {
        return this.PanicReductionValue;
    }

    public void setPanicReductionValue(float f) {
        this.PanicReductionValue = f;
    }

    public float getDrunkIncreaseValue() {
        return this.DrunkIncreaseValue;
    }

    public void setDrunkIncreaseValue(float f) {
        this.DrunkIncreaseValue = f;
    }

    public float getDrunkReductionValue() {
        return this.DrunkReductionValue;
    }

    public void setDrunkReductionValue(float f) {
        this.DrunkReductionValue = f;
    }

    public boolean isIsOnFire() {
        return this.IsOnFire;
    }

    public void setIsOnFire(boolean bl) {
        this.IsOnFire = bl;
    }

    public boolean isBurntToDeath() {
        return this.BurntToDeath;
    }

    public void setBurntToDeath(boolean bl) {
        this.BurntToDeath = bl;
    }

    public void setWetness(float f) {
        float f2 = 0.0f;
        if (this.BodyParts.size() > 0) {
            for (int i = 0; i < this.BodyParts.size(); ++i) {
                BodyPart bodyPart = this.BodyParts.get(i);
                bodyPart.setWetness(f);
                f2 += bodyPart.getWetness();
            }
            f2 /= (float)this.BodyParts.size();
        }
        this.Wetness = PZMath.clamp(f2, 0.0f, 100.0f);
    }

    public float getCatchACold() {
        return this.CatchACold;
    }

    public void setCatchACold(float f) {
        this.CatchACold = f;
    }

    public boolean isHasACold() {
        return this.HasACold;
    }

    public void setHasACold(boolean bl) {
        this.HasACold = bl;
    }

    public void setColdStrength(float f) {
        this.ColdStrength = f;
    }

    public float getColdProgressionRate() {
        return this.ColdProgressionRate;
    }

    public void setColdProgressionRate(float f) {
        this.ColdProgressionRate = f;
    }

    public int getTimeToSneezeOrCough() {
        return this.TimeToSneezeOrCough;
    }

    public void setTimeToSneezeOrCough(int n) {
        this.TimeToSneezeOrCough = n;
    }

    public int getMildColdSneezeTimerMin() {
        return this.MildColdSneezeTimerMin;
    }

    public void setMildColdSneezeTimerMin(int n) {
        this.MildColdSneezeTimerMin = n;
    }

    public int getMildColdSneezeTimerMax() {
        return this.MildColdSneezeTimerMax;
    }

    public void setMildColdSneezeTimerMax(int n) {
        this.MildColdSneezeTimerMax = n;
    }

    public int getColdSneezeTimerMin() {
        return this.ColdSneezeTimerMin;
    }

    public void setColdSneezeTimerMin(int n) {
        this.ColdSneezeTimerMin = n;
    }

    public int getColdSneezeTimerMax() {
        return this.ColdSneezeTimerMax;
    }

    public void setColdSneezeTimerMax(int n) {
        this.ColdSneezeTimerMax = n;
    }

    public int getNastyColdSneezeTimerMin() {
        return this.NastyColdSneezeTimerMin;
    }

    public void setNastyColdSneezeTimerMin(int n) {
        this.NastyColdSneezeTimerMin = n;
    }

    public int getNastyColdSneezeTimerMax() {
        return this.NastyColdSneezeTimerMax;
    }

    public void setNastyColdSneezeTimerMax(int n) {
        this.NastyColdSneezeTimerMax = n;
    }

    public int getSneezeCoughActive() {
        return this.SneezeCoughActive;
    }

    public void setSneezeCoughActive(int n) {
        this.SneezeCoughActive = n;
    }

    public int getSneezeCoughTime() {
        return this.SneezeCoughTime;
    }

    public void setSneezeCoughTime(int n) {
        this.SneezeCoughTime = n;
    }

    public int getSneezeCoughDelay() {
        return this.SneezeCoughDelay;
    }

    public void setSneezeCoughDelay(int n) {
        this.SneezeCoughDelay = n;
    }

    public void setUnhappynessLevel(float f) {
        this.UnhappynessLevel = f;
    }

    public IsoGameCharacter getParentChar() {
        return this.ParentChar;
    }

    public void setParentChar(IsoGameCharacter isoGameCharacter) {
        this.ParentChar = isoGameCharacter;
    }

    public float getTemperature() {
        return this.Temperature;
    }

    public void setTemperature(float f) {
        this.lastTemperature = this.Temperature;
        this.Temperature = f;
    }

    public float getTemperatureChangeTick() {
        return this.Temperature - this.lastTemperature;
    }

    public void setPoisonLevel(float f) {
        this.PoisonLevel = f;
    }

    public float getPoisonLevel() {
        return this.PoisonLevel;
    }

    public float getFoodSicknessLevel() {
        return this.FoodSicknessLevel;
    }

    public void setFoodSicknessLevel(float f) {
        this.FoodSicknessLevel = Math.max(f, 0.0f);
    }

    public boolean isReduceFakeInfection() {
        return this.reduceFakeInfection;
    }

    public void setReduceFakeInfection(boolean bl) {
        this.reduceFakeInfection = bl;
    }

    public void AddRandomDamage() {
        BodyPart bodyPart = this.getBodyParts().get(Rand.Next(this.getBodyParts().size()));
        switch (Rand.Next(4)) {
            case 0: {
                bodyPart.generateDeepWound();
                if (Rand.Next(4) != 0) break;
                bodyPart.setInfectedWound(true);
                break;
            }
            case 1: {
                bodyPart.generateDeepShardWound();
                if (Rand.Next(4) != 0) break;
                bodyPart.setInfectedWound(true);
                break;
            }
            case 2: {
                bodyPart.setFractureTime(Rand.Next(30, 50));
                break;
            }
            case 3: {
                bodyPart.setBurnTime(Rand.Next(30, 50));
            }
        }
    }

    public float getPainReduction() {
        return this.painReduction;
    }

    public void setPainReduction(float f) {
        this.painReduction = f;
    }

    public float getColdReduction() {
        return this.coldReduction;
    }

    public void setColdReduction(float f) {
        this.coldReduction = f;
    }

    public int getRemotePainLevel() {
        return this.RemotePainLevel;
    }

    public void setRemotePainLevel(int n) {
        this.RemotePainLevel = n;
    }

    public float getColdDamageStage() {
        return this.ColdDamageStage;
    }

    public void setColdDamageStage(float f) {
        this.ColdDamageStage = f;
    }

    public Thermoregulator getThermoregulator() {
        return this.thermoregulator;
    }

    public void decreaseBodyWetness(float f) {
        float f2 = 0.0f;
        if (this.BodyParts.size() > 0) {
            for (int i = 0; i < this.BodyParts.size(); ++i) {
                BodyPart bodyPart = this.BodyParts.get(i);
                bodyPart.setWetness(bodyPart.getWetness() - f);
                f2 += bodyPart.getWetness();
            }
            f2 /= (float)this.BodyParts.size();
        }
        this.Wetness = PZMath.clamp(f2, 0.0f, 100.0f);
    }

    public void increaseBodyWetness(float f) {
        float f2 = 0.0f;
        if (this.BodyParts.size() > 0) {
            for (int i = 0; i < this.BodyParts.size(); ++i) {
                BodyPart bodyPart = this.BodyParts.get(i);
                bodyPart.setWetness(bodyPart.getWetness() + f);
                f2 += bodyPart.getWetness();
            }
            f2 /= (float)this.BodyParts.size();
        }
        this.Wetness = PZMath.clamp(f2, 0.0f, 100.0f);
    }
}

