/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters.AttachedItems;

import java.util.ArrayList;
import zombie.characters.AttachedItems.AttachedLocation;

public final class AttachedLocationGroup {
    protected final String id;
    protected final ArrayList<AttachedLocation> locations = new ArrayList();

    public AttachedLocationGroup(String string) {
        if (string == null) {
            throw new NullPointerException("id is null");
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("id is empty");
        }
        this.id = string;
    }

    public AttachedLocation getLocation(String string) {
        for (int i = 0; i < this.locations.size(); ++i) {
            AttachedLocation attachedLocation = this.locations.get(i);
            if (!attachedLocation.id.equals(string)) continue;
            return attachedLocation;
        }
        return null;
    }

    public AttachedLocation getOrCreateLocation(String string) {
        AttachedLocation attachedLocation = this.getLocation(string);
        if (attachedLocation == null) {
            attachedLocation = new AttachedLocation(this, string);
            this.locations.add(attachedLocation);
        }
        return attachedLocation;
    }

    public AttachedLocation getLocationByIndex(int n) {
        if (n >= 0 && n < this.size()) {
            return this.locations.get(n);
        }
        return null;
    }

    public int size() {
        return this.locations.size();
    }

    public int indexOf(String string) {
        for (int i = 0; i < this.locations.size(); ++i) {
            AttachedLocation attachedLocation = this.locations.get(i);
            if (!attachedLocation.id.equals(string)) continue;
            return i;
        }
        return -1;
    }

    public void checkValid(String string) {
        if (string == null) {
            throw new NullPointerException("locationId is null");
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("locationId is empty");
        }
        if (this.indexOf(string) == -1) {
            throw new RuntimeException("no such location \"" + string + "\"");
        }
    }
}

