/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters.AttachedItems;

import java.util.ArrayList;
import java.util.function.Consumer;
import zombie.characters.AttachedItems.AttachedItem;
import zombie.characters.AttachedItems.AttachedLocationGroup;
import zombie.inventory.InventoryItem;

public final class AttachedItems {
    protected final AttachedLocationGroup group;
    protected final ArrayList<AttachedItem> items = new ArrayList();

    public AttachedItems(AttachedLocationGroup attachedLocationGroup) {
        this.group = attachedLocationGroup;
    }

    public AttachedItems(AttachedItems attachedItems) {
        this.group = attachedItems.group;
        this.copyFrom(attachedItems);
    }

    public void copyFrom(AttachedItems attachedItems) {
        if (this.group != attachedItems.group) {
            throw new RuntimeException("group=" + this.group.id + " other.group=" + attachedItems.group.id);
        }
        this.items.clear();
        this.items.addAll(attachedItems.items);
    }

    public AttachedLocationGroup getGroup() {
        return this.group;
    }

    public AttachedItem get(int n) {
        return this.items.get(n);
    }

    public void setItem(String string, InventoryItem inventoryItem) {
        this.group.checkValid(string);
        int n = this.indexOf(string);
        if (n != -1) {
            this.items.remove(n);
        }
        if (inventoryItem == null) {
            return;
        }
        this.remove(inventoryItem);
        int n2 = this.items.size();
        for (int i = 0; i < this.items.size(); ++i) {
            AttachedItem attachedItem = this.items.get(i);
            if (this.group.indexOf(attachedItem.getLocation()) <= this.group.indexOf(string)) continue;
            n2 = i;
            break;
        }
        AttachedItem attachedItem = new AttachedItem(string, inventoryItem);
        this.items.add(n2, attachedItem);
    }

    public InventoryItem getItem(String string) {
        this.group.checkValid(string);
        int n = this.indexOf(string);
        if (n == -1) {
            return null;
        }
        return this.items.get((int)n).item;
    }

    public InventoryItem getItemByIndex(int n) {
        if (n < 0 || n >= this.items.size()) {
            return null;
        }
        return this.items.get(n).getItem();
    }

    public void remove(InventoryItem inventoryItem) {
        int n = this.indexOf(inventoryItem);
        if (n == -1) {
            return;
        }
        this.items.remove(n);
    }

    public void clear() {
        this.items.clear();
    }

    public String getLocation(InventoryItem inventoryItem) {
        int n = this.indexOf(inventoryItem);
        if (n == -1) {
            return null;
        }
        return this.items.get(n).getLocation();
    }

    public boolean contains(InventoryItem inventoryItem) {
        return this.indexOf(inventoryItem) != -1;
    }

    public int size() {
        return this.items.size();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public void forEach(Consumer<AttachedItem> consumer) {
        for (int i = 0; i < this.items.size(); ++i) {
            consumer.accept(this.items.get(i));
        }
    }

    private int indexOf(String string) {
        for (int i = 0; i < this.items.size(); ++i) {
            AttachedItem attachedItem = this.items.get(i);
            if (!attachedItem.location.equals(string)) continue;
            return i;
        }
        return -1;
    }

    private int indexOf(InventoryItem inventoryItem) {
        for (int i = 0; i < this.items.size(); ++i) {
            AttachedItem attachedItem = this.items.get(i);
            if (attachedItem.getItem() != inventoryItem) continue;
            return i;
        }
        return -1;
    }
}

