/*
 * Decompiled with CFR 0.152.
 */
package zombie.characterTextures;

import zombie.characterTextures.BloodBodyPartType;
import zombie.characterTextures.CharacterSmartTexture;
import zombie.core.textures.SmartTexture;
import zombie.core.textures.TextureCombinerCommand;
import zombie.core.textures.TextureCombinerShaderParam;
import zombie.util.StringUtils;

public final class ItemSmartTexture
extends SmartTexture {
    public static final int DecalOverlayCategory = 300;
    private String m_texName = null;

    public ItemSmartTexture(String string) {
        if (string == null) {
            return;
        }
        this.add(string);
        this.m_texName = string;
    }

    public ItemSmartTexture(String string, float f) {
        this.addHue("media/textures/" + string + ".png", 300, f);
        this.m_texName = string;
    }

    public void setDenimPatches(BloodBodyPartType bloodBodyPartType) {
        if (StringUtils.isNullOrEmpty(CharacterSmartTexture.DenimPatchesMaskFiles[bloodBodyPartType.index()])) {
            return;
        }
        String string = "media/textures/patches/" + CharacterSmartTexture.DenimPatchesMaskFiles[bloodBodyPartType.index()] + ".png";
        int n = CharacterSmartTexture.DecalOverlayCategory + bloodBodyPartType.index();
        this.addOverlayPatches(string, "media/textures/patches/patchesmask.png", n);
    }

    public void setLeatherPatches(BloodBodyPartType bloodBodyPartType) {
        if (StringUtils.isNullOrEmpty(CharacterSmartTexture.LeatherPatchesMaskFiles[bloodBodyPartType.index()])) {
            return;
        }
        String string = "media/textures/patches/" + CharacterSmartTexture.LeatherPatchesMaskFiles[bloodBodyPartType.index()] + ".png";
        int n = CharacterSmartTexture.DecalOverlayCategory + bloodBodyPartType.index();
        this.addOverlayPatches(string, "media/textures/patches/patchesmask.png", n);
    }

    public void setBasicPatches(BloodBodyPartType bloodBodyPartType) {
        if (StringUtils.isNullOrEmpty(CharacterSmartTexture.BasicPatchesMaskFiles[bloodBodyPartType.index()])) {
            return;
        }
        String string = "media/textures/patches/" + CharacterSmartTexture.BasicPatchesMaskFiles[bloodBodyPartType.index()] + ".png";
        int n = CharacterSmartTexture.DecalOverlayCategory + bloodBodyPartType.index();
        this.addOverlayPatches(string, "media/textures/patches/patchesmask.png", n);
    }

    public void setBlood(String string, BloodBodyPartType bloodBodyPartType, float f) {
        String string2 = "media/textures/BloodTextures/" + CharacterSmartTexture.MaskFiles[bloodBodyPartType.index()] + ".png";
        int n = CharacterSmartTexture.DecalOverlayCategory + bloodBodyPartType.index();
        this.setBlood(string, string2, f, n);
    }

    public void setBlood(String string, String string2, float f, int n) {
        f = Math.max(0.0f, Math.min(1.0f, f));
        TextureCombinerCommand textureCombinerCommand = this.getFirstFromCategory(n);
        if (textureCombinerCommand != null) {
            for (int i = 0; i < textureCombinerCommand.shaderParams.size(); ++i) {
                TextureCombinerShaderParam textureCombinerShaderParam = textureCombinerCommand.shaderParams.get(i);
                if (!textureCombinerShaderParam.name.equals("intensity") || textureCombinerShaderParam.min == f && textureCombinerShaderParam.max == f) continue;
                textureCombinerShaderParam.min = textureCombinerShaderParam.max = f;
                this.setDirty();
            }
        } else if (f > 0.0f) {
            this.addOverlay(string, string2, f, n);
        }
    }

    public float addBlood(String string, BloodBodyPartType bloodBodyPartType, float f) {
        String string2 = "media/textures/BloodTextures/" + CharacterSmartTexture.MaskFiles[bloodBodyPartType.index()] + ".png";
        int n = CharacterSmartTexture.DecalOverlayCategory + bloodBodyPartType.index();
        return this.addBlood(string, string2, f, n);
    }

    public float addDirt(String string, BloodBodyPartType bloodBodyPartType, float f) {
        String string2 = "media/textures/BloodTextures/" + CharacterSmartTexture.MaskFiles[bloodBodyPartType.index()] + ".png";
        int n = CharacterSmartTexture.DirtOverlayCategory + bloodBodyPartType.index();
        return this.addDirt(string, string2, f, n);
    }

    public float addBlood(String string, String string2, float f, int n) {
        TextureCombinerCommand textureCombinerCommand = this.getFirstFromCategory(n);
        if (textureCombinerCommand == null) {
            this.addOverlay(string, string2, f, n);
            return f;
        }
        for (int i = 0; i < textureCombinerCommand.shaderParams.size(); ++i) {
            TextureCombinerShaderParam textureCombinerShaderParam = textureCombinerCommand.shaderParams.get(i);
            if (!textureCombinerShaderParam.name.equals("intensity")) continue;
            float f2 = textureCombinerShaderParam.min;
            f2 += f;
            if (textureCombinerShaderParam.min != (f2 = Math.min(1.0f, f2)) || textureCombinerShaderParam.max != f2) {
                textureCombinerShaderParam.min = textureCombinerShaderParam.max = f2;
                this.setDirty();
            }
            return f2;
        }
        this.addOverlay(string, string2, f, n);
        return f;
    }

    public float addDirt(String string, String string2, float f, int n) {
        TextureCombinerCommand textureCombinerCommand = this.getFirstFromCategory(n);
        if (textureCombinerCommand == null) {
            this.addDirtOverlay(string, string2, f, n);
            return f;
        }
        for (int i = 0; i < textureCombinerCommand.shaderParams.size(); ++i) {
            TextureCombinerShaderParam textureCombinerShaderParam = textureCombinerCommand.shaderParams.get(i);
            if (!textureCombinerShaderParam.name.equals("intensity")) continue;
            float f2 = textureCombinerShaderParam.min;
            f2 += f;
            if (textureCombinerShaderParam.min != (f2 = Math.min(1.0f, f2)) || textureCombinerShaderParam.max != f2) {
                textureCombinerShaderParam.min = textureCombinerShaderParam.max = f2;
                this.setDirty();
            }
            return f2;
        }
        this.addOverlay(string, string2, f, n);
        return f;
    }

    public void removeBlood() {
        for (int i = 0; i < BloodBodyPartType.MAX.index(); ++i) {
            this.removeBlood(BloodBodyPartType.FromIndex(i));
        }
    }

    public void removeDirt() {
        for (int i = 0; i < BloodBodyPartType.MAX.index(); ++i) {
            this.removeDirt(BloodBodyPartType.FromIndex(i));
        }
    }

    public void removeBlood(BloodBodyPartType bloodBodyPartType) {
        TextureCombinerCommand textureCombinerCommand = this.getFirstFromCategory(CharacterSmartTexture.DecalOverlayCategory + bloodBodyPartType.index());
        if (textureCombinerCommand != null) {
            for (int i = 0; i < textureCombinerCommand.shaderParams.size(); ++i) {
                TextureCombinerShaderParam textureCombinerShaderParam = textureCombinerCommand.shaderParams.get(i);
                if (!textureCombinerShaderParam.name.equals("intensity") || textureCombinerShaderParam.min == 0.0f && textureCombinerShaderParam.max == 0.0f) continue;
                textureCombinerShaderParam.max = 0.0f;
                textureCombinerShaderParam.min = 0.0f;
                this.setDirty();
            }
        }
    }

    public void removeDirt(BloodBodyPartType bloodBodyPartType) {
        TextureCombinerCommand textureCombinerCommand = this.getFirstFromCategory(CharacterSmartTexture.DirtOverlayCategory + bloodBodyPartType.index());
        if (textureCombinerCommand != null) {
            for (int i = 0; i < textureCombinerCommand.shaderParams.size(); ++i) {
                TextureCombinerShaderParam textureCombinerShaderParam = textureCombinerCommand.shaderParams.get(i);
                if (!textureCombinerShaderParam.name.equals("intensity") || textureCombinerShaderParam.min == 0.0f && textureCombinerShaderParam.max == 0.0f) continue;
                textureCombinerShaderParam.max = 0.0f;
                textureCombinerShaderParam.min = 0.0f;
                this.setDirty();
            }
        }
    }

    public String getTexName() {
        return this.m_texName;
    }
}

