/*
 * Decompiled with CFR 0.152.
 */
package zombie.characterTextures;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import zombie.SandboxOptions;
import zombie.characterTextures.BloodBodyPartType;
import zombie.core.Rand;
import zombie.core.skinnedmodel.population.OutfitRNG;
import zombie.core.skinnedmodel.visual.HumanVisual;
import zombie.core.skinnedmodel.visual.ItemVisual;
import zombie.inventory.types.Clothing;
import zombie.scripting.objects.Item;
import zombie.util.Type;

public enum BloodClothingType {
    Jacket,
    LongJacket,
    Trousers,
    ShortsShort,
    Shirt,
    ShirtLongSleeves,
    ShirtNoSleeves,
    Jumper,
    JumperNoSleeves,
    Shoes,
    FullHelmet,
    Apron,
    Bag,
    Hands,
    Head,
    Neck,
    UpperBody,
    LowerBody,
    LowerLegs,
    UpperLegs,
    LowerArms,
    UpperArms,
    Groin;

    private static HashMap<BloodClothingType, ArrayList<BloodBodyPartType>> coveredParts;
    private static final ArrayList<BloodBodyPartType> bodyParts;

    public static BloodClothingType fromString(String string) {
        if (Jacket.toString().equals(string)) {
            return Jacket;
        }
        if (LongJacket.toString().equals(string)) {
            return LongJacket;
        }
        if (Trousers.toString().equals(string)) {
            return Trousers;
        }
        if (ShortsShort.toString().equals(string)) {
            return ShortsShort;
        }
        if (Shirt.toString().equals(string)) {
            return Shirt;
        }
        if (ShirtLongSleeves.toString().equals(string)) {
            return ShirtLongSleeves;
        }
        if (ShirtNoSleeves.toString().equals(string)) {
            return ShirtNoSleeves;
        }
        if (Jumper.toString().equals(string)) {
            return Jumper;
        }
        if (JumperNoSleeves.toString().equals(string)) {
            return JumperNoSleeves;
        }
        if (Shoes.toString().equals(string)) {
            return Shoes;
        }
        if (FullHelmet.toString().equals(string)) {
            return FullHelmet;
        }
        if (Bag.toString().equals(string)) {
            return Bag;
        }
        if (Hands.toString().equals(string)) {
            return Hands;
        }
        if (Head.toString().equals(string)) {
            return Head;
        }
        if (Neck.toString().equals(string)) {
            return Neck;
        }
        if (Apron.toString().equals(string)) {
            return Apron;
        }
        if (Bag.toString().equals(string)) {
            return Bag;
        }
        if (Hands.toString().equals(string)) {
            return Hands;
        }
        if (Head.toString().equals(string)) {
            return Head;
        }
        if (Neck.toString().equals(string)) {
            return Neck;
        }
        if (UpperBody.toString().equals(string)) {
            return UpperBody;
        }
        if (LowerBody.toString().equals(string)) {
            return LowerBody;
        }
        if (LowerLegs.toString().equals(string)) {
            return LowerLegs;
        }
        if (UpperLegs.toString().equals(string)) {
            return UpperLegs;
        }
        if (LowerArms.toString().equals(string)) {
            return LowerArms;
        }
        if (UpperArms.toString().equals(string)) {
            return UpperArms;
        }
        if (Groin.toString().equals(string)) {
            return Groin;
        }
        return null;
    }

    private static void init() {
        if (coveredParts == null) {
            coveredParts = new HashMap();
            ArrayList<BloodBodyPartType> arrayList = new ArrayList<BloodBodyPartType>();
            arrayList.add(BloodBodyPartType.Torso_Upper);
            arrayList.add(BloodBodyPartType.Torso_Lower);
            arrayList.add(BloodBodyPartType.UpperLeg_L);
            arrayList.add(BloodBodyPartType.UpperLeg_R);
            coveredParts.put(Apron, arrayList);
            ArrayList<BloodBodyPartType> arrayList2 = new ArrayList<BloodBodyPartType>();
            arrayList2.add(BloodBodyPartType.Torso_Upper);
            arrayList2.add(BloodBodyPartType.Torso_Lower);
            arrayList2.add(BloodBodyPartType.Back);
            coveredParts.put(ShirtNoSleeves, arrayList2);
            coveredParts.put(JumperNoSleeves, arrayList2);
            ArrayList<BloodBodyPartType> arrayList3 = new ArrayList<BloodBodyPartType>();
            arrayList3.addAll(arrayList2);
            arrayList3.add(BloodBodyPartType.UpperArm_L);
            arrayList3.add(BloodBodyPartType.UpperArm_R);
            coveredParts.put(Shirt, arrayList3);
            ArrayList<BloodBodyPartType> arrayList4 = new ArrayList<BloodBodyPartType>();
            arrayList4.addAll(arrayList3);
            arrayList4.add(BloodBodyPartType.ForeArm_L);
            arrayList4.add(BloodBodyPartType.ForeArm_R);
            coveredParts.put(ShirtLongSleeves, arrayList4);
            coveredParts.put(Jumper, arrayList4);
            ArrayList<BloodBodyPartType> arrayList5 = new ArrayList<BloodBodyPartType>();
            arrayList5.addAll(arrayList4);
            arrayList5.add(BloodBodyPartType.Neck);
            coveredParts.put(Jacket, arrayList5);
            ArrayList<BloodBodyPartType> arrayList6 = new ArrayList<BloodBodyPartType>();
            arrayList6.addAll(arrayList4);
            arrayList6.add(BloodBodyPartType.Neck);
            arrayList6.add(BloodBodyPartType.Groin);
            arrayList6.add(BloodBodyPartType.UpperLeg_L);
            arrayList6.add(BloodBodyPartType.UpperLeg_R);
            coveredParts.put(LongJacket, arrayList6);
            ArrayList<BloodBodyPartType> arrayList7 = new ArrayList<BloodBodyPartType>();
            arrayList7.add(BloodBodyPartType.Groin);
            arrayList7.add(BloodBodyPartType.UpperLeg_L);
            arrayList7.add(BloodBodyPartType.UpperLeg_R);
            coveredParts.put(ShortsShort, arrayList7);
            ArrayList<BloodBodyPartType> arrayList8 = new ArrayList<BloodBodyPartType>();
            arrayList8.addAll(arrayList7);
            arrayList8.add(BloodBodyPartType.LowerLeg_L);
            arrayList8.add(BloodBodyPartType.LowerLeg_R);
            coveredParts.put(Trousers, arrayList8);
            ArrayList<BloodBodyPartType> arrayList9 = new ArrayList<BloodBodyPartType>();
            arrayList9.add(BloodBodyPartType.Foot_L);
            arrayList9.add(BloodBodyPartType.Foot_R);
            coveredParts.put(Shoes, arrayList9);
            ArrayList<BloodBodyPartType> arrayList10 = new ArrayList<BloodBodyPartType>();
            arrayList10.add(BloodBodyPartType.Head);
            coveredParts.put(FullHelmet, arrayList10);
            ArrayList<BloodBodyPartType> arrayList11 = new ArrayList<BloodBodyPartType>();
            arrayList11.add(BloodBodyPartType.Back);
            coveredParts.put(Bag, arrayList11);
            ArrayList<BloodBodyPartType> arrayList12 = new ArrayList<BloodBodyPartType>();
            arrayList12.add(BloodBodyPartType.Hand_L);
            arrayList12.add(BloodBodyPartType.Hand_R);
            coveredParts.put(Hands, arrayList12);
            ArrayList<BloodBodyPartType> arrayList13 = new ArrayList<BloodBodyPartType>();
            arrayList13.add(BloodBodyPartType.Head);
            coveredParts.put(Head, arrayList13);
            ArrayList<BloodBodyPartType> arrayList14 = new ArrayList<BloodBodyPartType>();
            arrayList14.add(BloodBodyPartType.Neck);
            coveredParts.put(Neck, arrayList14);
            ArrayList<BloodBodyPartType> arrayList15 = new ArrayList<BloodBodyPartType>();
            arrayList15.add(BloodBodyPartType.Groin);
            coveredParts.put(Groin, arrayList15);
            ArrayList<BloodBodyPartType> arrayList16 = new ArrayList<BloodBodyPartType>();
            arrayList16.add(BloodBodyPartType.Torso_Upper);
            coveredParts.put(UpperBody, arrayList16);
            ArrayList<BloodBodyPartType> arrayList17 = new ArrayList<BloodBodyPartType>();
            arrayList17.add(BloodBodyPartType.Torso_Lower);
            coveredParts.put(LowerBody, arrayList17);
            ArrayList<BloodBodyPartType> arrayList18 = new ArrayList<BloodBodyPartType>();
            arrayList18.add(BloodBodyPartType.LowerLeg_L);
            arrayList18.add(BloodBodyPartType.LowerLeg_R);
            coveredParts.put(LowerLegs, arrayList18);
            ArrayList<BloodBodyPartType> arrayList19 = new ArrayList<BloodBodyPartType>();
            arrayList19.add(BloodBodyPartType.UpperLeg_L);
            arrayList19.add(BloodBodyPartType.UpperLeg_R);
            coveredParts.put(UpperLegs, arrayList19);
            ArrayList<BloodBodyPartType> arrayList20 = new ArrayList<BloodBodyPartType>();
            arrayList20.add(BloodBodyPartType.UpperArm_L);
            arrayList20.add(BloodBodyPartType.UpperArm_R);
            coveredParts.put(UpperArms, arrayList20);
            ArrayList<BloodBodyPartType> arrayList21 = new ArrayList<BloodBodyPartType>();
            arrayList21.add(BloodBodyPartType.ForeArm_L);
            arrayList21.add(BloodBodyPartType.ForeArm_R);
            coveredParts.put(LowerArms, arrayList21);
        }
    }

    public static ArrayList<BloodBodyPartType> getCoveredParts(ArrayList<BloodClothingType> arrayList) {
        return BloodClothingType.getCoveredParts(arrayList, new ArrayList<BloodBodyPartType>());
    }

    public static ArrayList<BloodBodyPartType> getCoveredParts(ArrayList<BloodClothingType> arrayList, ArrayList<BloodBodyPartType> arrayList2) {
        if (arrayList == null) {
            return arrayList2;
        }
        BloodClothingType.init();
        for (int i = 0; i < arrayList.size(); ++i) {
            BloodClothingType bloodClothingType = arrayList.get(i);
            arrayList2.addAll((Collection<BloodBodyPartType>)coveredParts.get((Object)bloodClothingType));
        }
        return arrayList2;
    }

    public static int getCoveredPartCount(ArrayList<BloodClothingType> arrayList) {
        if (arrayList == null) {
            return 0;
        }
        BloodClothingType.init();
        int n = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            BloodClothingType bloodClothingType = arrayList.get(i);
            n += coveredParts.get((Object)bloodClothingType).size();
        }
        return n;
    }

    public static void addBlood(int n, HumanVisual humanVisual, ArrayList<ItemVisual> arrayList, boolean bl) {
        for (int i = 0; i < n; ++i) {
            BloodBodyPartType bloodBodyPartType = BloodBodyPartType.FromIndex(Rand.Next(0, BloodBodyPartType.MAX.index()));
            BloodClothingType.addBlood(bloodBodyPartType, humanVisual, arrayList, bl);
        }
    }

    public static void addBlood(BloodBodyPartType bloodBodyPartType, HumanVisual humanVisual, ArrayList<ItemVisual> arrayList, boolean bl) {
        BloodClothingType.init();
        float f = 0.0f;
        if (SandboxOptions.instance.ClothingDegradation.getValue() > 1) {
            float f2 = 0.01f;
            float f3 = 0.05f;
            if (SandboxOptions.instance.ClothingDegradation.getValue() == 2) {
                f2 = 0.001f;
                f3 = 0.01f;
            }
            if (SandboxOptions.instance.ClothingDegradation.getValue() == 3) {
                f2 = 0.05f;
                f3 = 0.1f;
            }
            f = OutfitRNG.Next(f2, f3);
        }
        BloodClothingType.addBlood(bloodBodyPartType, f, humanVisual, arrayList, bl);
    }

    public static void addDirt(BloodBodyPartType bloodBodyPartType, HumanVisual humanVisual, ArrayList<ItemVisual> arrayList, boolean bl) {
        BloodClothingType.init();
        float f = 0.0f;
        if (SandboxOptions.instance.ClothingDegradation.getValue() > 1) {
            float f2 = 0.01f;
            float f3 = 0.05f;
            if (SandboxOptions.instance.ClothingDegradation.getValue() == 2) {
                f2 = 0.001f;
                f3 = 0.01f;
            }
            if (SandboxOptions.instance.ClothingDegradation.getValue() == 3) {
                f2 = 0.05f;
                f3 = 0.1f;
            }
            f = OutfitRNG.Next(f2, f3);
        }
        BloodClothingType.addDirt(bloodBodyPartType, f, humanVisual, arrayList, bl);
    }

    public static void addHole(BloodBodyPartType bloodBodyPartType, HumanVisual humanVisual, ArrayList<ItemVisual> arrayList) {
        BloodClothingType.addHole(bloodBodyPartType, humanVisual, arrayList, false);
    }

    public static boolean addHole(BloodBodyPartType bloodBodyPartType, HumanVisual humanVisual, ArrayList<ItemVisual> arrayList, boolean bl) {
        BloodClothingType.init();
        ItemVisual itemVisual = null;
        boolean bl2 = false;
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            ArrayList<BloodClothingType> arrayList2;
            ItemVisual itemVisual2 = arrayList.get(i);
            Item item = itemVisual2.getScriptItem();
            if (item == null || itemVisual2.getInventoryItem() != null && itemVisual2.getInventoryItem().isBroken() || (arrayList2 = item.getBloodClothingType()) == null) continue;
            for (int j = 0; j < arrayList2.size(); ++j) {
                BloodClothingType bloodClothingType = item.getBloodClothingType().get(j);
                if (!coveredParts.get((Object)bloodClothingType).contains((Object)bloodBodyPartType) || !item.canHaveHoles.booleanValue() || itemVisual2.getHole(bloodBodyPartType) != 0.0f) continue;
                itemVisual = itemVisual2;
                break;
            }
            if (itemVisual == null) continue;
            itemVisual.setHole(bloodBodyPartType);
            Clothing clothing = Type.tryCastTo(itemVisual.getInventoryItem(), Clothing.class);
            if (clothing != null) {
                clothing.removePatch(bloodBodyPartType);
                clothing.setCondition(clothing.getCondition() - clothing.getCondLossPerHole());
            }
            bl2 = true;
            if (!bl) break;
            itemVisual = null;
        }
        if (itemVisual == null || bl) {
            humanVisual.setHole(bloodBodyPartType);
        }
        return bl2;
    }

    public static void addBasicPatch(BloodBodyPartType bloodBodyPartType, HumanVisual humanVisual, ArrayList<ItemVisual> arrayList) {
        BloodClothingType.init();
        ItemVisual itemVisual = null;
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            ArrayList<BloodClothingType> arrayList2;
            ItemVisual itemVisual2 = arrayList.get(i);
            Item item = itemVisual2.getScriptItem();
            if (item == null || (arrayList2 = item.getBloodClothingType()) == null) continue;
            for (int j = 0; j < arrayList2.size(); ++j) {
                BloodClothingType bloodClothingType = arrayList2.get(j);
                if (!coveredParts.get((Object)bloodClothingType).contains((Object)bloodBodyPartType) || itemVisual2.getBasicPatch(bloodBodyPartType) != 0.0f) continue;
                itemVisual = itemVisual2;
                break;
            }
            if (itemVisual != null) break;
        }
        if (itemVisual != null) {
            itemVisual.removeHole(BloodBodyPartType.ToIndex(bloodBodyPartType));
            itemVisual.setBasicPatch(bloodBodyPartType);
        }
    }

    public static void addDirt(BloodBodyPartType bloodBodyPartType, float f, HumanVisual humanVisual, ArrayList<ItemVisual> arrayList, boolean bl) {
        block9: {
            ItemVisual itemVisual;
            block7: {
                block8: {
                    BloodClothingType.init();
                    itemVisual = null;
                    if (bl) break block7;
                    for (int i = arrayList.size() - 1; i >= 0; --i) {
                        ArrayList<BloodClothingType> arrayList2;
                        ItemVisual itemVisual2 = arrayList.get(i);
                        Item item = itemVisual2.getScriptItem();
                        if (item == null || (arrayList2 = item.getBloodClothingType()) == null) continue;
                        for (int j = 0; j < arrayList2.size(); ++j) {
                            BloodClothingType bloodClothingType = arrayList2.get(j);
                            if (!coveredParts.get((Object)bloodClothingType).contains((Object)bloodBodyPartType) || itemVisual2.getHole(bloodBodyPartType) != 0.0f) continue;
                            itemVisual = itemVisual2;
                            break;
                        }
                        if (itemVisual != null) break;
                    }
                    if (itemVisual == null) break block8;
                    if (!(f > 0.0f)) break block9;
                    itemVisual.setDirt(bloodBodyPartType, itemVisual.getDirt(bloodBodyPartType) + f);
                    if (!(itemVisual.getInventoryItem() instanceof Clothing)) break block9;
                    BloodClothingType.calcTotalDirtLevel((Clothing)itemVisual.getInventoryItem());
                    break block9;
                }
                float f2 = humanVisual.getDirt(bloodBodyPartType);
                humanVisual.setDirt(bloodBodyPartType, f2 + 0.05f);
                break block9;
            }
            float f3 = humanVisual.getDirt(bloodBodyPartType);
            humanVisual.setDirt(bloodBodyPartType, f3 + 0.05f);
            float f4 = humanVisual.getDirt(bloodBodyPartType);
            if (Rand.NextBool(Math.abs(new Float(f4 * 100.0f).intValue() - 100))) {
                return;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                ArrayList<BloodClothingType> arrayList3;
                itemVisual = null;
                ItemVisual itemVisual3 = arrayList.get(i);
                Item item = itemVisual3.getScriptItem();
                if (item == null || (arrayList3 = item.getBloodClothingType()) == null) continue;
                for (int j = 0; j < arrayList3.size(); ++j) {
                    BloodClothingType bloodClothingType = arrayList3.get(j);
                    if (!coveredParts.get((Object)bloodClothingType).contains((Object)bloodBodyPartType) || itemVisual3.getHole(bloodBodyPartType) != 0.0f) continue;
                    itemVisual = itemVisual3;
                    break;
                }
                if (itemVisual == null) continue;
                if (f > 0.0f) {
                    itemVisual.setDirt(bloodBodyPartType, itemVisual.getDirt(bloodBodyPartType) + f);
                    if (itemVisual.getInventoryItem() instanceof Clothing) {
                        BloodClothingType.calcTotalDirtLevel((Clothing)itemVisual.getInventoryItem());
                    }
                    f4 = itemVisual.getDirt(bloodBodyPartType);
                }
                if (Rand.NextBool(Math.abs(new Float(f4 * 100.0f).intValue() - 100))) break;
            }
        }
    }

    public static void addBlood(BloodBodyPartType bloodBodyPartType, float f, HumanVisual humanVisual, ArrayList<ItemVisual> arrayList, boolean bl) {
        block9: {
            ItemVisual itemVisual;
            block7: {
                block8: {
                    BloodClothingType.init();
                    itemVisual = null;
                    if (bl) break block7;
                    for (int i = arrayList.size() - 1; i >= 0; --i) {
                        ArrayList<BloodClothingType> arrayList2;
                        ItemVisual itemVisual2 = arrayList.get(i);
                        Item item = itemVisual2.getScriptItem();
                        if (item == null || (arrayList2 = item.getBloodClothingType()) == null) continue;
                        for (int j = 0; j < arrayList2.size(); ++j) {
                            BloodClothingType bloodClothingType = arrayList2.get(j);
                            if (!coveredParts.get((Object)bloodClothingType).contains((Object)bloodBodyPartType) || itemVisual2.getHole(bloodBodyPartType) != 0.0f) continue;
                            itemVisual = itemVisual2;
                            break;
                        }
                        if (itemVisual != null) break;
                    }
                    if (itemVisual == null) break block8;
                    if (!(f > 0.0f)) break block9;
                    itemVisual.setBlood(bloodBodyPartType, itemVisual.getBlood(bloodBodyPartType) + f);
                    if (!(itemVisual.getInventoryItem() instanceof Clothing)) break block9;
                    BloodClothingType.calcTotalBloodLevel((Clothing)itemVisual.getInventoryItem());
                    break block9;
                }
                float f2 = humanVisual.getBlood(bloodBodyPartType);
                humanVisual.setBlood(bloodBodyPartType, f2 + 0.05f);
                break block9;
            }
            float f3 = humanVisual.getBlood(bloodBodyPartType);
            humanVisual.setBlood(bloodBodyPartType, f3 + 0.05f);
            float f4 = humanVisual.getBlood(bloodBodyPartType);
            if (OutfitRNG.NextBool(Math.abs(new Float(f4 * 100.0f).intValue() - 100))) {
                return;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                ArrayList<BloodClothingType> arrayList3;
                itemVisual = null;
                ItemVisual itemVisual3 = arrayList.get(i);
                Item item = itemVisual3.getScriptItem();
                if (item == null || (arrayList3 = item.getBloodClothingType()) == null) continue;
                for (int j = 0; j < arrayList3.size(); ++j) {
                    BloodClothingType bloodClothingType = arrayList3.get(j);
                    if (!coveredParts.get((Object)bloodClothingType).contains((Object)bloodBodyPartType) || itemVisual3.getHole(bloodBodyPartType) != 0.0f) continue;
                    itemVisual = itemVisual3;
                    break;
                }
                if (itemVisual == null) continue;
                if (f > 0.0f) {
                    itemVisual.setBlood(bloodBodyPartType, itemVisual.getBlood(bloodBodyPartType) + f);
                    if (itemVisual.getInventoryItem() instanceof Clothing) {
                        BloodClothingType.calcTotalBloodLevel((Clothing)itemVisual.getInventoryItem());
                    }
                    f4 = itemVisual.getBlood(bloodBodyPartType);
                }
                if (OutfitRNG.NextBool(Math.abs(new Float(f4 * 100.0f).intValue() - 100))) break;
            }
        }
    }

    public static synchronized void calcTotalBloodLevel(Clothing clothing) {
        ItemVisual itemVisual = clothing.getVisual();
        if (itemVisual == null) {
            clothing.setBloodLevel(0.0f);
            return;
        }
        ArrayList<BloodClothingType> arrayList = clothing.getBloodClothingType();
        if (arrayList == null) {
            clothing.setBloodLevel(0.0f);
            return;
        }
        bodyParts.clear();
        BloodClothingType.getCoveredParts(arrayList, bodyParts);
        if (bodyParts.isEmpty()) {
            clothing.setBloodLevel(0.0f);
            return;
        }
        float f = 0.0f;
        for (int i = 0; i < bodyParts.size(); ++i) {
            f += itemVisual.getBlood(bodyParts.get(i)) * 100.0f;
        }
        clothing.setBloodLevel(f / (float)bodyParts.size());
    }

    public static synchronized void calcTotalDirtLevel(Clothing clothing) {
        ItemVisual itemVisual = clothing.getVisual();
        if (itemVisual == null) {
            clothing.setDirtyness(0.0f);
            return;
        }
        ArrayList<BloodClothingType> arrayList = clothing.getBloodClothingType();
        if (arrayList == null) {
            clothing.setDirtyness(0.0f);
            return;
        }
        bodyParts.clear();
        BloodClothingType.getCoveredParts(arrayList, bodyParts);
        if (bodyParts.isEmpty()) {
            clothing.setDirtyness(0.0f);
            return;
        }
        float f = 0.0f;
        for (int i = 0; i < bodyParts.size(); ++i) {
            f += itemVisual.getDirt(bodyParts.get(i)) * 100.0f;
        }
        clothing.setDirtyness(f / (float)bodyParts.size());
    }

    static {
        coveredParts = null;
        bodyParts = new ArrayList();
    }
}

