/*
 * Decompiled with CFR 0.152.
 */
package zombie.audio.parameters;

import zombie.audio.FMODLocalParameter;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.vehicles.BaseVehicle;

public final class ParameterVehicleRoadMaterial
extends FMODLocalParameter {
    private final BaseVehicle vehicle;

    public ParameterVehicleRoadMaterial(BaseVehicle baseVehicle) {
        super("VehicleRoadMaterial");
        this.vehicle = baseVehicle;
    }

    @Override
    public float calculateCurrentValue() {
        if (!this.vehicle.isEngineRunning()) {
            return Float.isNaN(this.getCurrentValue()) ? 0.0f : this.getCurrentValue();
        }
        return this.getMaterial().label;
    }

    private Material getMaterial() {
        IsoGridSquare isoGridSquare = this.vehicle.getCurrentSquare();
        if (isoGridSquare == null) {
            return Material.Concrete;
        }
        IsoObject isoObject = this.vehicle.getCurrentSquare().getFloor();
        if (isoObject == null || isoObject.getSprite() == null || isoObject.getSprite().getName() == null) {
            return Material.Concrete;
        }
        String string = isoObject.getSprite().getName();
        if (string.endsWith("blends_natural_01_5") || string.endsWith("blends_natural_01_6") || string.endsWith("blends_natural_01_7") || string.endsWith("blends_natural_01_0")) {
            return Material.Sand;
        }
        if (string.endsWith("blends_natural_01_64") || string.endsWith("blends_natural_01_69") || string.endsWith("blends_natural_01_70") || string.endsWith("blends_natural_01_71")) {
            return Material.Dirt;
        }
        if (string.startsWith("blends_natural_01")) {
            return Material.Grass;
        }
        if (string.endsWith("blends_street_01_48") || string.endsWith("blends_street_01_53") || string.endsWith("blends_street_01_54") || string.endsWith("blends_street_01_55")) {
            return Material.Gravel;
        }
        if (string.startsWith("floors_interior_tilesandwood_01_")) {
            int n = Integer.parseInt(string.replaceFirst("floors_interior_tilesandwood_01_", ""));
            if (n > 40 && n < 48) {
                return Material.Wood;
            }
            return Material.Concrete;
        }
        if (string.startsWith("carpentry_02_")) {
            return Material.Wood;
        }
        if (string.contains("interior_carpet_")) {
            return Material.Carpet;
        }
        float f = isoGridSquare.getPuddlesInGround();
        if ((double)f > 0.1) {
            return Material.Puddle;
        }
        return Material.Concrete;
    }

    static enum Material {
        Concrete(0),
        Grass(1),
        Gravel(2),
        Puddle(3),
        Snow(4),
        Wood(5),
        Carpet(6),
        Dirt(7),
        Sand(8);

        final int label;

        private Material(int n2) {
            this.label = n2;
        }
    }
}

