/*
 * Decompiled with CFR 0.152.
 */
package zombie.audio.parameters;

import zombie.audio.FMODLocalParameter;
import zombie.characters.IsoGameCharacter;
import zombie.core.skinnedmodel.visual.ItemVisual;
import zombie.core.skinnedmodel.visual.ItemVisuals;
import zombie.scripting.objects.Item;

public final class ParameterShoeType
extends FMODLocalParameter {
    private static final ItemVisuals tempItemVisuals = new ItemVisuals();
    private final IsoGameCharacter character;
    private ShoeType shoeType = null;

    public ParameterShoeType(IsoGameCharacter isoGameCharacter) {
        super("ShoeType");
        this.character = isoGameCharacter;
    }

    @Override
    public float calculateCurrentValue() {
        if (this.shoeType == null) {
            this.shoeType = this.getShoeType();
        }
        return this.shoeType.label;
    }

    private ShoeType getShoeType() {
        this.character.getItemVisuals(tempItemVisuals);
        Item item = null;
        for (int i = 0; i < tempItemVisuals.size(); ++i) {
            ItemVisual itemVisual = (ItemVisual)tempItemVisuals.get(i);
            Item item2 = itemVisual.getScriptItem();
            if (item2 == null || !"Shoes".equals(item2.getBodyLocation())) continue;
            item = item2;
            break;
        }
        if (item == null) {
            return ShoeType.Barefoot;
        }
        String string = item.getName();
        if (string.contains("Boots") || string.contains("Wellies")) {
            return ShoeType.Boots;
        }
        if (string.contains("FlipFlop")) {
            return ShoeType.FlipFlops;
        }
        if (string.contains("Slippers")) {
            return ShoeType.Slippers;
        }
        if (string.contains("Trainer")) {
            return ShoeType.Sneakers;
        }
        return ShoeType.Shoes;
    }

    public void setShoeType(ShoeType shoeType) {
        this.shoeType = shoeType;
    }

    private static enum ShoeType {
        Barefoot(0),
        Boots(1),
        FlipFlops(2),
        Shoes(3),
        Slippers(4),
        Sneakers(5);

        final int label;

        private ShoeType(int n2) {
            this.label = n2;
        }
    }
}

