/*
 * Decompiled with CFR 0.152.
 */
package zombie.audio.parameters;

import zombie.audio.FMODGlobalParameter;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.iso.IsoGridSquare;
import zombie.iso.RoomDef;

public final class ParameterRoomSize
extends FMODGlobalParameter {
    public ParameterRoomSize() {
        super("RoomSize");
    }

    @Override
    public float calculateCurrentValue() {
        IsoGameCharacter isoGameCharacter = this.getCharacter();
        if (isoGameCharacter == null) {
            return 0.0f;
        }
        RoomDef roomDef = isoGameCharacter.getCurrentRoomDef();
        if (roomDef != null) {
            return roomDef.getArea();
        }
        IsoGridSquare isoGridSquare = isoGameCharacter.getCurrentSquare();
        if (isoGridSquare != null && isoGridSquare.isInARoom()) {
            return isoGridSquare.getRoomSize();
        }
        return 0.0f;
    }

    private IsoGameCharacter getCharacter() {
        IsoGameCharacter isoGameCharacter = null;
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            IsoPlayer isoPlayer = IsoPlayer.players[i];
            if (isoPlayer == null || isoGameCharacter != null && (!isoGameCharacter.isDead() || !isoPlayer.isAlive()) && (!isoGameCharacter.Traits.Deaf.isSet() || isoPlayer.Traits.Deaf.isSet())) continue;
            isoGameCharacter = isoPlayer;
        }
        return isoGameCharacter;
    }
}

