/*
 * Decompiled with CFR 0.152.
 */
package zombie.audio.parameters;

import fmod.fmod.FMODManager;
import zombie.audio.FMODLocalParameter;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.properties.PropertyContainer;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.objects.IsoWorldInventoryObject;
import zombie.util.list.PZArrayList;

public final class ParameterFootstepMaterial
extends FMODLocalParameter {
    private final IsoGameCharacter character;

    public ParameterFootstepMaterial(IsoGameCharacter isoGameCharacter) {
        super("FootstepMaterial");
        this.character = isoGameCharacter;
    }

    @Override
    public float calculateCurrentValue() {
        return this.getMaterial().label;
    }

    private FootstepMaterial getMaterial() {
        int n;
        Object object;
        IsoObject isoObject;
        if (FMODManager.instance.getNumListeners() == 1) {
            for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                isoObject = IsoPlayer.players[i];
                if (isoObject == null || isoObject == this.character || isoObject.Traits.Deaf.isSet()) continue;
                if ((int)isoObject.getZ() >= (int)this.character.getZ()) break;
                return FootstepMaterial.Upstairs;
            }
        }
        IsoObject isoObject2 = null;
        isoObject = null;
        IsoGridSquare isoGridSquare = this.character.getCurrentSquare();
        if (isoGridSquare != null) {
            object = isoGridSquare.getObjects();
            for (n = 0; n < ((PZArrayList)object).size(); ++n) {
                PropertyContainer propertyContainer;
                IsoObject isoObject3 = (IsoObject)((PZArrayList)object).get(n);
                if (isoObject3 instanceof IsoWorldInventoryObject || (propertyContainer = isoObject3.getProperties()) == null) continue;
                if (propertyContainer.Is(IsoFlagType.solidfloor)) {
                    isoObject2 = isoObject3;
                }
                if (!propertyContainer.Is("FootstepMaterial")) continue;
                isoObject = isoObject3;
            }
        }
        if (isoObject != null) {
            try {
                object = isoObject.getProperties().Val("FootstepMaterial");
                return FootstepMaterial.valueOf((String)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                n = 1;
            }
        }
        return FootstepMaterial.Concrete;
    }

    static enum FootstepMaterial {
        Upstairs(0),
        BrokenGlass(1),
        Concrete(2),
        Grass(3),
        Gravel(4),
        Puddle(5),
        Snow(6),
        Wood(7),
        Carpet(8),
        Dirt(9),
        Sand(10),
        Ceramic(11),
        Metal(12);

        final int label;

        private FootstepMaterial(int n2) {
            this.label = n2;
        }
    }
}

