/*
 * Decompiled with CFR 0.152.
 */
package zombie.audio.parameters;

import zombie.audio.FMODGlobalParameter;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.iso.NearestWalls;

public final class ParameterClosestWallDistance
extends FMODGlobalParameter {
    public ParameterClosestWallDistance() {
        super("ClosestWallDistance");
    }

    @Override
    public float calculateCurrentValue() {
        IsoGameCharacter isoGameCharacter = this.getCharacter();
        if (isoGameCharacter == null) {
            return 127.0f;
        }
        return NearestWalls.ClosestWallDistance(isoGameCharacter.getCurrentSquare());
    }

    private IsoGameCharacter getCharacter() {
        IsoGameCharacter isoGameCharacter = null;
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            IsoPlayer isoPlayer = IsoPlayer.players[i];
            if (isoPlayer == null || isoGameCharacter != null && (!isoGameCharacter.isDead() || !isoPlayer.isAlive()) && (!isoGameCharacter.Traits.Deaf.isSet() || isoPlayer.Traits.Deaf.isSet())) continue;
            isoGameCharacter = isoPlayer;
        }
        return isoGameCharacter;
    }
}

