/*
 * Decompiled with CFR 0.152.
 */
package zombie.audio;

import fmod.fmod.FMODManager;
import fmod.fmod.FMODSoundEmitter;
import fmod.fmod.FMOD_STUDIO_PARAMETER_DESCRIPTION;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import zombie.GameSounds;
import zombie.audio.BaseSoundEmitter;
import zombie.audio.DummySoundEmitter;
import zombie.audio.GameSound;
import zombie.audio.parameters.ParameterCurrentZone;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.math.PZMath;
import zombie.core.properties.PropertyContainer;
import zombie.debug.DebugOptions;
import zombie.debug.LineDrawer;
import zombie.inventory.ItemContainer;
import zombie.iso.IsoCamera;
import zombie.iso.IsoChunk;
import zombie.iso.IsoChunkMap;
import zombie.iso.IsoObject;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.Vector2;
import zombie.iso.objects.IsoDoor;
import zombie.iso.objects.IsoWindow;
import zombie.network.GameServer;
import zombie.popman.ObjectPool;
import zombie.util.Type;
import zombie.util.list.PZArrayUtil;

public final class ObjectAmbientEmitters {
    private final HashMap<String, PowerPolicy> powerPolicyMap = new HashMap();
    private static ObjectAmbientEmitters instance = null;
    static final Vector2 tempVector2 = new Vector2();
    private final HashMap<IsoObject, ObjectWithDistance> m_added = new HashMap();
    private final ObjectPool<ObjectWithDistance> m_objectPool = new ObjectPool<ObjectWithDistance>(ObjectWithDistance::new);
    private final ArrayList<ObjectWithDistance> m_objects = new ArrayList();
    private final Slot[] m_slots;
    private final Comparator<ObjectWithDistance> comp = new Comparator<ObjectWithDistance>(){

        @Override
        public int compare(ObjectWithDistance objectWithDistance, ObjectWithDistance objectWithDistance2) {
            return Float.compare(objectWithDistance.distSq, objectWithDistance2.distSq);
        }
    };

    public static ObjectAmbientEmitters getInstance() {
        if (instance == null) {
            instance = new ObjectAmbientEmitters();
        }
        return instance;
    }

    private ObjectAmbientEmitters() {
        int n = 16;
        this.m_slots = PZArrayUtil.newInstance(Slot.class, n, Slot::new);
        this.powerPolicyMap.put("FactoryMachineAmbiance", PowerPolicy.InteriorHydro);
        this.powerPolicyMap.put("HotdogMachineAmbiance", PowerPolicy.InteriorHydro);
        this.powerPolicyMap.put("PayPhoneAmbiance", PowerPolicy.ExteriorOK);
        this.powerPolicyMap.put("StreetLightAmbiance", PowerPolicy.ExteriorOK);
        this.powerPolicyMap.put("NeonLightAmbiance", PowerPolicy.ExteriorOK);
        this.powerPolicyMap.put("NeonSignAmbiance", PowerPolicy.ExteriorOK);
        this.powerPolicyMap.put("JukeboxAmbiance", PowerPolicy.InteriorHydro);
        this.powerPolicyMap.put("ControlStationAmbiance", PowerPolicy.InteriorHydro);
        this.powerPolicyMap.put("ClockAmbiance", PowerPolicy.InteriorHydro);
        this.powerPolicyMap.put("GasPumpAmbiance", PowerPolicy.ExteriorOK);
        this.powerPolicyMap.put("LightBulbAmbiance", PowerPolicy.InteriorHydro);
        this.powerPolicyMap.put("ArcadeMachineAmbiance", PowerPolicy.InteriorHydro);
    }

    private void addObject(IsoObject isoObject, PerObjectLogic perObjectLogic) {
        if (GameServer.bServer) {
            return;
        }
        if (this.m_added.containsKey(isoObject)) {
            return;
        }
        boolean bl = false;
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            IsoPlayer isoPlayer = IsoPlayer.players[i];
            if (isoPlayer == null || isoObject.getObjectIndex() == -1) continue;
            int n = 15;
            if (perObjectLogic instanceof DoorLogic || perObjectLogic instanceof WindowLogic) {
                n = 10;
            }
            if (isoObject.square.z != PZMath.fastfloor(isoPlayer.getZ()) && (perObjectLogic instanceof DoorLogic || perObjectLogic instanceof WindowLogic) || isoPlayer.DistToSquared((float)isoObject.square.x + 0.5f, (float)isoObject.square.y + 0.5f) > (float)(n * n)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        ObjectWithDistance objectWithDistance = this.m_objectPool.alloc();
        objectWithDistance.object = isoObject;
        objectWithDistance.logic = perObjectLogic;
        this.m_objects.add(objectWithDistance);
        this.m_added.put(isoObject, objectWithDistance);
    }

    void removeObject(IsoObject isoObject) {
        if (GameServer.bServer) {
            return;
        }
        ObjectWithDistance objectWithDistance = this.m_added.remove(isoObject);
        if (objectWithDistance == null) {
            return;
        }
        this.m_objects.remove(objectWithDistance);
        this.m_objectPool.release(objectWithDistance);
    }

    public void update() {
        int n;
        int n2;
        PerObjectLogic perObjectLogic;
        IsoObject isoObject;
        int n3;
        if (GameServer.bServer) {
            return;
        }
        this.addObjectsFromChunks();
        for (n3 = 0; n3 < this.m_slots.length; ++n3) {
            this.m_slots[n3].playing = false;
        }
        if (this.m_objects.isEmpty()) {
            this.stopNotPlaying();
            return;
        }
        for (n3 = 0; n3 < this.m_objects.size(); ++n3) {
            ObjectWithDistance objectWithDistance = this.m_objects.get(n3);
            isoObject = objectWithDistance.object;
            perObjectLogic = this.m_objects.get((int)n3).logic;
            if (!this.shouldPlay(isoObject, perObjectLogic)) {
                this.m_added.remove(isoObject);
                this.m_objects.remove(n3--);
                this.m_objectPool.release(objectWithDistance);
                continue;
            }
            isoObject.getFacingPosition(tempVector2);
            objectWithDistance.distSq = this.getClosestListener(ObjectAmbientEmitters.tempVector2.x, ObjectAmbientEmitters.tempVector2.y, isoObject.square.z);
        }
        this.m_objects.sort(this.comp);
        n3 = Math.min(this.m_objects.size(), this.m_slots.length);
        for (n2 = 0; n2 < n3; ++n2) {
            isoObject = this.m_objects.get((int)n2).object;
            perObjectLogic = this.m_objects.get((int)n2).logic;
            if (!this.shouldPlay(isoObject, perObjectLogic) || (n = this.getExistingSlot(isoObject)) == -1) continue;
            this.m_slots[n].playSound(isoObject, perObjectLogic);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            isoObject = this.m_objects.get((int)n2).object;
            perObjectLogic = this.m_objects.get((int)n2).logic;
            if (!this.shouldPlay(isoObject, perObjectLogic) || (n = this.getExistingSlot(isoObject)) != -1) continue;
            n = this.getFreeSlot();
            if (this.m_slots[n].object != null) {
                this.m_slots[n].stopPlaying();
                this.m_slots[n].object = null;
            }
            this.m_slots[n].playSound(isoObject, perObjectLogic);
        }
        this.stopNotPlaying();
        this.m_added.clear();
        this.m_objectPool.release((List<ObjectWithDistance>)this.m_objects);
        this.m_objects.clear();
    }

    void addObjectsFromChunks() {
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            IsoChunkMap isoChunkMap = IsoWorld.instance.CurrentCell.ChunkMap[i];
            if (isoChunkMap.ignore) continue;
            int n = IsoChunkMap.ChunkGridWidth / 2;
            int n2 = IsoChunkMap.ChunkGridWidth / 2;
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    IsoChunk isoChunk = isoChunkMap.getChunk(n + k, n2 + j);
                    if (isoChunk == null) continue;
                    Set<IsoObject> set = isoChunk.m_objectEmitterData.m_objects.keySet();
                    for (IsoObject isoObject : set) {
                        this.addObject(isoObject, isoChunk.m_objectEmitterData.m_objects.get(isoObject));
                    }
                }
            }
        }
    }

    float getClosestListener(float f, float f2, float f3) {
        float f4 = Float.MAX_VALUE;
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            IsoPlayer isoPlayer = IsoPlayer.players[i];
            if (isoPlayer == null || isoPlayer.getCurrentSquare() == null) continue;
            float f5 = isoPlayer.getX();
            float f6 = isoPlayer.getY();
            float f7 = isoPlayer.getZ();
            float f8 = IsoUtils.DistanceToSquared(f5, f6, f7 * 3.0f, f, f2, f3 * 3.0f);
            if (isoPlayer.Traits.HardOfHearing.isSet()) {
                f8 *= 4.5f;
            }
            if (!(f8 < f4)) continue;
            f4 = f8;
        }
        return f4;
    }

    boolean shouldPlay(IsoObject isoObject, PerObjectLogic perObjectLogic) {
        if (isoObject == null) {
            return false;
        }
        if (isoObject.getObjectIndex() == -1) {
            return false;
        }
        return perObjectLogic.shouldPlaySound();
    }

    int getExistingSlot(IsoObject isoObject) {
        for (int i = 0; i < this.m_slots.length; ++i) {
            if (this.m_slots[i].object != isoObject) continue;
            return i;
        }
        return -1;
    }

    int getFreeSlot() {
        for (int i = 0; i < this.m_slots.length; ++i) {
            if (this.m_slots[i].playing) continue;
            return i;
        }
        return -1;
    }

    void stopNotPlaying() {
        for (int i = 0; i < this.m_slots.length; ++i) {
            Slot slot = this.m_slots[i];
            if (slot.playing) continue;
            slot.stopPlaying();
            slot.object = null;
        }
    }

    public void render() {
        int n;
        if (!DebugOptions.instance.ObjectAmbientEmitterRender.getValue()) {
            return;
        }
        IsoChunkMap isoChunkMap = IsoWorld.instance.CurrentCell.ChunkMap[IsoCamera.frameState.playerIndex];
        if (!isoChunkMap.ignore) {
            n = IsoChunkMap.ChunkGridWidth / 2;
            int n2 = IsoChunkMap.ChunkGridWidth / 2;
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    IsoChunk isoChunk = isoChunkMap.getChunk(n + j, n2 + i);
                    if (isoChunk == null) continue;
                    Set<IsoObject> set = isoChunk.m_objectEmitterData.m_objects.keySet();
                    for (IsoObject isoObject : set) {
                        if (isoObject.square.z != (int)IsoCamera.frameState.CamCharacterZ) continue;
                        isoObject.getFacingPosition(tempVector2);
                        float f = ObjectAmbientEmitters.tempVector2.x;
                        float f2 = ObjectAmbientEmitters.tempVector2.y;
                        float f3 = isoObject.square.z;
                        LineDrawer.addLine(f - 0.45f, f2 - 0.45f, f3, f + 0.45f, f2 + 0.45f, f3, 0.5f, 0.5f, 0.5f, null, false);
                    }
                }
            }
        }
        for (n = 0; n < this.m_slots.length; ++n) {
            Slot slot = this.m_slots[n];
            if (!slot.playing) continue;
            IsoObject isoObject = slot.object;
            isoObject.getFacingPosition(tempVector2);
            float f = ObjectAmbientEmitters.tempVector2.x;
            float f4 = ObjectAmbientEmitters.tempVector2.y;
            float f5 = isoObject.square.z;
            LineDrawer.addLine(f - 0.45f, f4 - 0.45f, f5, f + 0.45f, f4 + 0.45f, f5, 0.0f, 0.0f, 1.0f, null, false);
        }
    }

    public static void Reset() {
        if (instance == null) {
            return;
        }
        for (int i = 0; i < ObjectAmbientEmitters.instance.m_slots.length; ++i) {
            ObjectAmbientEmitters.instance.m_slots[i].stopPlaying();
            ObjectAmbientEmitters.instance.m_slots[i].object = null;
            ObjectAmbientEmitters.instance.m_slots[i].playing = false;
        }
    }

    static final class Slot {
        IsoObject object = null;
        PerObjectLogic logic = null;
        BaseSoundEmitter emitter = null;
        long instance = 0L;
        boolean playing = false;

        Slot() {
        }

        void playSound(IsoObject isoObject, PerObjectLogic perObjectLogic) {
            if (this.emitter == null) {
                this.emitter = Core.SoundDisabled ? new DummySoundEmitter() : new FMODSoundEmitter();
            }
            isoObject.getFacingPosition(tempVector2);
            this.emitter.setPos(tempVector2.getX(), tempVector2.getY(), isoObject.square.z);
            this.object = isoObject;
            this.logic = perObjectLogic;
            String string = perObjectLogic.getSoundName();
            if (!this.emitter.isPlaying(string)) {
                this.emitter.stopAll();
                FMODSoundEmitter fMODSoundEmitter = Type.tryCastTo(this.emitter, FMODSoundEmitter.class);
                if (fMODSoundEmitter != null) {
                    fMODSoundEmitter.clearParameters();
                }
                this.instance = this.emitter.playSoundImpl(string, (IsoObject)null);
                perObjectLogic.startPlaying(this.emitter, this.instance);
            }
            perObjectLogic.checkParameters(this.emitter, this.instance);
            this.playing = true;
            this.emitter.tick();
        }

        void stopPlaying() {
            if (this.emitter == null || this.instance == 0L) {
                return;
            }
            this.logic.stopPlaying(this.emitter, this.instance);
            if (this.emitter.hasSustainPoints(this.instance)) {
                this.emitter.triggerCue(this.instance);
                this.instance = 0L;
                return;
            }
            this.emitter.stopAll();
            this.instance = 0L;
        }
    }

    static enum PowerPolicy {
        NotRequired,
        InteriorHydro,
        ExteriorOK;

    }

    public static final class DoorLogic
    extends PerObjectLogic {
        @Override
        public boolean shouldPlaySound() {
            return true;
        }

        @Override
        public String getSoundName() {
            return "DoorAmbiance";
        }

        @Override
        public void startPlaying(BaseSoundEmitter baseSoundEmitter, long l) {
        }

        @Override
        public void stopPlaying(BaseSoundEmitter baseSoundEmitter, long l) {
            this.parameterValue1 = Float.NaN;
        }

        @Override
        public void checkParameters(BaseSoundEmitter baseSoundEmitter, long l) {
            IsoDoor isoDoor = Type.tryCastTo(this.object, IsoDoor.class);
            float f = isoDoor.IsOpen() ? 1.0f : 0.0f;
            this.setParameterValue1(baseSoundEmitter, l, "DoorWindowOpen", f);
        }
    }

    public static final class WindowLogic
    extends PerObjectLogic {
        @Override
        public boolean shouldPlaySound() {
            return true;
        }

        @Override
        public String getSoundName() {
            return "WindowAmbiance";
        }

        @Override
        public void startPlaying(BaseSoundEmitter baseSoundEmitter, long l) {
        }

        @Override
        public void stopPlaying(BaseSoundEmitter baseSoundEmitter, long l) {
            this.parameterValue1 = Float.NaN;
        }

        @Override
        public void checkParameters(BaseSoundEmitter baseSoundEmitter, long l) {
            IsoWindow isoWindow = Type.tryCastTo(this.object, IsoWindow.class);
            float f = isoWindow.IsOpen() || isoWindow.isDestroyed() ? 1.0f : 0.0f;
            this.setParameterValue1(baseSoundEmitter, l, "DoorWindowOpen", f);
        }
    }

    static final class ObjectWithDistance {
        IsoObject object;
        PerObjectLogic logic;
        float distSq;

        ObjectWithDistance() {
        }
    }

    public static abstract class PerObjectLogic {
        public IsoObject object;
        public float parameterValue1 = Float.NaN;

        public PerObjectLogic init(IsoObject isoObject) {
            this.object = isoObject;
            return this;
        }

        void setParameterValue1(BaseSoundEmitter baseSoundEmitter, long l, String string, float f) {
            if (f == this.parameterValue1) {
                return;
            }
            this.parameterValue1 = f;
            FMOD_STUDIO_PARAMETER_DESCRIPTION fMOD_STUDIO_PARAMETER_DESCRIPTION = FMODManager.instance.getParameterDescription(string);
            baseSoundEmitter.setParameterValue(l, fMOD_STUDIO_PARAMETER_DESCRIPTION, f);
        }

        void setParameterValue1(BaseSoundEmitter baseSoundEmitter, long l, FMOD_STUDIO_PARAMETER_DESCRIPTION fMOD_STUDIO_PARAMETER_DESCRIPTION, float f) {
            if (f == this.parameterValue1) {
                return;
            }
            this.parameterValue1 = f;
            baseSoundEmitter.setParameterValue(l, fMOD_STUDIO_PARAMETER_DESCRIPTION, f);
        }

        public abstract boolean shouldPlaySound();

        public abstract String getSoundName();

        public abstract void startPlaying(BaseSoundEmitter var1, long var2);

        public abstract void stopPlaying(BaseSoundEmitter var1, long var2);

        public abstract void checkParameters(BaseSoundEmitter var1, long var2);
    }

    public static final class ChunkData {
        final HashMap<IsoObject, PerObjectLogic> m_objects = new HashMap();

        public boolean hasObject(IsoObject isoObject) {
            return this.m_objects.containsKey(isoObject);
        }

        public void addObject(IsoObject isoObject, PerObjectLogic perObjectLogic) {
            if (this.m_objects.containsKey(isoObject)) {
                return;
            }
            this.m_objects.put(isoObject, perObjectLogic);
        }

        public void removeObject(IsoObject isoObject) {
            this.m_objects.remove(isoObject);
        }

        public void reset() {
            this.m_objects.clear();
        }
    }

    public static final class WaterDripLogic
    extends PerObjectLogic {
        @Override
        public boolean shouldPlaySound() {
            return this.object.sprite != null && this.object.sprite.getProperties().Is(IsoFlagType.waterPiped) && (float)this.object.getWaterAmount() > 0.0f;
        }

        @Override
        public String getSoundName() {
            return "WaterDrip";
        }

        @Override
        public void startPlaying(BaseSoundEmitter baseSoundEmitter, long l) {
            if (this.object.sprite != null && this.object.sprite.getProperties().Is("SinkType")) {
                String string;
                int n = switch (string = this.object.sprite.getProperties().Val("SinkType")) {
                    case "Ceramic" -> 1;
                    case "Metal" -> 2;
                    default -> 0;
                };
                this.setParameterValue1(baseSoundEmitter, l, "SinkType", (float)n);
            }
        }

        @Override
        public void stopPlaying(BaseSoundEmitter baseSoundEmitter, long l) {
            this.parameterValue1 = Float.NaN;
        }

        @Override
        public void checkParameters(BaseSoundEmitter baseSoundEmitter, long l) {
        }
    }

    public static final class TreeAmbianceLogic
    extends PerObjectLogic {
        @Override
        public boolean shouldPlaySound() {
            return true;
        }

        @Override
        public String getSoundName() {
            return "TreeAmbiance";
        }

        @Override
        public void startPlaying(BaseSoundEmitter baseSoundEmitter, long l) {
            FMODSoundEmitter fMODSoundEmitter = Type.tryCastTo(baseSoundEmitter, FMODSoundEmitter.class);
            if (fMODSoundEmitter != null) {
                fMODSoundEmitter.addParameter(new ParameterCurrentZone(this.object));
            }
            baseSoundEmitter.playAmbientLoopedImpl("BirdInTree");
        }

        @Override
        public void stopPlaying(BaseSoundEmitter baseSoundEmitter, long l) {
            baseSoundEmitter.stopOrTriggerSoundByName("BirdInTree");
        }

        @Override
        public void checkParameters(BaseSoundEmitter baseSoundEmitter, long l) {
        }
    }

    public static final class TentAmbianceLogic
    extends PerObjectLogic {
        @Override
        public boolean shouldPlaySound() {
            return this.object.sprite != null && this.object.sprite.getName() != null && this.object.sprite.getName().startsWith("camping_01") && (this.object.sprite.tileSheetIndex == 0 || this.object.sprite.tileSheetIndex == 3);
        }

        @Override
        public String getSoundName() {
            return "TentAmbiance";
        }

        @Override
        public void startPlaying(BaseSoundEmitter baseSoundEmitter, long l) {
        }

        @Override
        public void stopPlaying(BaseSoundEmitter baseSoundEmitter, long l) {
        }

        @Override
        public void checkParameters(BaseSoundEmitter baseSoundEmitter, long l) {
        }
    }

    public static final class AmbientSoundLogic
    extends PerObjectLogic {
        PowerPolicy powerPolicy = PowerPolicy.NotRequired;
        boolean bHasGeneratorParameter = false;

        @Override
        public PerObjectLogic init(IsoObject isoObject) {
            super.init(isoObject);
            String string = this.getSoundName();
            this.powerPolicy = ObjectAmbientEmitters.getInstance().powerPolicyMap.getOrDefault(string, PowerPolicy.NotRequired);
            if (this.powerPolicy != PowerPolicy.NotRequired) {
                GameSound gameSound = GameSounds.getSound(string);
                this.bHasGeneratorParameter = gameSound != null && gameSound.numClipsUsingParameter("Generator") > 0;
            }
            return this;
        }

        @Override
        public boolean shouldPlaySound() {
            boolean bl;
            if (this.powerPolicy == PowerPolicy.InteriorHydro) {
                boolean bl2 = bl = this.object.square.haveElectricity() || IsoWorld.instance.isHydroPowerOn() && this.object.square.getRoom() != null;
                if (!bl) {
                    return false;
                }
            }
            if (this.powerPolicy == PowerPolicy.ExteriorOK) {
                boolean bl3 = bl = this.object.square.haveElectricity() || IsoWorld.instance.isHydroPowerOn();
                if (!bl) {
                    return false;
                }
            }
            if (this.powerPolicy != PowerPolicy.NotRequired && !IsoWorld.instance.isHydroPowerOn() && !this.bHasGeneratorParameter) {
                return false;
            }
            PropertyContainer propertyContainer = this.object.getProperties();
            return propertyContainer != null && propertyContainer.Is("AmbientSound");
        }

        @Override
        public String getSoundName() {
            return this.object.getProperties().Val("AmbientSound");
        }

        @Override
        public void startPlaying(BaseSoundEmitter baseSoundEmitter, long l) {
        }

        @Override
        public void stopPlaying(BaseSoundEmitter baseSoundEmitter, long l) {
            this.parameterValue1 = Float.NaN;
        }

        @Override
        public void checkParameters(BaseSoundEmitter baseSoundEmitter, long l) {
            if (this.powerPolicy != PowerPolicy.NotRequired) {
                this.setParameterValue1(baseSoundEmitter, l, "Generator", IsoWorld.instance.isHydroPowerOn() ? 0.0f : 1.0f);
            }
        }
    }

    public static final class FridgeHumLogic
    extends PerObjectLogic {
        @Override
        public boolean shouldPlaySound() {
            ItemContainer itemContainer = this.object.getContainerByEitherType("fridge", "freezer");
            return itemContainer != null && itemContainer.isPowered();
        }

        @Override
        public String getSoundName() {
            return "FridgeHum";
        }

        @Override
        public void startPlaying(BaseSoundEmitter baseSoundEmitter, long l) {
        }

        @Override
        public void stopPlaying(BaseSoundEmitter baseSoundEmitter, long l) {
            this.parameterValue1 = Float.NaN;
        }

        @Override
        public void checkParameters(BaseSoundEmitter baseSoundEmitter, long l) {
            this.setParameterValue1(baseSoundEmitter, l, "Generator", IsoWorld.instance.isHydroPowerOn() ? 0.0f : 1.0f);
        }
    }
}

