/*
 * Decompiled with CFR 0.152.
 */
package zombie.audio;

import fmod.fmod.FMODManager;
import fmod.fmod.FMOD_STUDIO_PARAMETER_DESCRIPTION;
import java.util.ArrayList;
import zombie.SystemDisabler;
import zombie.audio.GameSoundClip;
import zombie.core.Rand;

public final class GameSound {
    public String name;
    public String category = "General";
    public boolean loop = false;
    public boolean is3D = true;
    public final ArrayList<GameSoundClip> clips = new ArrayList();
    private float userVolume = 1.0f;
    public MasterVolume master = MasterVolume.Primary;
    public int maxInstancesPerEmitter = -1;
    public short reloadEpoch;

    public String getName() {
        return this.name;
    }

    public String getCategory() {
        return this.category;
    }

    public boolean isLooped() {
        return this.loop;
    }

    public void setUserVolume(float f) {
        this.userVolume = Math.max(0.0f, Math.min(2.0f, f));
    }

    public float getUserVolume() {
        if (!SystemDisabler.getEnableAdvancedSoundOptions()) {
            return 1.0f;
        }
        return this.userVolume;
    }

    public GameSoundClip getRandomClip() {
        return this.clips.get(Rand.Next(this.clips.size()));
    }

    public String getMasterName() {
        return this.master.name();
    }

    public int numClipsUsingParameter(String string) {
        FMOD_STUDIO_PARAMETER_DESCRIPTION fMOD_STUDIO_PARAMETER_DESCRIPTION = FMODManager.instance.getParameterDescription(string);
        if (fMOD_STUDIO_PARAMETER_DESCRIPTION == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this.clips.size(); ++i) {
            GameSoundClip gameSoundClip = this.clips.get(i);
            if (!gameSoundClip.hasParameter(fMOD_STUDIO_PARAMETER_DESCRIPTION)) continue;
            ++n;
        }
        return n;
    }

    public void reset() {
        this.name = null;
        this.category = "General";
        this.loop = false;
        this.is3D = true;
        this.clips.clear();
        this.userVolume = 1.0f;
        this.master = MasterVolume.Primary;
        this.maxInstancesPerEmitter = -1;
        this.reloadEpoch = (short)(this.reloadEpoch + 1);
    }

    public static enum MasterVolume {
        Primary,
        Ambient,
        Music,
        VehicleEngine;

    }
}

