/*
 * Decompiled with CFR 0.152.
 */
package zombie.asset;

import java.util.ArrayList;
import zombie.asset.AssetManager;
import zombie.asset.AssetPath;
import zombie.asset.AssetStateObserver;
import zombie.asset.AssetTask;
import zombie.asset.AssetType;

public abstract class Asset {
    protected final AssetManager m_asset_manager;
    private AssetPath m_path;
    private int m_ref_count = 0;
    final PRIVATE m_priv = new PRIVATE();

    protected Asset(AssetPath assetPath, AssetManager assetManager) {
        this.m_path = assetPath;
        this.m_asset_manager = assetManager;
    }

    public abstract AssetType getType();

    public State getState() {
        return this.m_priv.m_current_state;
    }

    public boolean isEmpty() {
        return this.m_priv.m_current_state == State.EMPTY;
    }

    public boolean isReady() {
        return this.m_priv.m_current_state == State.READY;
    }

    public boolean isFailure() {
        return this.m_priv.m_current_state == State.FAILURE;
    }

    public void onCreated(State state) {
        this.m_priv.onCreated(state);
    }

    public int getRefCount() {
        return this.m_ref_count;
    }

    public ObserverCallback getObserverCb() {
        if (this.m_priv.m_cb == null) {
            this.m_priv.m_cb = new ObserverCallback();
        }
        return this.m_priv.m_cb;
    }

    public AssetPath getPath() {
        return this.m_path;
    }

    public AssetManager getAssetManager() {
        return this.m_asset_manager;
    }

    protected void onBeforeReady() {
    }

    protected void onBeforeEmpty() {
    }

    public void addDependency(Asset asset) {
        this.m_priv.addDependency(asset);
    }

    public void removeDependency(Asset asset) {
        this.m_priv.removeDependency(asset);
    }

    int addRef() {
        return ++this.m_ref_count;
    }

    int rmRef() {
        return --this.m_ref_count;
    }

    public void setAssetParams(AssetManager.AssetParams assetParams) {
    }

    final class PRIVATE
    implements AssetStateObserver {
        State m_current_state = State.EMPTY;
        State m_desired_state = State.EMPTY;
        int m_empty_dep_count = 1;
        int m_failed_dep_count = 0;
        ObserverCallback m_cb;
        AssetTask m_task = null;

        PRIVATE() {
        }

        void onCreated(State state) {
            assert (this.m_empty_dep_count == 1);
            assert (this.m_failed_dep_count == 0);
            this.m_current_state = state;
            this.m_desired_state = State.READY;
            this.m_failed_dep_count = state == State.FAILURE ? 1 : 0;
            this.m_empty_dep_count = 0;
        }

        void addDependency(Asset asset) {
            assert (this.m_desired_state != State.EMPTY);
            asset.getObserverCb().add(this);
            if (asset.isEmpty()) {
                ++this.m_empty_dep_count;
            }
            if (asset.isFailure()) {
                ++this.m_failed_dep_count;
            }
            this.checkState();
        }

        void removeDependency(Asset asset) {
            asset.getObserverCb().remove(this);
            if (asset.isEmpty()) {
                assert (this.m_empty_dep_count > 0);
                --this.m_empty_dep_count;
            }
            if (asset.isFailure()) {
                assert (this.m_failed_dep_count > 0);
                --this.m_failed_dep_count;
            }
            this.checkState();
        }

        @Override
        public void onStateChanged(State state, State state2, Asset asset) {
            assert (state != state2);
            assert (this.m_current_state != State.EMPTY || this.m_desired_state != State.EMPTY);
            if (state == State.EMPTY) {
                assert (this.m_empty_dep_count > 0);
                --this.m_empty_dep_count;
            }
            if (state == State.FAILURE) {
                assert (this.m_failed_dep_count > 0);
                --this.m_failed_dep_count;
            }
            if (state2 == State.EMPTY) {
                ++this.m_empty_dep_count;
            }
            if (state2 == State.FAILURE) {
                ++this.m_failed_dep_count;
            }
            this.checkState();
        }

        void onLoadingSucceeded() {
            assert (this.m_current_state != State.READY);
            assert (this.m_empty_dep_count == 1);
            --this.m_empty_dep_count;
            this.m_task = null;
            this.checkState();
        }

        void onLoadingFailed() {
            assert (this.m_current_state != State.READY);
            assert (this.m_empty_dep_count == 1);
            ++this.m_failed_dep_count;
            --this.m_empty_dep_count;
            this.m_task = null;
            this.checkState();
        }

        void checkState() {
            State state = this.m_current_state;
            if (this.m_failed_dep_count > 0 && this.m_current_state != State.FAILURE) {
                this.m_current_state = State.FAILURE;
                Asset.this.getAssetManager().onStateChanged(state, this.m_current_state, Asset.this);
                if (this.m_cb != null) {
                    this.m_cb.invoke(state, this.m_current_state, Asset.this);
                }
            }
            if (this.m_failed_dep_count == 0) {
                if (this.m_empty_dep_count == 0 && this.m_current_state != State.READY && this.m_desired_state != State.EMPTY) {
                    Asset.this.onBeforeReady();
                    this.m_current_state = State.READY;
                    Asset.this.getAssetManager().onStateChanged(state, this.m_current_state, Asset.this);
                    if (this.m_cb != null) {
                        this.m_cb.invoke(state, this.m_current_state, Asset.this);
                    }
                }
                if (this.m_empty_dep_count > 0 && this.m_current_state != State.EMPTY) {
                    Asset.this.onBeforeEmpty();
                    this.m_current_state = State.EMPTY;
                    Asset.this.getAssetManager().onStateChanged(state, this.m_current_state, Asset.this);
                    if (this.m_cb != null) {
                        this.m_cb.invoke(state, this.m_current_state, Asset.this);
                    }
                }
            }
        }
    }

    public static enum State {
        EMPTY,
        READY,
        FAILURE;

    }

    public static final class ObserverCallback
    extends ArrayList<AssetStateObserver> {
        public void invoke(State state, State state2, Asset asset) {
            int n = this.size();
            for (int i = 0; i < n; ++i) {
                ((AssetStateObserver)this.get(i)).onStateChanged(state, state2, asset);
            }
        }
    }
}

