/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import zombie.ai.State;
import zombie.audio.parameters.ParameterZombieState;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoZombie;
import zombie.core.skinnedmodel.advancedanimation.AnimEvent;

public final class ZombieReanimateState
extends State {
    private static final ZombieReanimateState _instance = new ZombieReanimateState();

    public static ZombieReanimateState instance() {
        return _instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        IsoZombie isoZombie = (IsoZombie)isoGameCharacter;
        isoZombie.clearVariable("ReanimateAnim");
        isoZombie.parameterZombieState.setState(ParameterZombieState.State.Idle);
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
        IsoZombie isoZombie = (IsoZombie)isoGameCharacter;
        isoZombie.clearVariable("ReanimateAnim");
    }

    @Override
    public void animEvent(IsoGameCharacter isoGameCharacter, AnimEvent animEvent) {
        IsoZombie isoZombie = (IsoZombie)isoGameCharacter;
        if (animEvent.m_EventName.equalsIgnoreCase("FallOnFront")) {
            isoGameCharacter.setFallOnFront(Boolean.parseBoolean(animEvent.m_ParameterValue));
        }
        if (animEvent.m_EventName.equalsIgnoreCase("ReanimateAnimFinishing")) {
            isoZombie.setReanimate(false);
            isoZombie.setFallOnFront(true);
        }
        if (animEvent.m_EventName.equalsIgnoreCase("FallOnFront")) {
            isoGameCharacter.setFallOnFront(Boolean.parseBoolean(animEvent.m_ParameterValue));
        }
    }
}

