/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import zombie.GameTime;
import zombie.ai.State;
import zombie.audio.parameters.ParameterZombieState;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoZombie;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.skinnedmodel.animation.AnimationPlayer;
import zombie.core.skinnedmodel.model.Model;
import zombie.iso.Vector3;
import zombie.iso.objects.IsoDeadBody;
import zombie.network.GameClient;

public final class ZombieOnGroundState
extends State {
    private static final ZombieOnGroundState _instance = new ZombieOnGroundState();
    static Vector3 tempVector = new Vector3();
    static Vector3 tempVectorBonePos = new Vector3();

    public static ZombieOnGroundState instance() {
        return _instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        IsoZombie isoZombie = (IsoZombie)isoGameCharacter;
        isoGameCharacter.setCollidable(false);
        if (!isoGameCharacter.isDead()) {
            isoGameCharacter.setOnFloor(true);
        }
        if (isoGameCharacter.isDead() || isoZombie.isFakeDead()) {
            isoGameCharacter.die();
            return;
        }
        if (isoZombie.isBecomeCrawler()) {
            return;
        }
        if (!"Tutorial".equals(Core.GameMode)) {
            isoGameCharacter.setReanimateTimer(Rand.Next(60) + 30);
        }
        if (GameClient.bClient && isoZombie.isReanimatedPlayer()) {
            IsoDeadBody.removeDeadBody(isoZombie.networkAI.reanimatedBodyID);
        }
        isoZombie.parameterZombieState.setState(ParameterZombieState.State.Idle);
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
        IsoZombie isoZombie = (IsoZombie)isoGameCharacter;
        if (isoGameCharacter.isDead() || isoZombie.isFakeDead()) {
            isoGameCharacter.die();
            return;
        }
        if (isoZombie.isBecomeCrawler()) {
            if (isoZombie.isBeingSteppedOn() || isoZombie.isUnderVehicle()) {
                return;
            }
            isoZombie.setCrawler(true);
            isoZombie.setCanWalk(false);
            isoZombie.setReanimate(true);
            isoZombie.setBecomeCrawler(false);
            return;
        }
        if (isoGameCharacter.hasAnimationPlayer()) {
            isoGameCharacter.getAnimationPlayer().setTargetToAngle();
        }
        isoGameCharacter.setReanimateTimer(isoGameCharacter.getReanimateTimer() - GameTime.getInstance().getMultiplier() / 1.6f);
        if (isoGameCharacter.getReanimateTimer() <= 2.0f) {
            if (GameClient.bClient) {
                if (isoGameCharacter.isBeingSteppedOn() && !isoZombie.isReanimatedPlayer()) {
                    isoGameCharacter.setReanimateTimer(Rand.Next(60) + 30);
                }
            } else if (isoGameCharacter.isBeingSteppedOn() && isoZombie.getReanimatedPlayer() == null) {
                isoGameCharacter.setReanimateTimer(Rand.Next(60) + 30);
            }
        }
    }

    public static boolean isCharacterStandingOnOther(IsoGameCharacter isoGameCharacter, IsoGameCharacter isoGameCharacter2) {
        AnimationPlayer animationPlayer = isoGameCharacter2.getAnimationPlayer();
        int n = ZombieOnGroundState.DoCollisionBoneCheck(isoGameCharacter, isoGameCharacter2, animationPlayer.getSkinningBoneIndex("Bip01_Spine", -1), 0.32f);
        if (n == -1) {
            n = ZombieOnGroundState.DoCollisionBoneCheck(isoGameCharacter, isoGameCharacter2, animationPlayer.getSkinningBoneIndex("Bip01_L_Calf", -1), 0.18f);
        }
        if (n == -1) {
            n = ZombieOnGroundState.DoCollisionBoneCheck(isoGameCharacter, isoGameCharacter2, animationPlayer.getSkinningBoneIndex("Bip01_R_Calf", -1), 0.18f);
        }
        if (n == -1) {
            n = ZombieOnGroundState.DoCollisionBoneCheck(isoGameCharacter, isoGameCharacter2, animationPlayer.getSkinningBoneIndex("Bip01_Head", -1), 0.28f);
        }
        return n > -1;
    }

    private static int DoCollisionBoneCheck(IsoGameCharacter isoGameCharacter, IsoGameCharacter isoGameCharacter2, int n, float f) {
        int n2 = n;
        float f2 = 0.3f;
        Model.BoneToWorldCoords(isoGameCharacter2, n2, tempVectorBonePos);
        for (int i = 1; i <= 10; ++i) {
            boolean bl;
            float f3 = (float)i / 10.0f;
            ZombieOnGroundState.tempVector.x = isoGameCharacter.x;
            ZombieOnGroundState.tempVector.y = isoGameCharacter.y;
            ZombieOnGroundState.tempVector.z = isoGameCharacter.z;
            ZombieOnGroundState.tempVector.x += isoGameCharacter.getForwardDirection().x * f2 * f3;
            ZombieOnGroundState.tempVector.y += isoGameCharacter.getForwardDirection().y * f2 * f3;
            ZombieOnGroundState.tempVector.x = ZombieOnGroundState.tempVectorBonePos.x - ZombieOnGroundState.tempVector.x;
            ZombieOnGroundState.tempVector.y = ZombieOnGroundState.tempVectorBonePos.y - ZombieOnGroundState.tempVector.y;
            ZombieOnGroundState.tempVector.z = 0.0f;
            boolean bl2 = bl = tempVector.getLength() < f;
            if (!bl) continue;
            return n2;
        }
        return -1;
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
    }
}

