/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import java.util.HashMap;
import zombie.ai.State;
import zombie.audio.parameters.ParameterZombieState;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.skinnedmodel.advancedanimation.AnimEvent;
import zombie.gameStates.IngameState;
import zombie.iso.objects.RainManager;

public final class ZombieIdleState
extends State {
    private static final ZombieIdleState _instance = new ZombieIdleState();
    private static final Integer PARAM_TICK_COUNT = 0;

    public static ZombieIdleState instance() {
        return _instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        ((IsoZombie)isoGameCharacter).soundSourceTarget = null;
        ((IsoZombie)isoGameCharacter).soundAttract = 0.0f;
        ((IsoZombie)isoGameCharacter).movex = 0.0f;
        ((IsoZombie)isoGameCharacter).movey = 0.0f;
        isoGameCharacter.setStateEventDelayTimer(this.pickRandomWanderInterval());
        if (IngameState.instance == null) {
            hashMap.put(PARAM_TICK_COUNT, 0L);
        } else {
            hashMap.put(PARAM_TICK_COUNT, IngameState.instance.numberTicks);
        }
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
        IsoZombie isoZombie = (IsoZombie)isoGameCharacter;
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        isoZombie.movex = 0.0f;
        isoZombie.movey = 0.0f;
        if (Core.bLastStand) {
            IsoPlayer isoPlayer = null;
            float f = 1000000.0f;
            for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                if (IsoPlayer.players[i] == null || !(IsoPlayer.players[i].DistTo(isoGameCharacter) < f) || IsoPlayer.players[i].isDead()) continue;
                f = IsoPlayer.players[i].DistTo(isoGameCharacter);
                isoPlayer = IsoPlayer.players[i];
            }
            if (isoPlayer != null) {
                isoZombie.pathToCharacter(isoPlayer);
            }
            return;
        }
        if (((IsoZombie)isoGameCharacter).bCrawling) {
            isoGameCharacter.setOnFloor(true);
        } else {
            isoGameCharacter.setOnFloor(false);
        }
        long l = (Long)hashMap.get(PARAM_TICK_COUNT);
        if (IngameState.instance.numberTicks - l == 2L) {
            ((IsoZombie)isoGameCharacter).parameterZombieState.setState(ParameterZombieState.State.Idle);
        }
        if (isoZombie.bIndoorZombie) {
            return;
        }
        if (isoZombie.isUseless()) {
            return;
        }
        if (isoZombie.getStateEventDelayTimer() <= 0.0f) {
            isoGameCharacter.setStateEventDelayTimer(this.pickRandomWanderInterval());
            int n = (int)isoGameCharacter.getX() + (Rand.Next(8) - 4);
            int n2 = (int)isoGameCharacter.getY() + (Rand.Next(8) - 4);
            if (isoGameCharacter.getCell().getGridSquare((double)n, (double)n2, isoGameCharacter.getZ()) != null && isoGameCharacter.getCell().getGridSquare((double)n, (double)n2, isoGameCharacter.getZ()).isFree(true)) {
                isoGameCharacter.pathToLocation(n, n2, (int)isoGameCharacter.getZ());
                isoZombie.AllowRepathDelay = 200.0f;
            }
        }
        isoZombie.networkAI.mindSync.zombieIdleUpdate();
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
    }

    @Override
    public void animEvent(IsoGameCharacter isoGameCharacter, AnimEvent animEvent) {
    }

    private float pickRandomWanderInterval() {
        float f = Rand.Next(400, 1000);
        if (!RainManager.isRaining().booleanValue()) {
            f *= 1.5f;
        }
        return f;
    }
}

