/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import java.util.HashMap;
import zombie.GameTime;
import zombie.ai.State;
import zombie.audio.parameters.ParameterZombieState;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoZombie;
import zombie.core.Rand;
import zombie.core.skinnedmodel.advancedanimation.AnimEvent;
import zombie.iso.IsoDirections;
import zombie.iso.objects.IsoZombieGiblets;

public final class ZombieHitReactionState
extends State {
    private static final ZombieHitReactionState _instance = new ZombieHitReactionState();
    private static final int TURN_TO_PLAYER = 1;
    private static final int HIT_REACTION_TIMER = 2;

    public static ZombieHitReactionState instance() {
        return _instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        IsoZombie isoZombie = (IsoZombie)isoGameCharacter;
        isoZombie.collideWhileHit = true;
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        hashMap.put(1, Boolean.FALSE);
        hashMap.put(2, Float.valueOf(0.0f));
        isoGameCharacter.clearVariable("onknees");
        if (isoZombie.isSitAgainstWall()) {
            isoGameCharacter.setHitReaction(null);
        }
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        isoGameCharacter.setOnFloor(((IsoZombie)isoGameCharacter).isKnockedDown());
        hashMap.put(2, Float.valueOf(((Float)hashMap.get(2)).floatValue() + GameTime.getInstance().getMultiplier()));
        if (hashMap.get(1) == Boolean.TRUE) {
            if (!isoGameCharacter.isHitFromBehind()) {
                isoGameCharacter.setDir(IsoDirections.reverse(IsoDirections.fromAngle(isoGameCharacter.getHitDir())));
            } else {
                isoGameCharacter.setDir(IsoDirections.fromAngle(isoGameCharacter.getHitDir()));
            }
        } else if (isoGameCharacter.hasAnimationPlayer()) {
            isoGameCharacter.getAnimationPlayer().setTargetToAngle();
        }
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
        IsoZombie isoZombie = (IsoZombie)isoGameCharacter;
        isoZombie.collideWhileHit = true;
        if (isoZombie.target != null) {
            isoZombie.AllowRepathDelay = 0.0f;
            isoZombie.spotted(isoZombie.target, true);
        }
        isoZombie.setStaggerBack(false);
        isoZombie.setHitReaction("");
        isoZombie.setEatBodyTarget(null, false);
        isoZombie.setSitAgainstWall(false);
        isoZombie.setShootable(true);
    }

    @Override
    public void animEvent(IsoGameCharacter isoGameCharacter, AnimEvent animEvent) {
        int n;
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        IsoZombie isoZombie = (IsoZombie)isoGameCharacter;
        if (animEvent.m_EventName.equalsIgnoreCase("DoDeath") && Boolean.parseBoolean(animEvent.m_ParameterValue) && isoGameCharacter.isAlive()) {
            isoGameCharacter.Kill(isoGameCharacter.getAttackedBy());
            if (isoZombie.upKillCount && isoGameCharacter.getAttackedBy() != null) {
                isoGameCharacter.getAttackedBy().setZombieKills(isoGameCharacter.getAttackedBy().getZombieKills() + 1);
            }
        }
        if (animEvent.m_EventName.equalsIgnoreCase("PlayDeathSound")) {
            isoGameCharacter.setDoDeathSound(false);
            isoGameCharacter.playDeadSound();
        }
        if (animEvent.m_EventName.equalsIgnoreCase("FallOnFront")) {
            isoGameCharacter.setFallOnFront(Boolean.parseBoolean(animEvent.m_ParameterValue));
        }
        if (animEvent.m_EventName.equalsIgnoreCase("ActiveAnimFinishing")) {
            // empty if block
        }
        if (animEvent.m_EventName.equalsIgnoreCase("Collide") && ((IsoZombie)isoGameCharacter).speedType == 1) {
            ((IsoZombie)isoGameCharacter).collideWhileHit = false;
        }
        if (animEvent.m_EventName.equalsIgnoreCase("ZombieTurnToPlayer")) {
            n = Boolean.parseBoolean(animEvent.m_ParameterValue);
            hashMap.put(1, n != 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        if (animEvent.m_EventName.equalsIgnoreCase("CancelKnockDown") && (n = Boolean.parseBoolean(animEvent.m_ParameterValue)) != 0) {
            ((IsoZombie)isoGameCharacter).setKnockedDown(false);
        }
        if (animEvent.m_EventName.equalsIgnoreCase("KnockDown")) {
            isoGameCharacter.setOnFloor(true);
            ((IsoZombie)isoGameCharacter).setKnockedDown(true);
        }
        if (animEvent.m_EventName.equalsIgnoreCase("SplatBlood")) {
            isoZombie.addBlood(null, true, false, false);
            isoZombie.addBlood(null, true, false, false);
            isoZombie.addBlood(null, true, false, false);
            isoZombie.playBloodSplatterSound();
            for (n = 0; n < 10; ++n) {
                isoZombie.getCurrentSquare().getChunk().addBloodSplat(isoZombie.x + Rand.Next(-0.5f, 0.5f), isoZombie.y + Rand.Next(-0.5f, 0.5f), isoZombie.z, Rand.Next(8));
                if (Rand.Next(5) == 0) {
                    new IsoZombieGiblets(IsoZombieGiblets.GibletType.B, isoZombie.getCell(), isoZombie.getX(), isoZombie.getY(), isoZombie.getZ() + 0.3f, Rand.Next(-0.2f, 0.2f) * 1.5f, Rand.Next(-0.2f, 0.2f) * 1.5f);
                    continue;
                }
                new IsoZombieGiblets(IsoZombieGiblets.GibletType.A, isoZombie.getCell(), isoZombie.getX(), isoZombie.getY(), isoZombie.getZ() + 0.3f, Rand.Next(-0.2f, 0.2f) * 1.5f, Rand.Next(-0.2f, 0.2f) * 1.5f);
            }
        }
        if (animEvent.m_EventName.equalsIgnoreCase("SetState") && !isoZombie.isDead()) {
            if (isoZombie.getAttackedBy() != null && isoZombie.getAttackedBy().getVehicle() != null && "Floor".equals(isoZombie.getHitReaction())) {
                isoZombie.parameterZombieState.setState(ParameterZombieState.State.RunOver);
                return;
            }
            isoZombie.parameterZombieState.setState(ParameterZombieState.State.Hit);
        }
    }
}

