/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import java.util.HashMap;
import zombie.ai.State;
import zombie.ai.states.PathFindState;
import zombie.ai.states.WalkTowardState;
import zombie.ai.states.ZombieGetUpFromCrawlState;
import zombie.audio.parameters.ParameterZombieState;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoZombie;
import zombie.core.skinnedmodel.advancedanimation.AnimEvent;
import zombie.network.GameClient;
import zombie.util.StringUtils;

public final class ZombieGetUpState
extends State {
    private static final ZombieGetUpState _instance = new ZombieGetUpState();
    static final Integer PARAM_STANDING = 1;
    static final Integer PARAM_PREV_STATE = 2;

    public static ZombieGetUpState instance() {
        return _instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        IsoZombie isoZombie = (IsoZombie)isoGameCharacter;
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        hashMap.put(PARAM_STANDING, Boolean.FALSE);
        State state = isoGameCharacter.getStateMachine().getPrevious();
        if (state == ZombieGetUpFromCrawlState.instance()) {
            state = (State)isoGameCharacter.getStateMachineParams(ZombieGetUpFromCrawlState.instance()).get(1);
        }
        hashMap.put(PARAM_PREV_STATE, state);
        isoZombie.parameterZombieState.setState(ParameterZombieState.State.GettingUp);
        if (GameClient.bClient) {
            isoGameCharacter.setKnockedDown(false);
        }
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        boolean bl = hashMap.get(PARAM_STANDING) == Boolean.TRUE;
        isoGameCharacter.setOnFloor(!bl);
        ((IsoZombie)isoGameCharacter).setKnockedDown(!bl);
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        IsoZombie isoZombie = (IsoZombie)isoGameCharacter;
        isoGameCharacter.setCollidable(true);
        isoGameCharacter.clearVariable("SprinterTripped");
        isoGameCharacter.clearVariable("ShouldStandUp");
        if (StringUtils.isNullOrEmpty(isoGameCharacter.getHitReaction())) {
            isoZombie.setSitAgainstWall(false);
        }
        isoZombie.setKnockedDown(false);
        isoZombie.AllowRepathDelay = 0.0f;
        if (hashMap.get(PARAM_PREV_STATE) == PathFindState.instance()) {
            if (isoGameCharacter.getPathFindBehavior2().getTargetChar() == null) {
                isoGameCharacter.setVariable("bPathfind", true);
                isoGameCharacter.setVariable("bMoving", false);
            } else if (isoZombie.isTargetLocationKnown()) {
                isoGameCharacter.pathToCharacter(isoGameCharacter.getPathFindBehavior2().getTargetChar());
            } else if (isoZombie.LastTargetSeenX != -1) {
                isoGameCharacter.pathToLocation(isoZombie.LastTargetSeenX, isoZombie.LastTargetSeenY, isoZombie.LastTargetSeenZ);
            }
        } else if (hashMap.get(PARAM_PREV_STATE) == WalkTowardState.instance()) {
            isoGameCharacter.setVariable("bPathFind", false);
            isoGameCharacter.setVariable("bMoving", true);
        }
    }

    @Override
    public void animEvent(IsoGameCharacter isoGameCharacter, AnimEvent animEvent) {
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        IsoZombie isoZombie = (IsoZombie)isoGameCharacter;
        if (animEvent.m_EventName.equalsIgnoreCase("IsAlmostUp")) {
            hashMap.put(PARAM_STANDING, Boolean.TRUE);
        }
    }
}

