/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import java.util.HashMap;
import zombie.ai.State;
import zombie.ai.states.PathFindState;
import zombie.ai.states.WalkTowardState;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoZombie;
import zombie.core.Rand;
import zombie.core.skinnedmodel.advancedanimation.AnimEvent;

public final class ZombieGetDownState
extends State {
    private static final ZombieGetDownState _instance = new ZombieGetDownState();
    static final Integer PARAM_PREV_STATE = 1;
    static final Integer PARAM_WAIT_TIME = 2;
    static final Integer PARAM_START_X = 3;
    static final Integer PARAM_START_Y = 4;

    public static ZombieGetDownState instance() {
        return _instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        hashMap.put(PARAM_PREV_STATE, isoGameCharacter.getStateMachine().getPrevious());
        hashMap.put(PARAM_START_X, Float.valueOf(isoGameCharacter.getX()));
        hashMap.put(PARAM_START_Y, Float.valueOf(isoGameCharacter.getY()));
        isoGameCharacter.setStateEventDelayTimer(((Float)hashMap.get(PARAM_WAIT_TIME)).floatValue());
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        IsoZombie isoZombie = (IsoZombie)isoGameCharacter;
        isoZombie.setStateEventDelayTimer(0.0f);
        isoZombie.AllowRepathDelay = 0.0f;
        if (hashMap.get(PARAM_PREV_STATE) == PathFindState.instance()) {
            if (isoGameCharacter.getPathFindBehavior2().getTargetChar() == null) {
                isoGameCharacter.setVariable("bPathfind", true);
                isoGameCharacter.setVariable("bMoving", false);
            } else if (isoZombie.isTargetLocationKnown()) {
                isoGameCharacter.pathToCharacter(isoGameCharacter.getPathFindBehavior2().getTargetChar());
            } else if (isoZombie.LastTargetSeenX != -1) {
                isoGameCharacter.pathToLocation(isoZombie.LastTargetSeenX, isoZombie.LastTargetSeenY, isoZombie.LastTargetSeenZ);
            }
        } else if (hashMap.get(PARAM_PREV_STATE) == WalkTowardState.instance()) {
            isoGameCharacter.setVariable("bPathFind", false);
            isoGameCharacter.setVariable("bMoving", true);
        }
    }

    @Override
    public void animEvent(IsoGameCharacter isoGameCharacter, AnimEvent animEvent) {
        IsoZombie isoZombie = (IsoZombie)isoGameCharacter;
        if (animEvent.m_EventName.equalsIgnoreCase("StartCrawling") && !isoZombie.isCrawling()) {
            isoZombie.toggleCrawling();
        }
    }

    public boolean isNearStartXY(IsoGameCharacter isoGameCharacter) {
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        Float f = (Float)hashMap.get(PARAM_START_X);
        Float f2 = (Float)hashMap.get(PARAM_START_Y);
        if (f == null || f2 == null) {
            return false;
        }
        return isoGameCharacter.DistToSquared(f.floatValue(), f2.floatValue()) <= 0.25f;
    }

    public void setParams(IsoGameCharacter isoGameCharacter) {
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        hashMap.put(PARAM_WAIT_TIME, Float.valueOf(Rand.Next(60.0f, 150.0f)));
    }
}

