/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import java.util.HashMap;
import zombie.ai.State;
import zombie.audio.parameters.ParameterZombieState;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.iso.IsoMovingObject;
import zombie.iso.objects.IsoDeadBody;
import zombie.iso.objects.IsoZombieGiblets;
import zombie.network.GameClient;
import zombie.network.GameServer;

public final class ZombieEatBodyState
extends State {
    private static final ZombieEatBodyState _instance = new ZombieEatBodyState();

    public static ZombieEatBodyState instance() {
        return _instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        IsoZombie isoZombie = (IsoZombie)isoGameCharacter;
        isoZombie.setStateEventDelayTimer(Rand.Next(1800.0f, 3600.0f));
        isoZombie.setVariable("onknees", Rand.Next(3) != 0);
        if (isoZombie.getEatBodyTarget() instanceof IsoDeadBody) {
            IsoDeadBody isoDeadBody = (IsoDeadBody)isoZombie.eatBodyTarget;
            if (!isoZombie.isEatingOther(isoDeadBody)) {
                HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
                hashMap.put(0, isoDeadBody);
                isoDeadBody.getEatingZombies().add(isoZombie);
            }
            if (GameClient.bClient && isoZombie.isLocal()) {
                GameClient.sendEatBody(isoZombie, isoZombie.getEatBodyTarget());
            }
        } else if (isoZombie.getEatBodyTarget() instanceof IsoPlayer && GameClient.bClient && isoZombie.isLocal()) {
            GameClient.sendEatBody(isoZombie, isoZombie.getEatBodyTarget());
        }
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
        IsoZombie isoZombie = (IsoZombie)isoGameCharacter;
        IsoMovingObject isoMovingObject = isoZombie.getEatBodyTarget();
        if (isoZombie.getStateEventDelayTimer() <= 0.0f) {
            isoZombie.setEatBodyTarget(null, false);
        } else if (!GameServer.bServer && !Core.SoundDisabled && Rand.Next(Rand.AdjustForFramerate(15)) == 0) {
            isoZombie.parameterZombieState.setState(ParameterZombieState.State.Eating);
        }
        isoZombie.TimeSinceSeenFlesh = 0.0f;
        if (isoMovingObject != null) {
            isoZombie.faceThisObject(isoMovingObject);
        }
        if (Rand.Next(Rand.AdjustForFramerate(450)) == 0) {
            isoZombie.getCurrentSquare().getChunk().addBloodSplat(isoZombie.x + Rand.Next(-0.5f, 0.5f), isoZombie.y + Rand.Next(-0.5f, 0.5f), isoZombie.z, Rand.Next(8));
            if (Rand.Next(6) == 0) {
                new IsoZombieGiblets(IsoZombieGiblets.GibletType.B, isoZombie.getCell(), isoZombie.getX(), isoZombie.getY(), isoZombie.getZ() + 0.3f, Rand.Next(-0.2f, 0.2f) * 1.5f, Rand.Next(-0.2f, 0.2f) * 1.5f);
            } else {
                new IsoZombieGiblets(IsoZombieGiblets.GibletType.A, isoZombie.getCell(), isoZombie.getX(), isoZombie.getY(), isoZombie.getZ() + 0.3f, Rand.Next(-0.2f, 0.2f) * 1.5f, Rand.Next(-0.2f, 0.2f) * 1.5f);
            }
            if (Rand.Next(4) == 0) {
                isoZombie.addBlood(null, true, false, false);
            }
        }
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
        IsoZombie isoZombie = (IsoZombie)isoGameCharacter;
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        if (hashMap.get(0) instanceof IsoDeadBody) {
            ((IsoDeadBody)hashMap.get(0)).getEatingZombies().remove(isoZombie);
        }
        if (isoZombie.parameterZombieState.isState(ParameterZombieState.State.Eating)) {
            isoZombie.parameterZombieState.setState(ParameterZombieState.State.Idle);
        }
        if (GameClient.bClient && isoZombie.isLocal()) {
            GameClient.sendEatBody(isoZombie, null);
        }
    }
}

