/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import java.util.HashMap;
import zombie.ai.State;
import zombie.audio.parameters.ParameterZombieState;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoZombie;
import zombie.gameStates.IngameState;
import zombie.iso.IsoChunk;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.network.GameServer;
import zombie.network.NetworkVariables;
import zombie.network.ServerMap;
import zombie.vehicles.PathFindBehavior2;
import zombie.vehicles.PolygonalMap2;

public class WalkTowardNetworkState
extends State {
    static WalkTowardNetworkState _instance = new WalkTowardNetworkState();
    private static final Integer PARAM_TICK_COUNT = 2;

    public static WalkTowardNetworkState instance() {
        return _instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        hashMap.put(PARAM_TICK_COUNT, IngameState.instance.numberTicks);
        isoGameCharacter.setVariable("bMoving", true);
        isoGameCharacter.setVariable("bPathfind", false);
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
        HashMap<Object, Object> hashMap;
        long l;
        IsoZombie isoZombie = (IsoZombie)isoGameCharacter;
        PathFindBehavior2 pathFindBehavior2 = isoZombie.getPathFindBehavior2();
        isoZombie.vectorToTarget.x = isoZombie.networkAI.targetX - isoZombie.x;
        isoZombie.vectorToTarget.y = isoZombie.networkAI.targetY - isoZombie.y;
        pathFindBehavior2.walkingOnTheSpot.reset(isoZombie.x, isoZombie.y);
        if (isoZombie.z == (float)isoZombie.networkAI.targetZ && (isoZombie.networkAI.predictionType == NetworkVariables.PredictionTypes.Thump || isoZombie.networkAI.predictionType == NetworkVariables.PredictionTypes.Climb)) {
            if (isoZombie.networkAI.usePathFind) {
                pathFindBehavior2.reset();
                isoZombie.setPath2(null);
                isoZombie.networkAI.usePathFind = false;
            }
            pathFindBehavior2.moveToPoint(isoZombie.networkAI.targetX, isoZombie.networkAI.targetY, 1.0f);
            isoZombie.setVariable("bMoving", IsoUtils.DistanceManhatten(isoZombie.networkAI.targetX, isoZombie.networkAI.targetY, isoZombie.nx, isoZombie.ny) > 0.5f);
        } else if (isoZombie.z == (float)isoZombie.networkAI.targetZ && !PolygonalMap2.instance.lineClearCollide(isoZombie.x, isoZombie.y, isoZombie.networkAI.targetX, isoZombie.networkAI.targetY, isoZombie.networkAI.targetZ, null)) {
            if (isoZombie.networkAI.usePathFind) {
                pathFindBehavior2.reset();
                isoZombie.setPath2(null);
                isoZombie.networkAI.usePathFind = false;
            }
            pathFindBehavior2.moveToPoint(isoZombie.networkAI.targetX, isoZombie.networkAI.targetY, 1.0f);
            isoZombie.setVariable("bMoving", IsoUtils.DistanceManhatten(isoZombie.networkAI.targetX, isoZombie.networkAI.targetY, isoZombie.nx, isoZombie.ny) > 0.5f);
        } else {
            PathFindBehavior2.BehaviorResult behaviorResult;
            if (!isoZombie.networkAI.usePathFind) {
                pathFindBehavior2.pathToLocationF(isoZombie.networkAI.targetX, isoZombie.networkAI.targetY, isoZombie.networkAI.targetZ);
                pathFindBehavior2.walkingOnTheSpot.reset(isoZombie.x, isoZombie.y);
                isoZombie.networkAI.usePathFind = true;
            }
            if ((behaviorResult = pathFindBehavior2.update()) == PathFindBehavior2.BehaviorResult.Failed) {
                isoZombie.setPathFindIndex(-1);
                return;
            }
            if (behaviorResult == PathFindBehavior2.BehaviorResult.Succeeded) {
                IsoChunk isoChunk;
                int n = (int)isoZombie.getPathFindBehavior2().getTargetX();
                int n2 = (int)isoZombie.getPathFindBehavior2().getTargetY();
                IsoChunk isoChunk2 = isoChunk = GameServer.bServer ? ServerMap.instance.getChunk(n / 10, n2 / 10) : IsoWorld.instance.CurrentCell.getChunkForGridSquare(n, n2, 0);
                if (isoChunk == null) {
                    isoZombie.setVariable("bMoving", true);
                    return;
                }
                isoZombie.setPath2(null);
                isoZombie.setVariable("bMoving", true);
                return;
            }
        }
        if (!((IsoZombie)isoGameCharacter).bCrawling) {
            isoGameCharacter.setOnFloor(false);
        }
        boolean bl = isoGameCharacter.isCollidedWithVehicle();
        if (isoZombie.target instanceof IsoGameCharacter && ((IsoGameCharacter)isoZombie.target).getVehicle() != null && ((IsoGameCharacter)isoZombie.target).getVehicle().isCharacterAdjacentTo(isoGameCharacter)) {
            bl = false;
        }
        if (isoGameCharacter.isCollidedThisFrame() || bl) {
            isoZombie.AllowRepathDelay = 0.0f;
            isoZombie.pathToLocation(isoGameCharacter.getPathTargetX(), isoGameCharacter.getPathTargetY(), isoGameCharacter.getPathTargetZ());
            if (!"true".equals(isoZombie.getVariableString("bPathfind"))) {
                isoZombie.setVariable("bPathfind", true);
                isoZombie.setVariable("bMoving", false);
            }
        }
        if (IngameState.instance.numberTicks - (l = ((Long)(hashMap = isoGameCharacter.getStateMachineParams(this)).get(PARAM_TICK_COUNT)).longValue()) == 2L) {
            isoZombie.parameterZombieState.setState(ParameterZombieState.State.Idle);
        }
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
        isoGameCharacter.setVariable("bMoving", false);
    }
}

