/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import zombie.GameTime;
import zombie.SoundManager;
import zombie.ai.State;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.characters.ZombieThumpManager;
import zombie.core.PerformanceSettings;
import zombie.core.Rand;
import zombie.core.skinnedmodel.advancedanimation.AnimEvent;
import zombie.iso.IsoChunk;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.LosUtil;
import zombie.iso.objects.IsoBarricade;
import zombie.iso.objects.IsoDoor;
import zombie.iso.objects.IsoThumpable;
import zombie.iso.objects.IsoWindow;
import zombie.iso.objects.interfaces.Thumpable;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.ServerMap;
import zombie.network.ServerOptions;
import zombie.util.Type;
import zombie.vehicles.BaseVehicle;

public final class ThumpState
extends State {
    private static final ThumpState _instance = new ThumpState();

    public static ThumpState instance() {
        return _instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        if (!GameClient.bClient || isoGameCharacter.isLocal()) {
            switch (Rand.Next(3)) {
                case 0: {
                    isoGameCharacter.setVariable("ThumpType", "DoorClaw");
                    break;
                }
                case 1: {
                    isoGameCharacter.setVariable("ThumpType", "Door");
                    break;
                }
                case 2: {
                    isoGameCharacter.setVariable("ThumpType", "DoorBang");
                }
            }
        }
        if (GameClient.bClient && isoGameCharacter.isLocal()) {
            GameClient.sendThump(isoGameCharacter, isoGameCharacter.getThumpTarget());
        }
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
        IsoGridSquare isoGridSquare;
        IsoThumpable isoThumpable;
        IsoGridSquare isoGridSquare2;
        IsoDoor isoDoor;
        Object object;
        boolean bl;
        IsoZombie isoZombie = (IsoZombie)isoGameCharacter;
        Thumpable thumpable = isoGameCharacter.getThumpTarget();
        if (thumpable instanceof IsoObject) {
            isoGameCharacter.faceThisObject((IsoObject)thumpable);
        }
        boolean bl2 = bl = GameServer.bServer && GameServer.bFastForward || !GameServer.bServer && IsoPlayer.allPlayersAsleep();
        if (bl || isoGameCharacter.actionContext.hasEventOccurred("thumpframe")) {
            boolean bl3;
            isoGameCharacter.actionContext.clearEvent("thumpframe");
            isoGameCharacter.setTimeThumping(isoGameCharacter.getTimeThumping() + 1);
            if (isoZombie.TimeSinceSeenFlesh < 5.0f) {
                isoGameCharacter.setTimeThumping(0);
            }
            int n = 1;
            if (isoGameCharacter.getCurrentSquare() != null) {
                n = isoGameCharacter.getCurrentSquare().getMovingObjects().size();
            }
            for (int i = 0; i < n && this.isThumpTargetValid(isoGameCharacter, isoGameCharacter.getThumpTarget()); ++i) {
                isoGameCharacter.getThumpTarget().Thump(isoGameCharacter);
            }
            object = isoGameCharacter.getThumpTarget() == null ? null : isoGameCharacter.getThumpTarget().getThumpableFor(isoGameCharacter);
            boolean bl4 = bl3 = GameServer.bServer || SoundManager.instance.isListenerInRange(isoGameCharacter.x, isoGameCharacter.y, 20.0f);
            if (bl3 && !IsoPlayer.allPlayersAsleep()) {
                if (object instanceof IsoWindow) {
                    isoZombie.setThumpFlag(Rand.Next(3) == 0 ? 2 : 3);
                    isoZombie.setThumpCondition(object.getThumpCondition());
                    if (!GameServer.bServer) {
                        ZombieThumpManager.instance.addCharacter(isoZombie);
                    }
                } else if (object != null) {
                    String string = "ZombieThumpGeneric";
                    IsoBarricade isoBarricade = Type.tryCastTo(object, IsoBarricade.class);
                    if (isoBarricade != null && (isoBarricade.isMetal() || isoBarricade.isMetalBar())) {
                        string = "ZombieThumpMetal";
                    } else if (object instanceof IsoDoor) {
                        string = ((IsoDoor)object).getThumpSound();
                    } else if (object instanceof IsoThumpable) {
                        string = ((IsoThumpable)object).getThumpSound();
                    }
                    if ("ZombieThumpGeneric".equals(string)) {
                        isoZombie.setThumpFlag(1);
                    } else if ("ZombieThumpWindow".equals(string)) {
                        isoZombie.setThumpFlag(3);
                    } else if ("ZombieThumpMetal".equals(string)) {
                        isoZombie.setThumpFlag(4);
                    } else if ("ZombieThumpGarageDoor".equals(string)) {
                        isoZombie.setThumpFlag(5);
                    } else {
                        isoZombie.setThumpFlag(1);
                    }
                    isoZombie.setThumpCondition(object.getThumpCondition());
                    if (!GameServer.bServer) {
                        ZombieThumpManager.instance.addCharacter(isoZombie);
                    }
                }
            }
        }
        if (this.isThumpTargetValid(isoGameCharacter, isoGameCharacter.getThumpTarget())) {
            return;
        }
        isoGameCharacter.setThumpTarget(null);
        isoGameCharacter.setTimeThumping(0);
        if (thumpable instanceof IsoWindow && ((IsoWindow)thumpable).canClimbThrough(isoGameCharacter)) {
            isoGameCharacter.climbThroughWindow((IsoWindow)thumpable);
            return;
        }
        if (thumpable instanceof IsoDoor && (((IsoDoor)thumpable).open || thumpable.isDestroyed()) && this.lungeThroughDoor(isoZombie, (IsoGridSquare)(object = (isoDoor = (IsoDoor)thumpable).getSquare()), isoGridSquare2 = isoDoor.getOppositeSquare())) {
            return;
        }
        if (thumpable instanceof IsoThumpable && ((IsoThumpable)thumpable).isDoor.booleanValue() && (((IsoThumpable)thumpable).open || thumpable.isDestroyed()) && this.lungeThroughDoor(isoZombie, (IsoGridSquare)(object = (isoThumpable = (IsoThumpable)thumpable).getSquare()), isoGridSquare = isoThumpable.getInsideSquare())) {
            return;
        }
        if (isoZombie.LastTargetSeenX != -1) {
            isoGameCharacter.pathToLocation(isoZombie.LastTargetSeenX, isoZombie.LastTargetSeenY, isoZombie.LastTargetSeenZ);
        }
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
        isoGameCharacter.setThumpTarget(null);
        ((IsoZombie)isoGameCharacter).setThumpTimer(200);
        if (GameClient.bClient && isoGameCharacter.isLocal()) {
            GameClient.sendThump(isoGameCharacter, isoGameCharacter.getThumpTarget());
        }
    }

    @Override
    public void animEvent(IsoGameCharacter isoGameCharacter, AnimEvent animEvent) {
        if (animEvent.m_EventName.equalsIgnoreCase("ThumpFrame")) {
            // empty if block
        }
    }

    private IsoPlayer findPlayer(int n, int n2, int n3, int n4, int n5) {
        for (int i = n3; i <= n4; ++i) {
            for (int j = n; j <= n2; ++j) {
                IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(j, i, n5);
                if (isoGridSquare == null) continue;
                for (int k = 0; k < isoGridSquare.getMovingObjects().size(); ++k) {
                    IsoMovingObject isoMovingObject = isoGridSquare.getMovingObjects().get(k);
                    if (!(isoMovingObject instanceof IsoPlayer) || ((IsoPlayer)isoMovingObject).isGhostMode()) continue;
                    return (IsoPlayer)isoMovingObject;
                }
            }
        }
        return null;
    }

    private boolean lungeThroughDoor(IsoZombie isoZombie, IsoGridSquare isoGridSquare, IsoGridSquare isoGridSquare2) {
        if (isoGridSquare == null || isoGridSquare2 == null) {
            return false;
        }
        boolean bl = isoGridSquare.getY() > isoGridSquare2.getY();
        IsoGridSquare isoGridSquare3 = null;
        IsoMovingObject isoMovingObject = null;
        if (isoZombie.getCurrentSquare() == isoGridSquare) {
            isoGridSquare3 = isoGridSquare2;
            isoMovingObject = bl ? this.findPlayer(isoGridSquare2.getX() - 1, isoGridSquare2.getX() + 1, isoGridSquare2.getY() - 1, isoGridSquare2.getY(), isoGridSquare2.getZ()) : this.findPlayer(isoGridSquare2.getX() - 1, isoGridSquare2.getX(), isoGridSquare2.getY() - 1, isoGridSquare2.getY() + 1, isoGridSquare2.getZ());
        } else if (isoZombie.getCurrentSquare() == isoGridSquare2) {
            isoGridSquare3 = isoGridSquare;
            isoMovingObject = bl ? this.findPlayer(isoGridSquare.getX() - 1, isoGridSquare.getX() + 1, isoGridSquare.getY(), isoGridSquare.getY() + 1, isoGridSquare.getZ()) : this.findPlayer(isoGridSquare.getX(), isoGridSquare.getX() + 1, isoGridSquare.getY() - 1, isoGridSquare.getY() + 1, isoGridSquare.getZ());
        }
        if (isoMovingObject != null && !LosUtil.lineClearCollide(isoGridSquare3.getX(), isoGridSquare3.getY(), isoGridSquare3.getZ(), (int)isoMovingObject.getX(), (int)isoMovingObject.getY(), (int)isoMovingObject.getZ(), false)) {
            isoZombie.setTarget(isoMovingObject);
            isoZombie.vectorToTarget.x = isoMovingObject.getX();
            isoZombie.vectorToTarget.y = isoMovingObject.getY();
            isoZombie.vectorToTarget.x -= isoZombie.getX();
            isoZombie.vectorToTarget.y -= isoZombie.getY();
            isoZombie.TimeSinceSeenFlesh = 0.0f;
            isoZombie.setThumpTarget(null);
            return true;
        }
        return false;
    }

    public static int getFastForwardDamageMultiplier() {
        GameTime gameTime = GameTime.getInstance();
        if (GameServer.bServer) {
            return (int)(GameServer.bFastForward ? ServerOptions.instance.FastForwardMultiplier.getValue() / (double)gameTime.getDeltaMinutesPerDay() : 1.0);
        }
        if (GameClient.bClient) {
            return (int)(GameClient.bFastForward ? ServerOptions.instance.FastForwardMultiplier.getValue() / (double)gameTime.getDeltaMinutesPerDay() : 1.0);
        }
        if (IsoPlayer.allPlayersAsleep()) {
            return (int)(200.0f * (30.0f / (float)PerformanceSettings.getLockFPS()) / 1.6f);
        }
        return (int)gameTime.getTrueMultiplier();
    }

    private boolean isThumpTargetValid(IsoGameCharacter isoGameCharacter, Thumpable thumpable) {
        IsoChunk isoChunk;
        if (thumpable == null) {
            return false;
        }
        if (thumpable.isDestroyed()) {
            return false;
        }
        IsoObject isoObject = Type.tryCastTo(thumpable, IsoObject.class);
        if (isoObject == null) {
            return false;
        }
        if (thumpable instanceof BaseVehicle) {
            return isoObject.getMovingObjectIndex() != -1;
        }
        if (isoObject.getObjectIndex() == -1) {
            return false;
        }
        int n = isoObject.getSquare().getX() / 10;
        int n2 = isoObject.getSquare().getY() / 10;
        IsoChunk isoChunk2 = isoChunk = GameServer.bServer ? ServerMap.instance.getChunk(n, n2) : IsoWorld.instance.CurrentCell.getChunk(n, n2);
        if (isoChunk == null) {
            return false;
        }
        return thumpable.getThumpableFor(isoGameCharacter) != null;
    }
}

