/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import fmod.fmod.FMODManager;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjglx.input.Keyboard;
import zombie.GameTime;
import zombie.Lua.LuaEventManager;
import zombie.Lua.LuaHookManager;
import zombie.SandboxOptions;
import zombie.ai.State;
import zombie.ai.states.AttackState;
import zombie.ai.states.FakeDeadZombieState;
import zombie.ai.states.ZombieEatBodyState;
import zombie.ai.states.ZombieGetUpState;
import zombie.ai.states.ZombieOnGroundState;
import zombie.audio.parameters.ParameterMeleeHitSurface;
import zombie.characterTextures.BloodBodyPartType;
import zombie.characters.BodyDamage.BodyPartType;
import zombie.characters.Faction;
import zombie.characters.HitReactionNetworkAI;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoLivingCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.characters.Moodles.MoodleType;
import zombie.characters.skills.PerkFactory;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.math.PZMath;
import zombie.core.skinnedmodel.advancedanimation.AnimEvent;
import zombie.core.skinnedmodel.animation.AnimationPlayer;
import zombie.core.skinnedmodel.model.Model;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.debug.DebugType;
import zombie.inventory.InventoryItem;
import zombie.inventory.InventoryItemFactory;
import zombie.inventory.types.Clothing;
import zombie.inventory.types.HandWeapon;
import zombie.inventory.types.WeaponType;
import zombie.iso.IsoCell;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoObject;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.iso.LosUtil;
import zombie.iso.Vector2;
import zombie.iso.Vector3;
import zombie.iso.areas.NonPvpZone;
import zombie.iso.objects.IsoDoor;
import zombie.iso.objects.IsoThumpable;
import zombie.iso.objects.IsoTree;
import zombie.iso.objects.IsoWindow;
import zombie.iso.objects.IsoZombieGiblets;
import zombie.iso.objects.interfaces.Thumpable;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.ServerOptions;
import zombie.network.packets.hit.AttackVars;
import zombie.network.packets.hit.HitInfo;
import zombie.popman.ObjectPool;
import zombie.scripting.objects.VehicleScript;
import zombie.ui.MoodlesUI;
import zombie.ui.UIManager;
import zombie.util.StringUtils;
import zombie.util.Type;
import zombie.vehicles.BaseVehicle;
import zombie.vehicles.PolygonalMap2;
import zombie.vehicles.VehiclePart;
import zombie.vehicles.VehicleWindow;

public final class SwipeStatePlayer
extends State {
    private static final SwipeStatePlayer _instance = new SwipeStatePlayer();
    static final Integer PARAM_LOWER_CONDITION = 0;
    static final Integer PARAM_ATTACKED = 1;
    private static final ArrayList<HitInfo> HitList2 = new ArrayList();
    private static final Vector2 tempVector2_1 = new Vector2();
    private static final Vector2 tempVector2_2 = new Vector2();
    private final ArrayList<Float> dotList = new ArrayList();
    private boolean bHitOnlyTree;
    public final ObjectPool<HitInfo> hitInfoPool = new ObjectPool<HitInfo>(HitInfo::new);
    private static final CustomComparator Comparator = new CustomComparator();
    static final Vector3 tempVector3_1 = new Vector3();
    static final Vector3 tempVector3_2 = new Vector3();
    static final Vector3 tempVectorBonePos = new Vector3();
    static final ArrayList<IsoMovingObject> movingStatic = new ArrayList();
    private final Vector4f tempVector4f = new Vector4f();
    private final WindowVisitor windowVisitor = new WindowVisitor();

    public static SwipeStatePlayer instance() {
        return _instance;
    }

    public static void WeaponLowerCondition(HandWeapon handWeapon, IsoGameCharacter isoGameCharacter) {
        if (handWeapon.getUses() > 1) {
            handWeapon.Use();
            InventoryItem inventoryItem = InventoryItemFactory.CreateItem(handWeapon.getFullType());
            inventoryItem.setCondition(handWeapon.getCondition() - 1);
            handWeapon.getContainer().AddItem(inventoryItem);
            isoGameCharacter.setPrimaryHandItem(inventoryItem);
        } else {
            handWeapon.setCondition(handWeapon.getCondition() - 1);
        }
    }

    private static HandWeapon GetWeapon(IsoGameCharacter isoGameCharacter) {
        HandWeapon handWeapon = isoGameCharacter.getUseHandWeapon();
        if (((IsoLivingCharacter)isoGameCharacter).bDoShove || isoGameCharacter.isForceShove()) {
            handWeapon = ((IsoLivingCharacter)isoGameCharacter).bareHands;
        }
        return handWeapon;
    }

    private void doAttack(IsoPlayer isoPlayer, float f, boolean bl, String string, AttackVars attackVars) {
        isoPlayer.setForceShove(bl);
        isoPlayer.setClickSound(string);
        if (bl) {
            f *= 2.0f;
        }
        if (f > 90.0f) {
            f = 90.0f;
        }
        isoPlayer.useChargeDelta = f /= 25.0f;
        InventoryItem inventoryItem = isoPlayer.getPrimaryHandItem();
        if (inventoryItem == null || !(inventoryItem instanceof HandWeapon) || bl || attackVars.bDoShove) {
            inventoryItem = isoPlayer.bareHands;
        }
        if (inventoryItem instanceof HandWeapon) {
            isoPlayer.setUseHandWeapon((HandWeapon)inventoryItem);
            if (isoPlayer.PlayerIndex == 0 && isoPlayer.JoypadBind == -1 && UIManager.getPicked() != null && (!GameClient.bClient || isoPlayer.isLocalPlayer())) {
                if (UIManager.getPicked().tile instanceof IsoMovingObject) {
                    isoPlayer.setAttackTargetSquare(((IsoMovingObject)UIManager.getPicked().tile).getCurrentSquare());
                } else {
                    isoPlayer.setAttackTargetSquare(UIManager.getPicked().square);
                }
            }
            isoPlayer.setRecoilDelay(attackVars.recoilDelay);
            if (bl) {
                isoPlayer.setRecoilDelay(10.0f);
            }
        }
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        if ("HitReaction".equals(isoGameCharacter.getHitReaction())) {
            isoGameCharacter.clearVariable("HitReaction");
        }
        UIManager.speedControls.SetCurrentGameSpeed(1);
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        hashMap.put(PARAM_LOWER_CONDITION, Boolean.FALSE);
        hashMap.put(PARAM_ATTACKED, Boolean.FALSE);
        if (!(isoGameCharacter instanceof IsoPlayer) || !((IsoPlayer)isoGameCharacter).bRemote) {
            isoGameCharacter.updateRecoilVar();
        }
        if ("Auto".equals(isoGameCharacter.getVariableString("FireMode"))) {
            isoGameCharacter.setVariable("autoShootSpeed", 4.0f * GameTime.getAnimSpeedFix());
            isoGameCharacter.setVariable("autoShootVarY", 0.0f);
            if (System.currentTimeMillis() - isoGameCharacter.lastAutomaticShoot < 600L) {
                ++isoGameCharacter.shootInARow;
                float f = Math.max(0.0f, 1.0f - (float)isoGameCharacter.shootInARow / 20.0f);
                isoGameCharacter.setVariable("autoShootVarX", f);
            } else {
                isoGameCharacter.setVariable("autoShootVarX", 1.0f);
                isoGameCharacter.shootInARow = 0;
            }
            isoGameCharacter.lastAutomaticShoot = System.currentTimeMillis();
        }
        IsoPlayer isoPlayer = (IsoPlayer)isoGameCharacter;
        isoGameCharacter.setVariable("ShotDone", false);
        isoGameCharacter.setVariable("ShoveAnim", false);
        this.CalcAttackVars((IsoLivingCharacter)isoGameCharacter, isoPlayer.attackVars);
        this.doAttack(isoPlayer, 2.0f, isoGameCharacter.isForceShove(), isoGameCharacter.getClickSound(), isoPlayer.attackVars);
        HandWeapon handWeapon = isoGameCharacter.getUseHandWeapon();
        if (!GameClient.bClient || isoPlayer.isLocalPlayer()) {
            isoGameCharacter.setVariable("AimFloorAnim", isoPlayer.attackVars.bAimAtFloor);
        }
        LuaEventManager.triggerEvent("OnWeaponSwing", isoGameCharacter, handWeapon);
        if (LuaHookManager.TriggerHook("WeaponSwing", isoGameCharacter, handWeapon)) {
            isoGameCharacter.getStateMachine().revertToPreviousState(this);
        }
        isoGameCharacter.StopAllActionQueue();
        if (((IsoPlayer)isoGameCharacter).isLocalPlayer()) {
            IsoWorld.instance.CurrentCell.setDrag(null, ((IsoPlayer)isoGameCharacter).PlayerIndex);
        }
        handWeapon = isoPlayer.attackVars.getWeapon(isoPlayer);
        isoPlayer.setAimAtFloor(isoPlayer.attackVars.bAimAtFloor);
        boolean bl = isoPlayer.bDoShove;
        isoPlayer.setDoShove(isoPlayer.attackVars.bDoShove);
        isoPlayer.useChargeDelta = isoPlayer.attackVars.useChargeDelta;
        isoPlayer.targetOnGround = (IsoGameCharacter)isoPlayer.attackVars.targetOnGround.getMovingObject();
        if (isoPlayer.bDoShove || bl || isoPlayer.getClickSound() != null || handWeapon.getPhysicsObject() != null || !handWeapon.isRanged()) {
            // empty if block
        }
        if (GameClient.bClient && isoGameCharacter == IsoPlayer.getInstance()) {
            GameClient.instance.sendPlayer((IsoPlayer)isoGameCharacter);
        }
        if (!isoPlayer.bDoShove && !bl && !handWeapon.isRanged() && isoPlayer.isLocalPlayer()) {
            isoGameCharacter.clearVariable("PlayedSwingSound");
        } else if ((isoPlayer.bDoShove || bl) && isoPlayer.isLocalPlayer()) {
            if (isoPlayer.targetOnGround != null) {
                isoGameCharacter.playSound("AttackStomp");
            } else {
                isoGameCharacter.playSound("AttackShove");
            }
        }
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
        isoGameCharacter.StopAllActionQueue();
    }

    private int DoSwingCollisionBoneCheck(IsoGameCharacter isoGameCharacter, HandWeapon handWeapon, IsoGameCharacter isoGameCharacter2, int n, float f) {
        movingStatic.clear();
        IsoGameCharacter isoGameCharacter3 = isoGameCharacter2;
        int n2 = n;
        float f2 = handWeapon.WeaponLength;
        f2 += 0.5f;
        if (isoGameCharacter.isAimAtFloor() && ((IsoLivingCharacter)isoGameCharacter).bDoShove) {
            f2 = 0.3f;
        }
        Model.BoneToWorldCoords(isoGameCharacter3, n2, tempVectorBonePos);
        for (int i = 1; i <= 10; ++i) {
            boolean bl;
            float f3 = (float)i / 10.0f;
            SwipeStatePlayer.tempVector3_1.x = isoGameCharacter.x;
            SwipeStatePlayer.tempVector3_1.y = isoGameCharacter.y;
            SwipeStatePlayer.tempVector3_1.z = isoGameCharacter.z;
            SwipeStatePlayer.tempVector3_1.x += isoGameCharacter.getForwardDirection().x * f2 * f3;
            SwipeStatePlayer.tempVector3_1.y += isoGameCharacter.getForwardDirection().y * f2 * f3;
            SwipeStatePlayer.tempVector3_1.x = SwipeStatePlayer.tempVectorBonePos.x - SwipeStatePlayer.tempVector3_1.x;
            SwipeStatePlayer.tempVector3_1.y = SwipeStatePlayer.tempVectorBonePos.y - SwipeStatePlayer.tempVector3_1.y;
            SwipeStatePlayer.tempVector3_1.z = 0.0f;
            boolean bl2 = bl = tempVector3_1.getLength() < f;
            if (!bl) continue;
            return n2;
        }
        return -1;
    }

    @Override
    public void animEvent(IsoGameCharacter isoGameCharacter, AnimEvent animEvent) {
        Object object;
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        if (animEvent.m_EventName.equalsIgnoreCase("ActiveAnimFinishing") || animEvent.m_EventName.equalsIgnoreCase("NonLoopedAnimFadeOut")) {
            boolean bl;
            boolean bl2 = bl = hashMap.get(PARAM_LOWER_CONDITION) == Boolean.TRUE;
            if (bl && !isoGameCharacter.isRangedWeaponEmpty()) {
                hashMap.put(PARAM_LOWER_CONDITION, Boolean.FALSE);
                object = SwipeStatePlayer.GetWeapon(isoGameCharacter);
                int n = ((HandWeapon)object).getConditionLowerChance();
                if (isoGameCharacter instanceof IsoPlayer && "charge".equals(((IsoPlayer)isoGameCharacter).getAttackType())) {
                    n = (int)((double)n / 1.5);
                }
                if (Rand.Next(n + isoGameCharacter.getMaintenanceMod() * 2) == 0) {
                    SwipeStatePlayer.WeaponLowerCondition((HandWeapon)object, isoGameCharacter);
                } else if (Rand.NextBool(2) && !((HandWeapon)object).isRanged() && WeaponType.getWeaponType(isoGameCharacter) != WeaponType.barehand) {
                    if (((InventoryItem)object).isTwoHandWeapon() && (isoGameCharacter.getPrimaryHandItem() != object || isoGameCharacter.getSecondaryHandItem() != object) && Rand.NextBool(3)) {
                        return;
                    }
                    isoGameCharacter.getXp().AddXP(PerkFactory.Perks.Maintenance, 1.0f);
                }
            }
        }
        if (animEvent.m_EventName.equalsIgnoreCase("AttackAnim")) {
            isoGameCharacter.setAttackAnim(Boolean.parseBoolean(animEvent.m_ParameterValue));
        }
        if (animEvent.m_EventName.equalsIgnoreCase("BlockTurn")) {
            isoGameCharacter.setIgnoreMovement(Boolean.parseBoolean(animEvent.m_ParameterValue));
        }
        if (animEvent.m_EventName.equalsIgnoreCase("ShoveAnim")) {
            isoGameCharacter.setVariable("ShoveAnim", Boolean.parseBoolean(animEvent.m_ParameterValue));
        }
        if (animEvent.m_EventName.equalsIgnoreCase("StompAnim")) {
            isoGameCharacter.setVariable("StompAnim", Boolean.parseBoolean(animEvent.m_ParameterValue));
        }
        HandWeapon handWeapon = SwipeStatePlayer.GetWeapon(isoGameCharacter);
        if (animEvent.m_EventName.equalsIgnoreCase("AttackCollisionCheck") && hashMap.get(PARAM_ATTACKED) == Boolean.FALSE && isoGameCharacter instanceof IsoPlayer && ((IsoPlayer)isoGameCharacter).isLocalPlayer()) {
            this.ConnectSwing(isoGameCharacter, handWeapon);
        }
        if (animEvent.m_EventName.equalsIgnoreCase("BlockMovement") && SandboxOptions.instance.AttackBlockMovements.getValue()) {
            isoGameCharacter.setVariable("SlowingMovement", Boolean.parseBoolean(animEvent.m_ParameterValue));
        }
        if (animEvent.m_EventName.equalsIgnoreCase("WeaponEmptyCheck") && isoGameCharacter.getClickSound() != null) {
            if (isoGameCharacter instanceof IsoPlayer && !((IsoPlayer)isoGameCharacter).isLocalPlayer()) {
                return;
            }
            isoGameCharacter.playSound(isoGameCharacter.getClickSound());
            isoGameCharacter.setRecoilDelay(10.0f);
        }
        if (animEvent.m_EventName.equalsIgnoreCase("ShotDone") && handWeapon != null && handWeapon.isRackAfterShoot()) {
            isoGameCharacter.setVariable("ShotDone", true);
        }
        if (animEvent.m_EventName.equalsIgnoreCase("SetVariable") && animEvent.m_ParameterValue.startsWith("ShotDone=")) {
            isoGameCharacter.setVariable("ShotDone", isoGameCharacter.getVariableBoolean("ShotDone") && handWeapon != null && handWeapon.isRackAfterShoot());
        }
        if (animEvent.m_EventName.equalsIgnoreCase("playRackSound")) {
            if (isoGameCharacter instanceof IsoPlayer && !((IsoPlayer)isoGameCharacter).isLocalPlayer()) {
                return;
            }
            isoGameCharacter.playSound(handWeapon.getRackSound());
        }
        if (animEvent.m_EventName.equalsIgnoreCase("playClickSound")) {
            if (isoGameCharacter instanceof IsoPlayer && !((IsoPlayer)isoGameCharacter).isLocalPlayer()) {
                return;
            }
            isoGameCharacter.playSound(handWeapon.getClickSound());
        }
        if (animEvent.m_EventName.equalsIgnoreCase("PlaySwingSound")) {
            if (isoGameCharacter instanceof IsoPlayer && !((IsoPlayer)isoGameCharacter).isLocalPlayer()) {
                return;
            }
            if (handWeapon == null) {
                return;
            }
            if (isoGameCharacter.getVariableBoolean("PlayedSwingSound")) {
                return;
            }
            isoGameCharacter.setVariable("PlayedSwingSound", true);
            if (!StringUtils.isNullOrWhitespace(animEvent.m_ParameterValue) && (object = handWeapon.getSoundByID(animEvent.m_ParameterValue)) != null) {
                isoGameCharacter.playSound((String)object);
                return;
            }
            isoGameCharacter.playSound(handWeapon.getSwingSound());
        }
        if (animEvent.m_EventName.equalsIgnoreCase("SetMeleeDelay")) {
            isoGameCharacter.setMeleeDelay(PZMath.tryParseFloat(animEvent.m_ParameterValue, 0.0f));
        }
        if (animEvent.m_EventName.equalsIgnoreCase("SitGroundStarted")) {
            isoGameCharacter.setVariable("SitGroundAnim", "Idle");
        }
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
        int n;
        InventoryItem inventoryItem;
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        isoGameCharacter.setSprinting(false);
        ((IsoPlayer)isoGameCharacter).setForceSprint(false);
        isoGameCharacter.setIgnoreMovement(false);
        isoGameCharacter.setVariable("ShoveAnim", false);
        isoGameCharacter.setVariable("StompAnim", false);
        isoGameCharacter.setAttackAnim(false);
        isoGameCharacter.setVariable("AimFloorAnim", false);
        ((IsoPlayer)isoGameCharacter).setBlockMovement(false);
        if (isoGameCharacter.isAimAtFloor() && ((IsoLivingCharacter)isoGameCharacter).bDoShove) {
            inventoryItem = (Clothing)isoGameCharacter.getWornItem("Shoes");
            n = 10;
            if (inventoryItem == null) {
                n = 3;
            } else {
                n += ((Clothing)inventoryItem).getConditionLowerChance() / 2;
                if (Rand.Next(((Clothing)inventoryItem).getConditionLowerChance()) == 0) {
                    ((Clothing)inventoryItem).setCondition(inventoryItem.getCondition() - 1);
                }
            }
            if (Rand.Next(n) == 0) {
                if (inventoryItem == null) {
                    isoGameCharacter.getBodyDamage().getBodyPart(BodyPartType.Foot_R).AddDamage(Rand.Next(5, 10));
                    isoGameCharacter.getBodyDamage().getBodyPart(BodyPartType.Foot_R).setAdditionalPain(isoGameCharacter.getBodyDamage().getBodyPart(BodyPartType.Foot_R).getAdditionalPain() + (float)Rand.Next(5, 10));
                } else {
                    isoGameCharacter.getBodyDamage().getBodyPart(BodyPartType.Foot_R).AddDamage(Rand.Next(1, 5));
                    isoGameCharacter.getBodyDamage().getBodyPart(BodyPartType.Foot_R).setAdditionalPain(isoGameCharacter.getBodyDamage().getBodyPart(BodyPartType.Foot_R).getAdditionalPain() + (float)Rand.Next(1, 5));
                }
            }
        }
        inventoryItem = SwipeStatePlayer.GetWeapon(isoGameCharacter);
        isoGameCharacter.clearVariable("ZombieHitReaction");
        ((IsoPlayer)isoGameCharacter).attackStarted = false;
        ((IsoPlayer)isoGameCharacter).setAttackType(null);
        ((IsoLivingCharacter)isoGameCharacter).setDoShove(false);
        isoGameCharacter.clearVariable("RackWeapon");
        isoGameCharacter.clearVariable("bShoveAiming");
        isoGameCharacter.clearVariable("PlayedSwingSound");
        int n2 = n = hashMap.get(PARAM_ATTACKED) == Boolean.TRUE ? 1 : 0;
        if (inventoryItem != null && (inventoryItem.getCondition() <= 0 || n != 0 && ((HandWeapon)inventoryItem).isUseSelf())) {
            isoGameCharacter.removeFromHands(inventoryItem);
            if (DebugOptions.instance.MultiplayerAutoEquip.getValue() && ((HandWeapon)inventoryItem).getPhysicsObject() != null) {
                isoGameCharacter.setPrimaryHandItem(isoGameCharacter.getInventory().getItemFromType(inventoryItem.getType()));
            }
            isoGameCharacter.getInventory().setDrawDirty(true);
        }
        if (isoGameCharacter.isRangedWeaponEmpty()) {
            isoGameCharacter.setRecoilDelay(10.0f);
        }
        isoGameCharacter.setRangedWeaponEmpty(false);
        isoGameCharacter.setForceShove(false);
        isoGameCharacter.setClickSound(null);
        if (n != 0) {
            LuaEventManager.triggerEvent("OnPlayerAttackFinished", isoGameCharacter, inventoryItem);
        }
        isoGameCharacter.hitList.clear();
        isoGameCharacter.attackVars.clear();
    }

    public void CalcAttackVars(IsoLivingCharacter isoLivingCharacter, AttackVars attackVars) {
        HitInfo hitInfo;
        InventoryItem inventoryItem;
        HandWeapon handWeapon = Type.tryCastTo(isoLivingCharacter.getPrimaryHandItem(), HandWeapon.class);
        if (!(handWeapon == null || handWeapon.getOtherHandRequire() == null || (inventoryItem = isoLivingCharacter.getSecondaryHandItem()) != null && inventoryItem.getType().equals(handWeapon.getOtherHandRequire()))) {
            handWeapon = null;
        }
        if (GameClient.bClient && !isoLivingCharacter.isLocal()) {
            return;
        }
        boolean bl = isoLivingCharacter.isAttackAnim() || isoLivingCharacter.getVariableBoolean("ShoveAnim") || isoLivingCharacter.getVariableBoolean("StompAnim");
        attackVars.setWeapon(handWeapon == null ? isoLivingCharacter.bareHands : handWeapon);
        attackVars.targetOnGround.setMovingObject(null);
        attackVars.bAimAtFloor = false;
        attackVars.bCloseKill = false;
        attackVars.bDoShove = isoLivingCharacter.bDoShove;
        if (!bl) {
            isoLivingCharacter.setVariable("ShoveAimX", 0.5f);
            isoLivingCharacter.setVariable("ShoveAimY", 1.0f);
            if (attackVars.bDoShove && isoLivingCharacter.getVariableBoolean("isMoving")) {
                isoLivingCharacter.setVariable("ShoveAim", true);
            } else {
                isoLivingCharacter.setVariable("ShoveAim", false);
            }
        }
        attackVars.useChargeDelta = isoLivingCharacter.useChargeDelta;
        attackVars.recoilDelay = 0;
        if (attackVars.getWeapon(isoLivingCharacter) == isoLivingCharacter.bareHands || attackVars.bDoShove || isoLivingCharacter.isForceShove()) {
            attackVars.bDoShove = true;
            attackVars.bAimAtFloor = false;
            attackVars.setWeapon(isoLivingCharacter.bareHands);
        }
        this.calcValidTargets(isoLivingCharacter, attackVars.getWeapon(isoLivingCharacter), true, attackVars.targetsProne, attackVars.targetsStanding);
        HitInfo hitInfo2 = attackVars.targetsStanding.isEmpty() ? null : attackVars.targetsStanding.get(0);
        HitInfo hitInfo3 = hitInfo = attackVars.targetsProne.isEmpty() ? null : attackVars.targetsProne.get(0);
        if (this.isProneTargetBetter(isoLivingCharacter, hitInfo2, hitInfo)) {
            hitInfo2 = null;
        }
        if (!bl) {
            isoLivingCharacter.setAimAtFloor(false);
        }
        float f = Float.MAX_VALUE;
        if (hitInfo2 != null) {
            if (!bl) {
                isoLivingCharacter.setAimAtFloor(false);
            }
            attackVars.bAimAtFloor = false;
            attackVars.targetOnGround.setMovingObject(null);
            f = hitInfo2.distSq;
        } else if (hitInfo != null && (Core.OptionAutoProneAtk || isoLivingCharacter.bDoShove)) {
            if (!bl) {
                isoLivingCharacter.setAimAtFloor(true);
            }
            attackVars.bAimAtFloor = true;
            attackVars.targetOnGround.setMovingObject(hitInfo.getObject());
        }
        if (!(f >= attackVars.getWeapon(isoLivingCharacter).getMinRange() * attackVars.getWeapon(isoLivingCharacter).getMinRange() || hitInfo2 != null && this.isWindowBetween(isoLivingCharacter, hitInfo2.getObject()))) {
            if (isoLivingCharacter.getStats().NumChasingZombies <= 1 && WeaponType.getWeaponType(isoLivingCharacter) == WeaponType.knife) {
                attackVars.bCloseKill = true;
                return;
            }
            attackVars.bDoShove = true;
            IsoPlayer isoPlayer = Type.tryCastTo(isoLivingCharacter, IsoPlayer.class);
            if (isoPlayer != null && !isoPlayer.isAuthorizeShoveStomp()) {
                attackVars.bDoShove = false;
            }
            attackVars.bAimAtFloor = false;
            if (isoLivingCharacter.bareHands.getSwingAnim() != null) {
                attackVars.useChargeDelta = 3.0f;
            }
        }
        int n = Core.getInstance().getKey("ManualFloorAtk");
        int n2 = Core.getInstance().getKey("Sprint");
        boolean bl2 = isoLivingCharacter.getVariableBoolean("StartedAttackWhileSprinting");
        if (Keyboard.isKeyDown(n) && (n != n2 || !bl2)) {
            attackVars.bAimAtFloor = true;
            attackVars.bDoShove = false;
            isoLivingCharacter.setDoShove(false);
        }
        if (attackVars.getWeapon(isoLivingCharacter).isRanged()) {
            int n3 = attackVars.getWeapon(isoLivingCharacter).getRecoilDelay();
            Float f2 = Float.valueOf((float)n3 * (1.0f - (float)isoLivingCharacter.getPerkLevel(PerkFactory.Perks.Aiming) / 30.0f));
            attackVars.recoilDelay = f2.intValue();
            isoLivingCharacter.setVariable("singleShootSpeed", (0.8f + (float)isoLivingCharacter.getPerkLevel(PerkFactory.Perks.Aiming) / 10.0f) * GameTime.getAnimSpeedFix());
        }
    }

    public void calcValidTargets(IsoLivingCharacter isoLivingCharacter, HandWeapon handWeapon, boolean bl, ArrayList<HitInfo> arrayList, ArrayList<HitInfo> arrayList2) {
        this.hitInfoPool.release((List<HitInfo>)arrayList);
        this.hitInfoPool.release((List<HitInfo>)arrayList2);
        arrayList.clear();
        arrayList2.clear();
        float f = Core.getInstance().getIgnoreProneZombieRange();
        float f2 = handWeapon.getMaxRange() * handWeapon.getRangeMod(isoLivingCharacter);
        float f3 = Math.max(f, f2 + (bl ? 1.0f : 0.0f));
        ArrayList<IsoMovingObject> arrayList3 = IsoWorld.instance.CurrentCell.getObjectList();
        for (int i = 0; i < arrayList3.size(); ++i) {
            IsoMovingObject isoMovingObject = arrayList3.get(i);
            HitInfo hitInfo = this.calcValidTarget(isoLivingCharacter, handWeapon, isoMovingObject, f3);
            if (hitInfo == null) continue;
            if (SwipeStatePlayer.isStanding(isoMovingObject)) {
                arrayList2.add(hitInfo);
                continue;
            }
            arrayList.add(hitInfo);
        }
        if (!arrayList.isEmpty() && this.shouldIgnoreProneZombies(isoLivingCharacter, arrayList2, f)) {
            this.hitInfoPool.release((List<HitInfo>)arrayList);
            arrayList.clear();
        }
        float f4 = handWeapon.getMinAngle();
        float f5 = handWeapon.getMaxAngle();
        if (handWeapon.isRanged()) {
            f4 -= handWeapon.getAimingPerkMinAngleModifier() * ((float)isoLivingCharacter.getPerkLevel(PerkFactory.Perks.Aiming) / 2.0f);
        }
        this.removeUnhittableTargets(isoLivingCharacter, handWeapon, f4, f5, bl, arrayList2);
        f4 = handWeapon.getMinAngle();
        f4 = (float)((double)f4 / 1.5);
        this.removeUnhittableTargets(isoLivingCharacter, handWeapon, f4, f5, bl, arrayList);
        arrayList2.sort(Comparator);
        arrayList.sort(Comparator);
    }

    private boolean shouldIgnoreProneZombies(IsoGameCharacter isoGameCharacter, ArrayList<HitInfo> arrayList, float f) {
        if (f <= 0.0f) {
            return false;
        }
        boolean bl = isoGameCharacter.isInvisible() || isoGameCharacter instanceof IsoPlayer && ((IsoPlayer)isoGameCharacter).isGhostMode();
        for (int i = 0; i < arrayList.size(); ++i) {
            boolean bl2;
            HitInfo hitInfo = arrayList.get(i);
            IsoZombie isoZombie = Type.tryCastTo(hitInfo.getObject(), IsoZombie.class);
            if (isoZombie != null && isoZombie.target == null && !bl || hitInfo.distSq > f * f || (bl2 = PolygonalMap2.instance.lineClearCollide(isoGameCharacter.x, isoGameCharacter.y, hitInfo.getObject().x, hitInfo.getObject().y, (int)isoGameCharacter.z, isoGameCharacter, false, true))) continue;
            return true;
        }
        return false;
    }

    private boolean isUnhittableTarget(IsoGameCharacter isoGameCharacter, HandWeapon handWeapon, float f, float f2, HitInfo hitInfo, boolean bl) {
        if (hitInfo.dot < f || hitInfo.dot > f2) {
            return true;
        }
        Vector3 vector3 = tempVectorBonePos.set(hitInfo.x, hitInfo.y, hitInfo.z);
        return !isoGameCharacter.IsAttackRange(handWeapon, hitInfo.getObject(), vector3, bl);
    }

    private void removeUnhittableTargets(IsoGameCharacter isoGameCharacter, HandWeapon handWeapon, float f, float f2, boolean bl, ArrayList<HitInfo> arrayList) {
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            HitInfo hitInfo = arrayList.get(i);
            if (!this.isUnhittableTarget(isoGameCharacter, handWeapon, f, f2, hitInfo, bl)) continue;
            this.hitInfoPool.release(hitInfo);
            arrayList.remove(i);
        }
    }

    private boolean getNearestTargetPosAndDot(IsoGameCharacter isoGameCharacter, HandWeapon handWeapon, IsoMovingObject isoMovingObject, boolean bl, Vector4f vector4f) {
        this.getNearestTargetPosAndDot(isoGameCharacter, isoMovingObject, vector4f);
        float f = vector4f.w;
        float f2 = handWeapon.getMinAngle();
        float f3 = handWeapon.getMaxAngle();
        IsoGameCharacter isoGameCharacter2 = Type.tryCastTo(isoMovingObject, IsoGameCharacter.class);
        if (isoGameCharacter2 != null) {
            if (SwipeStatePlayer.isStanding(isoMovingObject)) {
                if (handWeapon.isRanged()) {
                    f2 -= handWeapon.getAimingPerkMinAngleModifier() * ((float)isoGameCharacter.getPerkLevel(PerkFactory.Perks.Aiming) / 2.0f);
                }
            } else {
                f2 /= 1.5f;
            }
        }
        if (f < f2 || f > f3) {
            return false;
        }
        Vector3 vector3 = tempVectorBonePos.set(vector4f.x, vector4f.y, vector4f.z);
        return isoGameCharacter.IsAttackRange(handWeapon, isoMovingObject, vector3, bl);
    }

    private void getNearestTargetPosAndDot(IsoGameCharacter isoGameCharacter, Vector3 vector3, Vector2 vector22, Vector4f vector4f) {
        float f = isoGameCharacter.getDotWithForwardDirection(vector3);
        f = PZMath.clamp(f, -1.0f, 1.0f);
        vector4f.w = Math.max(f, vector4f.w);
        float f2 = IsoUtils.DistanceToSquared(isoGameCharacter.x, isoGameCharacter.y, (int)isoGameCharacter.z * 3, vector3.x, vector3.y, (int)Math.max(vector3.z, 0.0f) * 3);
        if (f2 < vector22.x) {
            vector22.x = f2;
            vector4f.set(vector3.x, vector3.y, vector3.z, vector4f.w);
        }
    }

    private void getNearestTargetPosAndDot(IsoGameCharacter isoGameCharacter, IsoMovingObject isoMovingObject, String string, Vector2 vector22, Vector4f vector4f) {
        Vector3 vector3 = SwipeStatePlayer.getBoneWorldPos(isoMovingObject, string, tempVectorBonePos);
        this.getNearestTargetPosAndDot(isoGameCharacter, vector3, vector22, vector4f);
    }

    private void getNearestTargetPosAndDot(IsoGameCharacter isoGameCharacter, IsoMovingObject isoMovingObject, Vector4f vector4f) {
        Vector2 vector22 = tempVector2_1.set(Float.MAX_VALUE, Float.NaN);
        vector4f.w = Float.NEGATIVE_INFINITY;
        IsoGameCharacter isoGameCharacter2 = Type.tryCastTo(isoMovingObject, IsoGameCharacter.class);
        if (isoGameCharacter2 == null) {
            this.getNearestTargetPosAndDot(isoGameCharacter, isoMovingObject, (String)null, vector22, vector4f);
            return;
        }
        SwipeStatePlayer.getBoneWorldPos(isoMovingObject, "Bip01_Head", tempVector3_1);
        SwipeStatePlayer.getBoneWorldPos(isoMovingObject, "Bip01_HeadNub", tempVector3_2);
        tempVector3_1.addToThis(tempVector3_2);
        tempVector3_1.div(2.0f);
        Vector3 vector3 = tempVector3_1;
        if (SwipeStatePlayer.isStanding(isoMovingObject)) {
            this.getNearestTargetPosAndDot(isoGameCharacter, vector3, vector22, vector4f);
            this.getNearestTargetPosAndDot(isoGameCharacter, isoMovingObject, "Bip01_Pelvis", vector22, vector4f);
            Vector3 vector32 = tempVectorBonePos.set(isoMovingObject.getX(), isoMovingObject.getY(), isoMovingObject.getZ());
            this.getNearestTargetPosAndDot(isoGameCharacter, vector32, vector22, vector4f);
        } else {
            this.getNearestTargetPosAndDot(isoGameCharacter, vector3, vector22, vector4f);
            this.getNearestTargetPosAndDot(isoGameCharacter, isoMovingObject, "Bip01_Pelvis", vector22, vector4f);
            this.getNearestTargetPosAndDot(isoGameCharacter, isoMovingObject, "Bip01_DressFrontNub", vector22, vector4f);
        }
    }

    private HitInfo calcValidTarget(IsoLivingCharacter isoLivingCharacter, HandWeapon handWeapon, IsoMovingObject isoMovingObject, float f) {
        if (isoMovingObject == isoLivingCharacter) {
            return null;
        }
        IsoGameCharacter isoGameCharacter = Type.tryCastTo(isoMovingObject, IsoGameCharacter.class);
        if (isoGameCharacter == null) {
            return null;
        }
        if (isoGameCharacter.isGodMod()) {
            return null;
        }
        if (!SwipeStatePlayer.checkPVP(isoLivingCharacter, isoMovingObject)) {
            return null;
        }
        float f2 = Math.abs(isoGameCharacter.getZ() - isoLivingCharacter.getZ());
        if (!handWeapon.isRanged() && f2 >= 0.5f) {
            return null;
        }
        if (f2 > 3.3f) {
            return null;
        }
        if (!isoGameCharacter.isShootable()) {
            return null;
        }
        if (isoGameCharacter.isCurrentState(FakeDeadZombieState.instance())) {
            return null;
        }
        if (isoGameCharacter.isDead()) {
            return null;
        }
        if (isoGameCharacter.getHitReaction() != null && isoGameCharacter.getHitReaction().contains("Death")) {
            return null;
        }
        Vector4f vector4f = this.tempVector4f;
        this.getNearestTargetPosAndDot(isoLivingCharacter, isoGameCharacter, vector4f);
        float f3 = vector4f.w;
        float f4 = IsoUtils.DistanceToSquared(isoLivingCharacter.x, isoLivingCharacter.y, (int)isoLivingCharacter.z * 3, vector4f.x, vector4f.y, (int)vector4f.z * 3);
        if (f3 < 0.0f) {
            return null;
        }
        if (f4 > f * f) {
            return null;
        }
        LosUtil.TestResults testResults = LosUtil.lineClear(isoLivingCharacter.getCell(), (int)isoLivingCharacter.getX(), (int)isoLivingCharacter.getY(), (int)isoLivingCharacter.getZ(), (int)isoGameCharacter.getX(), (int)isoGameCharacter.getY(), (int)isoGameCharacter.getZ(), false);
        if (testResults == LosUtil.TestResults.Blocked || testResults == LosUtil.TestResults.ClearThroughClosedDoor) {
            return null;
        }
        return this.hitInfoPool.alloc().init(isoGameCharacter, f3, f4, vector4f.x, vector4f.y, vector4f.z);
    }

    public static boolean isProne(IsoMovingObject isoMovingObject) {
        IsoZombie isoZombie = Type.tryCastTo(isoMovingObject, IsoZombie.class);
        if (isoZombie == null) {
            return isoMovingObject.isOnFloor();
        }
        if (isoZombie.isOnFloor()) {
            return true;
        }
        if (isoZombie.isCurrentState(ZombieEatBodyState.instance())) {
            return true;
        }
        if (isoZombie.isDead()) {
            return true;
        }
        if (isoZombie.isSitAgainstWall()) {
            return true;
        }
        return isoZombie.isCrawling();
    }

    public static boolean isStanding(IsoMovingObject isoMovingObject) {
        return !SwipeStatePlayer.isProne(isoMovingObject);
    }

    public boolean isProneTargetBetter(IsoGameCharacter isoGameCharacter, HitInfo hitInfo, HitInfo hitInfo2) {
        if (hitInfo == null || hitInfo.getObject() == null) {
            return false;
        }
        if (hitInfo2 == null || hitInfo2.getObject() == null) {
            return false;
        }
        if (hitInfo.distSq <= hitInfo2.distSq) {
            return false;
        }
        boolean bl = PolygonalMap2.instance.lineClearCollide(isoGameCharacter.x, isoGameCharacter.y, hitInfo.getObject().x, hitInfo.getObject().y, (int)isoGameCharacter.z, null, false, true);
        if (!bl) {
            return false;
        }
        boolean bl2 = PolygonalMap2.instance.lineClearCollide(isoGameCharacter.x, isoGameCharacter.y, hitInfo2.getObject().x, hitInfo2.getObject().y, (int)isoGameCharacter.z, null, false, true);
        return !bl2;
    }

    public static boolean checkPVP(IsoGameCharacter isoGameCharacter, IsoMovingObject isoMovingObject) {
        IsoPlayer isoPlayer = Type.tryCastTo(isoGameCharacter, IsoPlayer.class);
        IsoPlayer isoPlayer2 = Type.tryCastTo(isoMovingObject, IsoPlayer.class);
        if (GameClient.bClient && isoPlayer2 != null && isoGameCharacter != null) {
            if (isoPlayer2.isGodMod() || !ServerOptions.instance.PVP.getValue() || ServerOptions.instance.SafetySystem.getValue() && isoGameCharacter.getSafety().isEnabled() && ((IsoGameCharacter)isoMovingObject).getSafety().isEnabled()) {
                return false;
            }
            if (NonPvpZone.getNonPvpZone((int)isoMovingObject.getX(), (int)isoMovingObject.getY()) != null) {
                return false;
            }
            if (isoPlayer != null && NonPvpZone.getNonPvpZone((int)isoGameCharacter.getX(), (int)isoGameCharacter.getY()) != null) {
                return false;
            }
            if (isoPlayer != null && !isoPlayer.factionPvp && !isoPlayer2.factionPvp) {
                Faction faction = Faction.getPlayerFaction(isoPlayer);
                Faction faction2 = Faction.getPlayerFaction(isoPlayer2);
                if (faction2 != null && faction == faction2) {
                    return false;
                }
            }
        }
        return GameClient.bClient || isoPlayer2 == null || IsoPlayer.getCoopPVP();
    }

    private void CalcHitListShove(IsoGameCharacter isoGameCharacter, boolean bl, AttackVars attackVars, ArrayList<HitInfo> arrayList) {
        HandWeapon handWeapon = attackVars.getWeapon((IsoLivingCharacter)isoGameCharacter);
        ArrayList<IsoMovingObject> arrayList2 = IsoWorld.instance.CurrentCell.getObjectList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            Vector4f vector4f;
            boolean bl2;
            IsoZombie isoZombie;
            IsoGameCharacter isoGameCharacter2;
            IsoMovingObject isoMovingObject = arrayList2.get(i);
            if (isoMovingObject == isoGameCharacter || isoMovingObject instanceof BaseVehicle || (isoGameCharacter2 = Type.tryCastTo(isoMovingObject, IsoGameCharacter.class)) == null || isoGameCharacter2.isGodMod() || isoGameCharacter2.isDead() || (isoZombie = Type.tryCastTo(isoMovingObject, IsoZombie.class)) != null && isoZombie.isCurrentState(FakeDeadZombieState.instance()) || !SwipeStatePlayer.checkPVP(isoGameCharacter, isoMovingObject)) continue;
            boolean bl3 = bl2 = isoMovingObject == attackVars.targetOnGround.getMovingObject() || isoMovingObject.isShootable() && SwipeStatePlayer.isStanding(isoMovingObject) && !attackVars.bAimAtFloor || isoMovingObject.isShootable() && SwipeStatePlayer.isProne(isoMovingObject) && attackVars.bAimAtFloor;
            if (!bl2 || !this.getNearestTargetPosAndDot(isoGameCharacter, handWeapon, isoMovingObject, bl, vector4f = this.tempVector4f)) continue;
            float f = vector4f.w;
            float f2 = IsoUtils.DistanceToSquared(isoGameCharacter.x, isoGameCharacter.y, (int)isoGameCharacter.z * 3, vector4f.x, vector4f.y, (int)vector4f.z * 3);
            LosUtil.TestResults testResults = LosUtil.lineClear(isoGameCharacter.getCell(), (int)isoGameCharacter.getX(), (int)isoGameCharacter.getY(), (int)isoGameCharacter.getZ(), (int)isoMovingObject.getX(), (int)isoMovingObject.getY(), (int)isoMovingObject.getZ(), false);
            if (testResults == LosUtil.TestResults.Blocked || testResults == LosUtil.TestResults.ClearThroughClosedDoor || isoMovingObject.getCurrentSquare() != null && isoGameCharacter.getCurrentSquare() != null && isoMovingObject.getCurrentSquare() != isoGameCharacter.getCurrentSquare() && isoMovingObject.getCurrentSquare().isWindowBlockedTo(isoGameCharacter.getCurrentSquare()) || isoMovingObject.getSquare().getTransparentWallTo(isoGameCharacter.getSquare()) != null) continue;
            HitInfo hitInfo = this.hitInfoPool.alloc().init(isoMovingObject, f, f2, vector4f.x, vector4f.y, vector4f.z);
            if (attackVars.targetOnGround.getMovingObject() == isoMovingObject) {
                arrayList.clear();
                arrayList.add(hitInfo);
                break;
            }
            arrayList.add(hitInfo);
        }
    }

    private void CalcHitListWeapon(IsoGameCharacter isoGameCharacter, boolean bl, AttackVars attackVars, ArrayList<HitInfo> arrayList) {
        HandWeapon handWeapon = attackVars.getWeapon((IsoLivingCharacter)isoGameCharacter);
        ArrayList<IsoMovingObject> arrayList2 = IsoWorld.instance.CurrentCell.getObjectList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            IsoWindow isoWindow;
            float f;
            Object object;
            boolean bl2;
            IsoZombie isoZombie;
            IsoGameCharacter isoGameCharacter2;
            IsoMovingObject isoMovingObject = arrayList2.get(i);
            if (isoMovingObject == isoGameCharacter || (isoGameCharacter2 = Type.tryCastTo(isoMovingObject, IsoGameCharacter.class)) != null && isoGameCharacter2.isGodMod() || isoGameCharacter2 != null && isoGameCharacter2.isDead() || (isoZombie = Type.tryCastTo(isoMovingObject, IsoZombie.class)) != null && isoZombie.isCurrentState(FakeDeadZombieState.instance()) || !SwipeStatePlayer.checkPVP(isoGameCharacter, isoMovingObject)) continue;
            boolean bl3 = bl2 = isoMovingObject == attackVars.targetOnGround.getMovingObject() || isoMovingObject.isShootable() && SwipeStatePlayer.isStanding(isoMovingObject) && !attackVars.bAimAtFloor || isoMovingObject.isShootable() && SwipeStatePlayer.isProne(isoMovingObject) && attackVars.bAimAtFloor;
            if (!bl2) continue;
            Vector4f vector4f = this.tempVector4f;
            if (isoMovingObject instanceof BaseVehicle) {
                object = ((BaseVehicle)isoMovingObject).getNearestBodyworkPart(isoGameCharacter);
                if (object == null || (f = isoGameCharacter.getDotWithForwardDirection(isoMovingObject.x, isoMovingObject.y)) < 0.8f) continue;
                vector4f.set(isoMovingObject.x, isoMovingObject.y, isoMovingObject.z, f);
            } else if (isoGameCharacter2 == null || !this.getNearestTargetPosAndDot(isoGameCharacter, handWeapon, isoMovingObject, bl, vector4f)) continue;
            object = LosUtil.lineClear(isoGameCharacter.getCell(), (int)isoGameCharacter.getX(), (int)isoGameCharacter.getY(), (int)isoGameCharacter.getZ(), (int)isoMovingObject.getX(), (int)isoMovingObject.getY(), (int)isoMovingObject.getZ(), false);
            if (object == LosUtil.TestResults.Blocked || object == LosUtil.TestResults.ClearThroughClosedDoor) continue;
            f = vector4f.w;
            float f2 = IsoUtils.DistanceToSquared(isoGameCharacter.x, isoGameCharacter.y, (int)isoGameCharacter.z * 3, vector4f.x, vector4f.y, (int)vector4f.z * 3);
            if (isoMovingObject.getSquare().getTransparentWallTo(isoGameCharacter.getSquare()) != null && isoGameCharacter instanceof IsoPlayer) {
                if (WeaponType.getWeaponType(isoGameCharacter) == WeaponType.spear) {
                    ((IsoPlayer)isoGameCharacter).setAttackType("spearStab");
                } else if (WeaponType.getWeaponType(isoGameCharacter) != WeaponType.knife) continue;
            }
            if ((isoWindow = this.getWindowBetween(isoGameCharacter, isoMovingObject)) != null && isoWindow.isBarricaded()) continue;
            HitInfo hitInfo = this.hitInfoPool.alloc().init(isoMovingObject, f, f2, vector4f.x, vector4f.y, vector4f.z);
            hitInfo.window.setObject(isoWindow);
            arrayList.add(hitInfo);
        }
        if (!arrayList.isEmpty()) {
            return;
        }
        this.CalcHitListWindow(isoGameCharacter, handWeapon, arrayList);
    }

    private void CalcHitListWindow(IsoGameCharacter isoGameCharacter, HandWeapon handWeapon, ArrayList<HitInfo> arrayList) {
        Vector2 vector22 = isoGameCharacter.getLookVector(tempVector2_1);
        vector22.setLength(handWeapon.getMaxRange() * handWeapon.getRangeMod(isoGameCharacter));
        HitInfo hitInfo = null;
        ArrayList<IsoWindow> arrayList2 = IsoWorld.instance.CurrentCell.getWindowList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            IsoGridSquare isoGridSquare;
            float f;
            float f2;
            float f3;
            IsoWindow isoWindow = arrayList2.get(i);
            if ((int)isoWindow.getZ() != (int)isoGameCharacter.z || !this.windowVisitor.isHittable(isoWindow)) continue;
            float f4 = isoWindow.getX();
            if (!Line2D.linesIntersect(isoGameCharacter.x, isoGameCharacter.y, isoGameCharacter.x + vector22.x, isoGameCharacter.y + vector22.y, f4, f3 = isoWindow.getY(), f2 = f4 + (isoWindow.getNorth() ? 1.0f : 0.0f), f = f3 + (isoWindow.getNorth() ? 0.0f : 1.0f)) || (isoGridSquare = isoWindow.getAddSheetSquare(isoGameCharacter)) == null || LosUtil.lineClearCollide((int)isoGameCharacter.x, (int)isoGameCharacter.y, (int)isoGameCharacter.z, isoGridSquare.x, isoGridSquare.y, isoGridSquare.z, false)) continue;
            float f5 = IsoUtils.DistanceToSquared(isoGameCharacter.x, isoGameCharacter.y, f4 + (f2 - f4) / 2.0f, f3 + (f - f3) / 2.0f);
            if (hitInfo != null && hitInfo.distSq < f5) continue;
            float f6 = 1.0f;
            if (hitInfo == null) {
                hitInfo = this.hitInfoPool.alloc();
            }
            hitInfo.init(isoWindow, f6, f5);
        }
        if (hitInfo != null) {
            arrayList.add(hitInfo);
        }
    }

    public void CalcHitList(IsoGameCharacter isoGameCharacter, boolean bl, AttackVars attackVars, ArrayList<HitInfo> arrayList) {
        if (GameClient.bClient && !isoGameCharacter.isLocal()) {
            return;
        }
        this.hitInfoPool.release((List<HitInfo>)arrayList);
        arrayList.clear();
        HandWeapon handWeapon = attackVars.getWeapon((IsoLivingCharacter)isoGameCharacter);
        int n = handWeapon.getMaxHitCount();
        if (attackVars.bDoShove) {
            int n2 = n = WeaponType.getWeaponType(isoGameCharacter) != WeaponType.barehand ? 3 : 1;
        }
        if (!handWeapon.isRanged() && !SandboxOptions.instance.MultiHitZombies.getValue()) {
            n = 1;
        }
        if (handWeapon == ((IsoPlayer)isoGameCharacter).bareHands && !(isoGameCharacter.getPrimaryHandItem() instanceof HandWeapon)) {
            n = 1;
        }
        if (handWeapon == ((IsoPlayer)isoGameCharacter).bareHands && attackVars.targetOnGround.getMovingObject() != null) {
            n = 1;
        }
        if (0 < n) {
            if (attackVars.bDoShove) {
                this.CalcHitListShove(isoGameCharacter, bl, attackVars, arrayList);
            } else {
                this.CalcHitListWeapon(isoGameCharacter, bl, attackVars, arrayList);
            }
            if (arrayList.size() == 1 && arrayList.get(0).getObject() == null) {
                return;
            }
            this.filterTargetsByZ(isoGameCharacter);
            Collections.sort(arrayList, Comparator);
            if (handWeapon.isPiercingBullets()) {
                HitList2.clear();
                double d = 0.0;
                for (int i = 0; i < arrayList.size(); ++i) {
                    HitInfo hitInfo = arrayList.get(i);
                    IsoMovingObject isoMovingObject = hitInfo.getObject();
                    if (isoMovingObject == null) continue;
                    double d2 = isoGameCharacter.getX() - isoMovingObject.getX();
                    double d3 = -(isoGameCharacter.getY() - isoMovingObject.getY());
                    double d4 = Math.atan2(d3, d2);
                    d4 = d4 < 0.0 ? Math.abs(d4) : Math.PI * 2 - d4;
                    if (i == 0) {
                        d = Math.toDegrees(d4);
                        HitList2.add(hitInfo);
                        continue;
                    }
                    double d5 = Math.toDegrees(d4);
                    if (!(Math.abs(d - d5) < 1.0)) continue;
                    HitList2.add(hitInfo);
                    break;
                }
                arrayList.removeAll(HitList2);
                this.hitInfoPool.release((List<HitInfo>)arrayList);
                arrayList.clear();
                arrayList.addAll(HitList2);
            } else {
                while (arrayList.size() > n) {
                    this.hitInfoPool.release(arrayList.remove(arrayList.size() - 1));
                }
            }
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            HitInfo hitInfo = arrayList.get(i);
            hitInfo.chance = this.CalcHitChance(isoGameCharacter, handWeapon, hitInfo);
        }
    }

    private void filterTargetsByZ(IsoGameCharacter isoGameCharacter) {
        float f;
        HitInfo hitInfo;
        int n;
        float f2 = Float.MAX_VALUE;
        HitInfo hitInfo2 = null;
        for (n = 0; n < isoGameCharacter.hitList.size(); ++n) {
            hitInfo = isoGameCharacter.hitList.get(n);
            f = Math.abs(hitInfo.z - isoGameCharacter.getZ());
            if (!(f < f2)) continue;
            f2 = f;
            hitInfo2 = hitInfo;
        }
        if (hitInfo2 == null) {
            return;
        }
        for (n = isoGameCharacter.hitList.size() - 1; n >= 0; --n) {
            hitInfo = isoGameCharacter.hitList.get(n);
            if (hitInfo == hitInfo2 || !((f = Math.abs(hitInfo.z - hitInfo2.z)) > 0.5f)) continue;
            this.hitInfoPool.release(hitInfo);
            isoGameCharacter.hitList.remove(n);
        }
    }

    public int CalcHitChance(IsoGameCharacter isoGameCharacter, HandWeapon handWeapon, HitInfo hitInfo) {
        IsoMovingObject isoMovingObject = hitInfo.getObject();
        if (isoMovingObject == null) {
            return 0;
        }
        if (isoGameCharacter.getVehicle() != null) {
            BaseVehicle baseVehicle = isoGameCharacter.getVehicle();
            Vector3f vector3f = baseVehicle.getForwardVector((Vector3f)BaseVehicle.TL_vector3f_pool.get().alloc());
            Vector2 vector22 = (Vector2)BaseVehicle.TL_vector2_pool.get().alloc();
            vector22.x = vector3f.x;
            vector22.y = vector3f.z;
            vector22.normalize();
            int n = baseVehicle.getSeat(isoGameCharacter);
            VehicleScript.Area area = baseVehicle.getScript().getAreaById(baseVehicle.getPassengerArea(n));
            int n2 = -90;
            if (area.x > 0.0f) {
                n2 = 90;
            }
            vector22.rotate((float)Math.toRadians(n2));
            vector22.normalize();
            Vector2 vector23 = (Vector2)BaseVehicle.TL_vector2_pool.get().alloc();
            vector23.x = isoMovingObject.x;
            vector23.y = isoMovingObject.y;
            vector23.x -= isoGameCharacter.x;
            vector23.y -= isoGameCharacter.y;
            vector23.normalize();
            float f = vector23.dot(vector22);
            if ((double)f > -0.6) {
                return 0;
            }
            BaseVehicle.TL_vector2_pool.get().release(vector22);
            BaseVehicle.TL_vector2_pool.get().release(vector23);
            BaseVehicle.TL_vector3f_pool.get().release(vector3f);
        }
        if (System.currentTimeMillis() - isoGameCharacter.lastAutomaticShoot > 600L) {
            isoGameCharacter.shootInARow = 0;
        }
        int n = handWeapon.getHitChance();
        if ((n = (int)((float)n + handWeapon.getAimingPerkHitChanceModifier() * (float)isoGameCharacter.getPerkLevel(PerkFactory.Perks.Aiming))) > 95) {
            n = 95;
        }
        n -= isoGameCharacter.shootInARow * 2;
        float f = PZMath.sqrt(hitInfo.distSq);
        float f2 = 1.3f;
        if (isoMovingObject instanceof IsoPlayer) {
            f = (float)((double)f * 1.5);
            f2 = 1.0f;
        }
        n = (int)((float)n + (handWeapon.getMaxRange() * handWeapon.getRangeMod(isoGameCharacter) - f) * f2);
        if (handWeapon.getMinRangeRanged() > 0.0f) {
            if (f < handWeapon.getMinRangeRanged()) {
                n -= 50;
            }
        } else if ((double)f < 1.7 && handWeapon.isRanged() && !(isoMovingObject instanceof IsoPlayer)) {
            n += 35;
        }
        if (handWeapon.isRanged() && isoGameCharacter.getBeenMovingFor() > (float)(handWeapon.getAimingTime() + isoGameCharacter.getPerkLevel(PerkFactory.Perks.Aiming))) {
            n = (int)((float)n - (isoGameCharacter.getBeenMovingFor() - (float)(handWeapon.getAimingTime() + isoGameCharacter.getPerkLevel(PerkFactory.Perks.Aiming))));
        }
        if (hitInfo.getObject() instanceof IsoPlayer) {
            IsoPlayer isoPlayer = (IsoPlayer)hitInfo.getObject();
            if (isoPlayer.isPlayerMoving()) {
                n -= 5;
            }
            if (isoPlayer.isRunning()) {
                n -= 10;
            }
            if (isoPlayer.isSprinting()) {
                n -= 15;
            }
        }
        if (handWeapon.isRanged() && isoGameCharacter.getVehicle() != null) {
            n = (int)((float)n - Math.abs(isoGameCharacter.getVehicle().getCurrentSpeedKmHour()) * 2.0f);
        }
        if (isoGameCharacter.Traits.Marksman.isSet()) {
            n += 20;
        }
        float f3 = 0.0f;
        for (int i = BodyPartType.ToIndex(BodyPartType.Hand_L); i <= BodyPartType.ToIndex(BodyPartType.UpperArm_R); ++i) {
            f3 += isoGameCharacter.getBodyDamage().getBodyParts().get(i).getPain();
        }
        if (f3 > 0.0f) {
            n = (int)((float)n - f3 / 10.0f);
        }
        if ((n -= isoGameCharacter.getMoodles().getMoodleLevel(MoodleType.Tired) * 5) <= 10) {
            n = 10;
        }
        if (n > 100 || !handWeapon.isRanged()) {
            n = 100;
        }
        return n;
    }

    public static Vector3 getBoneWorldPos(IsoMovingObject isoMovingObject, String string, Vector3 vector3) {
        IsoGameCharacter isoGameCharacter = Type.tryCastTo(isoMovingObject, IsoGameCharacter.class);
        if (isoGameCharacter == null || string == null) {
            return vector3.set(isoMovingObject.x, isoMovingObject.y, isoMovingObject.z);
        }
        AnimationPlayer animationPlayer = isoGameCharacter.getAnimationPlayer();
        if (animationPlayer == null || !animationPlayer.isReady()) {
            return vector3.set(isoMovingObject.x, isoMovingObject.y, isoMovingObject.z);
        }
        int n = animationPlayer.getSkinningBoneIndex(string, -1);
        if (n == -1) {
            return vector3.set(isoMovingObject.x, isoMovingObject.y, isoMovingObject.z);
        }
        Model.BoneToWorldCoords(isoGameCharacter, n, vector3);
        return vector3;
    }

    public void ConnectSwing(IsoGameCharacter isoGameCharacter, HandWeapon handWeapon) {
        int n;
        int n2;
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        IsoLivingCharacter isoLivingCharacter = (IsoLivingCharacter)isoGameCharacter;
        IsoPlayer isoPlayer = Type.tryCastTo(isoGameCharacter, IsoPlayer.class);
        if (isoGameCharacter.getVariableBoolean("ShoveAnim")) {
            isoLivingCharacter.setDoShove(true);
        }
        if (GameServer.bServer) {
            DebugLog.log(DebugType.Network, "Player swing connects.");
        }
        LuaEventManager.triggerEvent("OnWeaponSwingHitPoint", isoGameCharacter, handWeapon);
        if (handWeapon.getPhysicsObject() != null) {
            isoGameCharacter.Throw(handWeapon);
        }
        if (handWeapon.isUseSelf()) {
            handWeapon.Use();
        }
        if (handWeapon.isOtherHandUse() && isoGameCharacter.getSecondaryHandItem() != null) {
            isoGameCharacter.getSecondaryHandItem().Use();
        }
        boolean bl = false;
        if (isoLivingCharacter.bDoShove && !isoGameCharacter.isAimAtFloor()) {
            bl = true;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        isoGameCharacter.attackVars.setWeapon(handWeapon);
        isoGameCharacter.attackVars.targetOnGround.setMovingObject(isoLivingCharacter.targetOnGround);
        isoGameCharacter.attackVars.bAimAtFloor = isoGameCharacter.isAimAtFloor();
        isoGameCharacter.attackVars.bDoShove = isoLivingCharacter.bDoShove;
        if (isoGameCharacter.getVariableBoolean("ShoveAnim")) {
            isoGameCharacter.attackVars.bDoShove = true;
        }
        this.CalcHitList(isoGameCharacter, false, isoGameCharacter.attackVars, isoGameCharacter.hitList);
        int n3 = isoGameCharacter.hitList.size();
        boolean bl4 = false;
        if (n3 == 0) {
            bl4 = this.CheckObjectHit(isoGameCharacter, handWeapon);
        }
        if (handWeapon.isUseEndurance()) {
            float f = 0.0f;
            if (handWeapon.isTwoHandWeapon() && (isoGameCharacter.getPrimaryHandItem() != handWeapon || isoGameCharacter.getSecondaryHandItem() != handWeapon)) {
                f = handWeapon.getWeight() / 1.5f / 10.0f;
            }
            if (n3 <= 0 && !isoGameCharacter.isForceShove()) {
                float f2 = (handWeapon.getWeight() * 0.18f * handWeapon.getFatigueMod(isoGameCharacter) * isoGameCharacter.getFatigueMod() * handWeapon.getEnduranceMod() * 0.3f + f) * 0.04f;
                float f3 = 1.0f;
                if (isoGameCharacter.Traits.Asthmatic.isSet()) {
                    f3 = 1.3f;
                }
                isoGameCharacter.getStats().endurance -= f2 * f3;
            }
        }
        isoGameCharacter.setLastHitCount(isoGameCharacter.hitList.size());
        if (!handWeapon.isMultipleHitConditionAffected()) {
            bl2 = true;
        }
        int n4 = 1;
        this.dotList.clear();
        if (isoGameCharacter.hitList.isEmpty() && isoGameCharacter.getClickSound() != null && !isoLivingCharacter.bDoShove) {
            if (isoGameCharacter instanceof IsoPlayer && ((IsoPlayer)isoGameCharacter).isLocalPlayer() || !(isoGameCharacter instanceof IsoPlayer)) {
                isoGameCharacter.getEmitter().playSound(isoGameCharacter.getClickSound());
            }
            isoGameCharacter.setRecoilDelay(10.0f);
        }
        boolean bl5 = false;
        for (n2 = 0; n2 < isoGameCharacter.hitList.size(); ++n2) {
            VehiclePart vehiclePart;
            Object object;
            int n5;
            float f;
            int n6;
            float f4;
            boolean bl6;
            n = 0;
            boolean bl7 = false;
            HitInfo hitInfo = isoGameCharacter.hitList.get(n2);
            IsoMovingObject isoMovingObject = hitInfo.getObject();
            BaseVehicle baseVehicle = Type.tryCastTo(isoMovingObject, BaseVehicle.class);
            IsoZombie isoZombie = Type.tryCastTo(isoMovingObject, IsoZombie.class);
            if (hitInfo.getObject() == null && hitInfo.window.getObject() != null) {
                hitInfo.window.getObject().WeaponHit(isoGameCharacter, handWeapon);
                continue;
            }
            this.smashWindowBetween(isoGameCharacter, isoMovingObject, handWeapon);
            if (this.isWindowBetween(isoGameCharacter, isoMovingObject)) continue;
            int n7 = hitInfo.chance;
            boolean bl8 = bl6 = Rand.Next(100) <= n7;
            if (!bl6) continue;
            Vector2 vector22 = tempVector2_1.set(isoGameCharacter.getX(), isoGameCharacter.getY());
            Vector2 vector23 = tempVector2_2.set(isoMovingObject.getX(), isoMovingObject.getY());
            vector23.x -= vector22.x;
            vector23.y -= vector22.y;
            Vector2 vector24 = isoGameCharacter.getLookVector(tempVector2_1);
            vector24.tangent();
            vector23.normalize();
            boolean bl9 = true;
            float f5 = vector24.dot(vector23);
            for (int i = 0; i < this.dotList.size(); ++i) {
                f4 = this.dotList.get(i).floatValue();
                if (!((double)Math.abs(f5 - f4) < 1.0E-4)) continue;
                bl9 = false;
            }
            float f6 = handWeapon.getMinDamage();
            f4 = handWeapon.getMaxDamage();
            long l = 0L;
            if (!bl9) {
                f6 /= 5.0f;
                f4 /= 5.0f;
            }
            if (isoGameCharacter.isAimAtFloor() && !handWeapon.isRanged() && isoGameCharacter.isNPC()) {
                SwipeStatePlayer.splash(isoMovingObject, handWeapon, isoGameCharacter);
                n = (byte)Rand.Next(2);
            } else if (isoGameCharacter.isAimAtFloor() && !handWeapon.isRanged()) {
                if (isoPlayer == null || isoPlayer.isLocalPlayer()) {
                    if (!StringUtils.isNullOrEmpty(handWeapon.getHitFloorSound())) {
                        isoGameCharacter.getEmitter().stopSoundByName(handWeapon.getSwingSound());
                        if (isoPlayer != null) {
                            isoPlayer.setMeleeHitSurface(ParameterMeleeHitSurface.Material.Body);
                        }
                        l = isoGameCharacter.playSound(handWeapon.getHitFloorSound());
                    } else {
                        isoGameCharacter.getEmitter().stopSoundByName(handWeapon.getSwingSound());
                        if (isoPlayer != null) {
                            isoPlayer.setMeleeHitSurface(ParameterMeleeHitSurface.Material.Body);
                        }
                        l = isoGameCharacter.playSound(handWeapon.getZombieHitSound());
                    }
                }
                if ((n6 = this.DoSwingCollisionBoneCheck(isoGameCharacter, SwipeStatePlayer.GetWeapon(isoGameCharacter), (IsoGameCharacter)isoMovingObject, ((IsoGameCharacter)isoMovingObject).getAnimationPlayer().getSkinningBoneIndex("Bip01_Head", -1), 0.28f)) == -1) {
                    n6 = this.DoSwingCollisionBoneCheck(isoGameCharacter, SwipeStatePlayer.GetWeapon(isoGameCharacter), (IsoGameCharacter)isoMovingObject, ((IsoGameCharacter)isoMovingObject).getAnimationPlayer().getSkinningBoneIndex("Bip01_Spine", -1), 0.28f);
                    if (n6 == -1) {
                        n6 = this.DoSwingCollisionBoneCheck(isoGameCharacter, SwipeStatePlayer.GetWeapon(isoGameCharacter), (IsoGameCharacter)isoMovingObject, ((IsoGameCharacter)isoMovingObject).getAnimationPlayer().getSkinningBoneIndex("Bip01_L_Calf", -1), 0.13f);
                        if (n6 == -1) {
                            n6 = this.DoSwingCollisionBoneCheck(isoGameCharacter, SwipeStatePlayer.GetWeapon(isoGameCharacter), (IsoGameCharacter)isoMovingObject, ((IsoGameCharacter)isoMovingObject).getAnimationPlayer().getSkinningBoneIndex("Bip01_R_Calf", -1), 0.13f);
                        }
                        if (n6 == -1) {
                            n6 = this.DoSwingCollisionBoneCheck(isoGameCharacter, SwipeStatePlayer.GetWeapon(isoGameCharacter), (IsoGameCharacter)isoMovingObject, ((IsoGameCharacter)isoMovingObject).getAnimationPlayer().getSkinningBoneIndex("Bip01_L_Foot", -1), 0.23f);
                        }
                        if (n6 == -1) {
                            n6 = this.DoSwingCollisionBoneCheck(isoGameCharacter, SwipeStatePlayer.GetWeapon(isoGameCharacter), (IsoGameCharacter)isoMovingObject, ((IsoGameCharacter)isoMovingObject).getAnimationPlayer().getSkinningBoneIndex("Bip01_R_Foot", -1), 0.23f);
                        }
                        if (n6 == -1) continue;
                        bl7 = true;
                    }
                } else {
                    SwipeStatePlayer.splash(isoMovingObject, handWeapon, isoGameCharacter);
                    SwipeStatePlayer.splash(isoMovingObject, handWeapon, isoGameCharacter);
                    n = (byte)(Rand.Next(0, 3) + 1);
                }
            }
            if (!(isoGameCharacter.attackVars.bAimAtFloor || isoGameCharacter.attackVars.bCloseKill && isoGameCharacter.isCriticalHit() || isoLivingCharacter.bDoShove || !(isoMovingObject instanceof IsoGameCharacter) || isoPlayer != null && !isoPlayer.isLocalPlayer())) {
                if (isoPlayer != null) {
                    isoPlayer.setMeleeHitSurface(ParameterMeleeHitSurface.Material.Body);
                }
                if (handWeapon.isRanged()) {
                    l = ((IsoGameCharacter)isoMovingObject).playSound(handWeapon.getZombieHitSound());
                } else {
                    isoGameCharacter.getEmitter().stopSoundByName(handWeapon.getSwingSound());
                    l = isoGameCharacter.playSound(handWeapon.getZombieHitSound());
                }
            }
            if (handWeapon.isRanged() && isoZombie != null) {
                Vector2 vector25 = tempVector2_1.set(isoGameCharacter.getX(), isoGameCharacter.getY());
                Vector2 vector26 = tempVector2_2.set(isoMovingObject.getX(), isoMovingObject.getY());
                vector26.x -= vector25.x;
                vector26.y -= vector25.y;
                Vector2 vector27 = isoZombie.getForwardDirection();
                vector26.normalize();
                vector27.normalize();
                f = vector26.dot(vector27);
                isoZombie.setHitFromBehind((double)f > 0.5);
            }
            if (this.dotList.isEmpty()) {
                this.dotList.add(Float.valueOf(f5));
            }
            if (isoZombie != null && isoZombie.isCurrentState(ZombieOnGroundState.instance())) {
                isoZombie.setReanimateTimer(isoZombie.getReanimateTimer() + (float)Rand.Next(10));
            }
            if (isoZombie != null && isoZombie.isCurrentState(ZombieGetUpState.instance())) {
                isoZombie.setReanimateTimer(Rand.Next(60) + 30);
            }
            n6 = 0;
            if (!handWeapon.isTwoHandWeapon() || isoGameCharacter.isItemInBothHands(handWeapon)) {
                n6 = 1;
            }
            float f7 = f6;
            float f8 = f4 - f6;
            f7 = f8 == 0.0f ? (f7 += 0.0f) : (f7 += (float)Rand.Next((int)(f8 * 1000.0f)) / 1000.0f);
            if (!handWeapon.isRanged()) {
                f7 *= handWeapon.getDamageMod(isoGameCharacter) * isoGameCharacter.getHittingMod();
            }
            if (n6 == 0 && !handWeapon.isRanged() && f4 > f6) {
                f7 -= f6;
            }
            if (!isoGameCharacter.isAimAtFloor() || !isoLivingCharacter.bDoShove) {
                f = 0.0f;
                for (var35_43 = BodyPartType.ToIndex(BodyPartType.Hand_L); var35_43 <= BodyPartType.ToIndex(BodyPartType.UpperArm_R); ++var35_43) {
                    f += isoGameCharacter.getBodyDamage().getBodyParts().get(var35_43).getPain();
                }
                if (f > 10.0f) {
                    f7 /= PZMath.clamp(f / 10.0f, 1.0f, 30.0f);
                    MoodlesUI.getInstance().wiggle(MoodleType.Pain);
                    MoodlesUI.getInstance().wiggle(MoodleType.Injured);
                }
            } else {
                f = 0.0f;
                for (var35_43 = BodyPartType.ToIndex(BodyPartType.UpperLeg_L); var35_43 <= BodyPartType.ToIndex(BodyPartType.Foot_R); ++var35_43) {
                    f += isoGameCharacter.getBodyDamage().getBodyParts().get(var35_43).getPain();
                }
                if (f > 10.0f) {
                    f7 /= PZMath.clamp(f / 10.0f, 1.0f, 30.0f);
                    MoodlesUI.getInstance().wiggle(MoodleType.Pain);
                    MoodlesUI.getInstance().wiggle(MoodleType.Injured);
                }
            }
            if (isoGameCharacter.Traits.Underweight.isSet()) {
                f7 *= 0.8f;
            }
            if (isoGameCharacter.Traits.VeryUnderweight.isSet()) {
                f7 *= 0.6f;
            }
            if (isoGameCharacter.Traits.Emaciated.isSet()) {
                f7 *= 0.4f;
            }
            f = f7 / ((float)n4 / 2.0f);
            if (isoGameCharacter.isAttackWasSuperAttack()) {
                f *= 5.0f;
            }
            ++n4;
            if (handWeapon.isMultipleHitConditionAffected()) {
                bl2 = true;
            }
            Vector2 vector28 = tempVector2_1.set(isoGameCharacter.getX(), isoGameCharacter.getY());
            Vector2 vector29 = tempVector2_2.set(isoMovingObject.getX(), isoMovingObject.getY());
            vector29.x -= vector28.x;
            vector29.y -= vector28.y;
            float f9 = vector29.getLength();
            float f10 = 1.0f;
            f10 = handWeapon.isRangeFalloff() ? 1.0f : (handWeapon.isRanged() ? 0.5f : f9 / handWeapon.getMaxRange(isoGameCharacter));
            if ((f10 *= 2.0f) < 0.3f) {
                f10 = 1.0f;
            }
            if (handWeapon.isRanged() && isoGameCharacter.getPerkLevel(PerkFactory.Perks.Aiming) < 6 && isoGameCharacter.getMoodles().getMoodleLevel(MoodleType.Panic) > 2) {
                f -= (float)isoGameCharacter.getMoodles().getMoodleLevel(MoodleType.Panic) * 0.2f;
                MoodlesUI.getInstance().wiggle(MoodleType.Panic);
            }
            if (!handWeapon.isRanged() && isoGameCharacter.getMoodles().getMoodleLevel(MoodleType.Panic) > 1) {
                f -= (float)isoGameCharacter.getMoodles().getMoodleLevel(MoodleType.Panic) * 0.1f;
                MoodlesUI.getInstance().wiggle(MoodleType.Panic);
            }
            if (isoGameCharacter.getMoodles().getMoodleLevel(MoodleType.Stress) > 1) {
                f -= (float)isoGameCharacter.getMoodles().getMoodleLevel(MoodleType.Stress) * 0.1f;
                MoodlesUI.getInstance().wiggle(MoodleType.Stress);
            }
            if (f < 0.0f) {
                f = 0.1f;
            }
            if (isoGameCharacter.isAimAtFloor() && isoLivingCharacter.bDoShove) {
                f = Rand.Next(0.7f, 1.0f) + (float)isoGameCharacter.getPerkLevel(PerkFactory.Perks.Strength) * 0.2f;
                Clothing clothing = (Clothing)isoGameCharacter.getWornItem("Shoes");
                f = clothing == null ? (f *= 0.5f) : (f *= clothing.getStompPower());
            }
            if (!handWeapon.isRanged()) {
                switch (isoGameCharacter.getMoodles().getMoodleLevel(MoodleType.Endurance)) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        f *= 0.5f;
                        MoodlesUI.getInstance().wiggle(MoodleType.Endurance);
                        break;
                    }
                    case 2: {
                        f *= 0.2f;
                        MoodlesUI.getInstance().wiggle(MoodleType.Endurance);
                        break;
                    }
                    case 3: {
                        f *= 0.1f;
                        MoodlesUI.getInstance().wiggle(MoodleType.Endurance);
                        break;
                    }
                    case 4: {
                        f *= 0.05f;
                        MoodlesUI.getInstance().wiggle(MoodleType.Endurance);
                    }
                }
                switch (isoGameCharacter.getMoodles().getMoodleLevel(MoodleType.Tired)) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        f *= 0.5f;
                        MoodlesUI.getInstance().wiggle(MoodleType.Tired);
                        break;
                    }
                    case 2: {
                        f *= 0.2f;
                        MoodlesUI.getInstance().wiggle(MoodleType.Tired);
                        break;
                    }
                    case 3: {
                        f *= 0.1f;
                        MoodlesUI.getInstance().wiggle(MoodleType.Tired);
                        break;
                    }
                    case 4: {
                        f *= 0.05f;
                        MoodlesUI.getInstance().wiggle(MoodleType.Tired);
                    }
                }
            }
            isoGameCharacter.knockbackAttackMod = 1.0f;
            if ("KnifeDeath".equals(isoGameCharacter.getVariableString("ZombieHitReaction"))) {
                f10 *= 1000.0f;
                isoGameCharacter.knockbackAttackMod = 0.0f;
                isoGameCharacter.addWorldSoundUnlessInvisible(4, 4, false);
                isoGameCharacter.attackVars.bCloseKill = true;
                isoMovingObject.setCloseKilled(true);
            } else {
                isoGameCharacter.attackVars.bCloseKill = false;
                isoMovingObject.setCloseKilled(false);
                isoGameCharacter.addWorldSoundUnlessInvisible(8, 8, false);
                if (Rand.Next(3) == 0 || isoGameCharacter.isAimAtFloor() && isoLivingCharacter.bDoShove) {
                    isoGameCharacter.addWorldSoundUnlessInvisible(10, 10, false);
                } else if (Rand.Next(7) == 0) {
                    isoGameCharacter.addWorldSoundUnlessInvisible(16, 16, false);
                }
            }
            isoMovingObject.setHitFromAngle(hitInfo.dot);
            if (isoZombie != null) {
                float f11;
                isoZombie.setHitFromBehind(isoGameCharacter.isBehind(isoZombie));
                isoZombie.setHitAngle(isoGameCharacter.getForwardDirection());
                isoZombie.setPlayerAttackPosition(isoZombie.testDotSide(isoGameCharacter));
                isoZombie.setHitHeadWhileOnFloor(n);
                isoZombie.setHitLegsWhileOnFloor(bl7);
                if (n > 0) {
                    isoZombie.addBlood(BloodBodyPartType.Head, true, true, true);
                    isoZombie.addBlood(BloodBodyPartType.Torso_Upper, true, false, false);
                    isoZombie.addBlood(BloodBodyPartType.UpperArm_L, true, false, false);
                    isoZombie.addBlood(BloodBodyPartType.UpperArm_R, true, false, false);
                    f *= 3.0f;
                }
                if (bl7) {
                    f = 0.05f;
                }
                int n8 = 0;
                n8 = n > 0 ? Rand.Next(BodyPartType.ToIndex(BodyPartType.Head), BodyPartType.ToIndex(BodyPartType.Neck) + 1) : (bl7 ? Rand.Next(BodyPartType.ToIndex(BodyPartType.Groin), BodyPartType.ToIndex(BodyPartType.Foot_R) + 1) : Rand.Next(BodyPartType.ToIndex(BodyPartType.Hand_L), BodyPartType.ToIndex(BodyPartType.Neck) + 1));
                float f12 = isoZombie.getBodyPartClothingDefense(n8, false, handWeapon.isRanged()) / 2.0f;
                if ((f12 += isoZombie.getBodyPartClothingDefense(n8, true, handWeapon.isRanged())) > 70.0f) {
                    f12 = 70.0f;
                }
                f = f11 = f * Math.abs(1.0f - f12 / 100.0f);
                if (!GameClient.bClient && !GameServer.bServer || GameClient.bClient && isoGameCharacter instanceof IsoPlayer && ((IsoPlayer)isoGameCharacter).isLocalPlayer()) {
                    bl3 = isoZombie.helmetFall(n > 0);
                }
                if ("KnifeDeath".equals(isoGameCharacter.getVariableString("ZombieHitReaction")) && !"Tutorial".equals(Core.GameMode)) {
                    int n9 = 8;
                    if (isoZombie.isCurrentState(AttackState.instance())) {
                        n9 = 3;
                    }
                    if (Rand.NextBool(n9 + (n5 = isoGameCharacter.getPerkLevel(PerkFactory.Perks.SmallBlade) + 1) * 2)) {
                        object = isoGameCharacter.getPrimaryHandItem();
                        isoGameCharacter.getInventory().Remove((InventoryItem)object);
                        isoGameCharacter.removeFromHands((InventoryItem)object);
                        isoZombie.setAttachedItem("JawStab", (InventoryItem)object);
                        isoZombie.setJawStabAttach(true);
                    }
                    isoZombie.setKnifeDeath(true);
                }
            }
            float f13 = 0.0f;
            boolean bl10 = isoGameCharacter.isCriticalHit();
            if (baseVehicle == null && isoMovingObject.getSquare() != null && isoGameCharacter.getSquare() != null) {
                isoMovingObject.setCloseKilled(isoGameCharacter.attackVars.bCloseKill);
                if (((IsoPlayer)isoGameCharacter).isLocalPlayer() || isoGameCharacter.isNPC()) {
                    f13 = isoMovingObject.Hit(handWeapon, isoGameCharacter, f, bl, f10);
                    this.setParameterCharacterHitResult(isoGameCharacter, isoZombie, l);
                }
                LuaEventManager.triggerEvent("OnWeaponHitXp", isoGameCharacter, handWeapon, isoMovingObject, Float.valueOf(f));
                if ((!isoLivingCharacter.bDoShove || isoGameCharacter.isAimAtFloor()) && isoGameCharacter.DistToSquared(isoMovingObject) < 2.0f && Math.abs(isoGameCharacter.z - isoMovingObject.z) < 0.5f) {
                    isoGameCharacter.addBlood(null, false, false, false);
                }
                if (isoMovingObject instanceof IsoGameCharacter) {
                    if (((IsoGameCharacter)isoMovingObject).isDead()) {
                        isoGameCharacter.getStats().stress -= 0.02f;
                    } else if (!(isoMovingObject instanceof IsoPlayer || isoLivingCharacter.bDoShove && !isoGameCharacter.isAimAtFloor())) {
                        SwipeStatePlayer.splash(isoMovingObject, handWeapon, isoGameCharacter);
                    }
                }
            } else if (baseVehicle != null && (vehiclePart = baseVehicle.getNearestBodyworkPart(isoGameCharacter)) != null) {
                VehicleWindow vehicleWindow = vehiclePart.getWindow();
                for (n5 = 0; n5 < vehiclePart.getChildCount(); ++n5) {
                    object = vehiclePart.getChild(n5);
                    if (((VehiclePart)object).getWindow() == null) continue;
                    vehicleWindow = ((VehiclePart)object).getWindow();
                    break;
                }
                if (vehicleWindow != null && vehicleWindow.isHittable()) {
                    n5 = this.calcDamageToVehicle((int)f * 10, handWeapon.getDoorDamage(), true);
                    vehicleWindow.damage(n5);
                    isoGameCharacter.playSound("HitVehicleWindowWithWeapon");
                } else {
                    n5 = this.calcDamageToVehicle((int)f * 10, handWeapon.getDoorDamage(), false);
                    vehiclePart.setCondition(vehiclePart.getCondition() - n5);
                    isoPlayer.setVehicleHitLocation(baseVehicle);
                    isoGameCharacter.playSound("HitVehiclePartWithWeapon");
                }
            }
            if (!GameClient.bClient || !isoGameCharacter.isLocal()) continue;
            if (isoMovingObject instanceof IsoGameCharacter) {
                HitReactionNetworkAI.CalcHitReactionWeapon(isoGameCharacter, (IsoGameCharacter)isoMovingObject, handWeapon);
            }
            bl5 = GameClient.sendHitCharacter(isoGameCharacter, isoMovingObject, handWeapon, f13, bl, f10, bl10, bl3, n > 0);
        }
        if (GameClient.bClient && ((IsoPlayer)isoGameCharacter).isLocalPlayer() && !bl5) {
            GameClient.sendHitCharacter(isoGameCharacter, null, handWeapon, 0.0f, bl, 1.0f, isoGameCharacter.isCriticalHit(), false, false);
        }
        if (!bl2 && bl4) {
            n2 = this.bHitOnlyTree && handWeapon.getScriptItem().Categories.contains("Axe") ? 1 : 0;
            int n10 = n = n2 != 0 ? 2 : 1;
            if (Rand.Next(handWeapon.getConditionLowerChance() * n + isoGameCharacter.getMaintenanceMod() * 2) == 0) {
                bl2 = true;
            } else if (!(!Rand.NextBool(2) || WeaponType.getWeaponType(isoGameCharacter) == WeaponType.barehand || handWeapon.isTwoHandWeapon() && isoGameCharacter.getPrimaryHandItem() != handWeapon && isoGameCharacter.getSecondaryHandItem() != handWeapon && Rand.NextBool(3))) {
                isoGameCharacter.getXp().AddXP(PerkFactory.Perks.Maintenance, 1.0f);
            }
        }
        hashMap.put(PARAM_LOWER_CONDITION, bl2 ? Boolean.TRUE : Boolean.FALSE);
        hashMap.put(PARAM_ATTACKED, Boolean.TRUE);
    }

    private int calcDamageToVehicle(int n, int n2, boolean bl) {
        if (n <= 0) {
            return 0;
        }
        float f = n;
        float f2 = PZMath.clamp(f / (bl ? 10.0f : 40.0f), 0.0f, 1.0f);
        int n3 = (int)((float)n2 * f2);
        return PZMath.clamp(n3, 1, n2);
    }

    public static void splash(IsoMovingObject isoMovingObject, HandWeapon handWeapon, IsoGameCharacter isoGameCharacter) {
        int n;
        int n2;
        IsoGameCharacter isoGameCharacter2 = (IsoGameCharacter)isoMovingObject;
        if (handWeapon != null && SandboxOptions.instance.BloodLevel.getValue() > 1) {
            n2 = handWeapon.getSplatNumber();
            if (n2 < 1) {
                n2 = 1;
            }
            if (Core.bLastStand) {
                n2 *= 3;
            }
            switch (SandboxOptions.instance.BloodLevel.getValue()) {
                case 2: {
                    n2 /= 2;
                    break;
                }
                case 4: {
                    n2 *= 2;
                    break;
                }
                case 5: {
                    n2 *= 5;
                }
            }
            for (n = 0; n < n2; ++n) {
                isoGameCharacter2.splatBlood(3, 0.3f);
            }
        }
        n2 = 3;
        n = 7;
        switch (SandboxOptions.instance.BloodLevel.getValue()) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 4;
                n2 = 5;
                break;
            }
            case 4: {
                n = 10;
                n2 = 2;
                break;
            }
            case 5: {
                n = 15;
                n2 = 0;
            }
        }
        if (SandboxOptions.instance.BloodLevel.getValue() > 1) {
            isoGameCharacter2.splatBloodFloorBig();
        }
        float f = 0.5f;
        if (isoGameCharacter2 instanceof IsoZombie && (((IsoZombie)isoGameCharacter2).bCrawling || isoGameCharacter2.getCurrentState() == ZombieOnGroundState.instance())) {
            f = 0.2f;
        }
        float f2 = Rand.Next(1.5f, 5.0f);
        float f3 = Rand.Next(1.5f, 5.0f);
        if (isoGameCharacter instanceof IsoPlayer && ((IsoPlayer)isoGameCharacter).bDoShove) {
            f2 = Rand.Next(0.0f, 0.5f);
            f3 = Rand.Next(0.0f, 0.5f);
        }
        if (n > 0) {
            isoGameCharacter2.playBloodSplatterSound();
        }
        for (int i = 0; i < n; ++i) {
            if (Rand.Next(n2) != 0) continue;
            new IsoZombieGiblets(IsoZombieGiblets.GibletType.A, isoGameCharacter2.getCell(), isoGameCharacter2.getX(), isoGameCharacter2.getY(), isoGameCharacter2.getZ() + f, isoGameCharacter2.getHitDir().x * f2, isoGameCharacter2.getHitDir().y * f3);
        }
    }

    private boolean checkObjectHit(IsoGameCharacter isoGameCharacter, HandWeapon handWeapon, IsoGridSquare isoGridSquare, boolean bl, boolean bl2) {
        if (isoGridSquare == null) {
            return false;
        }
        for (int i = isoGridSquare.getSpecialObjects().size() - 1; i >= 0; --i) {
            Thumpable thumpable;
            IsoObject isoObject = isoGridSquare.getSpecialObjects().get(i);
            IsoDoor isoDoor = Type.tryCastTo(isoObject, IsoDoor.class);
            IsoThumpable isoThumpable = Type.tryCastTo(isoObject, IsoThumpable.class);
            IsoWindow isoWindow = Type.tryCastTo(isoObject, IsoWindow.class);
            if (isoDoor != null && (bl && isoDoor.north || bl2 && !isoDoor.north) && (thumpable = isoDoor.getThumpableFor(isoGameCharacter)) != null) {
                thumpable.WeaponHit(isoGameCharacter, handWeapon);
                return true;
            }
            if (isoThumpable != null) {
                if (isoThumpable.isDoor() || isoThumpable.isWindow() || !isoThumpable.isBlockAllTheSquare()) {
                    if ((bl && isoThumpable.north || bl2 && !isoThumpable.north) && (thumpable = isoThumpable.getThumpableFor(isoGameCharacter)) != null) {
                        thumpable.WeaponHit(isoGameCharacter, handWeapon);
                        return true;
                    }
                } else {
                    thumpable = isoThumpable.getThumpableFor(isoGameCharacter);
                    if (thumpable != null) {
                        thumpable.WeaponHit(isoGameCharacter, handWeapon);
                        return true;
                    }
                }
            }
            if (isoWindow == null || (!bl || !isoWindow.north) && (!bl2 || isoWindow.north) || (thumpable = isoWindow.getThumpableFor(isoGameCharacter)) == null) continue;
            thumpable.WeaponHit(isoGameCharacter, handWeapon);
            return true;
        }
        return false;
    }

    private boolean CheckObjectHit(IsoGameCharacter isoGameCharacter, HandWeapon handWeapon) {
        IsoGridSquare isoGridSquare;
        IsoGridSquare isoGridSquare2;
        IsoGridSquare isoGridSquare3;
        IsoCell isoCell;
        IsoGridSquare isoGridSquare4;
        if (isoGameCharacter.isAimAtFloor()) {
            this.bHitOnlyTree = false;
            return false;
        }
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        IsoDirections isoDirections = IsoDirections.fromAngle(isoGameCharacter.getForwardDirection());
        int n3 = 0;
        int n4 = 0;
        if (isoDirections == IsoDirections.NE || isoDirections == IsoDirections.N || isoDirections == IsoDirections.NW) {
            --n4;
        }
        if (isoDirections == IsoDirections.SE || isoDirections == IsoDirections.S || isoDirections == IsoDirections.SW) {
            ++n4;
        }
        if (isoDirections == IsoDirections.NW || isoDirections == IsoDirections.W || isoDirections == IsoDirections.SW) {
            --n3;
        }
        if (isoDirections == IsoDirections.NE || isoDirections == IsoDirections.E || isoDirections == IsoDirections.SE) {
            ++n3;
        }
        if ((isoGridSquare4 = (isoCell = IsoWorld.instance.CurrentCell).getGridSquare((isoGridSquare3 = isoGameCharacter.getCurrentSquare()).getX() + n3, isoGridSquare3.getY() + n4, isoGridSquare3.getZ())) != null) {
            if (this.checkObjectHit(isoGameCharacter, handWeapon, isoGridSquare4, false, false)) {
                bl = true;
                ++n;
            }
            if (!isoGridSquare4.isBlockedTo(isoGridSquare3)) {
                for (int i = 0; i < isoGridSquare4.getObjects().size(); ++i) {
                    IsoObject isoObject = isoGridSquare4.getObjects().get(i);
                    if (!(isoObject instanceof IsoTree)) continue;
                    ((IsoTree)isoObject).WeaponHit(isoGameCharacter, handWeapon);
                    bl = true;
                    ++n;
                    ++n2;
                    if (isoObject.getObjectIndex() != -1) continue;
                    --i;
                }
            }
        }
        if ((isoDirections == IsoDirections.NE || isoDirections == IsoDirections.N || isoDirections == IsoDirections.NW) && this.checkObjectHit(isoGameCharacter, handWeapon, isoGridSquare3, true, false)) {
            bl = true;
            ++n;
        }
        if ((isoDirections == IsoDirections.SE || isoDirections == IsoDirections.S || isoDirections == IsoDirections.SW) && this.checkObjectHit(isoGameCharacter, handWeapon, isoGridSquare2 = isoCell.getGridSquare(isoGridSquare3.getX(), isoGridSquare3.getY() + 1, isoGridSquare3.getZ()), true, false)) {
            bl = true;
            ++n;
        }
        if ((isoDirections == IsoDirections.SE || isoDirections == IsoDirections.E || isoDirections == IsoDirections.NE) && this.checkObjectHit(isoGameCharacter, handWeapon, isoGridSquare = isoCell.getGridSquare(isoGridSquare3.getX() + 1, isoGridSquare3.getY(), isoGridSquare3.getZ()), false, true)) {
            bl = true;
            ++n;
        }
        if ((isoDirections == IsoDirections.NW || isoDirections == IsoDirections.W || isoDirections == IsoDirections.SW) && this.checkObjectHit(isoGameCharacter, handWeapon, isoGridSquare3, false, true)) {
            bl = true;
            ++n;
        }
        this.bHitOnlyTree = bl && n == n2;
        return bl;
    }

    private LosUtil.TestResults los(int n, int n2, int n3, int n4, int n5, LOSVisitor lOSVisitor) {
        IsoCell isoCell = IsoWorld.instance.CurrentCell;
        int n6 = n5;
        int n7 = n5;
        int n8 = n4 - n2;
        int n9 = n3 - n;
        int n10 = n7 - n6;
        float f = 0.5f;
        float f2 = 0.5f;
        IsoGridSquare isoGridSquare = isoCell.getGridSquare(n, n2, n6);
        if (Math.abs(n9) > Math.abs(n8)) {
            float f3 = (float)n8 / (float)n9;
            float f4 = (float)n10 / (float)n9;
            f += (float)n2;
            f2 += (float)n6;
            n9 = n9 < 0 ? -1 : 1;
            f3 *= (float)n9;
            f4 *= (float)n9;
            while (n != n3) {
                IsoGridSquare isoGridSquare2 = isoCell.getGridSquare(n += n9, (int)(f += f3), (int)(f2 += f4));
                if (lOSVisitor.visit(isoGridSquare2, isoGridSquare)) {
                    return lOSVisitor.getResult();
                }
                isoGridSquare = isoGridSquare2;
            }
        } else {
            float f5 = (float)n9 / (float)n8;
            float f6 = (float)n10 / (float)n8;
            f += (float)n;
            f2 += (float)n6;
            n8 = n8 < 0 ? -1 : 1;
            f5 *= (float)n8;
            f6 *= (float)n8;
            while (n2 != n4) {
                IsoGridSquare isoGridSquare3 = isoCell.getGridSquare((int)(f += f5), n2 += n8, (int)(f2 += f6));
                if (lOSVisitor.visit(isoGridSquare3, isoGridSquare)) {
                    return lOSVisitor.getResult();
                }
                isoGridSquare = isoGridSquare3;
            }
        }
        return LosUtil.TestResults.Clear;
    }

    private IsoWindow getWindowBetween(int n, int n2, int n3, int n4, int n5) {
        this.windowVisitor.init();
        this.los(n, n2, n3, n4, n5, this.windowVisitor);
        return this.windowVisitor.window;
    }

    private IsoWindow getWindowBetween(IsoMovingObject isoMovingObject, IsoMovingObject isoMovingObject2) {
        return this.getWindowBetween((int)isoMovingObject.x, (int)isoMovingObject.y, (int)isoMovingObject2.x, (int)isoMovingObject2.y, (int)isoMovingObject.z);
    }

    private boolean isWindowBetween(IsoMovingObject isoMovingObject, IsoMovingObject isoMovingObject2) {
        return this.getWindowBetween(isoMovingObject, isoMovingObject2) != null;
    }

    private void smashWindowBetween(IsoGameCharacter isoGameCharacter, IsoMovingObject isoMovingObject, HandWeapon handWeapon) {
        IsoWindow isoWindow = this.getWindowBetween(isoGameCharacter, isoMovingObject);
        if (isoWindow == null) {
            return;
        }
        isoWindow.WeaponHit(isoGameCharacter, handWeapon);
    }

    public void changeWeapon(HandWeapon handWeapon, IsoGameCharacter isoGameCharacter) {
        if (handWeapon != null && handWeapon.isUseSelf()) {
            isoGameCharacter.getInventory().setDrawDirty(true);
            for (InventoryItem inventoryItem : isoGameCharacter.getInventory().getItems()) {
                if (inventoryItem == handWeapon || !(inventoryItem instanceof HandWeapon) || inventoryItem.getType() != handWeapon.getType() || inventoryItem.getCondition() <= 0) continue;
                if (isoGameCharacter.getPrimaryHandItem() == handWeapon && isoGameCharacter.getSecondaryHandItem() == handWeapon) {
                    isoGameCharacter.setPrimaryHandItem(inventoryItem);
                    isoGameCharacter.setSecondaryHandItem(inventoryItem);
                } else if (isoGameCharacter.getPrimaryHandItem() == handWeapon) {
                    isoGameCharacter.setPrimaryHandItem(inventoryItem);
                } else if (isoGameCharacter.getSecondaryHandItem() == handWeapon) {
                    isoGameCharacter.setSecondaryHandItem(inventoryItem);
                }
                return;
            }
        }
        if (handWeapon == null || handWeapon.getCondition() <= 0 || handWeapon.isUseSelf()) {
            HandWeapon handWeapon2 = (HandWeapon)isoGameCharacter.getInventory().getBestWeapon(isoGameCharacter.getDescriptor());
            isoGameCharacter.setPrimaryHandItem(null);
            if (isoGameCharacter.getSecondaryHandItem() == handWeapon) {
                isoGameCharacter.setSecondaryHandItem(null);
            }
            if (handWeapon2 != null && handWeapon2 != isoGameCharacter.getPrimaryHandItem() && handWeapon2.getCondition() > 0) {
                isoGameCharacter.setPrimaryHandItem(handWeapon2);
                if (handWeapon2.isTwoHandWeapon() && isoGameCharacter.getSecondaryHandItem() == null) {
                    isoGameCharacter.setSecondaryHandItem(handWeapon2);
                }
            }
        }
    }

    private void setParameterCharacterHitResult(IsoGameCharacter isoGameCharacter, IsoZombie isoZombie, long l) {
        if (l == 0L) {
            return;
        }
        int n = 0;
        if (isoZombie != null) {
            if (isoZombie.isDead()) {
                n = 2;
            } else if (isoZombie.isKnockedDown()) {
                n = 1;
            }
        }
        isoGameCharacter.getEmitter().setParameterValue(l, FMODManager.instance.getParameterDescription("CharacterHitResult"), n);
    }

    private static final class WindowVisitor
    implements LOSVisitor {
        LosUtil.TestResults test;
        IsoWindow window;

        private WindowVisitor() {
        }

        void init() {
            this.test = LosUtil.TestResults.Clear;
            this.window = null;
        }

        @Override
        public boolean visit(IsoGridSquare isoGridSquare, IsoGridSquare isoGridSquare2) {
            IsoWindow isoWindow;
            if (isoGridSquare == null || isoGridSquare2 == null) {
                return false;
            }
            boolean bl = true;
            boolean bl2 = false;
            LosUtil.TestResults testResults = isoGridSquare.testVisionAdjacent(isoGridSquare2.getX() - isoGridSquare.getX(), isoGridSquare2.getY() - isoGridSquare.getY(), isoGridSquare2.getZ() - isoGridSquare.getZ(), bl, bl2);
            if (testResults == LosUtil.TestResults.ClearThroughWindow && this.isHittable(isoWindow = isoGridSquare.getWindowTo(isoGridSquare2)) && isoWindow.TestVision(isoGridSquare, isoGridSquare2) == IsoObject.VisionResult.Unblocked) {
                this.window = isoWindow;
                return true;
            }
            if (testResults == LosUtil.TestResults.Blocked || this.test == LosUtil.TestResults.Clear || testResults == LosUtil.TestResults.ClearThroughWindow && this.test == LosUtil.TestResults.ClearThroughOpenDoor) {
                this.test = testResults;
            } else if (testResults == LosUtil.TestResults.ClearThroughClosedDoor && this.test == LosUtil.TestResults.ClearThroughOpenDoor) {
                this.test = testResults;
            }
            return this.test == LosUtil.TestResults.Blocked;
        }

        @Override
        public LosUtil.TestResults getResult() {
            return this.test;
        }

        boolean isHittable(IsoWindow isoWindow) {
            if (isoWindow == null) {
                return false;
            }
            if (isoWindow.isBarricaded()) {
                return true;
            }
            return !isoWindow.isDestroyed() && !isoWindow.IsOpen();
        }
    }

    public static class CustomComparator
    implements Comparator<HitInfo> {
        @Override
        public int compare(HitInfo hitInfo, HitInfo hitInfo2) {
            float f = hitInfo.distSq;
            float f2 = hitInfo2.distSq;
            IsoZombie isoZombie = Type.tryCastTo(hitInfo.getObject(), IsoZombie.class);
            IsoZombie isoZombie2 = Type.tryCastTo(hitInfo2.getObject(), IsoZombie.class);
            if (isoZombie != null && isoZombie2 != null) {
                boolean bl = SwipeStatePlayer.isProne(isoZombie);
                boolean bl2 = SwipeStatePlayer.isProne(isoZombie2);
                boolean bl3 = isoZombie.isCurrentState(ZombieGetUpState.instance());
                boolean bl4 = isoZombie2.isCurrentState(ZombieGetUpState.instance());
                if (bl3 && !bl4 && bl2) {
                    return -1;
                }
                if (!bl3 && bl && bl4) {
                    return 1;
                }
                if (bl && bl2) {
                    if (isoZombie.isCrawling() && !isoZombie2.isCrawling()) {
                        return -1;
                    }
                    if (!isoZombie.isCrawling() && isoZombie2.isCrawling()) {
                        return 1;
                    }
                }
            }
            if (f > f2) {
                return 1;
            }
            if (f2 > f) {
                return -1;
            }
            return 0;
        }
    }

    private static interface LOSVisitor {
        public boolean visit(IsoGridSquare var1, IsoGridSquare var2);

        public LosUtil.TestResults getResult();
    }
}

