/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import zombie.ai.State;
import zombie.audio.parameters.ParameterZombieState;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoZombie;
import zombie.core.skinnedmodel.advancedanimation.AnimEvent;

public final class StaggerBackState
extends State {
    private static final StaggerBackState _instance = new StaggerBackState();

    public static StaggerBackState instance() {
        return _instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        isoGameCharacter.setStateEventDelayTimer(this.getMaxStaggerTime(isoGameCharacter));
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
        if (isoGameCharacter.hasAnimationPlayer()) {
            isoGameCharacter.getAnimationPlayer().setTargetToAngle();
        }
        isoGameCharacter.getVectorFromDirection(isoGameCharacter.getForwardDirection());
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
        if (isoGameCharacter.isZombie()) {
            ((IsoZombie)isoGameCharacter).setStaggerBack(false);
        }
        isoGameCharacter.setShootable(true);
    }

    private float getMaxStaggerTime(IsoGameCharacter isoGameCharacter) {
        float f = 35.0f * isoGameCharacter.getHitForce() * isoGameCharacter.getStaggerTimeMod();
        if (f < 20.0f) {
            return 20.0f;
        }
        if (f > 30.0f) {
            return 30.0f;
        }
        return f;
    }

    @Override
    public void animEvent(IsoGameCharacter isoGameCharacter, AnimEvent animEvent) {
        if (animEvent.m_EventName.equalsIgnoreCase("FallOnFront")) {
            isoGameCharacter.setFallOnFront(Boolean.parseBoolean(animEvent.m_ParameterValue));
        }
        if (animEvent.m_EventName.equalsIgnoreCase("SetState")) {
            IsoZombie isoZombie = (IsoZombie)isoGameCharacter;
            isoZombie.parameterZombieState.setState(ParameterZombieState.State.Pushed);
        }
    }
}

