/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import java.util.HashMap;
import zombie.ai.State;
import zombie.ai.states.IdleState;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.Rand;
import zombie.core.skinnedmodel.advancedanimation.AnimEvent;
import zombie.inventory.types.HandWeapon;
import zombie.iso.IsoGridSquare;
import zombie.iso.objects.IsoFireplace;
import zombie.util.StringUtils;
import zombie.util.Type;

public final class PlayerSitOnGroundState
extends State {
    private static final PlayerSitOnGroundState _instance = new PlayerSitOnGroundState();
    private static final int RAND_EXT = 2500;
    private static final Integer PARAM_FIRE = 0;
    private static final Integer PARAM_SITGROUNDANIM = 1;
    private static final Integer PARAM_CHECK_FIRE = 2;
    private static final Integer PARAM_CHANGE_ANIM = 3;

    public static PlayerSitOnGroundState instance() {
        return _instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        hashMap.put(PARAM_FIRE, this.checkFire(isoGameCharacter));
        hashMap.put(PARAM_CHECK_FIRE, System.currentTimeMillis());
        hashMap.put(PARAM_CHANGE_ANIM, 0L);
        isoGameCharacter.setSitOnGround(true);
        if (!(isoGameCharacter.getPrimaryHandItem() != null && isoGameCharacter.getPrimaryHandItem() instanceof HandWeapon || isoGameCharacter.getSecondaryHandItem() != null && isoGameCharacter.getSecondaryHandItem() instanceof HandWeapon)) {
            isoGameCharacter.setHideWeaponModel(true);
        }
        if (isoGameCharacter.getStateMachine().getPrevious() == IdleState.instance()) {
            isoGameCharacter.clearVariable("SitGroundStarted");
            isoGameCharacter.clearVariable("forceGetUp");
            isoGameCharacter.clearVariable("SitGroundAnim");
        }
    }

    private boolean checkFire(IsoGameCharacter isoGameCharacter) {
        IsoGridSquare isoGridSquare = isoGameCharacter.getCurrentSquare();
        for (int i = -4; i < 4; ++i) {
            for (int j = -4; j < 4; ++j) {
                IsoGridSquare isoGridSquare2 = isoGridSquare.getCell().getGridSquare(isoGridSquare.x + i, isoGridSquare.y + j, isoGridSquare.z);
                if (isoGridSquare2 == null) continue;
                if (isoGridSquare2.haveFire()) {
                    return true;
                }
                for (int k = 0; k < isoGridSquare2.getObjects().size(); ++k) {
                    IsoFireplace isoFireplace = Type.tryCastTo(isoGridSquare2.getObjects().get(k), IsoFireplace.class);
                    if (isoFireplace == null || !isoFireplace.isLit()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
        boolean bl;
        long l;
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        IsoPlayer isoPlayer = (IsoPlayer)isoGameCharacter;
        if (isoPlayer.pressedMovement(false)) {
            isoGameCharacter.StopAllActionQueue();
            isoGameCharacter.setVariable("forceGetUp", true);
        }
        if ((l = System.currentTimeMillis()) > (Long)hashMap.get(PARAM_CHECK_FIRE) + 5000L) {
            hashMap.put(PARAM_FIRE, this.checkFire(isoGameCharacter));
            hashMap.put(PARAM_CHECK_FIRE, l);
        }
        if (isoGameCharacter.hasTimedActions()) {
            hashMap.put(PARAM_FIRE, false);
            isoGameCharacter.setVariable("SitGroundAnim", "Idle");
        }
        if (bl = ((Boolean)hashMap.get(PARAM_FIRE)).booleanValue()) {
            boolean bl2;
            boolean bl3 = bl2 = l > (Long)hashMap.get(PARAM_CHANGE_ANIM);
            if (bl2) {
                if ("Idle".equals(isoGameCharacter.getVariableString("SitGroundAnim"))) {
                    isoGameCharacter.setVariable("SitGroundAnim", "WarmHands");
                } else if ("WarmHands".equals(isoGameCharacter.getVariableString("SitGroundAnim"))) {
                    isoGameCharacter.setVariable("SitGroundAnim", "Idle");
                }
                hashMap.put(PARAM_CHANGE_ANIM, l + (long)Rand.Next(30000, 90000));
            }
        } else if (isoGameCharacter.getVariableBoolean("SitGroundStarted")) {
            isoGameCharacter.clearVariable("FireNear");
            isoGameCharacter.setVariable("SitGroundAnim", "Idle");
        }
        if ("WarmHands".equals(isoGameCharacter.getVariableString("SitGroundAnim")) && Rand.Next(Rand.AdjustForFramerate(2500)) == 0) {
            hashMap.put(PARAM_SITGROUNDANIM, isoGameCharacter.getVariableString("SitGroundAnim"));
            isoGameCharacter.setVariable("SitGroundAnim", "rubhands");
        }
        isoPlayer.setInitiateAttack(false);
        isoPlayer.attackStarted = false;
        isoPlayer.setAttackType(null);
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
        isoGameCharacter.setHideWeaponModel(false);
        if (StringUtils.isNullOrEmpty(isoGameCharacter.getVariableString("HitReaction"))) {
            isoGameCharacter.clearVariable("SitGroundStarted");
            isoGameCharacter.clearVariable("forceGetUp");
            isoGameCharacter.clearVariable("SitGroundAnim");
            isoGameCharacter.setIgnoreMovement(false);
        }
    }

    @Override
    public void animEvent(IsoGameCharacter isoGameCharacter, AnimEvent animEvent) {
        if (animEvent.m_EventName.equalsIgnoreCase("SitGroundStarted")) {
            isoGameCharacter.setVariable("SitGroundStarted", true);
            boolean bl = (Boolean)isoGameCharacter.getStateMachineParams(this).get(PARAM_FIRE);
            if (bl) {
                isoGameCharacter.setVariable("SitGroundAnim", "WarmHands");
            } else {
                isoGameCharacter.setVariable("SitGroundAnim", "Idle");
            }
        }
        if (animEvent.m_EventName.equalsIgnoreCase("ResetSitOnGroundAnim")) {
            isoGameCharacter.setVariable("SitGroundAnim", (String)isoGameCharacter.getStateMachineParams(this).get(PARAM_SITGROUNDANIM));
        }
    }
}

