/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import zombie.ai.State;
import zombie.characters.IsoGameCharacter;
import zombie.core.skinnedmodel.advancedanimation.AnimEvent;
import zombie.network.GameClient;
import zombie.network.GameServer;

public final class PlayerFallDownState
extends State {
    private static final PlayerFallDownState _instance = new PlayerFallDownState();

    public static PlayerFallDownState instance() {
        return _instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        isoGameCharacter.setIgnoreMovement(true);
        isoGameCharacter.clearVariable("bKnockedDown");
        if (isoGameCharacter.isDead() && !GameServer.bServer && !GameClient.bClient) {
            isoGameCharacter.Kill(null);
        }
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
        isoGameCharacter.setIgnoreMovement(false);
        isoGameCharacter.setOnFloor(true);
    }

    @Override
    public void animEvent(IsoGameCharacter isoGameCharacter, AnimEvent animEvent) {
        if (GameClient.bClient && animEvent.m_EventName.equalsIgnoreCase("FallOnFront")) {
            isoGameCharacter.setFallOnFront(Boolean.parseBoolean(animEvent.m_ParameterValue));
        }
    }
}

