/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import java.util.HashMap;
import org.joml.Vector3f;
import zombie.GameTime;
import zombie.ai.State;
import zombie.ai.states.WalkTowardNetworkState;
import zombie.audio.parameters.ParameterZombieState;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.gameStates.IngameState;
import zombie.iso.Vector2;
import zombie.util.Type;

public class LungeNetworkState
extends State {
    static LungeNetworkState _instance = new LungeNetworkState();
    private Vector2 temp = new Vector2();
    private final Vector3f worldPos = new Vector3f();
    private static final Integer PARAM_TICK_COUNT = 0;

    public static LungeNetworkState instance() {
        return _instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        WalkTowardNetworkState.instance().enter(isoGameCharacter);
        IsoZombie isoZombie = (IsoZombie)isoGameCharacter;
        isoZombie.LungeTimer = 180.0f;
        hashMap.put(PARAM_TICK_COUNT, IngameState.instance.numberTicks);
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
        HashMap<Object, Object> hashMap;
        long l;
        WalkTowardNetworkState.instance().execute(isoGameCharacter);
        IsoZombie isoZombie = (IsoZombie)isoGameCharacter;
        isoGameCharacter.setOnFloor(false);
        isoGameCharacter.setShootable(true);
        if (isoZombie.bLunger) {
            isoZombie.walkVariantUse = "ZombieWalk3";
        }
        isoZombie.LungeTimer -= GameTime.getInstance().getMultiplier() / 1.6f;
        IsoPlayer isoPlayer = Type.tryCastTo(isoZombie.getTarget(), IsoPlayer.class);
        if (isoPlayer != null && isoPlayer.isGhostMode()) {
            isoZombie.LungeTimer = 0.0f;
        }
        if (isoZombie.LungeTimer < 0.0f) {
            isoZombie.LungeTimer = 0.0f;
        }
        if (isoZombie.LungeTimer <= 0.0f) {
            isoZombie.AllowRepathDelay = 0.0f;
        }
        if (IngameState.instance.numberTicks - (l = ((Long)(hashMap = isoGameCharacter.getStateMachineParams(this)).get(PARAM_TICK_COUNT)).longValue()) == 2L) {
            ((IsoZombie)isoGameCharacter).parameterZombieState.setState(ParameterZombieState.State.LockTarget);
        }
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
        WalkTowardNetworkState.instance().exit(isoGameCharacter);
    }

    @Override
    public boolean isMoving(IsoGameCharacter isoGameCharacter) {
        return true;
    }
}

