/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import zombie.GameTime;
import zombie.ai.State;
import zombie.characters.IsoGameCharacter;

public final class ForecastBeatenPlayerState
extends State {
    private static final ForecastBeatenPlayerState _instance = new ForecastBeatenPlayerState();

    public static ForecastBeatenPlayerState instance() {
        return _instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        isoGameCharacter.setIgnoreMovement(true);
        isoGameCharacter.setReanimateTimer(30.0f);
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
        if (isoGameCharacter.getCurrentSquare() == null) {
            return;
        }
        isoGameCharacter.setReanimateTimer(isoGameCharacter.getReanimateTimer() - GameTime.getInstance().getMultiplier() / 1.6f);
        if (isoGameCharacter.getReanimateTimer() <= 0.0f) {
            isoGameCharacter.setReanimateTimer(0.0f);
            isoGameCharacter.setVariable("bKnockedDown", true);
        }
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
        isoGameCharacter.setIgnoreMovement(false);
    }
}

