/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import zombie.ai.State;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.Rand;
import zombie.core.skinnedmodel.advancedanimation.AnimEvent;
import zombie.debug.DebugLog;
import zombie.network.GameClient;

public final class FishingState
extends State {
    private static final FishingState _instance = new FishingState();
    float pauseTime = 0.0f;
    private String stage = null;

    public static FishingState instance() {
        return _instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        DebugLog.log("FISHINGSTATE - ENTER");
        isoGameCharacter.setVariable("FishingFinished", false);
        this.pauseTime = Rand.Next(60.0f, 120.0f);
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
        String string;
        if (GameClient.bClient && isoGameCharacter instanceof IsoPlayer && ((IsoPlayer)isoGameCharacter).isLocalPlayer() && (string = isoGameCharacter.getVariableString("FishingStage")) != null && !string.equals(this.stage)) {
            this.stage = string;
            if (!string.equals("idle")) {
                GameClient.sendEvent((IsoPlayer)isoGameCharacter, "EventFishing");
            }
        }
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
        DebugLog.log("FISHINGSTATE - EXIT");
        isoGameCharacter.clearVariable("FishingStage");
        isoGameCharacter.clearVariable("FishingFinished");
    }

    @Override
    public void animEvent(IsoGameCharacter isoGameCharacter, AnimEvent animEvent) {
    }
}

