/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import java.util.HashMap;
import zombie.GameTime;
import zombie.ai.State;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.Moodles.MoodleType;
import zombie.characters.skills.PerkFactory;
import zombie.core.Core;
import zombie.core.skinnedmodel.advancedanimation.AnimEvent;
import zombie.debug.DebugOptions;
import zombie.iso.IsoDirections;
import zombie.iso.objects.IsoWindow;

public final class CloseWindowState
extends State {
    private static final CloseWindowState _instance = new CloseWindowState();

    public static CloseWindowState instance() {
        return _instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        isoGameCharacter.setIgnoreMovement(true);
        isoGameCharacter.setHideWeaponModel(true);
        IsoWindow isoWindow = (IsoWindow)hashMap.get(0);
        if (Core.bDebug && DebugOptions.instance.CheatWindowUnlock.getValue()) {
            isoWindow.Locked = false;
            isoWindow.PermaLocked = false;
        }
        if (isoWindow.north) {
            if ((float)isoWindow.getSquare().getY() < isoGameCharacter.getY()) {
                isoGameCharacter.setDir(IsoDirections.N);
            } else {
                isoGameCharacter.setDir(IsoDirections.S);
            }
        } else if ((float)isoWindow.getSquare().getX() < isoGameCharacter.getX()) {
            isoGameCharacter.setDir(IsoDirections.W);
        } else {
            isoGameCharacter.setDir(IsoDirections.E);
        }
        isoGameCharacter.setVariable("bCloseWindow", true);
        isoGameCharacter.clearVariable("BlockWindow");
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        if (!isoGameCharacter.getVariableBoolean("bCloseWindow")) {
            return;
        }
        IsoPlayer isoPlayer = (IsoPlayer)isoGameCharacter;
        if (isoPlayer.pressedMovement(false) || isoPlayer.pressedCancelAction()) {
            isoGameCharacter.setVariable("bCloseWindow", false);
            return;
        }
        if (!(hashMap.get(0) instanceof IsoWindow)) {
            isoGameCharacter.setVariable("bCloseWindow", false);
            return;
        }
        IsoWindow isoWindow = (IsoWindow)hashMap.get(0);
        if (isoWindow == null || isoWindow.getObjectIndex() == -1) {
            isoGameCharacter.setVariable("bCloseWindow", false);
            return;
        }
        isoPlayer.setCollidable(true);
        isoPlayer.updateLOS();
        if (isoWindow.north) {
            if ((float)isoWindow.getSquare().getY() < isoGameCharacter.getY()) {
                isoGameCharacter.setDir(IsoDirections.N);
            } else {
                isoGameCharacter.setDir(IsoDirections.S);
            }
        } else if ((float)isoWindow.getSquare().getX() < isoGameCharacter.getX()) {
            isoGameCharacter.setDir(IsoDirections.W);
        } else {
            isoGameCharacter.setDir(IsoDirections.E);
        }
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
        isoGameCharacter.clearVariable("BlockWindow");
        isoGameCharacter.clearVariable("bCloseWindow");
        isoGameCharacter.clearVariable("CloseWindowOutcome");
        isoGameCharacter.clearVariable("StopAfterAnimLooped");
        isoGameCharacter.setIgnoreMovement(false);
        isoGameCharacter.setHideWeaponModel(false);
    }

    @Override
    public void animEvent(IsoGameCharacter isoGameCharacter, AnimEvent animEvent) {
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        if (!isoGameCharacter.getVariableBoolean("bCloseWindow")) {
            return;
        }
        if (!(hashMap.get(0) instanceof IsoWindow)) {
            isoGameCharacter.setVariable("bCloseWindow", false);
            return;
        }
        IsoWindow isoWindow = (IsoWindow)hashMap.get(0);
        if (animEvent.m_EventName.equalsIgnoreCase("WindowAnimLooped")) {
            if ("start".equalsIgnoreCase(animEvent.m_ParameterValue)) {
                int n = Math.max(5 - isoGameCharacter.getMoodles().getMoodleLevel(MoodleType.Panic), 1);
                if (isoWindow.isPermaLocked() || isoWindow.getFirstCharacterClimbingThrough() != null) {
                    isoGameCharacter.setVariable("CloseWindowOutcome", "struggle");
                } else {
                    isoGameCharacter.setVariable("CloseWindowOutcome", "success");
                }
                return;
            }
            if (animEvent.m_ParameterValue.equalsIgnoreCase(isoGameCharacter.getVariableString("StopAfterAnimLooped"))) {
                isoGameCharacter.setVariable("bCloseWindow", false);
            }
        }
        if (animEvent.m_EventName.equalsIgnoreCase("WindowCloseAttempt")) {
            this.onAttemptFinished(isoGameCharacter, isoWindow);
        } else if (animEvent.m_EventName.equalsIgnoreCase("WindowCloseSuccess")) {
            this.onSuccess(isoGameCharacter, isoWindow);
        }
    }

    @Override
    public boolean isDoingActionThatCanBeCancelled() {
        return true;
    }

    private void onAttemptFinished(IsoGameCharacter isoGameCharacter, IsoWindow isoWindow) {
        this.exert(isoGameCharacter);
        if (isoWindow.isPermaLocked()) {
            isoGameCharacter.getEmitter().playSound("WindowIsLocked", isoWindow);
            isoGameCharacter.setVariable("CloseWindowOutcome", "fail");
            isoGameCharacter.setVariable("StopAfterAnimLooped", "fail");
            return;
        }
        int n = Math.max(5 - isoGameCharacter.getMoodles().getMoodleLevel(MoodleType.Panic), 3);
        if (isoWindow.isPermaLocked() || isoWindow.getFirstCharacterClimbingThrough() != null) {
            isoGameCharacter.setVariable("CloseWindowOutcome", "struggle");
        } else {
            isoGameCharacter.setVariable("CloseWindowOutcome", "success");
        }
    }

    private void onSuccess(IsoGameCharacter isoGameCharacter, IsoWindow isoWindow) {
        isoGameCharacter.setVariable("StopAfterAnimLooped", "success");
        IsoPlayer.getInstance().ContextPanic = 0.0f;
        if (isoWindow.getObjectIndex() != -1 && isoWindow.open) {
            isoWindow.ToggleWindow(isoGameCharacter);
        }
    }

    private void exert(IsoGameCharacter isoGameCharacter) {
        float f = GameTime.getInstance().getMultiplier() / 1.6f;
        switch (isoGameCharacter.getPerkLevel(PerkFactory.Perks.Fitness)) {
            case 1: {
                isoGameCharacter.exert(0.01f * f);
                break;
            }
            case 2: {
                isoGameCharacter.exert(0.009f * f);
                break;
            }
            case 3: {
                isoGameCharacter.exert(0.008f * f);
                break;
            }
            case 4: {
                isoGameCharacter.exert(0.007f * f);
                break;
            }
            case 5: {
                isoGameCharacter.exert(0.006f * f);
                break;
            }
            case 6: {
                isoGameCharacter.exert(0.005f * f);
                break;
            }
            case 7: {
                isoGameCharacter.exert(0.004f * f);
                break;
            }
            case 8: {
                isoGameCharacter.exert(0.003f * f);
                break;
            }
            case 9: {
                isoGameCharacter.exert(0.0025f * f);
                break;
            }
            case 10: {
                isoGameCharacter.exert(0.002f * f);
            }
        }
    }

    public IsoWindow getWindow(IsoGameCharacter isoGameCharacter) {
        if (!isoGameCharacter.isCurrentState(this)) {
            return null;
        }
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        return (IsoWindow)hashMap.get(0);
    }
}

