/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import fmod.fmod.FMODManager;
import java.util.HashMap;
import zombie.GameTime;
import zombie.ZomboidGlobals;
import zombie.ai.State;
import zombie.ai.states.AttackState;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.characters.Moodles.MoodleType;
import zombie.characters.skills.PerkFactory;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.math.PZMath;
import zombie.core.properties.PropertyContainer;
import zombie.core.skinnedmodel.advancedanimation.AnimEvent;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.SpriteDetails.IsoObjectType;

public final class ClimbOverWallState
extends State {
    private static final ClimbOverWallState _instance = new ClimbOverWallState();
    static final Integer PARAM_START_X = 0;
    static final Integer PARAM_START_Y = 1;
    static final Integer PARAM_Z = 2;
    static final Integer PARAM_END_X = 3;
    static final Integer PARAM_END_Y = 4;
    static final Integer PARAM_DIR = 5;
    static final int FENCE_TYPE_WOOD = 0;
    static final int FENCE_TYPE_METAL = 1;
    static final int FENCE_TYPE_METAL_BARS = 2;

    public static ClimbOverWallState instance() {
        return _instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        isoGameCharacter.setIgnoreMovement(true);
        isoGameCharacter.setHideWeaponModel(true);
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        isoGameCharacter.getStats().endurance = (float)((double)isoGameCharacter.getStats().endurance - ZomboidGlobals.RunningEnduranceReduce * 1200.0);
        IsoPlayer isoPlayer = (IsoPlayer)isoGameCharacter;
        boolean bl = isoPlayer.isClimbOverWallStruggle();
        if (bl) {
            isoGameCharacter.getStats().endurance = (float)((double)isoGameCharacter.getStats().endurance - ZomboidGlobals.RunningEnduranceReduce * 500.0);
        }
        boolean bl2 = isoPlayer.isClimbOverWallSuccess();
        isoGameCharacter.setVariable("ClimbFenceFinished", false);
        isoGameCharacter.setVariable("ClimbFenceOutcome", bl2 ? "success" : "fail");
        isoGameCharacter.setVariable("ClimbFenceStarted", false);
        isoGameCharacter.setVariable("ClimbFenceStruggle", bl);
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        IsoDirections isoDirections = (IsoDirections)((Object)hashMap.get(PARAM_DIR));
        isoGameCharacter.setAnimated(true);
        isoGameCharacter.setDir(isoDirections);
        boolean bl = isoGameCharacter.getVariableBoolean("ClimbFenceStarted");
        if (!bl) {
            int n = (Integer)hashMap.get(PARAM_START_X);
            int n2 = (Integer)hashMap.get(PARAM_START_Y);
            float f = 0.15f;
            float f2 = isoGameCharacter.getX();
            float f3 = isoGameCharacter.getY();
            switch (isoDirections) {
                case N: {
                    f3 = (float)n2 + f;
                    break;
                }
                case S: {
                    f3 = (float)(n2 + 1) - f;
                    break;
                }
                case W: {
                    f2 = (float)n + f;
                    break;
                }
                case E: {
                    f2 = (float)(n + 1) - f;
                }
            }
            float f4 = GameTime.getInstance().getMultiplier() / 1.6f / 8.0f;
            isoGameCharacter.setX(isoGameCharacter.x + (f2 - isoGameCharacter.x) * f4);
            isoGameCharacter.setY(isoGameCharacter.y + (f3 - isoGameCharacter.y) * f4);
        }
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
        isoGameCharacter.clearVariable("ClimbFenceFinished");
        isoGameCharacter.clearVariable("ClimbFenceOutcome");
        isoGameCharacter.clearVariable("ClimbFenceStarted");
        isoGameCharacter.clearVariable("ClimbFenceStruggle");
        isoGameCharacter.setIgnoreMovement(false);
        isoGameCharacter.setHideWeaponModel(false);
        if (isoGameCharacter instanceof IsoZombie) {
            ((IsoZombie)isoGameCharacter).networkAI.isClimbing = false;
        }
    }

    @Override
    public void animEvent(IsoGameCharacter isoGameCharacter, AnimEvent animEvent) {
        if (animEvent.m_EventName.equalsIgnoreCase("PlayFenceSound")) {
            IsoObject isoObject = this.getFence(isoGameCharacter);
            if (isoObject == null) {
                return;
            }
            int n = this.getFenceType(isoObject);
            long l = isoGameCharacter.getEmitter().playSoundImpl(animEvent.m_ParameterValue, null);
            isoGameCharacter.getEmitter().setParameterValue(l, FMODManager.instance.getParameterDescription("FenceTypeHigh"), n);
        }
    }

    @Override
    public boolean isIgnoreCollide(IsoGameCharacter isoGameCharacter, int n, int n2, int n3, int n4, int n5, int n6) {
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        int n7 = (Integer)hashMap.get(PARAM_START_X);
        int n8 = (Integer)hashMap.get(PARAM_START_Y);
        int n9 = (Integer)hashMap.get(PARAM_END_X);
        int n10 = (Integer)hashMap.get(PARAM_END_Y);
        int n11 = (Integer)hashMap.get(PARAM_Z);
        if (n11 != n3 || n11 != n6) {
            return false;
        }
        int n12 = PZMath.min(n7, n9);
        int n13 = PZMath.min(n8, n10);
        int n14 = PZMath.max(n7, n9);
        int n15 = PZMath.max(n8, n10);
        int n16 = PZMath.min(n, n4);
        int n17 = PZMath.min(n2, n5);
        int n18 = PZMath.max(n, n4);
        int n19 = PZMath.max(n2, n5);
        return n12 <= n16 && n13 <= n17 && n14 >= n18 && n15 >= n19;
    }

    private IsoObject getClimbableWallN(IsoGridSquare isoGridSquare) {
        IsoObject[] isoObjectArray = isoGridSquare.getObjects().getElements();
        int n = isoGridSquare.getObjects().size();
        for (int i = 0; i < n; ++i) {
            IsoObject isoObject = isoObjectArray[i];
            PropertyContainer propertyContainer = isoObject.getProperties();
            if (propertyContainer == null || propertyContainer.Is(IsoFlagType.CantClimb) || isoObject.getType() != IsoObjectType.wall || !propertyContainer.Is(IsoFlagType.collideN) || propertyContainer.Is(IsoFlagType.HoppableN)) continue;
            return isoObject;
        }
        return null;
    }

    private IsoObject getClimbableWallW(IsoGridSquare isoGridSquare) {
        IsoObject[] isoObjectArray = isoGridSquare.getObjects().getElements();
        int n = isoGridSquare.getObjects().size();
        for (int i = 0; i < n; ++i) {
            IsoObject isoObject = isoObjectArray[i];
            PropertyContainer propertyContainer = isoObject.getProperties();
            if (propertyContainer == null || propertyContainer.Is(IsoFlagType.CantClimb) || isoObject.getType() != IsoObjectType.wall || !propertyContainer.Is(IsoFlagType.collideW) || propertyContainer.Is(IsoFlagType.HoppableW)) continue;
            return isoObject;
        }
        return null;
    }

    private IsoObject getFence(IsoGameCharacter isoGameCharacter) {
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        int n = (Integer)hashMap.get(PARAM_START_X);
        int n2 = (Integer)hashMap.get(PARAM_START_Y);
        int n3 = (Integer)hashMap.get(PARAM_Z);
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n, n2, n3);
        int n4 = (Integer)hashMap.get(PARAM_END_X);
        int n5 = (Integer)hashMap.get(PARAM_END_Y);
        IsoGridSquare isoGridSquare2 = IsoWorld.instance.CurrentCell.getGridSquare(n4, n5, n3);
        if (isoGridSquare == null || isoGridSquare2 == null) {
            return null;
        }
        IsoDirections isoDirections = (IsoDirections)((Object)hashMap.get(PARAM_DIR));
        return switch (isoDirections) {
            case IsoDirections.N -> this.getClimbableWallN(isoGridSquare);
            case IsoDirections.E -> this.getClimbableWallW(isoGridSquare2);
            case IsoDirections.W -> this.getClimbableWallW(isoGridSquare);
            case IsoDirections.S -> this.getClimbableWallN(isoGridSquare2);
            default -> null;
        };
    }

    private int getFenceType(IsoObject isoObject) {
        if (isoObject.getSprite() == null) {
            return 0;
        }
        PropertyContainer propertyContainer = isoObject.getSprite().getProperties();
        String string = propertyContainer.Val("FenceTypeHigh");
        if (string != null) {
            return switch (string) {
                case "Wood" -> 0;
                case "Metal" -> 1;
                case "MetalGate" -> 2;
                default -> 0;
            };
        }
        return 0;
    }

    public void setParams(IsoGameCharacter isoGameCharacter, IsoDirections isoDirections) {
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        int n = isoGameCharacter.getSquare().getX();
        int n2 = isoGameCharacter.getSquare().getY();
        int n3 = isoGameCharacter.getSquare().getZ();
        int n4 = n;
        int n5 = n2;
        int n6 = n;
        int n7 = n2;
        switch (isoDirections) {
            case N: {
                --n7;
                break;
            }
            case S: {
                ++n7;
                break;
            }
            case W: {
                --n6;
                break;
            }
            case E: {
                ++n6;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid direction");
            }
        }
        hashMap.put(PARAM_START_X, n4);
        hashMap.put(PARAM_START_Y, n5);
        hashMap.put(PARAM_Z, n3);
        hashMap.put(PARAM_END_X, n6);
        hashMap.put(PARAM_END_Y, n7);
        hashMap.put(PARAM_DIR, (Object)isoDirections);
        IsoPlayer isoPlayer = (IsoPlayer)isoGameCharacter;
        if (isoPlayer.isLocalPlayer()) {
            int n8;
            IsoGridSquare isoGridSquare;
            int n9 = 20;
            n9 += isoGameCharacter.getPerkLevel(PerkFactory.Perks.Fitness) * 2;
            n9 += isoGameCharacter.getPerkLevel(PerkFactory.Perks.Strength) * 2;
            n9 -= isoGameCharacter.getMoodles().getMoodleLevel(MoodleType.Endurance) * 5;
            n9 -= isoGameCharacter.getMoodles().getMoodleLevel(MoodleType.HeavyLoad) * 8;
            if (isoGameCharacter.getTraits().contains("Emaciated") || isoGameCharacter.Traits.Obese.isSet() || isoGameCharacter.getTraits().contains("Very Underweight")) {
                n9 -= 25;
            }
            if (isoGameCharacter.getTraits().contains("Underweight") || isoGameCharacter.getTraits().contains("Overweight")) {
                n9 -= 15;
            }
            if ((isoGridSquare = isoGameCharacter.getCurrentSquare()) != null) {
                for (n8 = 0; n8 < isoGridSquare.getMovingObjects().size(); n8 += 1) {
                    IsoMovingObject isoMovingObject = isoGridSquare.getMovingObjects().get(n8);
                    if (!(isoMovingObject instanceof IsoZombie)) continue;
                    if (((IsoZombie)isoMovingObject).target == isoGameCharacter && ((IsoZombie)isoMovingObject).getCurrentState() == AttackState.instance()) {
                        n9 -= 25;
                        continue;
                    }
                    n9 -= 7;
                }
            }
            n9 = Math.max(0, n9);
            n8 = Rand.NextBool(n9 / 2) ? 1 : 0;
            if ("Tutorial".equals(Core.GameMode)) {
                n8 = 0;
            }
            boolean bl = !Rand.NextBool(n9);
            isoPlayer.setClimbOverWallStruggle(n8 != 0);
            isoPlayer.setClimbOverWallSuccess(bl);
        }
    }
}

