/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import java.util.HashMap;
import zombie.GameTime;
import zombie.ai.State;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.skills.PerkFactory;
import zombie.iso.IsoCell;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoWorld;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.objects.IsoWindow;

public final class ClimbDownSheetRopeState
extends State {
    public static final float CLIMB_DOWN_SPEED = 0.16f;
    private static final float CLIMB_DOWN_SLOWDOWN = 0.5f;
    private static final ClimbDownSheetRopeState _instance = new ClimbDownSheetRopeState();

    public static ClimbDownSheetRopeState instance() {
        return _instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        isoGameCharacter.setIgnoreMovement(true);
        isoGameCharacter.setHideWeaponModel(true);
        isoGameCharacter.setbClimbing(true);
        isoGameCharacter.setVariable("ClimbRope", true);
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
        float f;
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (isoGameCharacter.getCurrentSquare().getProperties().Is(IsoFlagType.climbSheetTopN) || isoGameCharacter.getCurrentSquare().getProperties().Is(IsoFlagType.climbSheetN)) {
            isoGameCharacter.setDir(IsoDirections.N);
            f2 = 0.54f;
            f3 = 0.39f;
        }
        if (isoGameCharacter.getCurrentSquare().getProperties().Is(IsoFlagType.climbSheetTopS) || isoGameCharacter.getCurrentSquare().getProperties().Is(IsoFlagType.climbSheetS)) {
            isoGameCharacter.setDir(IsoDirections.S);
            f2 = 0.118f;
            f3 = 0.5756f;
        }
        if (isoGameCharacter.getCurrentSquare().getProperties().Is(IsoFlagType.climbSheetTopW) || isoGameCharacter.getCurrentSquare().getProperties().Is(IsoFlagType.climbSheetW)) {
            isoGameCharacter.setDir(IsoDirections.W);
            f2 = 0.4f;
            f3 = 0.7f;
        }
        if (isoGameCharacter.getCurrentSquare().getProperties().Is(IsoFlagType.climbSheetTopE) || isoGameCharacter.getCurrentSquare().getProperties().Is(IsoFlagType.climbSheetE)) {
            isoGameCharacter.setDir(IsoDirections.E);
            f2 = 0.5417f;
            f3 = 0.3144f;
        }
        float f4 = isoGameCharacter.x - (float)((int)isoGameCharacter.x);
        float f5 = isoGameCharacter.y - (float)((int)isoGameCharacter.y);
        if (f4 != f2) {
            f = (f2 - f4) / 4.0f;
            isoGameCharacter.x = (float)((int)isoGameCharacter.x) + (f4 += f);
        }
        if (f5 != f3) {
            f = (f3 - f5) / 4.0f;
            isoGameCharacter.y = (float)((int)isoGameCharacter.y) + (f5 += f);
        }
        isoGameCharacter.nx = isoGameCharacter.x;
        isoGameCharacter.ny = isoGameCharacter.y;
        isoGameCharacter.getSpriteDef().AnimFrameIncrease = f = this.getClimbDownSheetRopeSpeed(isoGameCharacter);
        float f6 = isoGameCharacter.z - f / 10.0f * GameTime.instance.getMultiplier();
        f6 = Math.max(f6, 0.0f);
        for (int i = (int)isoGameCharacter.z; i >= (int)f6; --i) {
            IsoCell isoCell = IsoWorld.instance.getCell();
            IsoGridSquare isoGridSquare = isoCell.getGridSquare(isoGameCharacter.getX(), isoGameCharacter.getY(), (double)i);
            if (!isoGridSquare.Is(IsoFlagType.solidtrans) && !isoGridSquare.TreatAsSolidFloor() && i != 0 || !(f6 <= (float)i)) continue;
            isoGameCharacter.z = i;
            hashMap.clear();
            isoGameCharacter.clearVariable("ClimbRope");
            isoGameCharacter.setCollidable(true);
            isoGameCharacter.setbClimbing(false);
            return;
        }
        isoGameCharacter.z = f6;
        if (!IsoWindow.isSheetRopeHere(isoGameCharacter.getCurrentSquare())) {
            isoGameCharacter.setCollidable(true);
            isoGameCharacter.setbClimbing(false);
            isoGameCharacter.setbFalling(true);
            isoGameCharacter.clearVariable("ClimbRope");
        }
        if (isoGameCharacter instanceof IsoPlayer && ((IsoPlayer)isoGameCharacter).isLocalPlayer()) {
            ((IsoPlayer)isoGameCharacter).dirtyRecalcGridStackTime = 2.0f;
        }
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
        isoGameCharacter.setIgnoreMovement(false);
        isoGameCharacter.setHideWeaponModel(false);
        isoGameCharacter.clearVariable("ClimbRope");
        isoGameCharacter.setbClimbing(false);
    }

    public float getClimbDownSheetRopeSpeed(IsoGameCharacter isoGameCharacter) {
        float f = 0.16f;
        switch (isoGameCharacter.getPerkLevel(PerkFactory.Perks.Strength)) {
            case 0: {
                f -= 0.12f;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                f -= 0.09f;
                break;
            }
            case 6: 
            case 7: {
                f += 0.05f;
                break;
            }
            case 8: 
            case 9: {
                f += 0.09f;
                break;
            }
            case 10: {
                f += 0.12f;
            }
        }
        return f *= 0.5f;
    }
}

