/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import java.util.HashMap;
import zombie.GameTime;
import zombie.ai.State;
import zombie.audio.parameters.ParameterZombieState;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.characters.skills.PerkFactory;
import zombie.core.Rand;
import zombie.core.skinnedmodel.advancedanimation.AnimEvent;
import zombie.iso.LosUtil;
import zombie.iso.Vector2;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.util.StringUtils;

public final class AttackState
extends State {
    private static final AttackState s_instance = new AttackState();
    private static final String frontStr = "FRONT";
    private static final String backStr = "BEHIND";
    private static final String rightStr = "LEFT";
    private static final String leftStr = "RIGHT";

    public static AttackState instance() {
        return s_instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        IsoZombie isoZombie = (IsoZombie)isoGameCharacter;
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        hashMap.clear();
        hashMap.put(0, Boolean.FALSE);
        isoGameCharacter.setVariable("AttackOutcome", "start");
        isoGameCharacter.clearVariable("AttackDidDamage");
        isoGameCharacter.clearVariable("ZombieBiteDone");
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
        boolean bl;
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        IsoZombie isoZombie = (IsoZombie)isoGameCharacter;
        IsoGameCharacter isoGameCharacter2 = (IsoGameCharacter)isoZombie.target;
        if (isoGameCharacter2 != null && "Chainsaw".equals(isoGameCharacter2.getVariableString("ZombieHitReaction"))) {
            return;
        }
        String string = isoGameCharacter.getVariableString("AttackOutcome");
        if ("success".equals(string) && isoGameCharacter.getVariableBoolean("bAttack") && isoGameCharacter.isVariable("targethitreaction", "EndDeath")) {
            string = "enddeath";
            isoGameCharacter.setVariable("AttackOutcome", string);
        }
        if ("success".equals(string) && !isoGameCharacter.getVariableBoolean("bAttack") && !isoGameCharacter.getVariableBoolean("AttackDidDamage") && isoGameCharacter.getVariableString("ZombieBiteDone") == null) {
            isoGameCharacter.setVariable("AttackOutcome", "interrupted");
        }
        if (isoGameCharacter2 == null || isoGameCharacter2.isDead()) {
            isoZombie.setTargetSeenTime(10.0f);
        }
        if (isoGameCharacter2 != null && hashMap.get(0) == Boolean.FALSE && !"started".equals(string) && !StringUtils.isNullOrEmpty(isoGameCharacter.getVariableString("PlayerHitReaction"))) {
            hashMap.put(0, Boolean.TRUE);
            isoGameCharacter2.testDefense(isoZombie);
        }
        isoZombie.setShootable(true);
        if (isoZombie.target != null && !isoZombie.bCrawling) {
            if (!"fail".equals(string) && !"interrupted".equals(string)) {
                isoZombie.faceThisObject(isoZombie.target);
            }
            isoZombie.setOnFloor(false);
        }
        boolean bl2 = bl = isoZombie.speedType == 1;
        if (isoZombie.target != null && bl && ("start".equals(string) || "success".equals(string))) {
            IsoGameCharacter isoGameCharacter3 = (IsoGameCharacter)isoZombie.target;
            float f = isoGameCharacter3.getSlowFactor();
            if (isoGameCharacter3.getSlowFactor() <= 0.0f) {
                isoGameCharacter3.setSlowTimer(30.0f);
            }
            isoGameCharacter3.setSlowTimer(isoGameCharacter3.getSlowTimer() + GameTime.instance.getMultiplier());
            if (isoGameCharacter3.getSlowTimer() > 60.0f) {
                isoGameCharacter3.setSlowTimer(60.0f);
            }
            isoGameCharacter3.setSlowFactor(isoGameCharacter3.getSlowFactor() + 0.03f);
            if (isoGameCharacter3.getSlowFactor() >= 0.5f) {
                isoGameCharacter3.setSlowFactor(0.5f);
            }
            if (GameServer.bServer && f != isoGameCharacter3.getSlowFactor()) {
                GameServer.sendSlowFactor(isoGameCharacter3);
            }
        }
        if (isoZombie.target != null) {
            isoZombie.target.setTimeSinceZombieAttack(0);
            isoZombie.target.setLastTargettedBy(isoZombie);
        }
        if (!isoZombie.bCrawling) {
            isoZombie.setVariable("AttackType", "bite");
        }
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
        IsoZombie isoZombie = (IsoZombie)isoGameCharacter;
        isoGameCharacter.clearVariable("AttackOutcome");
        isoGameCharacter.clearVariable("AttackType");
        isoGameCharacter.clearVariable("PlayerHitReaction");
        isoGameCharacter.setStateMachineLocked(false);
        if (isoZombie.target != null && isoZombie.target.isOnFloor()) {
            isoZombie.setEatBodyTarget(isoZombie.target, true);
            isoZombie.setTarget(null);
        }
        isoZombie.AllowRepathDelay = 0.0f;
    }

    @Override
    public void animEvent(IsoGameCharacter isoGameCharacter, AnimEvent animEvent) {
        IsoZombie isoZombie = (IsoZombie)isoGameCharacter;
        if (animEvent.m_EventName.equalsIgnoreCase("SetAttackOutcome")) {
            if (isoZombie.getVariableBoolean("bAttack")) {
                isoZombie.setVariable("AttackOutcome", "success");
            } else {
                isoZombie.setVariable("AttackOutcome", "fail");
            }
        }
        if (animEvent.m_EventName.equalsIgnoreCase("AttackCollisionCheck") && !isoZombie.isNoTeeth()) {
            int n;
            int n2;
            IsoGameCharacter isoGameCharacter2 = (IsoGameCharacter)isoZombie.target;
            if (isoGameCharacter2 == null) {
                return;
            }
            isoGameCharacter2.setHitFromBehind(isoZombie.isBehind(isoGameCharacter2));
            String string = isoGameCharacter2.testDotSide(isoZombie);
            boolean bl = string.equals(frontStr);
            if (bl && !isoGameCharacter2.isAimAtFloor() && !StringUtils.isNullOrEmpty(isoGameCharacter2.getVariableString("AttackType"))) {
                return;
            }
            if ("KnifeDeath".equals(isoGameCharacter2.getVariableString("ZombieHitReaction")) && Rand.NextBool(n2 = Math.max(0, 9 - (n = isoGameCharacter2.getPerkLevel(PerkFactory.Perks.SmallBlade) + 1) * 2))) {
                return;
            }
            this.triggerPlayerReaction(isoGameCharacter.getVariableString("PlayerHitReaction"), isoGameCharacter);
            Vector2 vector22 = isoZombie.getHitDir();
            vector22.x = isoZombie.getX();
            vector22.y = isoZombie.getY();
            vector22.x -= isoGameCharacter2.getX();
            vector22.y -= isoGameCharacter2.getY();
            vector22.normalize();
            if (GameClient.bClient && !isoZombie.isRemoteZombie()) {
                GameClient.sendHitCharacter(isoZombie, isoGameCharacter2, null, 0.0f, false, 1.0f, false, false, false);
            }
        }
        if (animEvent.m_EventName.equalsIgnoreCase("EatBody")) {
            isoGameCharacter.setVariable("EatingStarted", true);
            ((IsoZombie)isoGameCharacter).setEatBodyTarget(((IsoZombie)isoGameCharacter).target, true);
            ((IsoZombie)isoGameCharacter).setTarget(null);
        }
        if (animEvent.m_EventName.equalsIgnoreCase("SetState")) {
            isoZombie.parameterZombieState.setState(ParameterZombieState.State.Attack);
        }
    }

    @Override
    public boolean isAttacking(IsoGameCharacter isoGameCharacter) {
        return true;
    }

    private void triggerPlayerReaction(String object, IsoGameCharacter isoGameCharacter) {
        IsoZombie isoZombie = (IsoZombie)isoGameCharacter;
        IsoGameCharacter isoGameCharacter2 = (IsoGameCharacter)isoZombie.target;
        if (isoGameCharacter2 == null) {
            return;
        }
        if (isoZombie.DistTo(isoGameCharacter2) > 1.0f && !isoZombie.bCrawling) {
            return;
        }
        if ((isoZombie.isFakeDead() || isoZombie.bCrawling) && isoZombie.DistTo(isoGameCharacter2) > 1.3f) {
            return;
        }
        if (isoGameCharacter2.isDead() && !isoGameCharacter2.getHitReaction().equals("EndDeath") || isoGameCharacter2.isOnFloor()) {
            isoZombie.setEatBodyTarget(isoGameCharacter2, true);
            return;
        }
        if (isoGameCharacter2.isDead()) {
            return;
        }
        isoGameCharacter2.setHitFromBehind(isoZombie.isBehind(isoGameCharacter2));
        String string = isoGameCharacter2.testDotSide(isoZombie);
        boolean bl = string.equals(frontStr);
        boolean bl2 = string.equals(backStr);
        if (string.equals(leftStr)) {
            object = (String)object + rightStr;
        }
        if (string.equals(rightStr)) {
            object = (String)object + leftStr;
        }
        if (((IsoPlayer)isoGameCharacter2).bDoShove && bl && !isoGameCharacter2.isAimAtFloor()) {
            return;
        }
        if (((IsoPlayer)isoGameCharacter2).bDoShove && !bl && !bl2 && Rand.Next(100) > 75) {
            return;
        }
        if (Math.abs(isoZombie.z - isoGameCharacter2.z) >= 0.2f) {
            return;
        }
        LosUtil.TestResults testResults = LosUtil.lineClear(isoZombie.getCell(), (int)isoZombie.getX(), (int)isoZombie.getY(), (int)isoZombie.getZ(), (int)isoGameCharacter2.getX(), (int)isoGameCharacter2.getY(), (int)isoGameCharacter2.getZ(), false);
        if (testResults == LosUtil.TestResults.Blocked || testResults == LosUtil.TestResults.ClearThroughClosedDoor) {
            return;
        }
        if (isoGameCharacter2.getSquare().isSomethingTo(isoZombie.getCurrentSquare())) {
            return;
        }
        isoGameCharacter2.setAttackedBy(isoZombie);
        boolean bl3 = false;
        if (!GameClient.bClient && !GameServer.bServer || GameClient.bClient && !isoZombie.isRemoteZombie()) {
            bl3 = isoGameCharacter2.getBodyDamage().AddRandomDamageFromZombie(isoZombie, (String)object);
        }
        isoGameCharacter.setVariable("AttackDidDamage", bl3);
        isoGameCharacter2.getBodyDamage().Update();
        if (isoGameCharacter2.isDead()) {
            isoGameCharacter2.setHealth(0.0f);
            isoZombie.setEatBodyTarget(isoGameCharacter2, true);
            isoZombie.setTarget(null);
        } else if (isoGameCharacter2.isAsleep()) {
            if (GameServer.bServer) {
                isoGameCharacter2.sendObjectChange("wakeUp");
            } else {
                isoGameCharacter2.forceAwake();
            }
        }
    }
}

