/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai;

import java.util.ArrayDeque;
import java.util.ArrayList;
import zombie.GameTime;
import zombie.SandboxOptions;
import zombie.VirtualZombieManager;
import zombie.ai.states.PathFindState;
import zombie.ai.states.WalkTowardState;
import zombie.ai.states.ZombieIdleState;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.characters.ZombieGroup;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMetaGrid;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.iso.Vector2;
import zombie.iso.Vector3;
import zombie.network.GameClient;
import zombie.network.GameServer;

public final class ZombieGroupManager {
    public static final ZombieGroupManager instance = new ZombieGroupManager();
    private final ArrayList<ZombieGroup> groups = new ArrayList();
    private final ArrayDeque<ZombieGroup> freeGroups = new ArrayDeque();
    private final Vector2 tempVec2 = new Vector2();
    private final Vector3 tempVec3 = new Vector3();
    private float tickCount = 30.0f;

    public void preupdate() {
        this.tickCount += GameTime.getInstance().getMultiplier() / 1.6f;
        if (this.tickCount >= 30.0f) {
            this.tickCount = 0.0f;
        }
        int n = SandboxOptions.instance.zombieConfig.RallyGroupSize.getValue();
        for (int i = 0; i < this.groups.size(); ++i) {
            ZombieGroup zombieGroup = this.groups.get(i);
            zombieGroup.update();
            if (!zombieGroup.isEmpty()) continue;
            this.freeGroups.push(zombieGroup);
            this.groups.remove(i--);
        }
    }

    public void Reset() {
        this.freeGroups.addAll(this.groups);
        this.groups.clear();
    }

    public boolean shouldBeInGroup(IsoZombie isoZombie) {
        IsoMetaGrid.Zone zone;
        if (isoZombie == null) {
            return false;
        }
        if (SandboxOptions.instance.zombieConfig.RallyGroupSize.getValue() <= 1) {
            return false;
        }
        if (!Core.getInstance().isZombieGroupSound()) {
            return false;
        }
        if (isoZombie.isUseless()) {
            return false;
        }
        if (isoZombie.isDead() || isoZombie.isFakeDead()) {
            return false;
        }
        if (isoZombie.isSitAgainstWall()) {
            return false;
        }
        if (isoZombie.target != null) {
            return false;
        }
        if (isoZombie.getCurrentBuilding() != null) {
            return false;
        }
        if (VirtualZombieManager.instance.isReused(isoZombie)) {
            return false;
        }
        IsoGridSquare isoGridSquare = isoZombie.getSquare();
        IsoMetaGrid.Zone zone2 = zone = isoGridSquare == null ? null : isoGridSquare.getZone();
        return zone == null || !"Forest".equals(zone.getType()) && !"DeepForest".equals(zone.getType());
    }

    public void update(IsoZombie isoZombie) {
        if (GameClient.bClient && isoZombie.isRemoteZombie()) {
            return;
        }
        if (!this.shouldBeInGroup(isoZombie)) {
            if (isoZombie.group != null) {
                isoZombie.group.remove(isoZombie);
            }
            return;
        }
        if (this.tickCount != 0.0f) {
            return;
        }
        if (isoZombie.group == null) {
            ZombieGroup zombieGroup = this.findNearestGroup(isoZombie.getX(), isoZombie.getY(), isoZombie.getZ());
            if (zombieGroup == null) {
                zombieGroup = this.freeGroups.isEmpty() ? new ZombieGroup() : this.freeGroups.pop().reset();
                zombieGroup.add(isoZombie);
                this.groups.add(zombieGroup);
                return;
            }
            zombieGroup.add(isoZombie);
        }
        if (isoZombie.getCurrentState() != ZombieIdleState.instance()) {
            return;
        }
        if (isoZombie == isoZombie.group.getLeader()) {
            int n;
            float f = (float)GameTime.getInstance().getWorldAgeHours();
            isoZombie.group.lastSpreadOutTime = Math.min(isoZombie.group.lastSpreadOutTime, f);
            if (isoZombie.group.lastSpreadOutTime + 0.083333336f > f) {
                return;
            }
            isoZombie.group.lastSpreadOutTime = f;
            int n2 = SandboxOptions.instance.zombieConfig.RallyGroupSeparation.getValue();
            Vector2 vector22 = this.tempVec2.set(0.0f, 0.0f);
            for (n = 0; n < this.groups.size(); ++n) {
                float f2;
                float f3;
                float f4;
                ZombieGroup zombieGroup = this.groups.get(n);
                if (zombieGroup.getLeader() == null || zombieGroup == isoZombie.group || (int)zombieGroup.getLeader().getZ() != (int)isoZombie.getZ() || (f4 = IsoUtils.DistanceToSquared(isoZombie.x, isoZombie.y, f3 = zombieGroup.getLeader().getX(), f2 = zombieGroup.getLeader().getY())) > (float)(n2 * n2)) continue;
                vector22.x = vector22.x - f3 + isoZombie.x;
                vector22.y = vector22.y - f2 + isoZombie.y;
            }
            n = this.lineClearCollideCount(isoZombie, isoZombie.getCell(), (int)(isoZombie.x + vector22.x), (int)(isoZombie.y + vector22.y), (int)isoZombie.z, (int)isoZombie.x, (int)isoZombie.y, (int)isoZombie.z, 10, this.tempVec3);
            if (n < 1) {
                return;
            }
            if (!GameClient.bClient && !GameServer.bServer && IsoPlayer.getInstance().getHoursSurvived() < 2.0) {
                return;
            }
            if (this.tempVec3.x < 0.0f || this.tempVec3.y < 0.0f || !IsoWorld.instance.MetaGrid.isValidChunk((int)this.tempVec3.x / 10, (int)this.tempVec3.y / 10)) {
                return;
            }
            isoZombie.pathToLocation((int)(this.tempVec3.x + 0.5f), (int)(this.tempVec3.y + 0.5f), (int)this.tempVec3.z);
            if (isoZombie.getCurrentState() == PathFindState.instance() || isoZombie.getCurrentState() == WalkTowardState.instance()) {
                isoZombie.setLastHeardSound(isoZombie.getPathTargetX(), isoZombie.getPathTargetY(), isoZombie.getPathTargetZ());
                isoZombie.AllowRepathDelay = 400.0f;
            }
            return;
        }
        float f = isoZombie.group.getLeader().getX();
        float f5 = isoZombie.group.getLeader().getY();
        int n = SandboxOptions.instance.zombieConfig.RallyGroupRadius.getValue();
        if (IsoUtils.DistanceToSquared(isoZombie.x, isoZombie.y, f, f5) < (float)(n * n)) {
            return;
        }
        if (!GameClient.bClient && !GameServer.bServer && IsoPlayer.getInstance().getHoursSurvived() < 2.0 && !Core.bDebug) {
            return;
        }
        int n3 = (int)(f + (float)Rand.Next(-n, n));
        int n4 = (int)(f5 + (float)Rand.Next(-n, n));
        if (n3 < 0 || n4 < 0 || !IsoWorld.instance.MetaGrid.isValidChunk(n3 / 10, n4 / 10)) {
            return;
        }
        isoZombie.pathToLocation(n3, n4, (int)isoZombie.group.getLeader().getZ());
        if (isoZombie.getCurrentState() == PathFindState.instance() || isoZombie.getCurrentState() == WalkTowardState.instance()) {
            isoZombie.setLastHeardSound(isoZombie.getPathTargetX(), isoZombie.getPathTargetY(), isoZombie.getPathTargetZ());
            isoZombie.AllowRepathDelay = 400.0f;
        }
    }

    public ZombieGroup findNearestGroup(float f, float f2, float f3) {
        ZombieGroup zombieGroup = null;
        float f4 = Float.MAX_VALUE;
        int n = SandboxOptions.instance.zombieConfig.RallyTravelDistance.getValue();
        for (int i = 0; i < this.groups.size(); ++i) {
            float f5;
            ZombieGroup zombieGroup2 = this.groups.get(i);
            if (zombieGroup2.isEmpty()) {
                this.groups.remove(i--);
                continue;
            }
            if ((int)zombieGroup2.getLeader().getZ() != (int)f3 || zombieGroup2.size() >= SandboxOptions.instance.zombieConfig.RallyGroupSize.getValue() || !((f5 = IsoUtils.DistanceToSquared(f, f2, zombieGroup2.getLeader().getX(), zombieGroup2.getLeader().getY())) < (float)(n * n)) || !(f5 < f4)) continue;
            f4 = f5;
            zombieGroup = zombieGroup2;
        }
        return zombieGroup;
    }

    private int lineClearCollideCount(IsoMovingObject isoMovingObject, IsoCell isoCell, int n, int n2, int n3, int n4, int n5, int n6, int n7, Vector3 vector3) {
        int n8 = 0;
        int n9 = n2 - n5;
        int n10 = n - n4;
        int n11 = n3 - n6;
        float f = 0.5f;
        float f2 = 0.5f;
        int n12 = n4;
        int n13 = n5;
        int n14 = n6;
        IsoGridSquare isoGridSquare = isoCell.getGridSquare(n12, n13, n14);
        vector3.set(n4, n5, n6);
        if (Math.abs(n10) > Math.abs(n9) && Math.abs(n10) > Math.abs(n11)) {
            float f3 = (float)n9 / (float)n10;
            float f4 = (float)n11 / (float)n10;
            f += (float)n5;
            f2 += (float)n6;
            n10 = n10 < 0 ? -1 : 1;
            f3 *= (float)n10;
            f4 *= (float)n10;
            while (n4 != n) {
                boolean bl;
                IsoGridSquare isoGridSquare2 = isoCell.getGridSquare(n4 += n10, (int)(f += f3), (int)(f2 += f4));
                if (isoGridSquare2 != null && isoGridSquare != null && (bl = isoGridSquare2.testCollideAdjacent(isoMovingObject, isoGridSquare.getX() - isoGridSquare2.getX(), isoGridSquare.getY() - isoGridSquare2.getY(), isoGridSquare.getZ() - isoGridSquare2.getZ()))) {
                    return n8;
                }
                isoGridSquare = isoGridSquare2;
                n12 = n4;
                n13 = (int)f;
                n14 = (int)f2;
                vector3.set(n12, n13, n14);
                if (++n8 < n7) continue;
                return n8;
            }
        } else if (Math.abs(n9) >= Math.abs(n10) && Math.abs(n9) > Math.abs(n11)) {
            float f5 = (float)n10 / (float)n9;
            float f6 = (float)n11 / (float)n9;
            f += (float)n4;
            f2 += (float)n6;
            n9 = n9 < 0 ? -1 : 1;
            f5 *= (float)n9;
            f6 *= (float)n9;
            while (n5 != n2) {
                boolean bl;
                IsoGridSquare isoGridSquare3 = isoCell.getGridSquare((int)(f += f5), n5 += n9, (int)(f2 += f6));
                if (isoGridSquare3 != null && isoGridSquare != null && (bl = isoGridSquare3.testCollideAdjacent(isoMovingObject, isoGridSquare.getX() - isoGridSquare3.getX(), isoGridSquare.getY() - isoGridSquare3.getY(), isoGridSquare.getZ() - isoGridSquare3.getZ()))) {
                    return n8;
                }
                isoGridSquare = isoGridSquare3;
                n12 = (int)f;
                n13 = n5;
                n14 = (int)f2;
                vector3.set(n12, n13, n14);
                if (++n8 < n7) continue;
                return n8;
            }
        } else {
            float f7 = (float)n10 / (float)n11;
            float f8 = (float)n9 / (float)n11;
            f += (float)n4;
            f2 += (float)n5;
            n11 = n11 < 0 ? -1 : 1;
            f7 *= (float)n11;
            f8 *= (float)n11;
            while (n6 != n3) {
                boolean bl;
                IsoGridSquare isoGridSquare4 = isoCell.getGridSquare((int)(f += f7), (int)(f2 += f8), n6 += n11);
                if (isoGridSquare4 != null && isoGridSquare != null && (bl = isoGridSquare4.testCollideAdjacent(isoMovingObject, isoGridSquare.getX() - isoGridSquare4.getX(), isoGridSquare.getY() - isoGridSquare4.getY(), isoGridSquare.getZ() - isoGridSquare4.getZ()))) {
                    return n8;
                }
                isoGridSquare = isoGridSquare4;
                n12 = (int)f;
                n13 = (int)f2;
                n14 = n6;
                vector3.set(n12, n13, n14);
                if (++n8 < n7) continue;
                return n8;
            }
        }
        return n8;
    }
}

