/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai;

import java.util.ArrayList;
import java.util.List;
import zombie.Lua.LuaEventManager;
import zombie.ai.State;
import zombie.ai.states.SwipeStatePlayer;
import zombie.characters.IsoGameCharacter;
import zombie.core.skinnedmodel.advancedanimation.AnimEvent;
import zombie.debug.DebugLog;
import zombie.util.Lambda;
import zombie.util.list.PZArrayUtil;

public final class StateMachine {
    private boolean m_isLocked = false;
    public int activeStateChanged = 0;
    private State m_currentState;
    private State m_previousState;
    private final IsoGameCharacter m_owner;
    private final List<SubstateSlot> m_subStates = new ArrayList<SubstateSlot>();

    public StateMachine(IsoGameCharacter isoGameCharacter) {
        this.m_owner = isoGameCharacter;
    }

    public void changeState(State state, Iterable<State> iterable) {
        this.changeState(state, iterable, false);
    }

    public void changeState(State state2, Iterable<State> iterable, boolean bl) {
        if (this.m_isLocked) {
            return;
        }
        this.changeRootState(state2, bl);
        PZArrayUtil.forEach(this.m_subStates, substateSlot -> {
            substateSlot.shouldBeActive = false;
        });
        PZArrayUtil.forEach(iterable, Lambda.consumer(this, (state, stateMachine) -> {
            if (state != null) {
                stateMachine.ensureSubstateActive((State)state);
            }
        }));
        Lambda.forEachFrom(PZArrayUtil::forEach, this.m_subStates, this, (substateSlot, stateMachine) -> {
            if (!substateSlot.shouldBeActive && !substateSlot.isEmpty()) {
                stateMachine.removeSubstate((SubstateSlot)substateSlot);
            }
        });
    }

    private void changeRootState(State state, boolean bl) {
        if (this.m_currentState == state) {
            if (bl) {
                this.stateEnter(this.m_currentState);
            }
            return;
        }
        State state2 = this.m_currentState;
        if (state2 != null) {
            this.stateExit(state2);
        }
        this.m_previousState = state2;
        this.m_currentState = state;
        if (state != null) {
            this.stateEnter(state);
        }
        LuaEventManager.triggerEvent("OnAIStateChange", this.m_owner, this.m_currentState, this.m_previousState);
    }

    private void ensureSubstateActive(State state) {
        SubstateSlot substateSlot = this.getExistingSlot(state);
        if (substateSlot != null) {
            substateSlot.shouldBeActive = true;
            return;
        }
        SubstateSlot substateSlot2 = PZArrayUtil.find(this.m_subStates, SubstateSlot::isEmpty);
        if (substateSlot2 != null) {
            substateSlot2.setState(state);
            substateSlot2.shouldBeActive = true;
        } else {
            SubstateSlot substateSlot3 = new SubstateSlot(state);
            this.m_subStates.add(substateSlot3);
        }
        this.stateEnter(state);
    }

    private SubstateSlot getExistingSlot(State state2) {
        return PZArrayUtil.find(this.m_subStates, Lambda.predicate(state2, (substateSlot, state) -> substateSlot.getState() == state));
    }

    private void removeSubstate(State state) {
        SubstateSlot substateSlot = this.getExistingSlot(state);
        if (substateSlot == null) {
            return;
        }
        this.removeSubstate(substateSlot);
    }

    private void removeSubstate(SubstateSlot substateSlot) {
        State state = substateSlot.getState();
        substateSlot.setState(null);
        if (state == this.m_currentState && state == SwipeStatePlayer.instance()) {
            return;
        }
        this.stateExit(state);
    }

    public boolean isSubstate(State state2) {
        return PZArrayUtil.contains(this.m_subStates, Lambda.predicate(state2, (substateSlot, state) -> substateSlot.getState() == state));
    }

    public State getCurrent() {
        return this.m_currentState;
    }

    public State getPrevious() {
        return this.m_previousState;
    }

    public int getSubStateCount() {
        return this.m_subStates.size();
    }

    public State getSubStateAt(int n) {
        return this.m_subStates.get(n).getState();
    }

    public void revertToPreviousState(State state) {
        if (this.isSubstate(state)) {
            this.removeSubstate(state);
            return;
        }
        if (this.m_currentState != state) {
            DebugLog.ActionSystem.warn("The sender $s is not an active state in this state machine.", String.valueOf(state));
            return;
        }
        this.changeRootState(this.m_previousState, false);
    }

    public void update() {
        if (this.m_currentState != null) {
            this.m_currentState.execute(this.m_owner);
        }
        Lambda.forEachFrom(PZArrayUtil::forEach, this.m_subStates, this.m_owner, (substateSlot, isoGameCharacter) -> {
            if (!substateSlot.isEmpty()) {
                substateSlot.state.execute((IsoGameCharacter)isoGameCharacter);
            }
        });
        this.logCurrentState();
    }

    private void logCurrentState() {
        if (this.m_owner.isAnimationRecorderActive()) {
            this.m_owner.getAnimationPlayerRecorder().logAIState(this.m_currentState, this.m_subStates);
        }
    }

    private void stateEnter(State state) {
        state.enter(this.m_owner);
    }

    private void stateExit(State state) {
        state.exit(this.m_owner);
    }

    public final void stateAnimEvent(int n, AnimEvent animEvent2) {
        if (n == 0) {
            if (this.m_currentState != null) {
                this.m_currentState.animEvent(this.m_owner, animEvent2);
            }
            return;
        }
        Lambda.forEachFrom(PZArrayUtil::forEach, this.m_subStates, this.m_owner, animEvent2, (substateSlot, isoGameCharacter, animEvent) -> {
            if (!substateSlot.isEmpty()) {
                substateSlot.state.animEvent((IsoGameCharacter)isoGameCharacter, (AnimEvent)animEvent);
            }
        });
    }

    public boolean isLocked() {
        return this.m_isLocked;
    }

    public void setLocked(boolean bl) {
        this.m_isLocked = bl;
    }

    public static class SubstateSlot {
        private State state;
        boolean shouldBeActive;

        SubstateSlot(State state) {
            this.state = state;
            this.shouldBeActive = true;
        }

        public State getState() {
            return this.state;
        }

        void setState(State state) {
            this.state = state;
        }

        public boolean isEmpty() {
            return this.state == null;
        }
    }
}

