/*
 * Decompiled with CFR 0.152.
 */
package zombie;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import zombie.DebugFileWatcher;
import zombie.FileGuidTable;
import zombie.GameWindow;
import zombie.Lua.LuaEventManager;
import zombie.PredicatedFileWatcher;
import zombie.core.Core;
import zombie.core.logger.ExceptionLogger;
import zombie.core.znet.SteamUtils;
import zombie.core.znet.SteamWorkshop;
import zombie.debug.DebugLog;
import zombie.debug.LogSeverity;
import zombie.gameStates.ChooseGameInfo;
import zombie.iso.IsoWorld;
import zombie.iso.sprite.IsoSpriteManager;
import zombie.modding.ActiveMods;
import zombie.modding.ActiveModsFile;
import zombie.network.CoopMaster;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.util.StringUtils;

public final class ZomboidFileSystem {
    public static final ZomboidFileSystem instance = new ZomboidFileSystem();
    private final ArrayList<String> loadList = new ArrayList();
    private final Map<String, String> modIdToDir = new HashMap<String, String>();
    private final Map<String, ChooseGameInfo.Mod> modDirToMod = new HashMap<String, ChooseGameInfo.Mod>();
    private ArrayList<String> modFolders;
    private ArrayList<String> modFoldersOrder;
    public final HashMap<String, String> ActiveFileMap = new HashMap();
    private final HashSet<String> AllAbsolutePaths = new HashSet();
    public File base;
    public URI baseURI;
    private File workdir;
    private URI workdirURI;
    private File localWorkdir;
    private File anims;
    private URI animsURI;
    private File animsX;
    private URI animsXURI;
    private File animSets;
    private URI animSetsURI;
    private File actiongroups;
    private URI actiongroupsURI;
    private File cacheDir;
    private final ConcurrentHashMap<String, String> RelativeMap = new ConcurrentHashMap();
    public final ThreadLocal<Boolean> IgnoreActiveFileMap = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private final ConcurrentHashMap<String, URI> CanonicalURIMap = new ConcurrentHashMap();
    private final ArrayList<String> mods = new ArrayList();
    private final HashSet<String> LoadedPacks = new HashSet();
    private FileGuidTable m_fileGuidTable = null;
    private boolean m_fileGuidTableWatcherActive = false;
    private final PredicatedFileWatcher m_modFileWatcher = new PredicatedFileWatcher(this::isModFile, this::onModFileChanged);
    private final HashSet<String> m_watchedModFolders = new HashSet();
    private long m_modsChangedTime = 0L;

    private ZomboidFileSystem() {
    }

    public void init() throws IOException {
        this.base = new File("./").getAbsoluteFile().getCanonicalFile();
        this.baseURI = this.base.toURI();
        this.workdir = new File(this.base, "media").getAbsoluteFile().getCanonicalFile();
        this.workdirURI = this.workdir.toURI();
        this.localWorkdir = this.base.toPath().relativize(this.workdir.toPath()).toFile();
        this.anims = new File(this.workdir, "anims");
        this.animsURI = this.anims.toURI();
        this.animsX = new File(this.workdir, "anims_X");
        this.animsXURI = this.animsX.toURI();
        this.animSets = new File(this.workdir, "AnimSets");
        this.animSetsURI = this.animSets.toURI();
        this.actiongroups = new File(this.workdir, "actiongroups");
        this.actiongroupsURI = this.actiongroups.toURI();
        this.searchFolders(this.workdir);
        for (int i = 0; i < this.loadList.size(); ++i) {
            String string = this.getRelativeFile(this.loadList.get(i));
            File file = new File(this.loadList.get(i)).getAbsoluteFile();
            Object object = file.getAbsolutePath();
            if (file.isDirectory()) {
                object = (String)object + File.separator;
            }
            this.ActiveFileMap.put(string.toLowerCase(Locale.ENGLISH), (String)object);
            this.AllAbsolutePaths.add((String)object);
        }
        this.loadList.clear();
    }

    public File getCanonicalFile(File file2, String string) {
        if (!file2.isDirectory()) {
            return new File(file2, string);
        }
        File[] fileArray = file2.listFiles((file, string2) -> string2.equalsIgnoreCase(string));
        if (fileArray == null || fileArray.length == 0) {
            return new File(file2, string);
        }
        return fileArray[0];
    }

    public String getGameModeCacheDir() {
        if (Core.GameMode == null) {
            Core.GameMode = "Sandbox";
        }
        String string = this.getSaveDir();
        return string + File.separator + Core.GameMode;
    }

    public String getCurrentSaveDir() {
        return this.getGameModeCacheDir() + File.separator + Core.GameSaveWorld;
    }

    public String getFileNameInCurrentSave(String string) {
        return this.getCurrentSaveDir() + File.separator + string;
    }

    public String getFileNameInCurrentSave(String string, String string2) {
        return this.getFileNameInCurrentSave(string + File.separator + string2);
    }

    public String getFileNameInCurrentSave(String string, String string2, String string3) {
        return this.getFileNameInCurrentSave(string + File.separator + string2 + File.separator + string3);
    }

    public File getFileInCurrentSave(String string) {
        return new File(this.getFileNameInCurrentSave(string));
    }

    public File getFileInCurrentSave(String string, String string2) {
        return new File(this.getFileNameInCurrentSave(string, string2));
    }

    public File getFileInCurrentSave(String string, String string2, String string3) {
        return new File(this.getFileNameInCurrentSave(string, string2, string3));
    }

    public String getSaveDir() {
        String string = this.getCacheDirSub("Saves");
        ZomboidFileSystem.ensureFolderExists(string);
        return string;
    }

    public String getSaveDirSub(String string) {
        return this.getSaveDir() + File.separator + string;
    }

    public String getScreenshotDir() {
        String string = this.getCacheDirSub("Screenshots");
        ZomboidFileSystem.ensureFolderExists(string);
        return string;
    }

    public String getScreenshotDirSub(String string) {
        return this.getScreenshotDir() + File.separator + string;
    }

    public void setCacheDir(String string) {
        string = string.replace("/", File.separator);
        this.cacheDir = new File(string).getAbsoluteFile();
        ZomboidFileSystem.ensureFolderExists(this.cacheDir);
    }

    public String getCacheDir() {
        if (this.cacheDir == null) {
            String string = System.getProperty("deployment.user.cachedir");
            if (string == null || System.getProperty("os.name").startsWith("Win")) {
                string = System.getProperty("user.home");
            }
            String string2 = string + File.separator + "Zomboid";
            this.setCacheDir(string2);
        }
        return this.cacheDir.getPath();
    }

    public String getCacheDirSub(String string) {
        return this.getCacheDir() + File.separator + string;
    }

    public String getMessagingDir() {
        String string = this.getCacheDirSub("messaging");
        ZomboidFileSystem.ensureFolderExists(string);
        return string;
    }

    public String getMessagingDirSub(String string) {
        return this.getMessagingDir() + File.separator + string;
    }

    public File getMediaRootFile() {
        assert (this.workdir != null);
        return this.workdir;
    }

    public String getMediaRootPath() {
        return this.workdir.getPath();
    }

    public File getMediaFile(String string) {
        assert (this.workdir != null);
        return new File(this.workdir, string);
    }

    public String getMediaPath(String string) {
        return this.getMediaFile(string).getPath();
    }

    public String getAbsoluteWorkDir() {
        return this.workdir.getPath();
    }

    public String getLocalWorkDir() {
        return this.localWorkdir.getPath();
    }

    public String getLocalWorkDirSub(String string) {
        return this.getLocalWorkDir() + File.separator + string;
    }

    public String getAnimSetsPath() {
        return this.animSets.getPath();
    }

    public String getActionGroupsPath() {
        return this.actiongroups.getPath();
    }

    public static boolean ensureFolderExists(String string) {
        return ZomboidFileSystem.ensureFolderExists(new File(string).getAbsoluteFile());
    }

    public static boolean ensureFolderExists(File file) {
        return file.exists() || file.mkdirs();
    }

    public void searchFolders(File file) {
        if (!GameServer.bServer) {
            Thread.yield();
            Core.getInstance().DoFrameReady();
        }
        if (file.isDirectory()) {
            String string = file.getAbsolutePath().replace("\\", "/").replace("./", "");
            if (string.contains("media/maps/")) {
                this.loadList.add(string);
            }
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                this.searchFolders(new File(file.getAbsolutePath() + File.separator + stringArray[i]));
            }
        } else {
            this.loadList.add(file.getAbsolutePath().replace("\\", "/").replace("./", ""));
        }
    }

    public Object[] getAllPathsContaining(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.ActiveFileMap.entrySet()) {
            if (!entry.getKey().contains(string)) continue;
            arrayList.add(entry.getValue());
        }
        return arrayList.toArray();
    }

    public Object[] getAllPathsContaining(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.ActiveFileMap.entrySet()) {
            if (!entry.getKey().contains(string) || !entry.getKey().contains(string2)) continue;
            arrayList.add(entry.getValue());
        }
        return arrayList.toArray();
    }

    public synchronized String getString(String string) {
        String string2;
        if (this.IgnoreActiveFileMap.get().booleanValue()) {
            return string;
        }
        String string3 = string.toLowerCase(Locale.ENGLISH);
        String string4 = this.RelativeMap.get(string3);
        if (string4 != null) {
            string3 = string4;
        } else {
            string2 = string3;
            string3 = this.getRelativeFile(string);
            string3 = string3.toLowerCase(Locale.ENGLISH);
            this.RelativeMap.put(string2, string3);
        }
        string2 = this.ActiveFileMap.get(string3);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    public synchronized boolean isKnownFile(String string) {
        String string2;
        if (this.AllAbsolutePaths.contains(string)) {
            return true;
        }
        String string3 = string.toLowerCase(Locale.ENGLISH);
        String string4 = this.RelativeMap.get(string3);
        if (string4 != null) {
            string3 = string4;
        } else {
            string2 = string3;
            string3 = this.getRelativeFile(string);
            string3 = string3.toLowerCase(Locale.ENGLISH);
            this.RelativeMap.put(string2, string3);
        }
        string2 = this.ActiveFileMap.get(string3);
        return string2 != null;
    }

    public String getAbsolutePath(String string) {
        String string2 = string.toLowerCase(Locale.ENGLISH);
        return this.ActiveFileMap.get(string2);
    }

    public void Reset() {
        this.loadList.clear();
        this.ActiveFileMap.clear();
        this.AllAbsolutePaths.clear();
        this.CanonicalURIMap.clear();
        this.modIdToDir.clear();
        this.modDirToMod.clear();
        this.mods.clear();
        this.modFolders = null;
        ActiveMods.Reset();
        if (this.m_fileGuidTable != null) {
            this.m_fileGuidTable.clear();
            this.m_fileGuidTable = null;
        }
    }

    public File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (Exception exception) {
            return file.getAbsoluteFile();
        }
    }

    public File getCanonicalFile(String string) {
        return this.getCanonicalFile(new File(string));
    }

    public String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (Exception exception) {
            return file.getAbsolutePath();
        }
    }

    public String getCanonicalPath(String string) {
        return this.getCanonicalPath(new File(string));
    }

    public URI getCanonicalURI(String string) {
        URI uRI = this.CanonicalURIMap.get(string);
        if (uRI == null) {
            uRI = this.getCanonicalFile(string).toURI();
            this.CanonicalURIMap.put(string, uRI);
        }
        return uRI;
    }

    public void resetModFolders() {
        this.modFolders = null;
    }

    public void getInstalledItemModsFolders(ArrayList<String> arrayList) {
        String[] stringArray;
        if (SteamUtils.isSteamModeEnabled() && (stringArray = SteamWorkshop.instance.GetInstalledItemFolders()) != null) {
            for (String string : stringArray) {
                File file = new File(string + File.separator + "mods");
                if (!file.exists()) continue;
                arrayList.add(file.getAbsolutePath());
            }
        }
    }

    public void getStagedItemModsFolders(ArrayList<String> arrayList) {
        if (SteamUtils.isSteamModeEnabled()) {
            ArrayList<String> arrayList2 = SteamWorkshop.instance.getStageFolders();
            for (int i = 0; i < arrayList2.size(); ++i) {
                File file = new File(arrayList2.get(i) + File.separator + "Contents" + File.separator + "mods");
                if (!file.exists()) continue;
                arrayList.add(file.getAbsolutePath());
            }
        }
    }

    private void getAllModFoldersAux(String string, List<String> list) {
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path path) throws IOException {
                return Files.isDirectory(path, new LinkOption[0]) && Files.exists(path.resolve("mod.info"), new LinkOption[0]);
            }
        };
        Path path = FileSystems.getDefault().getPath(string, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path, (DirectoryStream.Filter<? super Path>)filter);){
            for (Path path2 : directoryStream) {
                if (path2.getFileName().toString().toLowerCase().equals("examplemod")) {
                    DebugLog.Mod.println("refusing to list " + path2.getFileName());
                    continue;
                }
                String string2 = path2.toAbsolutePath().toString();
                if (!this.m_watchedModFolders.contains(string2)) {
                    this.m_watchedModFolders.add(string2);
                    DebugFileWatcher.instance.addDirectory(string2);
                    Path path3 = path2.resolve("media");
                    if (Files.exists(path3, new LinkOption[0])) {
                        DebugFileWatcher.instance.addDirectoryRecurse(path3.toAbsolutePath().toString());
                    }
                }
                list.add(string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setModFoldersOrder(String string) {
        this.modFoldersOrder = new ArrayList<String>(Arrays.asList(string.split(",")));
    }

    public void getAllModFolders(List<String> list) {
        if (this.modFolders == null) {
            String string;
            int n;
            this.modFolders = new ArrayList();
            if (this.modFoldersOrder == null) {
                this.setModFoldersOrder("workshop,steam,mods");
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (n = 0; n < this.modFoldersOrder.size(); ++n) {
                string = this.modFoldersOrder.get(n);
                if ("workshop".equals(string)) {
                    this.getStagedItemModsFolders(arrayList);
                }
                if ("steam".equals(string)) {
                    this.getInstalledItemModsFolders(arrayList);
                }
                if (!"mods".equals(string)) continue;
                arrayList.add(Core.getMyDocumentFolder() + File.separator + "mods");
            }
            for (n = 0; n < arrayList.size(); ++n) {
                string = (String)arrayList.get(n);
                if (!this.m_watchedModFolders.contains(string)) {
                    this.m_watchedModFolders.add(string);
                    DebugFileWatcher.instance.addDirectory(string);
                }
                this.getAllModFoldersAux(string, this.modFolders);
            }
            DebugFileWatcher.instance.add(this.m_modFileWatcher);
        }
        list.clear();
        list.addAll(this.modFolders);
    }

    public ArrayList<ChooseGameInfo.Mod> getWorkshopItemMods(long l) {
        File[] fileArray;
        ArrayList<ChooseGameInfo.Mod> arrayList = new ArrayList<ChooseGameInfo.Mod>();
        if (!SteamUtils.isSteamModeEnabled()) {
            return arrayList;
        }
        String string = SteamWorkshop.instance.GetItemInstallFolder(l);
        if (string == null) {
            return arrayList;
        }
        File file = new File(string + File.separator + "mods");
        if (!file.exists() || !file.isDirectory()) {
            return arrayList;
        }
        for (File file2 : fileArray = file.listFiles()) {
            ChooseGameInfo.Mod mod;
            if (!file2.isDirectory() || (mod = ChooseGameInfo.readModInfo(file2.getAbsolutePath())) == null) continue;
            arrayList.add(mod);
        }
        return arrayList;
    }

    public ChooseGameInfo.Mod searchForModInfo(File file, String string, ArrayList<ChooseGameInfo.Mod> arrayList) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            if (stringArray == null) {
                return null;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file.getAbsolutePath() + File.separator + stringArray[i]);
                ChooseGameInfo.Mod mod = this.searchForModInfo(file2, string, arrayList);
                if (mod == null) continue;
                return mod;
            }
        } else if (file.getAbsolutePath().endsWith("mod.info")) {
            ChooseGameInfo.Mod mod = ChooseGameInfo.readModInfo(file.getAbsoluteFile().getParent());
            if (mod == null) {
                return null;
            }
            if (!StringUtils.isNullOrWhitespace(mod.getId())) {
                this.modIdToDir.put(mod.getId(), mod.getDir());
                arrayList.add(mod);
            }
            if (mod.getId().equals(string)) {
                return mod;
            }
        }
        return null;
    }

    public void loadMod(String string) {
        if (this.getModDir(string) != null) {
            if (CoopMaster.instance != null) {
                CoopMaster.instance.update();
            }
            DebugLog.Mod.println("loading " + string);
            File file = new File(this.getModDir(string));
            URI uRI = file.toURI();
            this.loadList.clear();
            this.searchFolders(file);
            for (int i = 0; i < this.loadList.size(); ++i) {
                String string2 = this.getRelativeFile(uRI, this.loadList.get(i));
                if (this.ActiveFileMap.containsKey(string2 = string2.toLowerCase(Locale.ENGLISH)) && !string2.endsWith("mod.info") && !string2.endsWith("poster.png")) {
                    DebugLog.Mod.println("mod \"" + string + "\" overrides " + string2);
                }
                String string3 = new File(this.loadList.get(i)).getAbsolutePath();
                this.ActiveFileMap.put(string2, string3);
                this.AllAbsolutePaths.add(string3);
            }
            this.loadList.clear();
        }
    }

    private ArrayList<String> readLoadedDotTxt() {
        String string = Core.getMyDocumentFolder() + File.separator + "mods" + File.separator + "loaded.txt";
        File file = new File(string);
        if (!file.exists()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        try (FileReader fileReader = new FileReader(string);
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                if (!(string2 = string2.trim()).isEmpty()) {
                    arrayList.add(string2);
                }
                string2 = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
            arrayList = null;
        }
        try {
            file.delete();
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ActiveMods readDefaultModsTxt() {
        ActiveMods activeMods = ActiveMods.getById("default");
        ArrayList<String> arrayList = this.readLoadedDotTxt();
        if (arrayList != null) {
            activeMods.getMods().addAll(arrayList);
            this.saveModsFile();
        }
        activeMods.clear();
        String string = Core.getMyDocumentFolder() + File.separator + "mods" + File.separator + "default.txt";
        try {
            ActiveModsFile activeModsFile = new ActiveModsFile();
            if (!activeModsFile.read(string, activeMods)) return activeMods;
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
        }
        return activeMods;
    }

    public void loadMods(String string) {
        if (!Core.OptionModsEnabled) {
            return;
        }
        if (GameClient.bClient) {
            ArrayList<String> arrayList = new ArrayList<String>();
            this.loadTranslationMods(arrayList);
            arrayList.addAll(GameClient.instance.ServerMods);
            this.loadMods(arrayList);
            return;
        }
        ActiveMods activeMods = ActiveMods.getById(string);
        if (!"default".equalsIgnoreCase(string)) {
            ActiveMods.setLoadedMods(activeMods);
            this.loadMods(activeMods.getMods());
            return;
        }
        try {
            activeMods = this.readDefaultModsTxt();
            activeMods.checkMissingMods();
            activeMods.checkMissingMaps();
            ActiveMods.setLoadedMods(activeMods);
            this.loadMods(activeMods.getMods());
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
        }
    }

    private boolean isTranslationMod(String string) {
        ChooseGameInfo.Mod mod = ChooseGameInfo.getAvailableModDetails(string);
        if (mod == null) {
            return false;
        }
        boolean bl = false;
        File file = new File(mod.getDir());
        URI uRI = file.toURI();
        this.loadList.clear();
        this.searchFolders(file);
        for (int i = 0; i < this.loadList.size(); ++i) {
            String string2 = this.getRelativeFile(uRI, this.loadList.get(i));
            if (string2.endsWith(".lua")) {
                return false;
            }
            if (string2.startsWith("media/maps/")) {
                return false;
            }
            if (string2.startsWith("media/scripts/")) {
                return false;
            }
            if (!string2.startsWith("media/lua/")) continue;
            if (!string2.startsWith("media/lua/shared/Translate/")) {
                return false;
            }
            bl = true;
        }
        this.loadList.clear();
        return bl;
    }

    private void loadTranslationMods(ArrayList<String> arrayList) {
        if (!GameClient.bClient) {
            return;
        }
        ActiveMods activeMods = this.readDefaultModsTxt();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (this.loadModsAux(activeMods.getMods(), arrayList2) == null) {
            for (String string : arrayList2) {
                if (!this.isTranslationMod(string)) continue;
                DebugLog.Mod.println("loading translation mod \"" + string + "\"");
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
            }
        }
    }

    private String loadModAndRequired(String string, ArrayList<String> arrayList) {
        String string2;
        if (string.isEmpty()) {
            return null;
        }
        if (string.toLowerCase().equals("examplemod")) {
            DebugLog.Mod.warn("refusing to load " + string);
            return null;
        }
        if (arrayList.contains(string)) {
            return null;
        }
        ChooseGameInfo.Mod mod = ChooseGameInfo.getAvailableModDetails(string);
        if (mod == null) {
            if (GameServer.bServer) {
                GameServer.ServerMods.remove(string);
            }
            DebugLog.Mod.warn("required mod \"" + string + "\" not found");
            return string;
        }
        if (mod.getRequire() != null && (string2 = this.loadModsAux(mod.getRequire(), arrayList)) != null) {
            return string2;
        }
        arrayList.add(string);
        return null;
    }

    public String loadModsAux(ArrayList<String> arrayList, ArrayList<String> arrayList2) {
        for (String string : arrayList) {
            String string2 = this.loadModAndRequired(string, arrayList2);
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }

    public void loadMods(ArrayList<String> arrayList) {
        this.mods.clear();
        for (String string : arrayList) {
            this.loadModAndRequired(string, this.mods);
        }
        for (String string : this.mods) {
            this.loadMod(string);
        }
    }

    public ArrayList<String> getModIDs() {
        return this.mods;
    }

    public String getModDir(String string) {
        return this.modIdToDir.get(string);
    }

    public ChooseGameInfo.Mod getModInfoForDir(String string) {
        ChooseGameInfo.Mod mod = this.modDirToMod.get(string);
        if (mod == null) {
            mod = new ChooseGameInfo.Mod(string);
            this.modDirToMod.put(string, mod);
        }
        return mod;
    }

    public String getRelativeFile(File file) {
        return this.getRelativeFile(this.baseURI, file.getAbsolutePath());
    }

    public String getRelativeFile(String string) {
        return this.getRelativeFile(this.baseURI, string);
    }

    public String getRelativeFile(URI uRI, File file) {
        return this.getRelativeFile(uRI, file.getAbsolutePath());
    }

    public String getRelativeFile(URI uRI, String string) {
        URI uRI2 = this.getCanonicalURI(string);
        URI uRI3 = this.getCanonicalURI(uRI.getPath()).relativize(uRI2);
        if (uRI3.equals(uRI2)) {
            return string;
        }
        Object object = uRI3.getPath();
        if (string.endsWith("/") && !((String)object).endsWith("/")) {
            object = (String)object + "/";
        }
        return object;
    }

    public String getAnimName(URI uRI, File file) {
        String string = this.getRelativeFile(uRI, file);
        String string2 = string.toLowerCase(Locale.ENGLISH);
        int n = string2.lastIndexOf(46);
        if (n > -1) {
            string2 = string2.substring(0, n);
        }
        if (string2.startsWith("anims/")) {
            string2 = string2.substring("anims/".length());
        } else if (string2.startsWith("anims_x/")) {
            string2 = string2.substring("anims_x/".length());
        }
        return string2;
    }

    public String resolveRelativePath(String string, String string2) {
        Path path = Paths.get(string, new String[0]);
        Path path2 = path.getParent();
        Path path3 = path2.resolve(string2);
        String string3 = path3.toString();
        string3 = this.getRelativeFile(string3);
        return string3;
    }

    public void saveModsFile() {
        try {
            ZomboidFileSystem.ensureFolderExists(Core.getMyDocumentFolder() + File.separator + "mods");
            String string = Core.getMyDocumentFolder() + File.separator + "mods" + File.separator + "default.txt";
            ActiveModsFile activeModsFile = new ActiveModsFile();
            activeModsFile.write(string, ActiveMods.getById("default"));
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
        }
    }

    public void loadModPackFiles() {
        for (String string : this.mods) {
            try {
                ChooseGameInfo.Mod mod = ChooseGameInfo.getAvailableModDetails(string);
                if (mod == null) continue;
                for (ChooseGameInfo.PackFile packFile : mod.getPacks()) {
                    String string2 = this.getRelativeFile("media/texturepacks/" + packFile.name + ".pack");
                    if (!this.ActiveFileMap.containsKey(string2 = string2.toLowerCase(Locale.ENGLISH))) {
                        DebugLog.Mod.warn("pack file \"" + packFile.name + "\" needed by " + string + " not found");
                        continue;
                    }
                    String string3 = instance.getString("media/texturepacks/" + packFile.name + ".pack");
                    if (this.LoadedPacks.contains(string3)) continue;
                    GameWindow.LoadTexturePack(packFile.name, packFile.flags, string);
                    this.LoadedPacks.add(string3);
                }
            }
            catch (Exception exception) {
                ExceptionLogger.logException(exception);
            }
        }
        GameWindow.setTexturePackLookup();
    }

    public void loadModTileDefs() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (String string : this.mods) {
            try {
                ChooseGameInfo.Mod mod = ChooseGameInfo.getAvailableModDetails(string);
                if (mod == null) continue;
                for (ChooseGameInfo.TileDef tileDef : mod.getTileDefs()) {
                    if (hashSet.contains(tileDef.fileNumber)) {
                        DebugLog.Mod.error("tiledef fileNumber " + tileDef.fileNumber + " used by more than one mod");
                        continue;
                    }
                    String string2 = tileDef.name;
                    String string3 = this.getRelativeFile("media/" + string2 + ".tiles");
                    if (!this.ActiveFileMap.containsKey(string3 = string3.toLowerCase(Locale.ENGLISH))) {
                        DebugLog.Mod.error("tiledef file \"" + tileDef.name + "\" needed by " + string + " not found");
                        continue;
                    }
                    string2 = this.ActiveFileMap.get(string3);
                    IsoWorld.instance.LoadTileDefinitions(IsoSpriteManager.instance, string2, tileDef.fileNumber);
                    hashSet.add(tileDef.fileNumber);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void loadModTileDefPropertyStrings() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (String string : this.mods) {
            try {
                ChooseGameInfo.Mod mod = ChooseGameInfo.getAvailableModDetails(string);
                if (mod == null) continue;
                for (ChooseGameInfo.TileDef tileDef : mod.getTileDefs()) {
                    if (hashSet.contains(tileDef.fileNumber)) {
                        DebugLog.Mod.error("tiledef fileNumber " + tileDef.fileNumber + " used by more than one mod");
                        continue;
                    }
                    String string2 = tileDef.name;
                    String string3 = this.getRelativeFile("media/" + string2 + ".tiles");
                    if (!this.ActiveFileMap.containsKey(string3 = string3.toLowerCase(Locale.ENGLISH))) {
                        DebugLog.Mod.error("tiledef file \"" + tileDef.name + "\" needed by " + string + " not found");
                        continue;
                    }
                    string2 = this.ActiveFileMap.get(string3);
                    IsoWorld.instance.LoadTileDefinitionsPropertyStrings(IsoSpriteManager.instance, string2, tileDef.fileNumber);
                    hashSet.add(tileDef.fileNumber);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void loadFileGuidTable() {
        JAXBContext jAXBContext;
        FileInputStream fileInputStream;
        File file = instance.getMediaFile("fileGuidTable.xml");
        try {
            fileInputStream = new FileInputStream(file);
            try {
                jAXBContext = JAXBContext.newInstance((Class[])new Class[]{FileGuidTable.class});
                Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
                this.m_fileGuidTable = (FileGuidTable)unmarshaller.unmarshal((InputStream)fileInputStream);
                this.m_fileGuidTable.setModID("game");
            }
            finally {
                fileInputStream.close();
            }
        }
        catch (IOException | JAXBException throwable) {
            System.err.println("Failed to load file Guid table.");
            ExceptionLogger.logException(throwable);
            return;
        }
        try {
            fileInputStream = JAXBContext.newInstance((Class[])new Class[]{FileGuidTable.class});
            jAXBContext = fileInputStream.createUnmarshaller();
            for (String string2 : this.getModIDs()) {
                ChooseGameInfo.Mod mod = ChooseGameInfo.getAvailableModDetails(string2);
                if (mod == null) continue;
                try (FileInputStream fileInputStream2 = new FileInputStream(this.getModDir(string2) + "/media/fileGuidTable.xml");){
                    FileGuidTable fileGuidTable = (FileGuidTable)jAXBContext.unmarshal((InputStream)fileInputStream2);
                    fileGuidTable.setModID(string2);
                    this.m_fileGuidTable.mergeFrom(fileGuidTable);
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (Exception exception) {
                    ExceptionLogger.logException(exception);
                }
            }
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
        }
        this.m_fileGuidTable.loaded();
        if (!this.m_fileGuidTableWatcherActive) {
            DebugFileWatcher.instance.add(new PredicatedFileWatcher("media/fileGuidTable.xml", string -> this.loadFileGuidTable()));
            this.m_fileGuidTableWatcherActive = true;
        }
    }

    public FileGuidTable getFileGuidTable() {
        if (this.m_fileGuidTable == null) {
            this.loadFileGuidTable();
        }
        return this.m_fileGuidTable;
    }

    public String getFilePathFromGuid(String string) {
        FileGuidTable fileGuidTable = this.getFileGuidTable();
        if (fileGuidTable != null) {
            return fileGuidTable.getFilePathFromGuid(string);
        }
        return null;
    }

    public String getGuidFromFilePath(String string) {
        FileGuidTable fileGuidTable = this.getFileGuidTable();
        if (fileGuidTable != null) {
            return fileGuidTable.getGuidFromFilePath(string);
        }
        return null;
    }

    public String resolveFileOrGUID(String string) {
        String string2;
        String string3 = string;
        String string4 = this.getFilePathFromGuid(string);
        if (string4 != null) {
            string3 = string4;
        }
        if (this.ActiveFileMap.containsKey(string2 = string3.toLowerCase(Locale.ENGLISH))) {
            return this.ActiveFileMap.get(string2);
        }
        return string3;
    }

    public boolean isValidFilePathGuid(String string) {
        return this.getFilePathFromGuid(string) != null;
    }

    public static File[] listAllDirectories(String string, FileFilter fileFilter, boolean bl) {
        File file = new File(string).getAbsoluteFile();
        return ZomboidFileSystem.listAllDirectories(file, fileFilter, bl);
    }

    public static File[] listAllDirectories(File file, FileFilter fileFilter, boolean bl) {
        if (!file.isDirectory()) {
            return new File[0];
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        ZomboidFileSystem.listAllDirectoriesInternal(file, fileFilter, bl, arrayList);
        return arrayList.toArray(new File[0]);
    }

    private static void listAllDirectoriesInternal(File file, FileFilter fileFilter, boolean bl, ArrayList<File> arrayList) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            if (file2.isFile() || !file2.isDirectory()) continue;
            if (fileFilter.accept(file2)) {
                arrayList.add(file2);
            }
            if (!bl) continue;
            ZomboidFileSystem.listAllFilesInternal(file2, fileFilter, true, arrayList);
        }
    }

    public static File[] listAllFiles(String string, FileFilter fileFilter, boolean bl) {
        File file = new File(string).getAbsoluteFile();
        return ZomboidFileSystem.listAllFiles(file, fileFilter, bl);
    }

    public static File[] listAllFiles(File file, FileFilter fileFilter, boolean bl) {
        if (!file.isDirectory()) {
            return new File[0];
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        ZomboidFileSystem.listAllFilesInternal(file, fileFilter, bl, arrayList);
        return arrayList.toArray(new File[0]);
    }

    private static void listAllFilesInternal(File file, FileFilter fileFilter, boolean bl, ArrayList<File> arrayList) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            if (file2.isFile()) {
                if (!fileFilter.accept(file2)) continue;
                arrayList.add(file2);
                continue;
            }
            if (!file2.isDirectory() || !bl) continue;
            ZomboidFileSystem.listAllFilesInternal(file2, fileFilter, true, arrayList);
        }
    }

    public void walkGameAndModFiles(String string, boolean bl, IWalkFilesVisitor iWalkFilesVisitor) {
        this.walkGameAndModFilesInternal(this.base, string, bl, iWalkFilesVisitor);
        ArrayList<String> arrayList = this.getModIDs();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = this.getModDir(arrayList.get(i));
            if (string2 == null) continue;
            this.walkGameAndModFilesInternal(new File(string2), string, bl, iWalkFilesVisitor);
        }
    }

    private void walkGameAndModFilesInternal(File file, String string, boolean bl, IWalkFilesVisitor iWalkFilesVisitor) {
        File file2 = new File(file, string);
        if (!file2.isDirectory()) {
            return;
        }
        File[] fileArray = file2.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file3 : fileArray) {
            iWalkFilesVisitor.visit(file3, string);
            if (!bl || !file3.isDirectory()) continue;
            this.walkGameAndModFilesInternal(file, string + "/" + file3.getName(), true, iWalkFilesVisitor);
        }
    }

    public String[] resolveAllDirectories(String string2, FileFilter fileFilter, boolean bl) {
        ArrayList arrayList = new ArrayList();
        this.walkGameAndModFiles(string2, bl, (file, string) -> {
            String string2;
            if (file.isDirectory() && fileFilter.accept(file) && !arrayList.contains(string2 = string + "/" + file.getName())) {
                arrayList.add(string2);
            }
        });
        return arrayList.toArray(new String[0]);
    }

    public String[] resolveAllFiles(String string2, FileFilter fileFilter, boolean bl) {
        ArrayList arrayList = new ArrayList();
        this.walkGameAndModFiles(string2, bl, (file, string) -> {
            String string2;
            if (file.isFile() && fileFilter.accept(file) && !arrayList.contains(string2 = string + "/" + file.getName())) {
                arrayList.add(string2);
            }
        });
        return arrayList.toArray(new String[0]);
    }

    public String normalizeFolderPath(String object) {
        object = ((String)object).toLowerCase(Locale.ENGLISH).replace('\\', '/');
        object = (String)object + "/";
        object = ((String)object).replace("///", "/").replace("//", "/");
        return object;
    }

    public static String processFilePath(String string, char c) {
        if (c != '\\') {
            string = string.replace('\\', c);
        }
        if (c != '/') {
            string = string.replace('/', c);
        }
        return string;
    }

    public boolean tryDeleteFile(String string) {
        if (StringUtils.isNullOrWhitespace(string)) {
            return false;
        }
        try {
            return this.deleteFile(string);
        }
        catch (IOException | AccessControlException exception) {
            ExceptionLogger.logException(exception, String.format("Failed to delete file: \"%s\"", string), DebugLog.FileIO, LogSeverity.General);
            return false;
        }
    }

    public boolean deleteFile(String string) throws IOException {
        File file = new File(string).getAbsoluteFile();
        if (!file.isFile()) {
            throw new FileNotFoundException(String.format("File path not found: \"%s\"", string));
        }
        if (file.delete()) {
            DebugLog.FileIO.debugln("File deleted successfully: \"%s\"", string);
            return true;
        }
        DebugLog.FileIO.debugln("Failed to delete file: \"%s\"", string);
        return false;
    }

    public void update() {
        if (this.m_modsChangedTime == 0L) {
            return;
        }
        long l = System.currentTimeMillis();
        if (this.m_modsChangedTime > l) {
            return;
        }
        this.m_modsChangedTime = 0L;
        this.modFolders = null;
        this.modIdToDir.clear();
        this.modDirToMod.clear();
        ChooseGameInfo.Reset();
        for (String string : this.getModIDs()) {
            ChooseGameInfo.getModDetails(string);
        }
        LuaEventManager.triggerEvent("OnModsModified");
    }

    private boolean isModFile(String string) {
        if (this.m_modsChangedTime > 0L) {
            return false;
        }
        if (this.modFolders == null) {
            return false;
        }
        if ((string = string.toLowerCase().replace('\\', '/')).endsWith("/mods/default.txt")) {
            return false;
        }
        for (int i = 0; i < this.modFolders.size(); ++i) {
            String string2 = this.modFolders.get(i).toLowerCase().replace('\\', '/');
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    private void onModFileChanged(String string) {
        this.m_modsChangedTime = System.currentTimeMillis() + 2000L;
    }

    public void cleanMultiplayerSaves() {
        DebugLog.FileIO.println("Start cleaning save fs");
        String string = this.getSaveDir();
        String string2 = string + File.separator + "Multiplayer" + File.separator;
        File file = new File(string2);
        if (!file.exists()) {
            file.mkdir();
        }
        try {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                File file3;
                DebugLog.FileIO.println("Checking " + file2.getAbsoluteFile() + " dir");
                if (!file2.isDirectory() || !(file3 = new File(file2.toString() + File.separator + "map.bin")).exists()) continue;
                DebugLog.FileIO.println("Processing " + file2.getAbsoluteFile() + " dir");
                try {
                    Stream<Path> stream = Files.walk(file2.toPath(), new FileVisitOption[0]);
                    stream.forEach(path -> {
                        if (path.getFileName().toString().matches("map_\\d+_\\d+.bin")) {
                            DebugLog.FileIO.println("Delete " + path.getFileName().toString());
                            path.toFile().delete();
                        }
                    });
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    public void resetDefaultModsForNewRelease(String string) {
        Object object;
        ZomboidFileSystem.ensureFolderExists(this.getCacheDirSub("mods"));
        String string2 = this.getCacheDirSub("mods") + File.separator + "reset-mods-" + string + ".txt";
        File file = new File(string2);
        if (file.exists()) {
            return;
        }
        try {
            object = new FileWriter(file);
            try (BufferedWriter bufferedWriter = new BufferedWriter((Writer)object);){
                String string3 = "If this file does not exist, default.txt will be reset to empty (no mods active).";
                bufferedWriter.write(string3);
            }
            finally {
                ((OutputStreamWriter)object).close();
            }
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
            return;
        }
        object = ActiveMods.getById("default");
        ((ActiveMods)object).clear();
        this.saveModsFile();
    }

    public static interface IWalkFilesVisitor {
        public void visit(File var1, String var2);
    }
}

