/*
 * Decompiled with CFR 0.152.
 */
package zombie;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import zombie.PersistentOutfits;
import zombie.ReanimatedPlayers;
import zombie.SandboxOptions;
import zombie.SystemDisabler;
import zombie.ZombieSpawnRecorder;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.characters.ZombiesZoneDefinition;
import zombie.characters.action.ActionGroup;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.inventory.InventoryItemFactory;
import zombie.inventory.types.HandWeapon;
import zombie.iso.IsoChunk;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMetaChunk;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoWorld;
import zombie.iso.RoomDef;
import zombie.iso.Vector2;
import zombie.iso.areas.IsoRoom;
import zombie.iso.objects.IsoDeadBody;
import zombie.iso.objects.IsoFireManager;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.ServerMap;
import zombie.popman.NetworkZombieSimulator;
import zombie.popman.ZombiePopulationManager;
import zombie.vehicles.PolygonalMap2;

public final class VirtualZombieManager {
    private final ArrayDeque<IsoZombie> ReusableZombies = new ArrayDeque();
    private final HashSet<IsoZombie> ReusableZombieSet = new HashSet();
    private final ArrayList<IsoZombie> ReusedThisFrame = new ArrayList();
    private final ArrayList<IsoZombie> RecentlyRemoved = new ArrayList();
    public static VirtualZombieManager instance = new VirtualZombieManager();
    public int MaxRealZombies = 1;
    private final ArrayList<IsoZombie> m_tempZombies = new ArrayList();
    public final ArrayList<IsoGridSquare> choices = new ArrayList();
    private final ArrayList<IsoGridSquare> bestchoices = new ArrayList();
    HandWeapon w = null;
    private int BLOCKED_N = 1;
    private int BLOCKED_S = 2;
    private int BLOCKED_W = 4;
    private int BLOCKED_E = 8;
    private int NO_SQUARE_N = 16;
    private int NO_SQUARE_S = 32;
    private int NO_SQUARE_W = 64;
    private int NO_SQUARE_E = 128;

    public boolean removeZombieFromWorld(IsoZombie isoZombie) {
        boolean bl = isoZombie.getCurrentSquare() != null;
        isoZombie.getEmitter().unregister();
        isoZombie.removeFromWorld();
        isoZombie.removeFromSquare();
        return bl;
    }

    private void reuseZombie(IsoZombie isoZombie) {
        if (isoZombie == null) {
            return;
        }
        assert (!IsoWorld.instance.CurrentCell.getObjectList().contains(isoZombie));
        assert (!IsoWorld.instance.CurrentCell.getZombieList().contains(isoZombie));
        assert (isoZombie.getCurrentSquare() == null || !isoZombie.getCurrentSquare().getMovingObjects().contains(isoZombie));
        if (this.isReused(isoZombie)) {
            return;
        }
        NetworkZombieSimulator.getInstance().remove(isoZombie);
        isoZombie.resetForReuse();
        this.addToReusable(isoZombie);
    }

    public void addToReusable(IsoZombie isoZombie) {
        if (isoZombie != null && !this.ReusableZombieSet.contains(isoZombie)) {
            this.ReusableZombies.addLast(isoZombie);
            this.ReusableZombieSet.add(isoZombie);
        }
    }

    public boolean isReused(IsoZombie isoZombie) {
        return this.ReusableZombieSet.contains(isoZombie);
    }

    public void init() {
        if (GameClient.bClient) {
            return;
        }
        IsoZombie isoZombie = null;
        if (IsoWorld.getZombiesDisabled()) {
            return;
        }
        for (int i = 0; i < this.MaxRealZombies; ++i) {
            isoZombie = new IsoZombie(IsoWorld.instance.CurrentCell);
            isoZombie.getEmitter().unregister();
            this.addToReusable(isoZombie);
        }
    }

    public void Reset() {
        for (IsoZombie isoZombie : this.ReusedThisFrame) {
            if (isoZombie.vocalEvent == 0L) continue;
            isoZombie.getEmitter().stopSoundLocal(isoZombie.vocalEvent);
            isoZombie.vocalEvent = 0L;
        }
        this.bestchoices.clear();
        this.choices.clear();
        this.RecentlyRemoved.clear();
        this.ReusableZombies.clear();
        this.ReusableZombieSet.clear();
        this.ReusedThisFrame.clear();
    }

    public void update() {
        IsoZombie isoZombie;
        int n;
        long l = System.currentTimeMillis();
        for (n = this.RecentlyRemoved.size() - 1; n >= 0; --n) {
            isoZombie = this.RecentlyRemoved.get(n);
            isoZombie.updateEmitter();
            if (l - isoZombie.removedFromWorldMS <= 5000L) continue;
            if (isoZombie.vocalEvent != 0L) {
                isoZombie.getEmitter().stopSoundLocal(isoZombie.vocalEvent);
                isoZombie.vocalEvent = 0L;
            }
            isoZombie.getEmitter().stopAll();
            this.RecentlyRemoved.remove(n);
            this.ReusedThisFrame.add(isoZombie);
        }
        if (GameClient.bClient || GameServer.bServer) {
            for (n = 0; n < this.ReusedThisFrame.size(); ++n) {
                isoZombie = this.ReusedThisFrame.get(n);
                this.reuseZombie(isoZombie);
            }
            this.ReusedThisFrame.clear();
            return;
        }
        for (n = 0; n < IsoWorld.instance.CurrentCell.getZombieList().size(); ++n) {
            isoZombie = IsoWorld.instance.CurrentCell.getZombieList().get(n);
            if (isoZombie.KeepItReal || isoZombie.getCurrentSquare() != null) continue;
            isoZombie.removeFromWorld();
            isoZombie.removeFromSquare();
            assert (this.ReusedThisFrame.contains(isoZombie));
            assert (!IsoWorld.instance.CurrentCell.getZombieList().contains(isoZombie));
            --n;
        }
        for (n = 0; n < this.ReusedThisFrame.size(); ++n) {
            isoZombie = this.ReusedThisFrame.get(n);
            this.reuseZombie(isoZombie);
        }
        this.ReusedThisFrame.clear();
    }

    public IsoZombie createRealZombieAlways(int n, boolean bl) {
        return this.createRealZombieAlways(n, bl, 0);
    }

    public IsoZombie createRealZombieAlways(int n, int n2, boolean bl) {
        int n3 = PersistentOutfits.instance.getOutfit(n);
        return this.createRealZombieAlways(n2, bl, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IsoZombie createRealZombieAlways(int n, boolean bl, int n2) {
        IsoZombie isoZombie = null;
        if (!SystemDisabler.doZombieCreation) {
            return null;
        }
        if (this.choices == null || this.choices.isEmpty()) {
            return null;
        }
        IsoGridSquare isoGridSquare = this.choices.get(Rand.Next(this.choices.size()));
        if (isoGridSquare == null) {
            return null;
        }
        if (this.w == null) {
            this.w = (HandWeapon)InventoryItemFactory.CreateItem("Base.Axe");
        }
        if ((GameServer.bServer || GameClient.bClient) && n2 == 0) {
            n2 = ZombiesZoneDefinition.pickPersistentOutfit(isoGridSquare);
        }
        if (this.ReusableZombies.isEmpty()) {
            isoZombie = new IsoZombie(IsoWorld.instance.CurrentCell);
            isoZombie.bDressInRandomOutfit = n2 == 0;
            isoZombie.setPersistentOutfitID(n2);
            IsoWorld.instance.CurrentCell.getObjectList().add(isoZombie);
        } else {
            isoZombie = this.ReusableZombies.removeFirst();
            this.ReusableZombieSet.remove(isoZombie);
            isoZombie.getHumanVisual().clear();
            isoZombie.clearAttachedItems();
            isoZombie.clearItemsToSpawnAtDeath();
            isoZombie.bDressInRandomOutfit = n2 == 0;
            isoZombie.setPersistentOutfitID(n2);
            isoZombie.setSitAgainstWall(false);
            isoZombie.setOnDeathDone(false);
            isoZombie.setOnKillDone(false);
            isoZombie.setDoDeathSound(true);
            isoZombie.setHitTime(0);
            isoZombie.setFallOnFront(false);
            isoZombie.setFakeDead(false);
            isoZombie.setReanimatedPlayer(false);
            isoZombie.setStateMachineLocked(false);
            Vector2 vector22 = isoZombie.dir.ToVector();
            vector22.x += (float)Rand.Next(200) / 100.0f - 0.5f;
            vector22.y += (float)Rand.Next(200) / 100.0f - 0.5f;
            vector22.normalize();
            isoZombie.setForwardDirection(vector22);
            IsoWorld.instance.CurrentCell.getObjectList().add(isoZombie);
            isoZombie.walkVariant = "ZombieWalk";
            isoZombie.DoZombieStats();
            if (isoZombie.isOnFire()) {
                IsoFireManager.RemoveBurningCharacter(isoZombie);
                isoZombie.setOnFire(false);
            }
            if (isoZombie.AttachedAnimSprite != null) {
                isoZombie.AttachedAnimSprite.clear();
            }
            isoZombie.thumpFlag = 0;
            isoZombie.thumpSent = false;
            isoZombie.soundSourceTarget = null;
            isoZombie.soundAttract = 0.0f;
            isoZombie.soundAttractTimeout = 0.0f;
            isoZombie.bodyToEat = null;
            isoZombie.eatBodyTarget = null;
            isoZombie.atlasTex = null;
            isoZombie.clearVariables();
            isoZombie.setStaggerBack(false);
            isoZombie.setKnockedDown(false);
            isoZombie.setKnifeDeath(false);
            isoZombie.setJawStabAttach(false);
            isoZombie.setCrawler(false);
            isoZombie.initializeStates();
            isoZombie.actionContext.setGroup(ActionGroup.getActionGroup("zombie"));
            isoZombie.advancedAnimator.OnAnimDataChanged(false);
            isoZombie.setDefaultState();
            isoZombie.getAnimationPlayer().resetBoneModelTransforms();
        }
        isoZombie.dir = IsoDirections.fromIndex(n);
        isoZombie.setForwardDirection(isoZombie.dir.ToVector());
        isoZombie.getInventory().setExplored(false);
        if (bl) {
            isoZombie.bDressInRandomOutfit = true;
        }
        isoZombie.target = null;
        isoZombie.TimeSinceSeenFlesh = 100000.0f;
        if (!isoZombie.isFakeDead()) {
            if (SandboxOptions.instance.Lore.Toughness.getValue() == 1) {
                isoZombie.setHealth(3.5f + Rand.Next(0.0f, 0.3f));
            }
            if (SandboxOptions.instance.Lore.Toughness.getValue() == 2) {
                isoZombie.setHealth(1.5f + Rand.Next(0.0f, 0.3f));
            }
            if (SandboxOptions.instance.Lore.Toughness.getValue() == 3) {
                isoZombie.setHealth(0.5f + Rand.Next(0.0f, 0.3f));
            }
            if (SandboxOptions.instance.Lore.Toughness.getValue() == 4) {
                isoZombie.setHealth(Rand.Next(0.5f, 3.5f) + Rand.Next(0.0f, 0.3f));
            }
        } else {
            isoZombie.setHealth(0.5f + Rand.Next(0.0f, 0.3f));
        }
        float f = Rand.Next(0, 1000);
        float f2 = Rand.Next(0, 1000);
        f /= 1000.0f;
        f2 /= 1000.0f;
        isoZombie.setCurrent(isoGridSquare);
        isoZombie.setMovingSquareNow();
        isoZombie.setX(f += (float)isoGridSquare.getX());
        isoZombie.setY(f2 += (float)isoGridSquare.getY());
        isoZombie.setZ(isoGridSquare.getZ());
        if ((GameClient.bClient || GameServer.bServer) && isoZombie.networkAI != null) {
            isoZombie.networkAI.reset();
        }
        isoZombie.upKillCount = true;
        if (bl) {
            isoZombie.setDir(IsoDirections.fromIndex(Rand.Next(8)));
            isoZombie.setForwardDirection(isoZombie.dir.ToVector());
            isoZombie.setFakeDead(false);
            isoZombie.setHealth(0.0f);
            isoZombie.upKillCount = false;
            isoZombie.DoZombieInventory();
            new IsoDeadBody(isoZombie, true);
            return isoZombie;
        }
        ArrayList<IsoZombie> arrayList = IsoWorld.instance.CurrentCell.getZombieList();
        synchronized (arrayList) {
            isoZombie.getEmitter().register();
            IsoWorld.instance.CurrentCell.getZombieList().add(isoZombie);
            if (GameClient.bClient) {
                isoZombie.bRemote = true;
            }
            if (GameServer.bServer) {
                isoZombie.OnlineID = ServerMap.instance.getUniqueZombieId();
                if (isoZombie.OnlineID == -1) {
                    IsoWorld.instance.CurrentCell.getZombieList().remove(isoZombie);
                    IsoWorld.instance.CurrentCell.getObjectList().remove(isoZombie);
                    this.ReusedThisFrame.add(isoZombie);
                    return null;
                }
                ServerMap.instance.ZombieMap.put(isoZombie.OnlineID, isoZombie);
            }
            return isoZombie;
        }
    }

    private IsoGridSquare pickEatingZombieSquare(float f, float f2, float f3, float f4, int n) {
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(f3, f4, (double)n);
        if (isoGridSquare == null || !this.canSpawnAt(isoGridSquare.x, isoGridSquare.y, isoGridSquare.z) || isoGridSquare.HasStairs()) {
            return null;
        }
        if (PolygonalMap2.instance.lineClearCollide(f, f2, f3, f4, n, null, false, true)) {
            return null;
        }
        return isoGridSquare;
    }

    public void createEatingZombies(IsoDeadBody isoDeadBody, int n) {
        if (IsoWorld.getZombiesDisabled()) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            float f = isoDeadBody.x;
            float f2 = isoDeadBody.y;
            switch (i) {
                case 0: {
                    f -= 0.5f;
                    break;
                }
                case 1: {
                    f += 0.5f;
                    break;
                }
                case 2: {
                    f2 -= 0.5f;
                    break;
                }
                case 3: {
                    f2 += 0.5f;
                }
            }
            IsoGridSquare isoGridSquare = this.pickEatingZombieSquare(isoDeadBody.x, isoDeadBody.y, f, f2, (int)isoDeadBody.z);
            if (isoGridSquare == null) continue;
            this.choices.clear();
            this.choices.add(isoGridSquare);
            IsoZombie isoZombie = this.createRealZombieAlways(1, false);
            if (isoZombie == null) continue;
            ZombieSpawnRecorder.instance.record(isoZombie, "createEatingZombies");
            isoZombie.bDressInRandomOutfit = true;
            isoZombie.setX(f);
            isoZombie.setY(f2);
            isoZombie.setZ(isoDeadBody.z);
            isoZombie.faceLocationF(isoDeadBody.x, isoDeadBody.y);
            isoZombie.setEatBodyTarget(isoDeadBody, true);
        }
    }

    private IsoZombie createRealZombie(int n, boolean bl) {
        if (GameClient.bClient) {
            return null;
        }
        return this.createRealZombieAlways(n, bl);
    }

    public void AddBloodToMap(int n, IsoChunk isoChunk) {
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            IsoGridSquare isoGridSquare = null;
            int n4 = 0;
            do {
                n3 = Rand.Next(10);
                n2 = Rand.Next(10);
                isoGridSquare = isoChunk.getGridSquare(n3, n2, 0);
            } while (++n4 < 100 && (isoGridSquare == null || !isoGridSquare.isFree(false)));
            if (isoGridSquare == null) continue;
            n3 = 5;
            if (Rand.Next(10) == 0) {
                n3 = 10;
            }
            if (Rand.Next(40) == 0) {
                n3 = 20;
            }
            for (n2 = 0; n2 < n3; ++n2) {
                float f = (float)Rand.Next(3000) / 1000.0f;
                float f2 = (float)Rand.Next(3000) / 1000.0f;
                isoChunk.addBloodSplat((float)isoGridSquare.getX() + (f -= 1.5f), (float)isoGridSquare.getY() + (f2 -= 1.5f), isoGridSquare.getZ(), Rand.Next(12) + 8);
            }
        }
    }

    public ArrayList<IsoZombie> addZombiesToMap(int n, RoomDef roomDef) {
        return this.addZombiesToMap(n, roomDef, true);
    }

    public ArrayList<IsoZombie> addZombiesToMap(int n, RoomDef roomDef, boolean bl) {
        int n2;
        int n3;
        ArrayList<IsoZombie> arrayList = new ArrayList<IsoZombie>();
        if ("Tutorial".equals(Core.GameMode)) {
            return arrayList;
        }
        if (IsoWorld.getZombiesDisabled()) {
            return arrayList;
        }
        this.choices.clear();
        this.bestchoices.clear();
        IsoGridSquare isoGridSquare = null;
        for (n3 = 0; n3 < roomDef.rects.size(); ++n3) {
            n2 = roomDef.level;
            RoomDef.RoomRect roomRect = roomDef.rects.get(n3);
            for (int i = roomRect.x; i < roomRect.getX2(); ++i) {
                for (int j = roomRect.y; j < roomRect.getY2(); ++j) {
                    isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(i, j, n2);
                    if (isoGridSquare == null || !this.canSpawnAt(i, j, n2)) continue;
                    this.choices.add(isoGridSquare);
                    boolean bl2 = false;
                    for (int k = 0; k < IsoPlayer.numPlayers; ++k) {
                        if (IsoPlayer.players[k] == null || !isoGridSquare.isSeen(k)) continue;
                        bl2 = true;
                    }
                    if (bl2) continue;
                    this.bestchoices.add(isoGridSquare);
                }
            }
        }
        n = Math.min(n, this.choices.size());
        if (!this.bestchoices.isEmpty()) {
            this.choices.addAll(this.bestchoices);
            this.choices.addAll(this.bestchoices);
        }
        for (n3 = 0; n3 < n; ++n3) {
            if (!this.choices.isEmpty()) {
                roomDef.building.bAlarmed = false;
                n2 = Rand.Next(8);
                int n4 = 4;
                IsoZombie isoZombie = this.createRealZombie(n2, bl ? Rand.Next(n4) == 0 : false);
                if (isoZombie == null || isoZombie.getSquare() == null) continue;
                if (!GameServer.bServer) {
                    isoZombie.bDressInRandomOutfit = true;
                }
                isoZombie.setX((float)((int)isoZombie.getX()) + (float)Rand.Next(2, 8) / 10.0f);
                isoZombie.setY((float)((int)isoZombie.getY()) + (float)Rand.Next(2, 8) / 10.0f);
                this.choices.remove(isoZombie.getSquare());
                this.choices.remove(isoZombie.getSquare());
                this.choices.remove(isoZombie.getSquare());
                arrayList.add(isoZombie);
                continue;
            }
            System.out.println("No choices for zombie.");
        }
        this.bestchoices.clear();
        this.choices.clear();
        return arrayList;
    }

    public void tryAddIndoorZombies(RoomDef roomDef, boolean bl) {
    }

    private void addIndoorZombies(int n, RoomDef roomDef, boolean bl) {
        int n2;
        int n3;
        this.choices.clear();
        this.bestchoices.clear();
        IsoGridSquare isoGridSquare = null;
        for (n3 = 0; n3 < roomDef.rects.size(); ++n3) {
            n2 = roomDef.level;
            RoomDef.RoomRect roomRect = roomDef.rects.get(n3);
            for (int i = roomRect.x; i < roomRect.getX2(); ++i) {
                for (int j = roomRect.y; j < roomRect.getY2(); ++j) {
                    isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(i, j, n2);
                    if (isoGridSquare == null || !this.canSpawnAt(i, j, n2)) continue;
                    this.choices.add(isoGridSquare);
                }
            }
        }
        n = Math.min(n, this.choices.size());
        if (!this.bestchoices.isEmpty()) {
            this.choices.addAll(this.bestchoices);
            this.choices.addAll(this.bestchoices);
        }
        for (n3 = 0; n3 < n; ++n3) {
            if (!this.choices.isEmpty()) {
                roomDef.building.bAlarmed = false;
                n2 = Rand.Next(8);
                int n4 = 4;
                IsoZombie isoZombie = this.createRealZombie(n2, bl ? Rand.Next(n4) == 0 : false);
                if (isoZombie == null || isoZombie.getSquare() == null) continue;
                ZombieSpawnRecorder.instance.record(isoZombie, "addIndoorZombies");
                isoZombie.bIndoorZombie = true;
                isoZombie.setX((float)((int)isoZombie.getX()) + (float)Rand.Next(2, 8) / 10.0f);
                isoZombie.setY((float)((int)isoZombie.getY()) + (float)Rand.Next(2, 8) / 10.0f);
                this.choices.remove(isoZombie.getSquare());
                this.choices.remove(isoZombie.getSquare());
                this.choices.remove(isoZombie.getSquare());
                continue;
            }
            System.out.println("No choices for zombie.");
        }
        this.bestchoices.clear();
        this.choices.clear();
    }

    public void addIndoorZombiesToChunk(IsoChunk isoChunk, IsoRoom isoRoom, int n, ArrayList<IsoZombie> arrayList) {
        Object object;
        int n2;
        if (n <= 0) {
            return;
        }
        float f = isoRoom.getRoomDef().getAreaOverlapping(isoChunk);
        int n3 = (int)Math.ceil((float)n * f);
        if (n3 <= 0) {
            return;
        }
        this.choices.clear();
        int n4 = isoRoom.def.level;
        for (n2 = 0; n2 < isoRoom.rects.size(); ++n2) {
            object = isoRoom.rects.get(n2);
            int n5 = Math.max(isoChunk.wx * 10, ((RoomDef.RoomRect)object).x);
            int n6 = Math.max(isoChunk.wy * 10, ((RoomDef.RoomRect)object).y);
            int n7 = Math.min((isoChunk.wx + 1) * 10, ((RoomDef.RoomRect)object).x + ((RoomDef.RoomRect)object).w);
            int n8 = Math.min((isoChunk.wy + 1) * 10, ((RoomDef.RoomRect)object).y + ((RoomDef.RoomRect)object).h);
            for (int i = n5; i < n7; ++i) {
                for (int j = n6; j < n8; ++j) {
                    IsoGridSquare isoGridSquare = isoChunk.getGridSquare(i - isoChunk.wx * 10, j - isoChunk.wy * 10, n4);
                    if (isoGridSquare == null || !this.canSpawnAt(i, j, n4)) continue;
                    this.choices.add(isoGridSquare);
                }
            }
        }
        if (this.choices.isEmpty()) {
            return;
        }
        isoRoom.def.building.bAlarmed = false;
        n3 = Math.min(n3, this.choices.size());
        for (n2 = 0; n2 < n3; ++n2) {
            object = this.createRealZombie(Rand.Next(8), false);
            if (object == null || ((IsoMovingObject)object).getSquare() == null) continue;
            if (!GameServer.bServer) {
                ((IsoZombie)object).bDressInRandomOutfit = true;
            }
            ((IsoMovingObject)object).setX((float)((int)((IsoMovingObject)object).getX()) + (float)Rand.Next(2, 8) / 10.0f);
            ((IsoMovingObject)object).setY((float)((int)((IsoMovingObject)object).getY()) + (float)Rand.Next(2, 8) / 10.0f);
            this.choices.remove(((IsoMovingObject)object).getSquare());
            arrayList.add((IsoZombie)object);
        }
        this.choices.clear();
    }

    public void addIndoorZombiesToChunk(IsoChunk isoChunk, IsoRoom isoRoom) {
        if (isoRoom.def.spawnCount == -1) {
            isoRoom.def.spawnCount = this.getZombieCountForRoom(isoRoom);
        }
        this.m_tempZombies.clear();
        this.addIndoorZombiesToChunk(isoChunk, isoRoom, isoRoom.def.spawnCount, this.m_tempZombies);
        ZombieSpawnRecorder.instance.record(this.m_tempZombies, "addIndoorZombiesToChunk");
    }

    public void addDeadZombiesToMap(int n, RoomDef roomDef) {
        int n2;
        int n3;
        boolean bl = false;
        this.choices.clear();
        this.bestchoices.clear();
        IsoGridSquare isoGridSquare = null;
        for (n3 = 0; n3 < roomDef.rects.size(); ++n3) {
            n2 = roomDef.level;
            RoomDef.RoomRect roomRect = roomDef.rects.get(n3);
            for (int i = roomRect.x; i < roomRect.getX2(); ++i) {
                for (int j = roomRect.y; j < roomRect.getY2(); ++j) {
                    isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(i, j, n2);
                    if (isoGridSquare == null || !isoGridSquare.isFree(false)) continue;
                    this.choices.add(isoGridSquare);
                    if (GameServer.bServer) continue;
                    boolean bl2 = false;
                    for (int k = 0; k < IsoPlayer.numPlayers; ++k) {
                        if (IsoPlayer.players[k] == null || !isoGridSquare.isSeen(k)) continue;
                        bl2 = true;
                    }
                    if (bl2) continue;
                    this.bestchoices.add(isoGridSquare);
                }
            }
        }
        n = Math.min(n, this.choices.size());
        if (!this.bestchoices.isEmpty()) {
            this.choices.addAll(this.bestchoices);
            this.choices.addAll(this.bestchoices);
        }
        for (n3 = 0; n3 < n; ++n3) {
            if (this.choices.isEmpty()) continue;
            n2 = Rand.Next(8);
            this.createRealZombie(n2, true);
        }
        this.bestchoices.clear();
        this.choices.clear();
    }

    public void RemoveZombie(IsoZombie isoZombie) {
        if (isoZombie.isReanimatedPlayer()) {
            if (isoZombie.vocalEvent != 0L) {
                isoZombie.getEmitter().stopSoundLocal(isoZombie.vocalEvent);
                isoZombie.vocalEvent = 0L;
            }
            ReanimatedPlayers.instance.removeReanimatedPlayerFromWorld(isoZombie);
            return;
        }
        if (isoZombie.isDead()) {
            if (!this.RecentlyRemoved.contains(isoZombie)) {
                isoZombie.removedFromWorldMS = System.currentTimeMillis();
                this.RecentlyRemoved.add(isoZombie);
            }
        } else if (!this.ReusedThisFrame.contains(isoZombie)) {
            this.ReusedThisFrame.add(isoZombie);
        }
    }

    public void createHordeFromTo(float f, float f2, float f3, float f4, int n) {
        ZombiePopulationManager.instance.createHordeFromTo((int)f, (int)f2, (int)f3, (int)f4, n);
    }

    public IsoZombie createRealZombie(float f, float f2, float f3) {
        this.choices.clear();
        this.choices.add(IsoWorld.instance.CurrentCell.getGridSquare(f, f2, f3));
        if (!this.choices.isEmpty()) {
            int n = Rand.Next(8);
            return this.createRealZombie(n, true);
        }
        return null;
    }

    public IsoZombie createRealZombieNow(float f, float f2, float f3) {
        this.choices.clear();
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(f, f2, f3);
        if (isoGridSquare == null) {
            return null;
        }
        this.choices.add(isoGridSquare);
        if (!this.choices.isEmpty()) {
            int n = Rand.Next(8);
            return this.createRealZombie(n, false);
        }
        return null;
    }

    private int getZombieCountForRoom(IsoRoom isoRoom) {
        int n;
        if (IsoWorld.getZombiesDisabled()) {
            return 0;
        }
        if (GameClient.bClient) {
            return 0;
        }
        if (Core.bLastStand) {
            return 0;
        }
        int n2 = 7;
        if (SandboxOptions.instance.Zombies.getValue() == 1) {
            n2 = 3;
        } else if (SandboxOptions.instance.Zombies.getValue() == 2) {
            n2 = 4;
        } else if (SandboxOptions.instance.Zombies.getValue() == 3) {
            n2 = 6;
        } else if (SandboxOptions.instance.Zombies.getValue() == 5) {
            n2 = 15;
        }
        float f = 0.0f;
        IsoMetaChunk isoMetaChunk = IsoWorld.instance.getMetaChunk(isoRoom.def.x / 10, isoRoom.def.y / 10);
        if (isoMetaChunk != null && (f = isoMetaChunk.getLootZombieIntensity()) > 4.0f) {
            n2 = (int)((float)n2 - (f / 2.0f - 2.0f));
        }
        if (isoRoom.def.getArea() > 100) {
            n2 -= 2;
        }
        n2 = Math.max(2, n2);
        if (isoRoom.getBuilding() != null) {
            n = isoRoom.def.getArea();
            if (isoRoom.getBuilding().getRoomsNumber() > 100 && n >= 20) {
                int n3 = isoRoom.getBuilding().getRoomsNumber() - 95;
                if (n3 > 20) {
                    n3 = 20;
                }
                if (SandboxOptions.instance.Zombies.getValue() == 1) {
                    n3 += 10;
                } else if (SandboxOptions.instance.Zombies.getValue() == 2) {
                    n3 += 7;
                } else if (SandboxOptions.instance.Zombies.getValue() == 3) {
                    n3 += 5;
                } else if (SandboxOptions.instance.Zombies.getValue() == 4) {
                    n3 -= 10;
                }
                if (n < 30) {
                    n3 -= 6;
                }
                if (n < 50) {
                    n3 -= 10;
                }
                if (n < 70) {
                    n3 -= 13;
                }
                return Rand.Next(n3, n3 + 10);
            }
        }
        if (Rand.Next(n2) == 0) {
            n = 1;
            n = (int)((float)n + (f / 2.0f - 2.0f));
            if (isoRoom.def.getArea() < 30) {
                n -= 4;
            }
            if (isoRoom.def.getArea() > 85) {
                n += 2;
            }
            if (isoRoom.getBuilding().getRoomsNumber() < 7) {
                n -= 2;
            }
            if (SandboxOptions.instance.Zombies.getValue() == 1) {
                n += 3;
            } else if (SandboxOptions.instance.Zombies.getValue() == 2) {
                n += 2;
            } else if (SandboxOptions.instance.Zombies.getValue() == 3) {
                ++n;
            } else if (SandboxOptions.instance.Zombies.getValue() == 5) {
                n -= 2;
            }
            n = Math.max(0, n);
            n = Math.min(7, n);
            return Rand.Next(n, n + 2);
        }
        return 0;
    }

    public void roomSpotted(IsoRoom isoRoom) {
        if (GameClient.bClient) {
            return;
        }
        isoRoom.def.forEachChunk((roomDef, isoChunk) -> isoChunk.addSpawnedRoom(roomDef.ID));
        if (isoRoom.def.spawnCount == -1) {
            isoRoom.def.spawnCount = this.getZombieCountForRoom(isoRoom);
        }
        if (isoRoom.def.spawnCount <= 0) {
            return;
        }
        if (isoRoom.getBuilding().getDef().isFullyStreamedIn()) {
            ArrayList<IsoZombie> arrayList = this.addZombiesToMap(isoRoom.def.spawnCount, isoRoom.def, false);
            ZombieSpawnRecorder.instance.record(arrayList, "roomSpotted");
        } else {
            this.m_tempZombies.clear();
            isoRoom.def.forEachChunk((roomDef, isoChunk) -> this.addIndoorZombiesToChunk((IsoChunk)isoChunk, isoRoom, isoRoom.def.spawnCount, this.m_tempZombies));
            ZombieSpawnRecorder.instance.record(this.m_tempZombies, "roomSpotted");
        }
    }

    private int getBlockedBits(IsoGridSquare isoGridSquare) {
        int n = 0;
        if (isoGridSquare == null) {
            return n;
        }
        if (isoGridSquare.nav[IsoDirections.N.index()] == null) {
            n |= this.NO_SQUARE_N;
        } else if (IsoGridSquare.getMatrixBit(isoGridSquare.pathMatrix, 1, 0, 1)) {
            n |= this.BLOCKED_N;
        }
        if (isoGridSquare.nav[IsoDirections.S.index()] == null) {
            n |= this.NO_SQUARE_S;
        } else if (IsoGridSquare.getMatrixBit(isoGridSquare.pathMatrix, 1, 2, 1)) {
            n |= this.BLOCKED_S;
        }
        if (isoGridSquare.nav[IsoDirections.W.index()] == null) {
            n |= this.NO_SQUARE_W;
        } else if (IsoGridSquare.getMatrixBit(isoGridSquare.pathMatrix, 0, 1, 1)) {
            n |= this.BLOCKED_W;
        }
        if (isoGridSquare.nav[IsoDirections.E.index()] == null) {
            n |= this.NO_SQUARE_E;
        } else if (IsoGridSquare.getMatrixBit(isoGridSquare.pathMatrix, 2, 1, 1)) {
            n |= this.BLOCKED_E;
        }
        return n;
    }

    private boolean isBlockedInAllDirections(int n, int n2, int n3) {
        IsoGridSquare isoGridSquare;
        IsoGridSquare isoGridSquare2 = isoGridSquare = GameServer.bServer ? ServerMap.instance.getGridSquare(n, n2, n3) : IsoWorld.instance.CurrentCell.getGridSquare(n, n2, n3);
        if (isoGridSquare == null) {
            return false;
        }
        boolean bl = IsoGridSquare.getMatrixBit(isoGridSquare.pathMatrix, 1, 0, 1) && isoGridSquare.nav[IsoDirections.N.index()] != null;
        boolean bl2 = IsoGridSquare.getMatrixBit(isoGridSquare.pathMatrix, 1, 2, 1) && isoGridSquare.nav[IsoDirections.S.index()] != null;
        boolean bl3 = IsoGridSquare.getMatrixBit(isoGridSquare.pathMatrix, 0, 1, 1) && isoGridSquare.nav[IsoDirections.W.index()] != null;
        boolean bl4 = IsoGridSquare.getMatrixBit(isoGridSquare.pathMatrix, 2, 1, 1) && isoGridSquare.nav[IsoDirections.E.index()] != null;
        return bl && bl2 && bl3 && bl4;
    }

    private boolean canPathOnlyN(IsoGridSquare isoGridSquare) {
        int n;
        while (((n = this.getBlockedBits(isoGridSquare)) & (this.BLOCKED_W | this.BLOCKED_E)) == (this.BLOCKED_W | this.BLOCKED_E)) {
            if ((n & this.NO_SQUARE_N) != 0) {
                return false;
            }
            if ((n & this.BLOCKED_N) != 0) {
                return true;
            }
            isoGridSquare = isoGridSquare.nav[IsoDirections.N.index()];
        }
        return false;
    }

    private boolean canPathOnlyS(IsoGridSquare isoGridSquare) {
        int n;
        while (((n = this.getBlockedBits(isoGridSquare)) & (this.BLOCKED_W | this.BLOCKED_E)) == (this.BLOCKED_W | this.BLOCKED_E)) {
            if ((n & this.NO_SQUARE_S) != 0) {
                return false;
            }
            if ((n & this.BLOCKED_S) != 0) {
                return true;
            }
            isoGridSquare = isoGridSquare.nav[IsoDirections.S.index()];
        }
        return false;
    }

    private boolean canPathOnlyW(IsoGridSquare isoGridSquare) {
        int n;
        while (((n = this.getBlockedBits(isoGridSquare)) & (this.BLOCKED_N | this.BLOCKED_S)) == (this.BLOCKED_N | this.BLOCKED_S)) {
            if ((n & this.NO_SQUARE_W) != 0) {
                return false;
            }
            if ((n & this.BLOCKED_W) != 0) {
                return true;
            }
            isoGridSquare = isoGridSquare.nav[IsoDirections.W.index()];
        }
        return false;
    }

    private boolean canPathOnlyE(IsoGridSquare isoGridSquare) {
        int n;
        while (((n = this.getBlockedBits(isoGridSquare)) & (this.BLOCKED_N | this.BLOCKED_S)) == (this.BLOCKED_N | this.BLOCKED_S)) {
            if ((n & this.NO_SQUARE_E) != 0) {
                return false;
            }
            if ((n & this.BLOCKED_E) != 0) {
                return true;
            }
            isoGridSquare = isoGridSquare.nav[IsoDirections.E.index()];
        }
        return false;
    }

    public boolean canSpawnAt(int n, int n2, int n3) {
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n, n2, n3);
        if (isoGridSquare == null || !isoGridSquare.isFree(false)) {
            return false;
        }
        int n4 = this.getBlockedBits(isoGridSquare);
        if (n4 == (this.BLOCKED_N | this.BLOCKED_S | this.BLOCKED_W | this.BLOCKED_E)) {
            return false;
        }
        if ((n4 & (this.BLOCKED_N | this.BLOCKED_S)) == (this.BLOCKED_N | this.BLOCKED_S) && this.canPathOnlyW(isoGridSquare) && this.canPathOnlyE(isoGridSquare)) {
            return false;
        }
        return (n4 & (this.BLOCKED_W | this.BLOCKED_E)) != (this.BLOCKED_W | this.BLOCKED_E) || !this.canPathOnlyN(isoGridSquare) || !this.canPathOnlyS(isoGridSquare);
    }

    public int reusableZombiesSize() {
        return this.ReusableZombies.size();
    }
}

