/*
 * Decompiled with CFR 0.152.
 */
package zombie;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import zombie.GameWindow;
import zombie.PersistentOutfits;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoZombie;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.core.skinnedmodel.visual.HumanVisual;
import zombie.core.skinnedmodel.visual.IHumanVisual;
import zombie.core.skinnedmodel.visual.ItemVisual;
import zombie.core.skinnedmodel.visual.ItemVisuals;
import zombie.debug.DebugLog;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.PacketTypes;
import zombie.util.Type;

public final class SharedDescriptors {
    private static final int DESCRIPTOR_COUNT = 500;
    private static final int DESCRIPTOR_ID_START = 500;
    private static final byte[] DESCRIPTOR_MAGIC = new byte[]{68, 69, 83, 67};
    private static final int VERSION_1 = 1;
    private static final int VERSION_2 = 2;
    private static final int VERSION = 2;
    private static Descriptor[] PlayerZombieDescriptors = new Descriptor[10];
    private static final int FIRST_PLAYER_ZOMBIE_DESCRIPTOR_ID = 1000;

    public static void initSharedDescriptors() {
        if (!GameServer.bServer) {
            return;
        }
    }

    private static void noise(String string) {
        DebugLog.log("shared-descriptor: " + string);
    }

    public static void createPlayerZombieDescriptor(IsoZombie isoZombie) {
        Object object;
        int n;
        int n2;
        if (!GameServer.bServer) {
            return;
        }
        if (!isoZombie.isReanimatedPlayer()) {
            return;
        }
        if (isoZombie.getDescriptor().getID() != 0) {
            return;
        }
        int n3 = -1;
        for (n2 = 0; n2 < PlayerZombieDescriptors.length; ++n2) {
            if (PlayerZombieDescriptors[n2] != null) continue;
            n3 = n2;
            break;
        }
        if (n3 == -1) {
            Descriptor[] descriptorArray = new Descriptor[PlayerZombieDescriptors.length + 10];
            System.arraycopy(PlayerZombieDescriptors, 0, descriptorArray, 0, PlayerZombieDescriptors.length);
            n3 = PlayerZombieDescriptors.length;
            PlayerZombieDescriptors = descriptorArray;
            SharedDescriptors.noise("resized PlayerZombieDescriptors array size=" + PlayerZombieDescriptors.length);
        }
        isoZombie.getDescriptor().setID(1000 + n3);
        n2 = PersistentOutfits.instance.pickOutfit("ReanimatedPlayer", isoZombie.isFemale());
        n2 = n2 & 0xFFFF0000 | n3 + 1;
        isoZombie.setPersistentOutfitID(n2);
        Descriptor descriptor = new Descriptor();
        descriptor.bFemale = isoZombie.isFemale();
        descriptor.bZombie = false;
        descriptor.ID = 1000 + n3;
        descriptor.persistentOutfitID = n2;
        descriptor.getHumanVisual().copyFrom(isoZombie.getHumanVisual());
        ItemVisuals itemVisuals = new ItemVisuals();
        isoZombie.getItemVisuals(itemVisuals);
        for (n = 0; n < itemVisuals.size(); ++n) {
            object = new ItemVisual((ItemVisual)itemVisuals.get(n));
            descriptor.itemVisuals.add(object);
        }
        SharedDescriptors.PlayerZombieDescriptors[n3] = descriptor;
        SharedDescriptors.noise("added id=" + descriptor.getID());
        for (n = 0; n < GameServer.udpEngine.connections.size(); ++n) {
            object = GameServer.udpEngine.connections.get(n);
            ByteBufferWriter byteBufferWriter = ((UdpConnection)object).startPacket();
            try {
                PacketTypes.PacketType.ZombieDescriptors.doPacket(byteBufferWriter);
                descriptor.save(byteBufferWriter.bb);
                PacketTypes.PacketType.ZombieDescriptors.send((UdpConnection)object);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                ((UdpConnection)object).cancelPacket();
            }
        }
    }

    public static void releasePlayerZombieDescriptor(IsoZombie isoZombie) {
        if (!GameServer.bServer) {
            return;
        }
        if (!isoZombie.isReanimatedPlayer()) {
            return;
        }
        int n = isoZombie.getDescriptor().getID() - 1000;
        if (n < 0 || n >= PlayerZombieDescriptors.length) {
            return;
        }
        SharedDescriptors.noise("released id=" + isoZombie.getDescriptor().getID());
        isoZombie.getDescriptor().setID(0);
        SharedDescriptors.PlayerZombieDescriptors[n] = null;
    }

    public static Descriptor[] getPlayerZombieDescriptors() {
        return PlayerZombieDescriptors;
    }

    public static void registerPlayerZombieDescriptor(Descriptor descriptor) {
        if (!GameClient.bClient) {
            return;
        }
        int n = descriptor.getID() - 1000;
        if (n < 0 || n >= Short.MAX_VALUE) {
            return;
        }
        if (PlayerZombieDescriptors.length <= n) {
            int n2 = (n + 10) / 10 * 10;
            Descriptor[] descriptorArray = new Descriptor[n2];
            System.arraycopy(PlayerZombieDescriptors, 0, descriptorArray, 0, PlayerZombieDescriptors.length);
            PlayerZombieDescriptors = descriptorArray;
            SharedDescriptors.noise("resized PlayerZombieDescriptors array size=" + PlayerZombieDescriptors.length);
        }
        SharedDescriptors.PlayerZombieDescriptors[n] = descriptor;
        SharedDescriptors.noise("registered id=" + descriptor.getID());
    }

    public static void ApplyReanimatedPlayerOutfit(int n, String string, IsoGameCharacter isoGameCharacter) {
        IsoZombie isoZombie = Type.tryCastTo(isoGameCharacter, IsoZombie.class);
        if (isoZombie == null) {
            return;
        }
        short s = (short)(n & 0xFFFF);
        if (s < 1 || s > PlayerZombieDescriptors.length) {
            return;
        }
        Descriptor descriptor = PlayerZombieDescriptors[s - 1];
        if (descriptor == null) {
            return;
        }
        isoZombie.useDescriptor(descriptor);
    }

    public static final class Descriptor
    implements IHumanVisual {
        public int ID = 0;
        public int persistentOutfitID = 0;
        public String outfitName;
        public final HumanVisual humanVisual = new HumanVisual(this);
        public final ItemVisuals itemVisuals = new ItemVisuals();
        public boolean bFemale = false;
        public boolean bZombie = false;

        public int getID() {
            return this.ID;
        }

        public int getPersistentOutfitID() {
            return this.persistentOutfitID;
        }

        @Override
        public HumanVisual getHumanVisual() {
            return this.humanVisual;
        }

        @Override
        public void getItemVisuals(ItemVisuals itemVisuals) {
            itemVisuals.clear();
            itemVisuals.addAll(this.itemVisuals);
        }

        @Override
        public boolean isFemale() {
            return this.bFemale;
        }

        @Override
        public boolean isZombie() {
            return this.bZombie;
        }

        @Override
        public boolean isSkeleton() {
            return false;
        }

        public void save(ByteBuffer byteBuffer) throws IOException {
            byte by = 0;
            if (this.bFemale) {
                by = (byte)(by | 1);
            }
            if (this.bZombie) {
                by = (byte)(by | 2);
            }
            byteBuffer.put(by);
            byteBuffer.putInt(this.ID);
            byteBuffer.putInt(this.persistentOutfitID);
            GameWindow.WriteStringUTF(byteBuffer, this.outfitName);
            this.humanVisual.save(byteBuffer);
            this.itemVisuals.save(byteBuffer);
        }

        public void load(ByteBuffer byteBuffer, int n) throws IOException {
            this.humanVisual.clear();
            this.itemVisuals.clear();
            byte by = byteBuffer.get();
            this.bFemale = (by & 1) != 0;
            this.bZombie = (by & 2) != 0;
            this.ID = byteBuffer.getInt();
            this.persistentOutfitID = byteBuffer.getInt();
            this.outfitName = GameWindow.ReadStringUTF(byteBuffer);
            this.humanVisual.load(byteBuffer, n);
            int n2 = byteBuffer.getShort();
            for (int i = 0; i < n2; ++i) {
                ItemVisual itemVisual = new ItemVisual();
                itemVisual.load(byteBuffer, n);
                this.itemVisuals.add(itemVisual);
            }
        }
    }

    private static final class DescriptorList
    extends ArrayList<Descriptor> {
        private DescriptorList() {
        }
    }
}

