/*
 * Decompiled with CFR 0.152.
 */
package zombie;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import se.krka.kahlua.vm.KahluaTable;
import se.krka.kahlua.vm.KahluaTableIterator;
import zombie.GameTime;
import zombie.GameWindow;
import zombie.Lua.LuaManager;
import zombie.VirtualZombieManager;
import zombie.ZomboidFileSystem;
import zombie.config.BooleanConfigOption;
import zombie.config.ConfigFile;
import zombie.config.ConfigOption;
import zombie.config.DoubleConfigOption;
import zombie.config.EnumConfigOption;
import zombie.config.IntegerConfigOption;
import zombie.config.StringConfigOption;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.Translator;
import zombie.core.logger.ExceptionLogger;
import zombie.debug.DebugLog;
import zombie.iso.SliceY;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.ServerSettingsManager;
import zombie.sandbox.CustomBooleanSandboxOption;
import zombie.sandbox.CustomDoubleSandboxOption;
import zombie.sandbox.CustomEnumSandboxOption;
import zombie.sandbox.CustomIntegerSandboxOption;
import zombie.sandbox.CustomSandboxOption;
import zombie.sandbox.CustomSandboxOptions;
import zombie.sandbox.CustomStringSandboxOption;
import zombie.util.Type;

public final class SandboxOptions {
    public static final SandboxOptions instance = new SandboxOptions();
    public int Speed = 3;
    public final EnumSandboxOption Zombies;
    public final EnumSandboxOption Distribution;
    public final EnumSandboxOption DayLength;
    public final EnumSandboxOption StartYear;
    public final EnumSandboxOption StartMonth;
    public final EnumSandboxOption StartDay;
    public final EnumSandboxOption StartTime;
    public final EnumSandboxOption WaterShut;
    public final EnumSandboxOption ElecShut;
    public final IntegerSandboxOption WaterShutModifier;
    public final IntegerSandboxOption ElecShutModifier;
    public final EnumSandboxOption FoodLoot;
    public final EnumSandboxOption LiteratureLoot;
    public final EnumSandboxOption MedicalLoot;
    public final EnumSandboxOption SurvivalGearsLoot;
    public final EnumSandboxOption CannedFoodLoot;
    public final EnumSandboxOption WeaponLoot;
    public final EnumSandboxOption RangedWeaponLoot;
    public final EnumSandboxOption AmmoLoot;
    public final EnumSandboxOption MechanicsLoot;
    public final EnumSandboxOption OtherLoot;
    public final EnumSandboxOption Temperature;
    public final EnumSandboxOption Rain;
    public final EnumSandboxOption ErosionSpeed;
    public final IntegerSandboxOption ErosionDays;
    public final DoubleSandboxOption XpMultiplier;
    public final BooleanSandboxOption XpMultiplierAffectsPassive;
    public final EnumSandboxOption Farming;
    public final EnumSandboxOption CompostTime;
    public final EnumSandboxOption StatsDecrease;
    public final EnumSandboxOption NatureAbundance;
    public final EnumSandboxOption Alarm;
    public final EnumSandboxOption LockedHouses;
    public final BooleanSandboxOption StarterKit;
    public final BooleanSandboxOption Nutrition;
    public final EnumSandboxOption FoodRotSpeed;
    public final EnumSandboxOption FridgeFactor;
    public final EnumSandboxOption LootRespawn;
    public final IntegerSandboxOption SeenHoursPreventLootRespawn;
    public final StringSandboxOption WorldItemRemovalList;
    public final DoubleSandboxOption HoursForWorldItemRemoval;
    public final BooleanSandboxOption ItemRemovalListBlacklistToggle;
    public final EnumSandboxOption TimeSinceApo;
    public final EnumSandboxOption PlantResilience;
    public final EnumSandboxOption PlantAbundance;
    public final EnumSandboxOption EndRegen;
    public final EnumSandboxOption Helicopter;
    public final EnumSandboxOption MetaEvent;
    public final EnumSandboxOption SleepingEvent;
    public final DoubleSandboxOption GeneratorFuelConsumption;
    public final EnumSandboxOption GeneratorSpawning;
    public final EnumSandboxOption SurvivorHouseChance;
    public final EnumSandboxOption AnnotatedMapChance;
    public final IntegerSandboxOption CharacterFreePoints;
    public final EnumSandboxOption ConstructionBonusPoints;
    public final EnumSandboxOption NightDarkness;
    public final EnumSandboxOption NightLength;
    public final BooleanSandboxOption BoneFracture;
    public final EnumSandboxOption InjurySeverity;
    public final DoubleSandboxOption HoursForCorpseRemoval;
    public final EnumSandboxOption DecayingCorpseHealthImpact;
    public final EnumSandboxOption BloodLevel;
    public final EnumSandboxOption ClothingDegradation;
    public final BooleanSandboxOption FireSpread;
    public final IntegerSandboxOption DaysForRottenFoodRemoval;
    public final BooleanSandboxOption AllowExteriorGenerator;
    public final EnumSandboxOption MaxFogIntensity;
    public final EnumSandboxOption MaxRainFxIntensity;
    public final BooleanSandboxOption EnableSnowOnGround;
    public final BooleanSandboxOption AttackBlockMovements;
    public final EnumSandboxOption VehicleStoryChance;
    public final EnumSandboxOption ZoneStoryChance;
    public final BooleanSandboxOption AllClothesUnlocked;
    public final BooleanSandboxOption EnableTaintedWaterText;
    public final BooleanSandboxOption EnableVehicles;
    public final EnumSandboxOption CarSpawnRate;
    public final DoubleSandboxOption ZombieAttractionMultiplier;
    public final BooleanSandboxOption VehicleEasyUse;
    public final EnumSandboxOption InitialGas;
    public final EnumSandboxOption FuelStationGas;
    public final EnumSandboxOption LockedCar;
    public final DoubleSandboxOption CarGasConsumption;
    public final EnumSandboxOption CarGeneralCondition;
    public final EnumSandboxOption CarDamageOnImpact;
    public final EnumSandboxOption DamageToPlayerFromHitByACar;
    public final BooleanSandboxOption TrafficJam;
    public final EnumSandboxOption CarAlarm;
    public final BooleanSandboxOption PlayerDamageFromCrash;
    public final DoubleSandboxOption SirenShutoffHours;
    public final EnumSandboxOption ChanceHasGas;
    public final EnumSandboxOption RecentlySurvivorVehicles;
    public final BooleanSandboxOption MultiHitZombies;
    public final EnumSandboxOption RearVulnerability;
    public final EnumSandboxOption EnablePoisoning;
    public final EnumSandboxOption MaggotSpawn;
    public final DoubleSandboxOption LightBulbLifespan;
    protected final ArrayList<SandboxOption> options = new ArrayList();
    protected final HashMap<String, SandboxOption> optionByName = new HashMap();
    public final Map Map = new Map();
    public final ZombieLore Lore = new ZombieLore();
    public final ZombieConfig zombieConfig = new ZombieConfig();
    public final int FIRST_YEAR = 1993;
    private final int SANDBOX_VERSION = 5;
    private final ArrayList<SandboxOption> m_customOptions = new ArrayList();

    public SandboxOptions() {
        this.Zombies = (EnumSandboxOption)this.newEnumOption("Zombies", 6, 4).setTranslation("ZombieCount");
        this.Distribution = (EnumSandboxOption)this.newEnumOption("Distribution", 2, 1).setTranslation("ZombieDistribution");
        this.DayLength = this.newEnumOption("DayLength", 26, 2);
        this.StartYear = this.newEnumOption("StartYear", 100, 1);
        this.StartMonth = this.newEnumOption("StartMonth", 12, 7);
        this.StartDay = this.newEnumOption("StartDay", 31, 23);
        this.StartTime = this.newEnumOption("StartTime", 9, 2);
        this.WaterShut = this.newEnumOption("WaterShut", 8, 2).setValueTranslation("Shutoff");
        this.ElecShut = this.newEnumOption("ElecShut", 8, 2).setValueTranslation("Shutoff");
        this.WaterShutModifier = (IntegerSandboxOption)this.newIntegerOption("WaterShutModifier", -1, Integer.MAX_VALUE, 14).setTranslation("WaterShut");
        this.ElecShutModifier = (IntegerSandboxOption)this.newIntegerOption("ElecShutModifier", -1, Integer.MAX_VALUE, 14).setTranslation("ElecShut");
        this.FoodLoot = (EnumSandboxOption)this.newEnumOption("FoodLoot", 7, 4).setValueTranslation("Rarity").setTranslation("LootFood");
        this.CannedFoodLoot = (EnumSandboxOption)this.newEnumOption("CannedFoodLoot", 7, 4).setValueTranslation("Rarity").setTranslation("LootCannedFood");
        this.LiteratureLoot = (EnumSandboxOption)this.newEnumOption("LiteratureLoot", 7, 4).setValueTranslation("Rarity").setTranslation("LootLiterature");
        this.SurvivalGearsLoot = (EnumSandboxOption)this.newEnumOption("SurvivalGearsLoot", 7, 4).setValueTranslation("Rarity").setTranslation("LootSurvivalGears");
        this.MedicalLoot = (EnumSandboxOption)this.newEnumOption("MedicalLoot", 7, 4).setValueTranslation("Rarity").setTranslation("LootMedical");
        this.WeaponLoot = (EnumSandboxOption)this.newEnumOption("WeaponLoot", 7, 4).setValueTranslation("Rarity").setTranslation("LootWeapon");
        this.RangedWeaponLoot = (EnumSandboxOption)this.newEnumOption("RangedWeaponLoot", 7, 4).setValueTranslation("Rarity").setTranslation("LootRangedWeapon");
        this.AmmoLoot = (EnumSandboxOption)this.newEnumOption("AmmoLoot", 7, 4).setValueTranslation("Rarity").setTranslation("LootAmmo");
        this.MechanicsLoot = (EnumSandboxOption)this.newEnumOption("MechanicsLoot", 7, 4).setValueTranslation("Rarity").setTranslation("LootMechanics");
        this.OtherLoot = (EnumSandboxOption)this.newEnumOption("OtherLoot", 7, 4).setValueTranslation("Rarity").setTranslation("LootOther");
        this.Temperature = (EnumSandboxOption)this.newEnumOption("Temperature", 5, 3).setTranslation("WorldTemperature");
        this.Rain = (EnumSandboxOption)this.newEnumOption("Rain", 5, 3).setTranslation("RainAmount");
        this.ErosionSpeed = this.newEnumOption("ErosionSpeed", 5, 3);
        this.ErosionDays = this.newIntegerOption("ErosionDays", -1, 36500, 0);
        this.XpMultiplier = this.newDoubleOption("XpMultiplier", 0.001, 1000.0, 1.0);
        this.XpMultiplierAffectsPassive = this.newBooleanOption("XpMultiplierAffectsPassive", false);
        this.ZombieAttractionMultiplier = this.newDoubleOption("ZombieAttractionMultiplier", 0.0, 100.0, 1.0);
        this.VehicleEasyUse = this.newBooleanOption("VehicleEasyUse", false);
        this.Farming = (EnumSandboxOption)this.newEnumOption("Farming", 5, 3).setTranslation("FarmingSpeed");
        this.CompostTime = this.newEnumOption("CompostTime", 8, 2);
        this.StatsDecrease = (EnumSandboxOption)this.newEnumOption("StatsDecrease", 5, 3).setTranslation("StatDecrease");
        this.NatureAbundance = (EnumSandboxOption)this.newEnumOption("NatureAbundance", 5, 3).setTranslation("NatureAmount");
        this.Alarm = (EnumSandboxOption)this.newEnumOption("Alarm", 6, 4).setTranslation("HouseAlarmFrequency");
        this.LockedHouses = (EnumSandboxOption)this.newEnumOption("LockedHouses", 6, 4).setTranslation("LockedHouseFrequency");
        this.StarterKit = this.newBooleanOption("StarterKit", false);
        this.Nutrition = this.newBooleanOption("Nutrition", false);
        this.FoodRotSpeed = (EnumSandboxOption)this.newEnumOption("FoodRotSpeed", 5, 3).setTranslation("FoodSpoil");
        this.FridgeFactor = (EnumSandboxOption)this.newEnumOption("FridgeFactor", 5, 3).setTranslation("FridgeEffect");
        this.LootRespawn = this.newEnumOption("LootRespawn", 5, 1).setValueTranslation("Respawn");
        this.SeenHoursPreventLootRespawn = this.newIntegerOption("SeenHoursPreventLootRespawn", 0, Integer.MAX_VALUE, 0);
        this.WorldItemRemovalList = this.newStringOption("WorldItemRemovalList", "Base.Hat,Base.Glasses", -1);
        this.HoursForWorldItemRemoval = this.newDoubleOption("HoursForWorldItemRemoval", 0.0, 2.147483647E9, 24.0);
        this.ItemRemovalListBlacklistToggle = this.newBooleanOption("ItemRemovalListBlacklistToggle", false);
        this.TimeSinceApo = this.newEnumOption("TimeSinceApo", 13, 1);
        this.PlantResilience = this.newEnumOption("PlantResilience", 5, 3);
        this.PlantAbundance = this.newEnumOption("PlantAbundance", 5, 3).setValueTranslation("NatureAmount");
        this.EndRegen = (EnumSandboxOption)this.newEnumOption("EndRegen", 5, 3).setTranslation("EnduranceRegen");
        this.Helicopter = this.newEnumOption("Helicopter", 4, 2).setValueTranslation("HelicopterFreq");
        this.MetaEvent = this.newEnumOption("MetaEvent", 3, 2).setValueTranslation("MetaEventFreq");
        this.SleepingEvent = this.newEnumOption("SleepingEvent", 3, 1).setValueTranslation("MetaEventFreq");
        this.GeneratorSpawning = this.newEnumOption("GeneratorSpawning", 5, 3);
        this.GeneratorFuelConsumption = this.newDoubleOption("GeneratorFuelConsumption", 0.0, 100.0, 1.0);
        this.SurvivorHouseChance = this.newEnumOption("SurvivorHouseChance", 6, 3);
        this.VehicleStoryChance = this.newEnumOption("VehicleStoryChance", 6, 3).setValueTranslation("SurvivorHouseChance");
        this.ZoneStoryChance = this.newEnumOption("ZoneStoryChance", 6, 3).setValueTranslation("SurvivorHouseChance");
        this.AnnotatedMapChance = this.newEnumOption("AnnotatedMapChance", 6, 4);
        this.CharacterFreePoints = this.newIntegerOption("CharacterFreePoints", -100, 100, 0);
        this.ConstructionBonusPoints = this.newEnumOption("ConstructionBonusPoints", 5, 3);
        this.NightDarkness = this.newEnumOption("NightDarkness", 4, 3);
        this.NightLength = this.newEnumOption("NightLength", 5, 3);
        this.InjurySeverity = this.newEnumOption("InjurySeverity", 3, 2);
        this.BoneFracture = this.newBooleanOption("BoneFracture", true);
        this.HoursForCorpseRemoval = this.newDoubleOption("HoursForCorpseRemoval", -1.0, 2.147483647E9, -1.0);
        this.DecayingCorpseHealthImpact = this.newEnumOption("DecayingCorpseHealthImpact", 4, 3);
        this.BloodLevel = this.newEnumOption("BloodLevel", 5, 3);
        this.ClothingDegradation = this.newEnumOption("ClothingDegradation", 4, 3);
        this.FireSpread = this.newBooleanOption("FireSpread", true);
        this.DaysForRottenFoodRemoval = this.newIntegerOption("DaysForRottenFoodRemoval", -1, Integer.MAX_VALUE, -1);
        this.AllowExteriorGenerator = this.newBooleanOption("AllowExteriorGenerator", true);
        this.MaxFogIntensity = this.newEnumOption("MaxFogIntensity", 3, 1);
        this.MaxRainFxIntensity = this.newEnumOption("MaxRainFxIntensity", 3, 1);
        this.EnableSnowOnGround = this.newBooleanOption("EnableSnowOnGround", true);
        this.MultiHitZombies = this.newBooleanOption("MultiHitZombies", false);
        this.RearVulnerability = this.newEnumOption("RearVulnerability", 3, 3);
        this.AttackBlockMovements = this.newBooleanOption("AttackBlockMovements", true);
        this.AllClothesUnlocked = this.newBooleanOption("AllClothesUnlocked", false);
        this.EnableTaintedWaterText = this.newBooleanOption("EnableTaintedWaterText", true);
        this.CarSpawnRate = this.newEnumOption("CarSpawnRate", 5, 4);
        this.ChanceHasGas = this.newEnumOption("ChanceHasGas", 3, 2);
        this.InitialGas = this.newEnumOption("InitialGas", 6, 3);
        this.FuelStationGas = this.newEnumOption("FuelStationGas", 9, 5);
        this.CarGasConsumption = this.newDoubleOption("CarGasConsumption", 0.0, 100.0, 1.0);
        this.LockedCar = this.newEnumOption("LockedCar", 6, 4);
        this.CarGeneralCondition = this.newEnumOption("CarGeneralCondition", 5, 3);
        this.CarDamageOnImpact = this.newEnumOption("CarDamageOnImpact", 5, 3);
        this.DamageToPlayerFromHitByACar = this.newEnumOption("DamageToPlayerFromHitByACar", 5, 1);
        this.TrafficJam = this.newBooleanOption("TrafficJam", true);
        this.CarAlarm = (EnumSandboxOption)this.newEnumOption("CarAlarm", 6, 4).setTranslation("CarAlarmFrequency");
        this.PlayerDamageFromCrash = this.newBooleanOption("PlayerDamageFromCrash", true);
        this.SirenShutoffHours = this.newDoubleOption("SirenShutoffHours", 0.0, 168.0, 0.0);
        this.RecentlySurvivorVehicles = this.newEnumOption("RecentlySurvivorVehicles", 4, 3);
        this.EnableVehicles = this.newBooleanOption("EnableVehicles", true);
        this.EnablePoisoning = this.newEnumOption("EnablePoisoning", 3, 1);
        this.MaggotSpawn = this.newEnumOption("MaggotSpawn", 3, 1);
        this.LightBulbLifespan = this.newDoubleOption("LightBulbLifespan", 0.0, 1000.0, 1.0);
        CustomSandboxOptions.instance.initInstance(this);
        this.loadGameFile("Apocalypse");
        this.setDefaultsToCurrentValues();
    }

    public static SandboxOptions getInstance() {
        return instance;
    }

    public void toLua() {
        KahluaTable kahluaTable = (KahluaTable)LuaManager.env.rawget("SandboxVars");
        for (int i = 0; i < this.options.size(); ++i) {
            this.options.get(i).toTable(kahluaTable);
        }
    }

    public void updateFromLua() {
        if (Core.GameMode.equals("LastStand")) {
            GameTime.instance.multiplierBias = 1.2f;
        }
        KahluaTable kahluaTable = (KahluaTable)LuaManager.env.rawget("SandboxVars");
        for (int i = 0; i < this.options.size(); ++i) {
            this.options.get(i).fromTable(kahluaTable);
        }
        switch (this.Speed) {
            case 1: {
                GameTime.instance.multiplierBias = 0.8f;
                break;
            }
            case 2: {
                GameTime.instance.multiplierBias = 0.9f;
                break;
            }
            case 3: {
                GameTime.instance.multiplierBias = 1.0f;
                break;
            }
            case 4: {
                GameTime.instance.multiplierBias = 1.1f;
                break;
            }
            case 5: {
                GameTime.instance.multiplierBias = 1.2f;
                break;
            }
        }
        if (this.Zombies.getValue() == 1) {
            VirtualZombieManager.instance.MaxRealZombies = 400;
        }
        if (this.Zombies.getValue() == 2) {
            VirtualZombieManager.instance.MaxRealZombies = 350;
        }
        if (this.Zombies.getValue() == 3) {
            VirtualZombieManager.instance.MaxRealZombies = 300;
        }
        if (this.Zombies.getValue() == 4) {
            VirtualZombieManager.instance.MaxRealZombies = 200;
        }
        if (this.Zombies.getValue() == 5) {
            VirtualZombieManager.instance.MaxRealZombies = 100;
        }
        if (this.Zombies.getValue() == 6) {
            VirtualZombieManager.instance.MaxRealZombies = 0;
        }
        VirtualZombieManager.instance.MaxRealZombies = 1;
        this.applySettings();
    }

    public void initSandboxVars() {
        KahluaTable kahluaTable = (KahluaTable)LuaManager.env.rawget("SandboxVars");
        for (int i = 0; i < this.options.size(); ++i) {
            SandboxOption sandboxOption = this.options.get(i);
            sandboxOption.fromTable(kahluaTable);
            sandboxOption.toTable(kahluaTable);
        }
    }

    public int randomWaterShut(int n) {
        switch (n) {
            case 2: {
                return Rand.Next(0, 30);
            }
            case 3: {
                return Rand.Next(0, 60);
            }
            case 4: {
                return Rand.Next(0, 180);
            }
            case 5: {
                return Rand.Next(0, 360);
            }
            case 6: {
                return Rand.Next(0, 1800);
            }
            case 7: {
                return Rand.Next(60, 180);
            }
            case 8: {
                return Rand.Next(180, 360);
            }
        }
        return -1;
    }

    public int randomElectricityShut(int n) {
        switch (n) {
            case 2: {
                return Rand.Next(14, 30);
            }
            case 3: {
                return Rand.Next(14, 60);
            }
            case 4: {
                return Rand.Next(14, 180);
            }
            case 5: {
                return Rand.Next(14, 360);
            }
            case 6: {
                return Rand.Next(14, 1800);
            }
            case 7: {
                return Rand.Next(60, 180);
            }
            case 8: {
                return Rand.Next(180, 360);
            }
        }
        return -1;
    }

    public int getTemperatureModifier() {
        return this.Temperature.getValue();
    }

    public int getRainModifier() {
        return this.Rain.getValue();
    }

    public int getErosionSpeed() {
        return this.ErosionSpeed.getValue();
    }

    public int getFoodLootModifier() {
        return this.FoodLoot.getValue();
    }

    public int getWeaponLootModifier() {
        return this.WeaponLoot.getValue();
    }

    public int getOtherLootModifier() {
        return this.OtherLoot.getValue();
    }

    public int getWaterShutModifier() {
        return this.WaterShutModifier.getValue();
    }

    public int getElecShutModifier() {
        return this.ElecShutModifier.getValue();
    }

    public int getTimeSinceApo() {
        return this.TimeSinceApo.getValue();
    }

    public double getEnduranceRegenMultiplier() {
        switch (this.EndRegen.getValue()) {
            case 1: {
                return 1.8;
            }
            case 2: {
                return 1.3;
            }
            case 4: {
                return 0.7;
            }
            case 5: {
                return 0.4;
            }
        }
        return 1.0;
    }

    public double getStatsDecreaseMultiplier() {
        switch (this.StatsDecrease.getValue()) {
            case 1: {
                return 2.0;
            }
            case 2: {
                return 1.6;
            }
            case 4: {
                return 0.8;
            }
            case 5: {
                return 0.65;
            }
        }
        return 1.0;
    }

    public int getDayLengthMinutes() {
        switch (this.DayLength.getValue()) {
            case 1: {
                return 15;
            }
            case 2: {
                return 30;
            }
        }
        return (this.DayLength.getValue() - 2) * 60;
    }

    public int getDayLengthMinutesDefault() {
        switch (this.DayLength.getDefaultValue()) {
            case 1: {
                return 15;
            }
            case 2: {
                return 30;
            }
        }
        return (this.DayLength.getDefaultValue() - 2) * 60;
    }

    public int getCompostHours() {
        switch (this.CompostTime.getValue()) {
            case 1: {
                return 168;
            }
            case 2: {
                return 336;
            }
            case 3: {
                return 504;
            }
            case 4: {
                return 672;
            }
            case 5: {
                return 1008;
            }
            case 6: {
                return 1344;
            }
            case 7: {
                return 1680;
            }
            case 8: {
                return 2016;
            }
        }
        return 336;
    }

    public void applySettings() {
        GameTime.instance.setStartYear(this.getFirstYear() + this.StartYear.getValue() - 1);
        GameTime.instance.setStartMonth(this.StartMonth.getValue() - 1);
        GameTime.instance.setStartDay(this.StartDay.getValue() - 1);
        GameTime.instance.setMinutesPerDay(this.getDayLengthMinutes());
        if (this.StartTime.getValue() == 1) {
            GameTime.instance.setStartTimeOfDay(7.0f);
        } else if (this.StartTime.getValue() == 2) {
            GameTime.instance.setStartTimeOfDay(9.0f);
        } else if (this.StartTime.getValue() == 3) {
            GameTime.instance.setStartTimeOfDay(12.0f);
        } else if (this.StartTime.getValue() == 4) {
            GameTime.instance.setStartTimeOfDay(14.0f);
        } else if (this.StartTime.getValue() == 5) {
            GameTime.instance.setStartTimeOfDay(17.0f);
        } else if (this.StartTime.getValue() == 6) {
            GameTime.instance.setStartTimeOfDay(21.0f);
        } else if (this.StartTime.getValue() == 7) {
            GameTime.instance.setStartTimeOfDay(0.0f);
        } else if (this.StartTime.getValue() == 8) {
            GameTime.instance.setStartTimeOfDay(2.0f);
        } else if (this.StartTime.getValue() == 9) {
            GameTime.instance.setStartTimeOfDay(5.0f);
        }
    }

    public void save(ByteBuffer byteBuffer) throws IOException {
        byteBuffer.put((byte)83);
        byteBuffer.put((byte)65);
        byteBuffer.put((byte)78);
        byteBuffer.put((byte)68);
        byteBuffer.putInt(195);
        byteBuffer.putInt(5);
        byteBuffer.putInt(this.options.size());
        for (int i = 0; i < this.options.size(); ++i) {
            SandboxOption sandboxOption = this.options.get(i);
            GameWindow.WriteStringUTF(byteBuffer, sandboxOption.asConfigOption().getName());
            GameWindow.WriteStringUTF(byteBuffer, sandboxOption.asConfigOption().getValueAsString());
        }
    }

    public void load(ByteBuffer byteBuffer) throws IOException {
        int n;
        byteBuffer.mark();
        byte by = byteBuffer.get();
        byte by2 = byteBuffer.get();
        byte by3 = byteBuffer.get();
        byte by4 = byteBuffer.get();
        if (by == 83 && by2 == 65 && by3 == 78 && by4 == 68) {
            n = byteBuffer.getInt();
        } else {
            n = 41;
            byteBuffer.reset();
        }
        if (n >= 88) {
            int n2 = 2;
            if (n >= 131) {
                n2 = byteBuffer.getInt();
            }
            int n3 = byteBuffer.getInt();
            for (int i = 0; i < n3; ++i) {
                String string = GameWindow.ReadStringUTF(byteBuffer);
                String string2 = GameWindow.ReadStringUTF(byteBuffer);
                string = this.upgradeOptionName(string, n2);
                string2 = this.upgradeOptionValue(string, string2, n2);
                SandboxOption sandboxOption = this.optionByName.get(string);
                if (sandboxOption == null) {
                    DebugLog.log("ERROR unknown SandboxOption \"" + string + "\"");
                    continue;
                }
                sandboxOption.asConfigOption().parse(string2);
            }
            if (n < 157) {
                SandboxOptions.instance.CannedFoodLoot.setValue(SandboxOptions.instance.FoodLoot.getValue());
                SandboxOptions.instance.AmmoLoot.setValue(SandboxOptions.instance.WeaponLoot.getValue());
                SandboxOptions.instance.RangedWeaponLoot.setValue(SandboxOptions.instance.WeaponLoot.getValue());
                SandboxOptions.instance.MedicalLoot.setValue(SandboxOptions.instance.OtherLoot.getValue());
                SandboxOptions.instance.LiteratureLoot.setValue(SandboxOptions.instance.OtherLoot.getValue());
                SandboxOptions.instance.SurvivalGearsLoot.setValue(SandboxOptions.instance.OtherLoot.getValue());
                SandboxOptions.instance.MechanicsLoot.setValue(SandboxOptions.instance.OtherLoot.getValue());
            }
            return;
        }
    }

    public int getFirstYear() {
        return 1993;
    }

    private static String[] parseName(String string) {
        String[] stringArray;
        String[] stringArray2 = new String[]{null, string};
        if (string.contains(".") && (stringArray = string.split("\\.")).length == 2) {
            stringArray2[0] = stringArray[0];
            stringArray2[1] = stringArray[1];
        }
        return stringArray2;
    }

    private BooleanSandboxOption newBooleanOption(String string, boolean bl) {
        return new BooleanSandboxOption(this, string, bl);
    }

    private DoubleSandboxOption newDoubleOption(String string, double d, double d2, double d3) {
        return new DoubleSandboxOption(this, string, d, d2, d3);
    }

    private EnumSandboxOption newEnumOption(String string, int n, int n2) {
        return new EnumSandboxOption(this, string, n, n2);
    }

    private IntegerSandboxOption newIntegerOption(String string, int n, int n2, int n3) {
        return new IntegerSandboxOption(this, string, n, n2, n3);
    }

    private StringSandboxOption newStringOption(String string, String string2, int n) {
        return new StringSandboxOption(this, string, string2, n);
    }

    protected SandboxOptions addOption(SandboxOption sandboxOption) {
        this.options.add(sandboxOption);
        this.optionByName.put(sandboxOption.asConfigOption().getName(), sandboxOption);
        return this;
    }

    public int getNumOptions() {
        return this.options.size();
    }

    public SandboxOption getOptionByIndex(int n) {
        return this.options.get(n);
    }

    public SandboxOption getOptionByName(String string) {
        return this.optionByName.get(string);
    }

    public void set(String string, Object object) {
        if (string == null || object == null) {
            throw new IllegalArgumentException();
        }
        SandboxOption sandboxOption = this.optionByName.get(string);
        if (sandboxOption == null) {
            throw new IllegalArgumentException("unknown SandboxOption \"" + string + "\"");
        }
        sandboxOption.asConfigOption().setValueFromObject(object);
    }

    public void copyValuesFrom(SandboxOptions sandboxOptions) {
        if (sandboxOptions == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < this.options.size(); ++i) {
            this.options.get(i).asConfigOption().setValueFromObject(sandboxOptions.options.get(i).asConfigOption().getValueAsObject());
        }
    }

    public void resetToDefault() {
        for (int i = 0; i < this.options.size(); ++i) {
            this.options.get(i).asConfigOption().resetToDefault();
        }
    }

    public void setDefaultsToCurrentValues() {
        for (int i = 0; i < this.options.size(); ++i) {
            this.options.get(i).asConfigOption().setDefaultToCurrentValue();
        }
    }

    public SandboxOptions newCopy() {
        SandboxOptions sandboxOptions = new SandboxOptions();
        sandboxOptions.copyValuesFrom(this);
        return sandboxOptions;
    }

    public static boolean isValidPresetName(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        return !string.contains("/") && !string.contains("\\") && !string.contains(":") && !string.contains(";") && !string.contains("\"") && !string.contains(".");
    }

    private boolean readTextFile(String string, boolean bl) {
        ConfigFile configFile = new ConfigFile();
        if (configFile.read(string)) {
            int n;
            int n2 = configFile.getVersion();
            HashSet<String> hashSet = null;
            if (bl && n2 == 1) {
                hashSet = new HashSet<String>();
                for (n = 0; n < this.options.size(); ++n) {
                    if (!"ZombieLore".equals(this.options.get(n).getTableName())) continue;
                    hashSet.add(this.options.get(n).getShortName());
                }
            }
            for (n = 0; n < configFile.getOptions().size(); ++n) {
                ConfigOption configOption = configFile.getOptions().get(n);
                Object object = configOption.getName();
                String string2 = configOption.getValueAsString();
                if (hashSet != null && hashSet.contains(object)) {
                    object = "ZombieLore." + (String)object;
                }
                if (bl && n2 == 1) {
                    if ("WaterShutModifier".equals(object)) {
                        object = "WaterShut";
                    } else if ("ElecShutModifier".equals(object)) {
                        object = "ElecShut";
                    }
                }
                object = this.upgradeOptionName((String)object, n2);
                string2 = this.upgradeOptionValue((String)object, string2, n2);
                SandboxOption sandboxOption = this.optionByName.get(object);
                if (sandboxOption == null) continue;
                sandboxOption.asConfigOption().parse(string2);
            }
            return true;
        }
        return false;
    }

    private boolean writeTextFile(String string, int n) {
        ConfigFile configFile = new ConfigFile();
        ArrayList<ConfigOption> arrayList = new ArrayList<ConfigOption>();
        for (SandboxOption sandboxOption : this.options) {
            arrayList.add(sandboxOption.asConfigOption());
        }
        return configFile.write(string, n, arrayList);
    }

    public boolean loadServerTextFile(String string) {
        return this.readTextFile(ServerSettingsManager.instance.getNameInSettingsFolder(string + "_sandbox.ini"), false);
    }

    public boolean loadServerLuaFile(String string) {
        boolean bl = this.readLuaFile(ServerSettingsManager.instance.getNameInSettingsFolder(string + "_SandboxVars.lua"));
        if (this.Lore.Speed.getValue() == 1) {
            this.Lore.Speed.setValue(2);
        }
        return bl;
    }

    public boolean saveServerLuaFile(String string) {
        return this.writeLuaFile(ServerSettingsManager.instance.getNameInSettingsFolder(string + "_SandboxVars.lua"), false);
    }

    public boolean loadPresetFile(String string) {
        return this.readTextFile(LuaManager.getSandboxCacheDir() + File.separator + string + ".cfg", true);
    }

    public boolean savePresetFile(String string) {
        if (!SandboxOptions.isValidPresetName(string)) {
            return false;
        }
        return this.writeTextFile(LuaManager.getSandboxCacheDir() + File.separator + string + ".cfg", 5);
    }

    public boolean loadGameFile(String string) {
        File file = ZomboidFileSystem.instance.getMediaFile("lua/shared/Sandbox/" + string + ".lua");
        if (!file.exists()) {
            throw new RuntimeException("media/lua/shared/Sandbox/" + string + ".lua not found");
        }
        try {
            LuaManager.loaded.remove(file.getAbsolutePath().replace("\\", "/"));
            Object object = LuaManager.RunLua(file.getAbsolutePath());
            if (object instanceof KahluaTable) {
                for (int i = 0; i < this.options.size(); ++i) {
                    this.options.get(i).fromTable((KahluaTable)object);
                }
                return true;
            }
            throw new RuntimeException(file.getName() + " must return a SandboxVars table");
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
            return false;
        }
    }

    public boolean saveGameFile(String string) {
        if (!Core.bDebug) {
            return false;
        }
        return this.writeLuaFile("media/lua/shared/Sandbox/" + string + ".lua", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCurrentGameBinFile() {
        File file = ZomboidFileSystem.instance.getFileInCurrentSave("map_sand.bin");
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);){
            Object object = SliceY.SliceBufferLock;
            synchronized (object) {
                SliceY.SliceBuffer.clear();
                this.save(SliceY.SliceBuffer);
                bufferedOutputStream.write(SliceY.SliceBuffer.array(), 0, SliceY.SliceBuffer.position());
            }
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
        }
    }

    public void handleOldZombiesFile1() {
        if (GameServer.bServer) {
            return;
        }
        ConfigFile configFile = new ConfigFile();
        String string = ZomboidFileSystem.instance.getFileNameInCurrentSave("zombies.ini");
        if (configFile.read(string)) {
            for (int i = 0; i < configFile.getOptions().size(); ++i) {
                ConfigOption configOption = configFile.getOptions().get(i);
                SandboxOption sandboxOption = this.optionByName.get("ZombieConfig." + configOption.getName());
                if (sandboxOption == null) continue;
                sandboxOption.asConfigOption().parse(configOption.getValueAsString());
            }
        }
    }

    public void handleOldZombiesFile2() {
        if (GameServer.bServer) {
            return;
        }
        String string = ZomboidFileSystem.instance.getFileNameInCurrentSave("zombies.ini");
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        try {
            DebugLog.log("deleting " + file.getAbsolutePath());
            file.delete();
            this.saveCurrentGameBinFile();
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
        }
    }

    public void handleOldServerZombiesFile() {
        if (!GameServer.bServer) {
            return;
        }
        if (this.loadServerZombiesFile(GameServer.ServerName)) {
            String string = ServerSettingsManager.instance.getNameInSettingsFolder(GameServer.ServerName + "_zombies.ini");
            try {
                File file = new File(string);
                DebugLog.log("deleting " + file.getAbsolutePath());
                file.delete();
                this.saveServerLuaFile(GameServer.ServerName);
            }
            catch (Exception exception) {
                ExceptionLogger.logException(exception);
            }
        }
    }

    public boolean loadServerZombiesFile(String string) {
        ConfigFile configFile = new ConfigFile();
        String string2 = ServerSettingsManager.instance.getNameInSettingsFolder(string + "_zombies.ini");
        if (configFile.read(string2)) {
            for (int i = 0; i < configFile.getOptions().size(); ++i) {
                ConfigOption configOption = configFile.getOptions().get(i);
                SandboxOption sandboxOption = this.optionByName.get("ZombieConfig." + configOption.getName());
                if (sandboxOption == null) continue;
                sandboxOption.asConfigOption().parse(configOption.getValueAsString());
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readLuaFile(String string) {
        File file = new File(string).getAbsoluteFile();
        if (!file.exists()) {
            return false;
        }
        Object object = LuaManager.env.rawget("SandboxVars");
        KahluaTable kahluaTable = null;
        if (object instanceof KahluaTable) {
            kahluaTable = (KahluaTable)object;
        }
        LuaManager.env.rawset("SandboxVars", null);
        try {
            LuaManager.loaded.remove(file.getAbsolutePath().replace("\\", "/"));
            Object object2 = LuaManager.RunLua(file.getAbsolutePath());
            Object object3 = LuaManager.env.rawget("SandboxVars");
            if (object3 == null) {
                boolean bl = false;
                return bl;
            }
            if (object3 instanceof KahluaTable) {
                KahluaTable kahluaTable2 = (KahluaTable)object3;
                int n = 0;
                Object object4 = kahluaTable2.rawget("VERSION");
                if (object4 != null) {
                    if (object4 instanceof Double) {
                        n = ((Double)object4).intValue();
                    } else {
                        DebugLog.log("ERROR: VERSION=\"" + object4 + "\" in " + string);
                    }
                    kahluaTable2.rawset("VERSION", null);
                }
                kahluaTable2 = this.upgradeLuaTable("", kahluaTable2, n);
                for (int i = 0; i < this.options.size(); ++i) {
                    this.options.get(i).fromTable(kahluaTable2);
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
            boolean bl = false;
            return bl;
        }
        finally {
            if (kahluaTable != null) {
                LuaManager.env.rawset("SandboxVars", (Object)kahluaTable);
            }
        }
    }

    private boolean writeLuaFile(String string, boolean bl) {
        File file = new File(string).getAbsoluteFile();
        DebugLog.log("writing " + string);
        try (FileWriter fileWriter = new FileWriter(file);){
            HashMap hashMap = new HashMap();
            ArrayList<String> arrayList = new ArrayList<String>();
            hashMap.put("", new ArrayList());
            for (SandboxOption object : this.options) {
                if (object.getTableName() == null) {
                    ((ArrayList)hashMap.get("")).add(object);
                    continue;
                }
                if (hashMap.get(object.getTableName()) == null) {
                    hashMap.put(object.getTableName(), new ArrayList());
                    arrayList.add(object.getTableName());
                }
                ((ArrayList)hashMap.get(object.getTableName())).add(object);
            }
            String string2 = System.lineSeparator();
            if (bl) {
                fileWriter.write("return {" + (String)string2);
            } else {
                fileWriter.write("SandboxVars = {" + (String)string2);
            }
            fileWriter.write("    VERSION = 5," + (String)string2);
            for (SandboxOption sandboxOption : (ArrayList)hashMap.get("")) {
                if (!bl) {
                    SandboxOption sandboxOption2;
                    Object object = sandboxOption.asConfigOption().getTooltip();
                    if (object != null) {
                        object = ((String)object).replace("\\n", " ").replace("\\\"", "\"");
                        object = ((String)object).replaceAll("\n", (String)string2 + "    -- ");
                        fileWriter.write("    -- " + (String)object + (String)string2);
                    }
                    if ((sandboxOption2 = Type.tryCastTo(sandboxOption, EnumSandboxOption.class)) != null) {
                        for (int i = 1; i < ((EnumConfigOption)((Object)sandboxOption2)).getNumValues(); ++i) {
                            try {
                                String string3 = ((EnumSandboxOption)sandboxOption2).getValueTranslationByIndexOrNull(i);
                                if (string3 == null) continue;
                                fileWriter.write("    -- " + i + " = " + string3.replace("\\\"", "\"") + (String)string2);
                                continue;
                            }
                            catch (Exception exception) {
                                ExceptionLogger.logException(exception);
                            }
                        }
                    }
                }
                fileWriter.write("    " + sandboxOption.asConfigOption().getName() + " = " + sandboxOption.asConfigOption().getValueAsLuaString() + "," + (String)string2);
            }
            for (String string4 : arrayList) {
                fileWriter.write("    " + string4 + " = {" + (String)string2);
                for (SandboxOption sandboxOption2 : (ArrayList)hashMap.get(string4)) {
                    if (!bl) {
                        String string5 = sandboxOption2.asConfigOption().getTooltip();
                        if (string5 != null) {
                            string5 = string5.replace("\\n", " ").replace("\\\"", "\"");
                            string5 = string5.replaceAll("\n", (String)string2 + "        -- ");
                            fileWriter.write("        -- " + string5 + (String)string2);
                        }
                        if (sandboxOption2 instanceof EnumSandboxOption) {
                            for (int i = 1; i < ((EnumSandboxOption)sandboxOption2).getNumValues(); ++i) {
                                try {
                                    String string6 = ((EnumSandboxOption)sandboxOption2).getValueTranslationByIndexOrNull(i);
                                    if (string6 == null) continue;
                                    fileWriter.write("        -- " + i + " = " + string6 + (String)string2);
                                    continue;
                                }
                                catch (Exception exception) {
                                    ExceptionLogger.logException(exception);
                                }
                            }
                        }
                    }
                    fileWriter.write("        " + sandboxOption2.getShortName() + " = " + sandboxOption2.asConfigOption().getValueAsLuaString() + "," + (String)string2);
                }
                fileWriter.write("    }," + (String)string2);
            }
            fileWriter.write("}" + (String)string2);
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        File file = ZomboidFileSystem.instance.getFileInCurrentSave("map_sand.bin");
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
                Object object = SliceY.SliceBufferLock;
                synchronized (object) {
                    SliceY.SliceBuffer.clear();
                    int n = bufferedInputStream.read(SliceY.SliceBuffer.array());
                    SliceY.SliceBuffer.limit(n);
                    this.load(SliceY.SliceBuffer);
                    this.handleOldZombiesFile1();
                    this.applySettings();
                    this.toLua();
                }
            }
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
        }
        this.resetToDefault();
        this.updateFromLua();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCurrentGameBinFile() {
        File file = ZomboidFileSystem.instance.getFileInCurrentSave("map_sand.bin");
        try (FileInputStream fileInputStream = new FileInputStream(file);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
            Object object = SliceY.SliceBufferLock;
            synchronized (object) {
                SliceY.SliceBuffer.clear();
                int n = bufferedInputStream.read(SliceY.SliceBuffer.array());
                SliceY.SliceBuffer.limit(n);
                this.load(SliceY.SliceBuffer);
            }
            this.toLua();
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
        }
    }

    private String upgradeOptionName(String string, int n) {
        return string;
    }

    private String upgradeOptionValue(String string, String string2, int n) {
        int n2;
        if (n < 3 && "DayLength".equals(string)) {
            this.DayLength.parse(string2);
            if (this.DayLength.getValue() == 8) {
                this.DayLength.setValue(14);
            } else if (this.DayLength.getValue() == 9) {
                this.DayLength.setValue(26);
            }
            string2 = this.DayLength.getValueAsString();
        }
        if (n < 4 && "CarSpawnRate".equals(string)) {
            try {
                n2 = (int)Double.parseDouble(string2);
                if (n2 > 1) {
                    string2 = Integer.toString(n2 + 1);
                }
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        if (n < 5) {
            if ("FoodLoot".equals(string) || "CannedFoodLoot".equals(string) || "LiteratureLoot".equals(string) || "SurvivalGearsLoot".equals(string) || "MedicalLoot".equals(string) || "WeaponLoot".equals(string) || "RangedWeaponLoot".equals(string) || "AmmoLoot".equals(string) || "MechanicsLoot".equals(string) || "OtherLoot".equals(string)) {
                try {
                    n2 = (int)Double.parseDouble(string2);
                    if (n2 > 0) {
                        string2 = Integer.toString(n2 + 2);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
            }
            if ("FuelStationGas".equals(string)) {
                try {
                    int n3 = (int)Double.parseDouble(string2);
                    if (n3 > 1) {
                        string2 = Integer.toString(n3 + 1);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
            }
            if ("RecentlySurvivorVehicles".equals(string)) {
                try {
                    int n4 = (int)Double.parseDouble(string2);
                    if (n4 > 0) {
                        string2 = Integer.toString(n4 + 1);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
            }
        }
        return string2;
    }

    private KahluaTable upgradeLuaTable(String string, KahluaTable kahluaTable, int n) {
        KahluaTable kahluaTable2 = LuaManager.platform.newTable();
        KahluaTableIterator kahluaTableIterator = kahluaTable.iterator();
        while (kahluaTableIterator.advance()) {
            if (kahluaTableIterator.getKey() instanceof String) {
                Object object;
                if (kahluaTableIterator.getValue() instanceof KahluaTable) {
                    object = this.upgradeLuaTable(string + kahluaTableIterator.getKey() + ".", (KahluaTable)kahluaTableIterator.getValue(), n);
                    kahluaTable2.rawset(kahluaTableIterator.getKey(), object);
                    continue;
                }
                object = this.upgradeOptionName(string + kahluaTableIterator.getKey(), n);
                String string2 = this.upgradeOptionValue((String)object, kahluaTableIterator.getValue().toString(), n);
                kahluaTable2.rawset(((String)object).replace(string, ""), (Object)string2);
                continue;
            }
            throw new IllegalStateException("expected a String key");
        }
        return kahluaTable2;
    }

    public void sendToServer() {
        if (GameClient.bClient) {
            GameClient.instance.sendSandboxOptionsToServer(this);
        }
    }

    public void newCustomOption(CustomSandboxOption customSandboxOption) {
        CustomBooleanSandboxOption customBooleanSandboxOption = Type.tryCastTo(customSandboxOption, CustomBooleanSandboxOption.class);
        if (customBooleanSandboxOption != null) {
            this.addCustomOption(new BooleanSandboxOption(this, customBooleanSandboxOption.m_id, customBooleanSandboxOption.defaultValue), customSandboxOption);
            return;
        }
        CustomDoubleSandboxOption customDoubleSandboxOption = Type.tryCastTo(customSandboxOption, CustomDoubleSandboxOption.class);
        if (customDoubleSandboxOption != null) {
            this.addCustomOption(new DoubleSandboxOption(this, customDoubleSandboxOption.m_id, customDoubleSandboxOption.min, customDoubleSandboxOption.max, customDoubleSandboxOption.defaultValue), customSandboxOption);
            return;
        }
        CustomEnumSandboxOption customEnumSandboxOption = Type.tryCastTo(customSandboxOption, CustomEnumSandboxOption.class);
        if (customEnumSandboxOption != null) {
            EnumSandboxOption enumSandboxOption = new EnumSandboxOption(this, customEnumSandboxOption.m_id, customEnumSandboxOption.numValues, customEnumSandboxOption.defaultValue);
            if (customEnumSandboxOption.m_valueTranslation != null) {
                enumSandboxOption.setValueTranslation(customEnumSandboxOption.m_valueTranslation);
            }
            this.addCustomOption(enumSandboxOption, customSandboxOption);
            return;
        }
        CustomIntegerSandboxOption customIntegerSandboxOption = Type.tryCastTo(customSandboxOption, CustomIntegerSandboxOption.class);
        if (customIntegerSandboxOption != null) {
            this.addCustomOption(new IntegerSandboxOption(this, customIntegerSandboxOption.m_id, customIntegerSandboxOption.min, customIntegerSandboxOption.max, customIntegerSandboxOption.defaultValue), customSandboxOption);
            return;
        }
        CustomStringSandboxOption customStringSandboxOption = Type.tryCastTo(customSandboxOption, CustomStringSandboxOption.class);
        if (customStringSandboxOption != null) {
            this.addCustomOption(new StringSandboxOption(this, customStringSandboxOption.m_id, customStringSandboxOption.defaultValue, -1), customSandboxOption);
            return;
        }
        throw new IllegalArgumentException("unhandled CustomSandboxOption " + customSandboxOption);
    }

    private void addCustomOption(SandboxOption sandboxOption, CustomSandboxOption customSandboxOption) {
        sandboxOption.setCustom();
        if (customSandboxOption.m_page != null) {
            sandboxOption.setPageName(customSandboxOption.m_page);
        }
        if (customSandboxOption.m_translation != null) {
            sandboxOption.setTranslation(customSandboxOption.m_translation);
        }
        this.m_customOptions.add(sandboxOption);
    }

    private void removeCustomOptions() {
        this.options.removeAll(this.m_customOptions);
        for (SandboxOption sandboxOption : this.m_customOptions) {
            this.optionByName.remove(sandboxOption.asConfigOption().getName());
        }
        this.m_customOptions.clear();
    }

    public static void Reset() {
        instance.removeCustomOptions();
    }

    public boolean getAllClothesUnlocked() {
        return this.AllClothesUnlocked.getValue();
    }

    public final class Map {
        public final BooleanSandboxOption AllowMiniMap;
        public final BooleanSandboxOption AllowWorldMap;
        public final BooleanSandboxOption MapAllKnown;

        Map() {
            this.AllowMiniMap = SandboxOptions.this.newBooleanOption("Map.AllowMiniMap", false);
            this.AllowWorldMap = SandboxOptions.this.newBooleanOption("Map.AllowWorldMap", true);
            this.MapAllKnown = SandboxOptions.this.newBooleanOption("Map.MapAllKnown", false);
        }
    }

    public final class ZombieLore {
        public final EnumSandboxOption Speed;
        public final EnumSandboxOption Strength;
        public final EnumSandboxOption Toughness;
        public final EnumSandboxOption Transmission;
        public final EnumSandboxOption Mortality;
        public final EnumSandboxOption Reanimate;
        public final EnumSandboxOption Cognition;
        public final EnumSandboxOption CrawlUnderVehicle;
        public final EnumSandboxOption Memory;
        public final EnumSandboxOption Sight;
        public final EnumSandboxOption Hearing;
        public final BooleanSandboxOption ThumpNoChasing;
        public final BooleanSandboxOption ThumpOnConstruction;
        public final EnumSandboxOption ActiveOnly;
        public final BooleanSandboxOption TriggerHouseAlarm;
        public final BooleanSandboxOption ZombiesDragDown;
        public final BooleanSandboxOption ZombiesFenceLunge;
        public final EnumSandboxOption DisableFakeDead;

        private ZombieLore() {
            this.Speed = (EnumSandboxOption)SandboxOptions.this.newEnumOption("ZombieLore.Speed", 4, 2).setTranslation("ZSpeed");
            this.Strength = (EnumSandboxOption)SandboxOptions.this.newEnumOption("ZombieLore.Strength", 4, 2).setTranslation("ZStrength");
            this.Toughness = (EnumSandboxOption)SandboxOptions.this.newEnumOption("ZombieLore.Toughness", 4, 2).setTranslation("ZToughness");
            this.Transmission = (EnumSandboxOption)SandboxOptions.this.newEnumOption("ZombieLore.Transmission", 4, 1).setTranslation("ZTransmission");
            this.Mortality = (EnumSandboxOption)SandboxOptions.this.newEnumOption("ZombieLore.Mortality", 7, 5).setTranslation("ZInfectionMortality");
            this.Reanimate = (EnumSandboxOption)SandboxOptions.this.newEnumOption("ZombieLore.Reanimate", 6, 3).setTranslation("ZReanimateTime");
            this.Cognition = (EnumSandboxOption)SandboxOptions.this.newEnumOption("ZombieLore.Cognition", 4, 3).setTranslation("ZCognition");
            this.CrawlUnderVehicle = (EnumSandboxOption)SandboxOptions.this.newEnumOption("ZombieLore.CrawlUnderVehicle", 7, 5).setTranslation("ZCrawlUnderVehicle");
            this.Memory = (EnumSandboxOption)SandboxOptions.this.newEnumOption("ZombieLore.Memory", 5, 2).setTranslation("ZMemory");
            this.Sight = (EnumSandboxOption)SandboxOptions.this.newEnumOption("ZombieLore.Sight", 4, 2).setTranslation("ZSight");
            this.Hearing = (EnumSandboxOption)SandboxOptions.this.newEnumOption("ZombieLore.Hearing", 4, 2).setTranslation("ZHearing");
            this.ThumpNoChasing = SandboxOptions.this.newBooleanOption("ZombieLore.ThumpNoChasing", false);
            this.ThumpOnConstruction = SandboxOptions.this.newBooleanOption("ZombieLore.ThumpOnConstruction", true);
            this.ActiveOnly = (EnumSandboxOption)SandboxOptions.this.newEnumOption("ZombieLore.ActiveOnly", 3, 1).setTranslation("ActiveOnly");
            this.TriggerHouseAlarm = SandboxOptions.this.newBooleanOption("ZombieLore.TriggerHouseAlarm", false);
            this.ZombiesDragDown = SandboxOptions.this.newBooleanOption("ZombieLore.ZombiesDragDown", true);
            this.ZombiesFenceLunge = SandboxOptions.this.newBooleanOption("ZombieLore.ZombiesFenceLunge", true);
            this.DisableFakeDead = SandboxOptions.this.newEnumOption("ZombieLore.DisableFakeDead", 3, 1);
        }
    }

    public final class ZombieConfig {
        public final DoubleSandboxOption PopulationMultiplier;
        public final DoubleSandboxOption PopulationStartMultiplier;
        public final DoubleSandboxOption PopulationPeakMultiplier;
        public final IntegerSandboxOption PopulationPeakDay;
        public final DoubleSandboxOption RespawnHours;
        public final DoubleSandboxOption RespawnUnseenHours;
        public final DoubleSandboxOption RespawnMultiplier;
        public final DoubleSandboxOption RedistributeHours;
        public final IntegerSandboxOption FollowSoundDistance;
        public final IntegerSandboxOption RallyGroupSize;
        public final IntegerSandboxOption RallyTravelDistance;
        public final IntegerSandboxOption RallyGroupSeparation;
        public final IntegerSandboxOption RallyGroupRadius;

        private ZombieConfig() {
            this.PopulationMultiplier = SandboxOptions.this.newDoubleOption("ZombieConfig.PopulationMultiplier", 0.0, 4.0, 1.0);
            this.PopulationStartMultiplier = SandboxOptions.this.newDoubleOption("ZombieConfig.PopulationStartMultiplier", 0.0, 4.0, 1.0);
            this.PopulationPeakMultiplier = SandboxOptions.this.newDoubleOption("ZombieConfig.PopulationPeakMultiplier", 0.0, 4.0, 1.5);
            this.PopulationPeakDay = SandboxOptions.this.newIntegerOption("ZombieConfig.PopulationPeakDay", 1, 365, 28);
            this.RespawnHours = SandboxOptions.this.newDoubleOption("ZombieConfig.RespawnHours", 0.0, 8760.0, 72.0);
            this.RespawnUnseenHours = SandboxOptions.this.newDoubleOption("ZombieConfig.RespawnUnseenHours", 0.0, 8760.0, 16.0);
            this.RespawnMultiplier = SandboxOptions.this.newDoubleOption("ZombieConfig.RespawnMultiplier", 0.0, 1.0, 0.1);
            this.RedistributeHours = SandboxOptions.this.newDoubleOption("ZombieConfig.RedistributeHours", 0.0, 8760.0, 12.0);
            this.FollowSoundDistance = SandboxOptions.this.newIntegerOption("ZombieConfig.FollowSoundDistance", 10, 1000, 100);
            this.RallyGroupSize = SandboxOptions.this.newIntegerOption("ZombieConfig.RallyGroupSize", 0, 1000, 20);
            this.RallyTravelDistance = SandboxOptions.this.newIntegerOption("ZombieConfig.RallyTravelDistance", 5, 50, 20);
            this.RallyGroupSeparation = SandboxOptions.this.newIntegerOption("ZombieConfig.RallyGroupSeparation", 5, 25, 15);
            this.RallyGroupRadius = SandboxOptions.this.newIntegerOption("ZombieConfig.RallyGroupRadius", 1, 10, 3);
        }
    }

    public static class EnumSandboxOption
    extends EnumConfigOption
    implements SandboxOption {
        protected String translation;
        protected String tableName;
        protected String shortName;
        protected boolean bCustom;
        protected String pageName;
        protected String valueTranslation;

        public EnumSandboxOption(SandboxOptions sandboxOptions, String string, int n, int n2) {
            super(string, n, n2);
            String[] stringArray = SandboxOptions.parseName(string);
            this.tableName = stringArray[0];
            this.shortName = stringArray[1];
            sandboxOptions.addOption(this);
        }

        @Override
        public ConfigOption asConfigOption() {
            return this;
        }

        @Override
        public String getShortName() {
            return this.shortName;
        }

        @Override
        public String getTableName() {
            return this.tableName;
        }

        @Override
        public SandboxOption setTranslation(String string) {
            this.translation = string;
            return this;
        }

        @Override
        public String getTranslatedName() {
            return Translator.getText("Sandbox_" + (this.translation == null ? this.getShortName() : this.translation));
        }

        @Override
        public String getTooltip() {
            String string;
            String string2 = Translator.getTextOrNull("Sandbox_" + (this.translation == null ? this.getShortName() : this.translation) + "_tooltip");
            String string3 = this.getValueTranslationByIndexOrNull(this.defaultValue);
            String string4 = string = string3 == null ? null : Translator.getText("Sandbox_Default", string3);
            if (string2 == null) {
                return string;
            }
            if (string == null) {
                return string2;
            }
            return string2 + "\\n" + string;
        }

        @Override
        public void fromTable(KahluaTable kahluaTable) {
            Object object;
            if (this.tableName != null) {
                object = kahluaTable.rawget(this.tableName);
                if (object instanceof KahluaTable) {
                    kahluaTable = (KahluaTable)object;
                } else {
                    return;
                }
            }
            if ((object = kahluaTable.rawget(this.getShortName())) != null) {
                this.setValueFromObject(object);
            }
        }

        @Override
        public void toTable(KahluaTable kahluaTable) {
            if (this.tableName != null) {
                Object object = kahluaTable.rawget(this.tableName);
                if (object instanceof KahluaTable) {
                    kahluaTable = (KahluaTable)object;
                } else {
                    KahluaTable kahluaTable2 = LuaManager.platform.newTable();
                    kahluaTable.rawset(this.tableName, (Object)kahluaTable2);
                    kahluaTable = kahluaTable2;
                }
            }
            kahluaTable.rawset(this.getShortName(), this.getValueAsObject());
        }

        @Override
        public void setCustom() {
            this.bCustom = true;
        }

        @Override
        public boolean isCustom() {
            return this.bCustom;
        }

        @Override
        public SandboxOption setPageName(String string) {
            this.pageName = string;
            return this;
        }

        @Override
        public String getPageName() {
            return this.pageName;
        }

        public EnumSandboxOption setValueTranslation(String string) {
            this.valueTranslation = string;
            return this;
        }

        public String getValueTranslation() {
            return this.valueTranslation != null ? this.valueTranslation : (this.translation == null ? this.getShortName() : this.translation);
        }

        public String getValueTranslationByIndex(int n) {
            if (n < 1 || n > this.getNumValues()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return Translator.getText("Sandbox_" + this.getValueTranslation() + "_option" + n);
        }

        public String getValueTranslationByIndexOrNull(int n) {
            if (n < 1 || n > this.getNumValues()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return Translator.getTextOrNull("Sandbox_" + this.getValueTranslation() + "_option" + n);
        }
    }

    public static interface SandboxOption {
        public ConfigOption asConfigOption();

        public String getShortName();

        public String getTableName();

        public SandboxOption setTranslation(String var1);

        public String getTranslatedName();

        public String getTooltip();

        public void fromTable(KahluaTable var1);

        public void toTable(KahluaTable var1);

        public void setCustom();

        public boolean isCustom();

        public SandboxOption setPageName(String var1);

        public String getPageName();
    }

    public static class IntegerSandboxOption
    extends IntegerConfigOption
    implements SandboxOption {
        protected String translation;
        protected String tableName;
        protected String shortName;
        protected boolean bCustom;
        protected String pageName;

        public IntegerSandboxOption(SandboxOptions sandboxOptions, String string, int n, int n2, int n3) {
            super(string, n, n2, n3);
            String[] stringArray = SandboxOptions.parseName(string);
            this.tableName = stringArray[0];
            this.shortName = stringArray[1];
            sandboxOptions.addOption(this);
        }

        @Override
        public ConfigOption asConfigOption() {
            return this;
        }

        @Override
        public String getShortName() {
            return this.shortName;
        }

        @Override
        public String getTableName() {
            return this.tableName;
        }

        @Override
        public SandboxOption setTranslation(String string) {
            this.translation = string;
            return this;
        }

        @Override
        public String getTranslatedName() {
            return Translator.getText("Sandbox_" + (this.translation == null ? this.getShortName() : this.translation));
        }

        @Override
        public String getTooltip() {
            String string = "ZombieConfig".equals(this.tableName) ? Translator.getTextOrNull("Sandbox_" + (this.translation == null ? this.getShortName() : this.translation) + "_help") : Translator.getTextOrNull("Sandbox_" + (this.translation == null ? this.getShortName() : this.translation) + "_tooltip");
            String string2 = Translator.getText("Sandbox_MinMaxDefault", this.min, this.max, this.defaultValue);
            if (string == null) {
                return string2;
            }
            if (string2 == null) {
                return string;
            }
            return string + "\\n" + string2;
        }

        @Override
        public void fromTable(KahluaTable kahluaTable) {
            Object object;
            if (this.tableName != null) {
                object = kahluaTable.rawget(this.tableName);
                if (object instanceof KahluaTable) {
                    kahluaTable = (KahluaTable)object;
                } else {
                    return;
                }
            }
            if ((object = kahluaTable.rawget(this.getShortName())) != null) {
                this.setValueFromObject(object);
            }
        }

        @Override
        public void toTable(KahluaTable kahluaTable) {
            if (this.tableName != null) {
                Object object = kahluaTable.rawget(this.tableName);
                if (object instanceof KahluaTable) {
                    kahluaTable = (KahluaTable)object;
                } else {
                    KahluaTable kahluaTable2 = LuaManager.platform.newTable();
                    kahluaTable.rawset(this.tableName, (Object)kahluaTable2);
                    kahluaTable = kahluaTable2;
                }
            }
            kahluaTable.rawset(this.getShortName(), this.getValueAsObject());
        }

        @Override
        public void setCustom() {
            this.bCustom = true;
        }

        @Override
        public boolean isCustom() {
            return this.bCustom;
        }

        @Override
        public SandboxOption setPageName(String string) {
            this.pageName = string;
            return this;
        }

        @Override
        public String getPageName() {
            return this.pageName;
        }
    }

    public static class DoubleSandboxOption
    extends DoubleConfigOption
    implements SandboxOption {
        protected String translation;
        protected String tableName;
        protected String shortName;
        protected boolean bCustom;
        protected String pageName;

        public DoubleSandboxOption(SandboxOptions sandboxOptions, String string, double d, double d2, double d3) {
            super(string, d, d2, d3);
            String[] stringArray = SandboxOptions.parseName(string);
            this.tableName = stringArray[0];
            this.shortName = stringArray[1];
            sandboxOptions.addOption(this);
        }

        @Override
        public ConfigOption asConfigOption() {
            return this;
        }

        @Override
        public String getShortName() {
            return this.shortName;
        }

        @Override
        public String getTableName() {
            return this.tableName;
        }

        @Override
        public SandboxOption setTranslation(String string) {
            this.translation = string;
            return this;
        }

        @Override
        public String getTranslatedName() {
            return Translator.getText("Sandbox_" + (this.translation == null ? this.getShortName() : this.translation));
        }

        @Override
        public String getTooltip() {
            String string = "ZombieConfig".equals(this.tableName) ? Translator.getTextOrNull("Sandbox_" + (this.translation == null ? this.getShortName() : this.translation) + "_help") : Translator.getTextOrNull("Sandbox_" + (this.translation == null ? this.getShortName() : this.translation) + "_tooltip");
            String string2 = Translator.getText("Sandbox_MinMaxDefault", String.format("%.02f", this.min), String.format("%.02f", this.max), String.format("%.02f", this.defaultValue));
            if (string == null) {
                return string2;
            }
            if (string2 == null) {
                return string;
            }
            return string + "\\n" + string2;
        }

        @Override
        public void fromTable(KahluaTable kahluaTable) {
            Object object;
            if (this.tableName != null) {
                object = kahluaTable.rawget(this.tableName);
                if (object instanceof KahluaTable) {
                    kahluaTable = (KahluaTable)object;
                } else {
                    return;
                }
            }
            if ((object = kahluaTable.rawget(this.getShortName())) != null) {
                this.setValueFromObject(object);
            }
        }

        @Override
        public void toTable(KahluaTable kahluaTable) {
            if (this.tableName != null) {
                Object object = kahluaTable.rawget(this.tableName);
                if (object instanceof KahluaTable) {
                    kahluaTable = (KahluaTable)object;
                } else {
                    KahluaTable kahluaTable2 = LuaManager.platform.newTable();
                    kahluaTable.rawset(this.tableName, (Object)kahluaTable2);
                    kahluaTable = kahluaTable2;
                }
            }
            kahluaTable.rawset(this.getShortName(), this.getValueAsObject());
        }

        @Override
        public void setCustom() {
            this.bCustom = true;
        }

        @Override
        public boolean isCustom() {
            return this.bCustom;
        }

        @Override
        public SandboxOption setPageName(String string) {
            this.pageName = string;
            return this;
        }

        @Override
        public String getPageName() {
            return this.pageName;
        }
    }

    public static class BooleanSandboxOption
    extends BooleanConfigOption
    implements SandboxOption {
        protected String translation;
        protected String tableName;
        protected String shortName;
        protected boolean bCustom;
        protected String pageName;

        public BooleanSandboxOption(SandboxOptions sandboxOptions, String string, boolean bl) {
            super(string, bl);
            String[] stringArray = SandboxOptions.parseName(string);
            this.tableName = stringArray[0];
            this.shortName = stringArray[1];
            sandboxOptions.addOption(this);
        }

        @Override
        public ConfigOption asConfigOption() {
            return this;
        }

        @Override
        public String getShortName() {
            return this.shortName;
        }

        @Override
        public String getTableName() {
            return this.tableName;
        }

        @Override
        public SandboxOption setTranslation(String string) {
            this.translation = string;
            return this;
        }

        @Override
        public String getTranslatedName() {
            return Translator.getText("Sandbox_" + (this.translation == null ? this.getShortName() : this.translation));
        }

        @Override
        public String getTooltip() {
            return Translator.getTextOrNull("Sandbox_" + (this.translation == null ? this.getShortName() : this.translation) + "_tooltip");
        }

        @Override
        public void fromTable(KahluaTable kahluaTable) {
            Object object;
            if (this.tableName != null) {
                object = kahluaTable.rawget(this.tableName);
                if (object instanceof KahluaTable) {
                    kahluaTable = (KahluaTable)object;
                } else {
                    return;
                }
            }
            if ((object = kahluaTable.rawget(this.getShortName())) != null) {
                this.setValueFromObject(object);
            }
        }

        @Override
        public void toTable(KahluaTable kahluaTable) {
            if (this.tableName != null) {
                Object object = kahluaTable.rawget(this.tableName);
                if (object instanceof KahluaTable) {
                    kahluaTable = (KahluaTable)object;
                } else {
                    KahluaTable kahluaTable2 = LuaManager.platform.newTable();
                    kahluaTable.rawset(this.tableName, (Object)kahluaTable2);
                    kahluaTable = kahluaTable2;
                }
            }
            kahluaTable.rawset(this.getShortName(), this.getValueAsObject());
        }

        @Override
        public void setCustom() {
            this.bCustom = true;
        }

        @Override
        public boolean isCustom() {
            return this.bCustom;
        }

        @Override
        public SandboxOption setPageName(String string) {
            this.pageName = string;
            return this;
        }

        @Override
        public String getPageName() {
            return this.pageName;
        }
    }

    public static class StringSandboxOption
    extends StringConfigOption
    implements SandboxOption {
        protected String translation;
        protected String tableName;
        protected String shortName;
        protected boolean bCustom;
        protected String pageName;

        public StringSandboxOption(SandboxOptions sandboxOptions, String string, String string2, int n) {
            super(string, string2, n);
            String[] stringArray = SandboxOptions.parseName(string);
            this.tableName = stringArray[0];
            this.shortName = stringArray[1];
            sandboxOptions.addOption(this);
        }

        @Override
        public ConfigOption asConfigOption() {
            return this;
        }

        @Override
        public String getShortName() {
            return this.shortName;
        }

        @Override
        public String getTableName() {
            return this.tableName;
        }

        @Override
        public SandboxOption setTranslation(String string) {
            this.translation = string;
            return this;
        }

        @Override
        public String getTranslatedName() {
            return Translator.getText("Sandbox_" + (this.translation == null ? this.getShortName() : this.translation));
        }

        @Override
        public String getTooltip() {
            return Translator.getTextOrNull("Sandbox_" + (this.translation == null ? this.getShortName() : this.translation) + "_tooltip");
        }

        @Override
        public void fromTable(KahluaTable kahluaTable) {
            Object object;
            if (this.tableName != null) {
                object = kahluaTable.rawget(this.tableName);
                if (object instanceof KahluaTable) {
                    kahluaTable = (KahluaTable)object;
                } else {
                    return;
                }
            }
            if ((object = kahluaTable.rawget(this.getShortName())) != null) {
                this.setValueFromObject(object);
            }
        }

        @Override
        public void toTable(KahluaTable kahluaTable) {
            if (this.tableName != null) {
                Object object = kahluaTable.rawget(this.tableName);
                if (object instanceof KahluaTable) {
                    kahluaTable = (KahluaTable)object;
                } else {
                    KahluaTable kahluaTable2 = LuaManager.platform.newTable();
                    kahluaTable.rawset(this.tableName, (Object)kahluaTable2);
                    kahluaTable = kahluaTable2;
                }
            }
            kahluaTable.rawset(this.getShortName(), this.getValueAsObject());
        }

        @Override
        public void setCustom() {
            this.bCustom = true;
        }

        @Override
        public boolean isCustom() {
            return this.bCustom;
        }

        @Override
        public SandboxOption setPageName(String string) {
            this.pageName = string;
            return this;
        }

        @Override
        public String getPageName() {
            return this.pageName;
        }
    }
}

