/*
 * Decompiled with CFR 0.152.
 */
package zombie;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import zombie.SharedDescriptors;
import zombie.VirtualZombieManager;
import zombie.ZomboidFileSystem;
import zombie.ai.states.ZombieIdleState;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.core.logger.ExceptionLogger;
import zombie.debug.DebugLog;
import zombie.iso.IsoChunk;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.SliceY;
import zombie.iso.objects.IsoFireManager;
import zombie.iso.sprite.IsoSpriteInstance;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.ServerMap;

public final class ReanimatedPlayers {
    public static ReanimatedPlayers instance = new ReanimatedPlayers();
    private final ArrayList<IsoZombie> Zombies = new ArrayList();

    private static void noise(String string) {
        DebugLog.log("reanimate: " + string);
    }

    public void addReanimatedPlayersToChunk(IsoChunk isoChunk) {
        int n = isoChunk.wx * 10;
        int n2 = isoChunk.wy * 10;
        int n3 = n + 10;
        int n4 = n2 + 10;
        for (int i = 0; i < this.Zombies.size(); ++i) {
            IsoGridSquare isoGridSquare;
            IsoZombie isoZombie = this.Zombies.get(i);
            if (!(isoZombie.getX() >= (float)n) || !(isoZombie.getX() < (float)n3) || !(isoZombie.getY() >= (float)n2) || !(isoZombie.getY() < (float)n4) || (isoGridSquare = isoChunk.getGridSquare((int)isoZombie.getX() - n, (int)isoZombie.getY() - n2, (int)isoZombie.getZ())) == null) continue;
            if (GameServer.bServer) {
                if (isoZombie.OnlineID != -1) {
                    ReanimatedPlayers.noise("ERROR? OnlineID != -1 for reanimated player zombie");
                }
                isoZombie.OnlineID = ServerMap.instance.getUniqueZombieId();
                if (isoZombie.OnlineID == -1) continue;
                ServerMap.instance.ZombieMap.put(isoZombie.OnlineID, isoZombie);
            }
            isoZombie.setCurrent(isoGridSquare);
            assert (!IsoWorld.instance.CurrentCell.getObjectList().contains(isoZombie));
            assert (!IsoWorld.instance.CurrentCell.getZombieList().contains(isoZombie));
            IsoWorld.instance.CurrentCell.getObjectList().add(isoZombie);
            IsoWorld.instance.CurrentCell.getZombieList().add(isoZombie);
            this.Zombies.remove(i);
            --i;
            SharedDescriptors.createPlayerZombieDescriptor(isoZombie);
            ReanimatedPlayers.noise("added to world " + isoZombie);
        }
    }

    public void removeReanimatedPlayerFromWorld(IsoZombie isoZombie) {
        if (!isoZombie.isReanimatedPlayer()) {
            return;
        }
        if (!GameServer.bServer) {
            isoZombie.setSceneCulled(true);
        }
        if (isoZombie.isOnFire()) {
            IsoFireManager.RemoveBurningCharacter(isoZombie);
            isoZombie.setOnFire(false);
        }
        if (isoZombie.AttachedAnimSprite != null) {
            ArrayList arrayList = isoZombie.AttachedAnimSprite;
            for (int i = 0; i < arrayList.size(); ++i) {
                IsoSpriteInstance isoSpriteInstance = (IsoSpriteInstance)arrayList.get(i);
                IsoSpriteInstance.add(isoSpriteInstance);
            }
            isoZombie.AttachedAnimSprite.clear();
        }
        if (!GameServer.bServer) {
            for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                IsoPlayer isoPlayer = IsoPlayer.players[i];
                if (isoPlayer == null || isoPlayer.ReanimatedCorpse != isoZombie) continue;
                isoPlayer.ReanimatedCorpse = null;
                isoPlayer.ReanimatedCorpseID = -1;
            }
        }
        if (GameServer.bServer && isoZombie.OnlineID != -1) {
            ServerMap.instance.ZombieMap.remove(isoZombie.OnlineID);
            isoZombie.OnlineID = (short)-1;
        }
        SharedDescriptors.releasePlayerZombieDescriptor(isoZombie);
        assert (!VirtualZombieManager.instance.isReused(isoZombie));
        if (isoZombie.isDead()) {
            return;
        }
        if (GameClient.bClient) {
            return;
        }
        if (this.Zombies.contains(isoZombie)) {
            return;
        }
        this.Zombies.add(isoZombie);
        ReanimatedPlayers.noise("added to Zombies " + isoZombie);
        isoZombie.setStateMachineLocked(false);
        isoZombie.changeState(ZombieIdleState.instance());
    }

    public void saveReanimatedPlayers() {
        if (GameClient.bClient) {
            return;
        }
        ArrayList<IsoZombie> arrayList = new ArrayList<IsoZombie>();
        try {
            ByteBuffer byteBuffer = SliceY.SliceBuffer;
            byteBuffer.clear();
            byteBuffer.putInt(195);
            arrayList.addAll(this.Zombies);
            ArrayList<IsoZombie> arrayList2 = IsoWorld.instance.CurrentCell.getZombieList();
            for (IsoZombie object2 : arrayList2) {
                if (!object2.isReanimatedPlayer() || object2.isDead() || arrayList.contains(object2)) continue;
                arrayList.add(object2);
            }
            byteBuffer.putInt(arrayList.size());
            for (IsoZombie isoZombie : arrayList) {
                isoZombie.save(byteBuffer);
            }
            File file = ZomboidFileSystem.instance.getFileInCurrentSave("reanimated.bin");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            bufferedOutputStream.write(byteBuffer.array(), 0, byteBuffer.position());
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
            return;
        }
        ReanimatedPlayers.noise("saved " + arrayList.size() + " zombies");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadReanimatedPlayers() {
        if (GameClient.bClient) {
            return;
        }
        this.Zombies.clear();
        File file = ZomboidFileSystem.instance.getFileInCurrentSave("reanimated.bin");
        try (FileInputStream fileInputStream = new FileInputStream(file);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
            Object object = SliceY.SliceBufferLock;
            synchronized (object) {
                ByteBuffer byteBuffer = SliceY.SliceBuffer;
                byteBuffer.clear();
                int n = bufferedInputStream.read(byteBuffer.array());
                byteBuffer.limit(n);
                this.loadReanimatedPlayers(byteBuffer);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
            return;
        }
        ReanimatedPlayers.noise("loaded " + this.Zombies.size() + " zombies");
    }

    private void loadReanimatedPlayers(ByteBuffer byteBuffer) throws IOException, RuntimeException {
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        for (int i = 0; i < n2; ++i) {
            IsoObject isoObject = IsoObject.factoryFromFileInput(IsoWorld.instance.CurrentCell, byteBuffer);
            if (!(isoObject instanceof IsoZombie)) {
                throw new RuntimeException("expected IsoZombie here");
            }
            IsoZombie isoZombie = (IsoZombie)isoObject;
            isoZombie.load(byteBuffer, n);
            isoZombie.getDescriptor().setID(0);
            isoZombie.setReanimatedPlayer(true);
            IsoWorld.instance.CurrentCell.getAddList().remove(isoZombie);
            IsoWorld.instance.CurrentCell.getObjectList().remove(isoZombie);
            IsoWorld.instance.CurrentCell.getZombieList().remove(isoZombie);
            this.Zombies.add(isoZombie);
        }
    }
}

