/*
 * Decompiled with CFR 0.152.
 */
package zombie;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeMap;
import zombie.SharedDescriptors;
import zombie.ZomboidFileSystem;
import zombie.characters.AttachedItems.AttachedWeaponDefinitions;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoZombie;
import zombie.characters.ZombiesZoneDefinition;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.logger.ExceptionLogger;
import zombie.core.skinnedmodel.population.Outfit;
import zombie.core.skinnedmodel.population.OutfitManager;
import zombie.core.skinnedmodel.population.OutfitRNG;
import zombie.core.skinnedmodel.visual.ItemVisual;
import zombie.core.skinnedmodel.visual.ItemVisuals;
import zombie.iso.IsoWorld;
import zombie.iso.SliceY;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.randomizedWorld.randomizedVehicleStory.RandomizedVehicleStoryBase;
import zombie.scripting.objects.Item;
import zombie.util.Type;
import zombie.util.list.PZArrayUtil;

public class PersistentOutfits {
    public static final PersistentOutfits instance = new PersistentOutfits();
    public static final int INVALID_ID = 0;
    public static final int FEMALE_BIT = Integer.MIN_VALUE;
    public static final int NO_HAT_BIT = 32768;
    private static final int FILE_VERSION_1 = 1;
    private static final int FILE_VERSION_LATEST = 1;
    private static final byte[] FILE_MAGIC = new byte[]{80, 83, 84, 90};
    private static final int NUM_SEEDS = 500;
    private final long[] m_seeds = new long[500];
    private final ArrayList<String> m_outfitNames = new ArrayList();
    private final DataList m_all = new DataList();
    private final DataList m_female = new DataList();
    private final DataList m_male = new DataList();
    private final TreeMap<String, Data> m_outfitToData = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private final TreeMap<String, Data> m_outfitToFemale = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private final TreeMap<String, Data> m_outfitToMale = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private static final ItemVisuals tempItemVisuals = new ItemVisuals();

    public void init() {
        this.m_all.clear();
        this.m_female.clear();
        this.m_male.clear();
        this.m_outfitToData.clear();
        this.m_outfitToFemale.clear();
        this.m_outfitToMale.clear();
        this.m_outfitNames.clear();
        if (!GameClient.bClient) {
            for (int i = 0; i < 500; ++i) {
                this.m_seeds[i] = Rand.Next(Integer.MAX_VALUE);
            }
        }
        this.initOutfitList(OutfitManager.instance.m_FemaleOutfits, true);
        this.initOutfitList(OutfitManager.instance.m_MaleOutfits, false);
        this.registerCustomOutfits();
        if (GameClient.bClient) {
            return;
        }
        this.load();
        this.save();
    }

    private void initOutfitList(ArrayList<Outfit> arrayList, boolean bl) {
        ArrayList<Outfit> arrayList2 = new ArrayList<Outfit>(arrayList);
        arrayList2.sort((outfit, outfit2) -> outfit.m_Name.compareTo(outfit2.m_Name));
        for (Outfit outfit3 : arrayList2) {
            this.initOutfit(outfit3.m_Name, bl, true, PersistentOutfits::ApplyOutfit);
        }
    }

    private void initOutfit(String string, boolean bl, boolean bl2, IOutfitter iOutfitter) {
        TreeMap<String, Data> treeMap = bl ? this.m_outfitToFemale : this.m_outfitToMale;
        Data data = this.m_outfitToData.get(string);
        if (data == null) {
            data = new Data();
            data.m_index = (short)this.m_all.size();
            data.m_outfitName = string;
            data.m_useSeed = bl2;
            data.m_outfitter = iOutfitter;
            this.m_outfitNames.add(string);
            this.m_outfitToData.put(string, data);
            this.m_all.add(data);
        }
        DataList dataList = bl ? this.m_female : this.m_male;
        dataList.add(data);
        treeMap.put(string, data);
    }

    private void registerCustomOutfits() {
        ArrayList<RandomizedVehicleStoryBase> arrayList = IsoWorld.instance.getRandomizedVehicleStoryList();
        for (int i = 0; i < arrayList.size(); ++i) {
            RandomizedVehicleStoryBase randomizedVehicleStoryBase = arrayList.get(i);
            randomizedVehicleStoryBase.registerCustomOutfits();
        }
        ZombiesZoneDefinition.registerCustomOutfits();
        if (GameServer.bServer || GameClient.bClient) {
            this.registerOutfitter("ReanimatedPlayer", false, SharedDescriptors::ApplyReanimatedPlayerOutfit);
        }
    }

    public ArrayList<String> getOutfitNames() {
        return this.m_outfitNames;
    }

    public int pickRandomFemale() {
        if (this.m_female.isEmpty()) {
            return 0;
        }
        String string = PZArrayUtil.pickRandom(this.m_female).m_outfitName;
        return this.pickOutfitFemale(string);
    }

    public int pickRandomMale() {
        if (this.m_male.isEmpty()) {
            return 0;
        }
        String string = PZArrayUtil.pickRandom(this.m_male).m_outfitName;
        return this.pickOutfitMale(string);
    }

    public int pickOutfitFemale(String string) {
        Data data = this.m_outfitToFemale.get(string);
        if (data == null) {
            return 0;
        }
        short s = (short)data.m_index;
        int n = data.m_useSeed ? (int)Rand.Next(500) : 0;
        return Integer.MIN_VALUE | s << 16 | n + 1;
    }

    public int pickOutfitMale(String string) {
        Data data = this.m_outfitToMale.get(string);
        if (data == null) {
            return 0;
        }
        short s = (short)data.m_index;
        int n = data.m_useSeed ? (int)Rand.Next(500) : 0;
        return s << 16 | n + 1;
    }

    public int pickOutfit(String string, boolean bl) {
        return bl ? this.pickOutfitFemale(string) : this.pickOutfitMale(string);
    }

    public int getOutfit(int n) {
        if (n == 0) {
            return 0;
        }
        int n2 = n & Integer.MIN_VALUE;
        int n3 = (n &= Integer.MAX_VALUE) & 0x8000;
        short s = (short)((n &= 0xFFFF7FFF) >> 16);
        short s2 = (short)(n & 0xFFFF);
        if (s < 0 || s >= this.m_all.size()) {
            return 0;
        }
        Data data = (Data)this.m_all.get(s);
        if (data.m_useSeed && (s2 < 1 || s2 > 500)) {
            s2 = (short)(Rand.Next(500) + 1);
        }
        return n2 | n3 | s << 16 | s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        if (Core.getInstance().isNoSave()) {
            return;
        }
        File file = ZomboidFileSystem.instance.getFileInCurrentSave("z_outfits.bin");
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);){
            Object object = SliceY.SliceBufferLock;
            synchronized (object) {
                SliceY.SliceBuffer.clear();
                ByteBuffer byteBuffer = SliceY.SliceBuffer;
                this.save(byteBuffer);
                bufferedOutputStream.write(byteBuffer.array(), 0, byteBuffer.position());
            }
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
        }
    }

    public void save(ByteBuffer byteBuffer) {
        byteBuffer.put(FILE_MAGIC);
        byteBuffer.putInt(1);
        byteBuffer.putShort((short)500);
        for (int i = 0; i < 500; ++i) {
            byteBuffer.putLong(this.m_seeds[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        File file = ZomboidFileSystem.instance.getFileInCurrentSave("z_outfits.bin");
        try (FileInputStream fileInputStream = new FileInputStream(file);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
            Object object = SliceY.SliceBufferLock;
            synchronized (object) {
                SliceY.SliceBuffer.clear();
                ByteBuffer byteBuffer = SliceY.SliceBuffer;
                int n = bufferedInputStream.read(byteBuffer.array());
                byteBuffer.limit(n);
                this.load(byteBuffer);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
        }
    }

    public void load(ByteBuffer byteBuffer) throws IOException {
        byte[] byArray = new byte[4];
        byteBuffer.get(byArray);
        if (!Arrays.equals(byArray, FILE_MAGIC)) {
            throw new IOException("not magic");
        }
        int n = byteBuffer.getInt();
        if (n < 1 || n > 1) {
            return;
        }
        int n2 = byteBuffer.getShort();
        for (int i = 0; i < n2; ++i) {
            if (i >= 500) continue;
            this.m_seeds[i] = byteBuffer.getLong();
        }
    }

    public void registerOutfitter(String string, boolean bl, IOutfitter iOutfitter) {
        this.initOutfit(string, true, bl, iOutfitter);
        this.initOutfit(string, false, bl, iOutfitter);
    }

    private static void ApplyOutfit(int n, String string, IsoGameCharacter isoGameCharacter) {
        instance.applyOutfit(n, string, isoGameCharacter);
    }

    private void applyOutfit(int n, String string, IsoGameCharacter isoGameCharacter) {
        boolean bl = (n & Integer.MIN_VALUE) != 0;
        short s = (short)((n &= Integer.MAX_VALUE) >> 16);
        Data data = (Data)this.m_all.get(s);
        IsoZombie isoZombie = Type.tryCastTo(isoGameCharacter, IsoZombie.class);
        if (isoZombie != null) {
            isoZombie.setFemaleEtc(bl);
        }
        isoGameCharacter.dressInNamedOutfit(data.m_outfitName);
        if (isoZombie != null && isoGameCharacter.doDirtBloodEtc) {
            AttachedWeaponDefinitions.instance.addRandomAttachedWeapon(isoZombie);
            isoZombie.addRandomBloodDirtHolesEtc();
        }
        this.removeFallenHat(n, isoGameCharacter);
    }

    public boolean isHatFallen(IsoGameCharacter isoGameCharacter) {
        return this.isHatFallen(isoGameCharacter.getPersistentOutfitID());
    }

    public boolean isHatFallen(int n) {
        return (n & 0x8000) != 0;
    }

    public void setFallenHat(IsoGameCharacter isoGameCharacter, boolean bl) {
        int n = isoGameCharacter.getPersistentOutfitID();
        if (n == 0) {
            return;
        }
        n = bl ? (n |= 0x8000) : (n &= 0xFFFF7FFF);
        isoGameCharacter.setPersistentOutfitID(n, isoGameCharacter.isPersistentOutfitInit());
    }

    public boolean removeFallenHat(int n, IsoGameCharacter isoGameCharacter) {
        if ((n & 0x8000) == 0) {
            return false;
        }
        if (isoGameCharacter.isUsingWornItems()) {
            return false;
        }
        boolean bl = false;
        isoGameCharacter.getItemVisuals(tempItemVisuals);
        for (int i = 0; i < tempItemVisuals.size(); ++i) {
            ItemVisual itemVisual = (ItemVisual)tempItemVisuals.get(i);
            Item item = itemVisual.getScriptItem();
            if (item == null || item.getChanceToFall() <= 0) continue;
            isoGameCharacter.getItemVisuals().remove(itemVisual);
            bl = true;
        }
        return bl;
    }

    public void dressInOutfit(IsoGameCharacter isoGameCharacter, int n) {
        if ((n = this.getOutfit(n)) == 0) {
            return;
        }
        int n2 = n;
        short s = (short)((n2 &= 0x7FFF7FFF) >> 16);
        short s2 = (short)(n2 & 0xFFFF);
        Data data = (Data)this.m_all.get(s);
        if (data.m_useSeed) {
            OutfitRNG.setSeed(this.m_seeds[s2 - 1]);
        }
        data.m_outfitter.accept(n, data.m_outfitName, isoGameCharacter);
    }

    private static final class DataList
    extends ArrayList<Data> {
        private DataList() {
        }
    }

    public static interface IOutfitter {
        public void accept(int var1, String var2, IsoGameCharacter var3);
    }

    private static final class Data {
        int m_index;
        String m_outfitName;
        boolean m_useSeed = true;
        IOutfitter m_outfitter;

        private Data() {
        }
    }
}

