/*
 * Decompiled with CFR 0.152.
 */
package zombie;

import java.util.ArrayList;
import zombie.GameTime;
import zombie.VirtualZombieManager;
import zombie.characters.IsoZombie;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoWorld;
import zombie.iso.objects.IsoDeadBody;
import zombie.util.Type;

public final class MovingObjectUpdateSchedulerUpdateBucket {
    public int frameMod;
    ArrayList<IsoMovingObject>[] buckets;

    public MovingObjectUpdateSchedulerUpdateBucket(int n) {
        this.init(n);
    }

    public void init(int n) {
        this.frameMod = n;
        this.buckets = new ArrayList[n];
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = new ArrayList();
        }
    }

    public void clear() {
        for (int i = 0; i < this.buckets.length; ++i) {
            ArrayList<IsoMovingObject> arrayList = this.buckets[i];
            arrayList.clear();
        }
    }

    public void remove(IsoMovingObject isoMovingObject) {
        for (int i = 0; i < this.buckets.length; ++i) {
            ArrayList<IsoMovingObject> arrayList = this.buckets[i];
            arrayList.remove(isoMovingObject);
        }
    }

    public void add(IsoMovingObject isoMovingObject) {
        int n = isoMovingObject.getID() % this.frameMod;
        this.buckets[n].add(isoMovingObject);
    }

    public void update(int n) {
        GameTime.getInstance().PerObjectMultiplier = this.frameMod;
        ArrayList<IsoMovingObject> arrayList = this.buckets[n % this.frameMod];
        for (int i = 0; i < arrayList.size(); ++i) {
            IsoMovingObject isoMovingObject = arrayList.get(i);
            if (isoMovingObject instanceof IsoDeadBody) {
                IsoWorld.instance.getCell().getRemoveList().add(isoMovingObject);
                continue;
            }
            IsoZombie isoZombie = Type.tryCastTo(isoMovingObject, IsoZombie.class);
            if (isoZombie != null && VirtualZombieManager.instance.isReused(isoZombie)) {
                DebugLog.log(DebugType.Zombie, "REUSABLE ZOMBIE IN MovingObjectUpdateSchedulerUpdateBucket IGNORED " + isoMovingObject);
                continue;
            }
            isoMovingObject.preupdate();
            isoMovingObject.update();
        }
        GameTime.getInstance().PerObjectMultiplier = 1.0f;
    }

    public void postupdate(int n) {
        GameTime.getInstance().PerObjectMultiplier = this.frameMod;
        ArrayList<IsoMovingObject> arrayList = this.buckets[n % this.frameMod];
        for (int i = 0; i < arrayList.size(); ++i) {
            IsoMovingObject isoMovingObject = arrayList.get(i);
            IsoZombie isoZombie = Type.tryCastTo(isoMovingObject, IsoZombie.class);
            if (isoZombie != null && VirtualZombieManager.instance.isReused(isoZombie)) {
                DebugLog.log(DebugType.Zombie, "REUSABLE ZOMBIE IN MovingObjectUpdateSchedulerUpdateBucket IGNORED " + isoMovingObject);
                continue;
            }
            isoMovingObject.postupdate();
        }
        GameTime.getInstance().PerObjectMultiplier = 1.0f;
    }

    public void removeObject(IsoMovingObject isoMovingObject) {
        for (int i = 0; i < this.buckets.length; ++i) {
            ArrayList<IsoMovingObject> arrayList = this.buckets[i];
            arrayList.remove(isoMovingObject);
        }
    }

    public ArrayList<IsoMovingObject> getBucket(int n) {
        return this.buckets[n % this.frameMod];
    }
}

