/*
 * Decompiled with CFR 0.152.
 */
package zombie;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import zombie.ZomboidFileSystem;
import zombie.core.Core;
import zombie.core.Translator;
import zombie.core.logger.ExceptionLogger;
import zombie.debug.DebugLog;
import zombie.gameStates.ChooseGameInfo;
import zombie.iso.IsoWorld;
import zombie.modding.ActiveMods;

public final class MapGroups {
    private final ArrayList<MapGroup> groups = new ArrayList();
    private final ArrayList<MapDirectory> realDirectories = new ArrayList();

    private static ArrayList<String> getVanillaMapDirectories(boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = ZomboidFileSystem.instance.getMediaFile("maps");
        String[] stringArray = file.list();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (string.equalsIgnoreCase("challengemaps")) {
                    if (!bl) continue;
                    try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(Paths.get(file.getPath(), string), path -> Files.isDirectory(path, new LinkOption[0]) && Files.exists(path.resolve("map.info"), new LinkOption[0]));){
                        for (Path path2 : directoryStream) {
                            arrayList.add(string + "/" + path2.getFileName().toString());
                        }
                    }
                    catch (Exception exception) {}
                    continue;
                }
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public static String addMissingVanillaDirectories(String string) {
        ArrayList<String> arrayList = MapGroups.getVanillaMapDirectories(false);
        boolean bl = false;
        String[] stringArray = string.split(";");
        for (String string2 : stringArray) {
            if ((string2 = string2.trim()).isEmpty() || !arrayList.contains(string2)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return string;
        }
        ArrayList arrayList2 = new ArrayList();
        for (String string3 : stringArray) {
            if ((string3 = string3.trim()).isEmpty()) continue;
            arrayList2.add(string3);
        }
        for (String string4 : arrayList) {
            if (arrayList2.contains(string4)) continue;
            arrayList2.add(string4);
        }
        Object object = "";
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            String string5 = (String)iterator.next();
            if (!((String)object).isEmpty()) {
                object = (String)object + ";";
            }
            object = (String)object + string5;
        }
        return object;
    }

    public void createGroups() {
        this.createGroups(ActiveMods.getById("currentGame"), true);
    }

    public void createGroups(ActiveMods activeMods, boolean bl) {
        this.createGroups(activeMods, bl, false);
    }

    public void createGroups(ActiveMods activeMods, boolean bl, boolean bl2) {
        Iterator iterator;
        this.groups.clear();
        this.realDirectories.clear();
        for (String object3 : activeMods.getMods()) {
            String[] stringArray;
            ChooseGameInfo.Mod mod = ChooseGameInfo.getAvailableModDetails(object3);
            if (mod == null || !((File)((Object)(iterator = new File(mod.getDir() + "/media/maps/")))).exists() || (stringArray = ((File)((Object)iterator)).list()) == null) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (string.equalsIgnoreCase("challengemaps")) {
                    if (!bl2) continue;
                    continue;
                }
                this.handleMapDirectory(string, mod.getDir() + "/media/maps/" + string);
            }
        }
        if (bl) {
            Iterator<Object> iterator2 = MapGroups.getVanillaMapDirectories(bl2);
            String string = ZomboidFileSystem.instance.getMediaPath("maps");
            Iterator iterator3 = ((ArrayList)((Object)iterator2)).iterator();
            while (iterator3.hasNext()) {
                iterator = (String)iterator3.next();
                this.handleMapDirectory((String)((Object)iterator), string + File.separator + (String)((Object)iterator));
            }
        }
        for (MapDirectory mapDirectory : this.realDirectories) {
            ArrayList<MapDirectory> arrayList = new ArrayList<MapDirectory>();
            this.getDirsRecursively(mapDirectory, arrayList);
            iterator = this.findGroupWithAnyOfTheseDirectories(arrayList);
            if (iterator == null) {
                iterator = new MapGroup();
                this.groups.add((MapGroup)((Object)iterator));
            }
            for (MapDirectory mapDirectory2 : arrayList) {
                if (((MapGroup)((Object)iterator)).hasDirectory(mapDirectory2.name)) continue;
                ((MapGroup)((Object)iterator)).addDirectory(mapDirectory2);
            }
        }
        for (MapGroup mapGroup : this.groups) {
            mapGroup.setPriority();
        }
        for (MapGroup mapGroup : this.groups) {
            mapGroup.setOrder(activeMods);
        }
        if (Core.bDebug) {
            int n = 1;
            for (MapGroup mapGroup : this.groups) {
                DebugLog.log("MapGroup " + n + "/" + this.groups.size());
                for (MapDirectory mapDirectory : mapGroup.directories) {
                    DebugLog.log("  " + mapDirectory.name);
                }
                ++n;
            }
            DebugLog.log("-----");
        }
    }

    private void getDirsRecursively(MapDirectory mapDirectory, ArrayList<MapDirectory> arrayList) {
        if (arrayList.contains(mapDirectory)) {
            return;
        }
        arrayList.add(mapDirectory);
        block0: for (String string : mapDirectory.lotDirs) {
            for (MapDirectory mapDirectory2 : this.realDirectories) {
                if (!mapDirectory2.name.equals(string)) continue;
                this.getDirsRecursively(mapDirectory2, arrayList);
                continue block0;
            }
        }
    }

    public int getNumberOfGroups() {
        return this.groups.size();
    }

    public ArrayList<String> getMapDirectoriesInGroup(int n) {
        if (n < 0 || n >= this.groups.size()) {
            throw new RuntimeException("invalid MapGroups index " + n);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (MapDirectory mapDirectory : this.groups.get((int)n).directories) {
            arrayList.add(mapDirectory.name);
        }
        return arrayList;
    }

    public void setWorld(int n) {
        ArrayList<String> arrayList = this.getMapDirectoriesInGroup(n);
        Object object = "";
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (String)object + arrayList.get(i);
            if (i >= arrayList.size() - 1) continue;
            object = (String)object + ";";
        }
        IsoWorld.instance.setMap((String)object);
    }

    private void handleMapDirectory(String string, String string2) {
        ArrayList<String> arrayList = this.getLotDirectories(string2);
        if (arrayList == null) {
            return;
        }
        MapDirectory mapDirectory = new MapDirectory(string, string2, arrayList);
        this.realDirectories.add(mapDirectory);
    }

    private ArrayList<String> getLotDirectories(String string) {
        File file = new File(string + "/map.info");
        if (!file.exists()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        try (FileReader fileReader = new FileReader(file.getAbsolutePath());
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (!(string2 = string2.trim()).startsWith("lots=")) continue;
                arrayList.add(string2.replace("lots=", "").trim());
            }
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
            return null;
        }
        return arrayList;
    }

    private MapGroup findGroupWithAnyOfTheseDirectories(ArrayList<MapDirectory> arrayList) {
        for (MapGroup mapGroup : this.groups) {
            if (!mapGroup.hasAnyOfTheseDirectories(arrayList)) continue;
            return mapGroup;
        }
        return null;
    }

    public ArrayList<String> getAllMapsInOrder() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (MapGroup mapGroup : this.groups) {
            for (MapDirectory mapDirectory : mapGroup.directories) {
                arrayList.add(mapDirectory.name);
            }
        }
        return arrayList;
    }

    public boolean checkMapConflicts() {
        boolean bl = false;
        for (MapGroup mapGroup : this.groups) {
            bl |= mapGroup.checkMapConflicts();
        }
        return bl;
    }

    public ArrayList<String> getMapConflicts(String string) {
        for (MapGroup mapGroup : this.groups) {
            MapDirectory mapDirectory = mapGroup.getDirectoryByName(string);
            if (mapDirectory == null) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.addAll(mapDirectory.conflicts);
            return arrayList;
        }
        return null;
    }

    private class MapDirectory {
        String name;
        String path;
        ArrayList<String> lotDirs = new ArrayList();
        ArrayList<String> conflicts = new ArrayList();

        public MapDirectory(String string, String string2) {
            this.name = string;
            this.path = string2;
        }

        public MapDirectory(String string, String string2, ArrayList<String> arrayList) {
            this.name = string;
            this.path = string2;
            this.lotDirs.addAll(arrayList);
        }

        public void getLotHeaders(ArrayList<String> arrayList) {
            File file = new File(this.path);
            if (!file.isDirectory()) {
                return;
            }
            String[] stringArray = file.list();
            if (stringArray == null) {
                return;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].endsWith(".lotheader")) continue;
                arrayList.add(stringArray[i]);
            }
        }
    }

    private class MapGroup {
        private LinkedList<MapDirectory> directories = new LinkedList();

        private MapGroup() {
        }

        void addDirectory(String string, String string2) {
            assert (!this.hasDirectory(string));
            MapDirectory mapDirectory = new MapDirectory(string, string2);
            this.directories.add(mapDirectory);
        }

        void addDirectory(String string, String string2, ArrayList<String> arrayList) {
            assert (!this.hasDirectory(string));
            MapDirectory mapDirectory = new MapDirectory(string, string2, arrayList);
            this.directories.add(mapDirectory);
        }

        void addDirectory(MapDirectory mapDirectory) {
            assert (!this.hasDirectory(mapDirectory.name));
            this.directories.add(mapDirectory);
        }

        MapDirectory getDirectoryByName(String string) {
            for (MapDirectory mapDirectory : this.directories) {
                if (!mapDirectory.name.equals(string)) continue;
                return mapDirectory;
            }
            return null;
        }

        boolean hasDirectory(String string) {
            return this.getDirectoryByName(string) != null;
        }

        boolean hasAnyOfTheseDirectories(ArrayList<MapDirectory> arrayList) {
            for (MapDirectory mapDirectory : arrayList) {
                if (!this.directories.contains(mapDirectory)) continue;
                return true;
            }
            return false;
        }

        boolean isReferencedByOtherMaps(MapDirectory mapDirectory) {
            for (MapDirectory mapDirectory2 : this.directories) {
                if (mapDirectory == mapDirectory2 || !mapDirectory2.lotDirs.contains(mapDirectory.name)) continue;
                return true;
            }
            return false;
        }

        void getDirsRecursively(MapDirectory mapDirectory, ArrayList<String> arrayList) {
            if (arrayList.contains(mapDirectory.name)) {
                return;
            }
            arrayList.add(mapDirectory.name);
            for (String string : mapDirectory.lotDirs) {
                MapDirectory mapDirectory2 = this.getDirectoryByName(string);
                if (mapDirectory2 == null) continue;
                this.getDirsRecursively(mapDirectory2, arrayList);
            }
        }

        void setPriority() {
            ArrayList<MapDirectory> arrayList = new ArrayList<MapDirectory>(this.directories);
            for (MapDirectory mapDirectory : arrayList) {
                if (this.isReferencedByOtherMaps(mapDirectory)) continue;
                ArrayList<String> arrayList2 = new ArrayList<String>();
                this.getDirsRecursively(mapDirectory, arrayList2);
                this.setPriority(arrayList2);
            }
        }

        void setPriority(List<String> list) {
            ArrayList<MapDirectory> arrayList = new ArrayList<MapDirectory>(list.size());
            for (String object : list) {
                if (!this.hasDirectory(object)) continue;
                arrayList.add(this.getDirectoryByName(object));
            }
            for (int i = 0; i < this.directories.size(); ++i) {
                MapDirectory mapDirectory = this.directories.get(i);
                if (!list.contains(mapDirectory.name)) continue;
                this.directories.set(i, (MapDirectory)arrayList.remove(0));
            }
        }

        void setOrder(ActiveMods activeMods) {
            if (!activeMods.getMapOrder().isEmpty()) {
                this.setPriority(activeMods.getMapOrder());
            }
        }

        boolean checkMapConflicts() {
            HashMap hashMap = new HashMap();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (MapDirectory object : this.directories) {
                object.conflicts.clear();
                arrayList.clear();
                object.getLotHeaders(arrayList);
                for (String string : arrayList) {
                    if (!hashMap.containsKey(string)) {
                        hashMap.put(string, new ArrayList());
                    }
                    ((ArrayList)hashMap.get(string)).add(object.name);
                }
            }
            boolean bl = false;
            for (Object object : hashMap.keySet()) {
                ArrayList arrayList2 = (ArrayList)hashMap.get(object);
                if (arrayList2.size() <= 1) continue;
                for (int i = 0; i < arrayList2.size(); ++i) {
                    MapDirectory mapDirectory = this.getDirectoryByName((String)arrayList2.get(i));
                    for (int j = 0; j < arrayList2.size(); ++j) {
                        if (i == j) continue;
                        String string = Translator.getText("UI_MapConflict", mapDirectory.name, arrayList2.get(j), object);
                        mapDirectory.conflicts.add(string);
                        bl = true;
                    }
                }
            }
            return bl;
        }
    }
}

