/*
 * Decompiled with CFR 0.152.
 */
package zombie;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.Stack;
import java.util.concurrent.ConcurrentLinkedQueue;
import zombie.GameTime;
import zombie.GameWindow;
import zombie.SandboxOptions;
import zombie.ZomboidFileSystem;
import zombie.core.Core;
import zombie.core.logger.ExceptionLogger;
import zombie.gameStates.IngameState;
import zombie.iso.IsoChunk;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoLot;
import zombie.iso.IsoMetaCell;
import zombie.iso.IsoMetaChunk;
import zombie.iso.IsoMetaGrid;
import zombie.iso.IsoWorld;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.SpriteDetails.IsoObjectType;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.MPStatistic;
import zombie.popman.ZombiePopulationManager;

public final class MapCollisionData {
    public static final MapCollisionData instance = new MapCollisionData();
    public static final byte BIT_SOLID = 1;
    public static final byte BIT_WALLN = 2;
    public static final byte BIT_WALLW = 4;
    public static final byte BIT_WATER = 8;
    public static final byte BIT_ROOM = 16;
    private static final int SQUARES_PER_CHUNK = 10;
    private static final int CHUNKS_PER_CELL = 30;
    private static final int SQUARES_PER_CELL = 300;
    private static int[] curXY = new int[2];
    public final Object renderLock = new Object();
    private final Stack<PathTask> freePathTasks = new Stack();
    private final ConcurrentLinkedQueue<PathTask> pathTaskQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<PathTask> pathResultQueue = new ConcurrentLinkedQueue();
    private final Sync sync = new Sync();
    private final byte[] squares = new byte[100];
    private final int SQUARE_UPDATE_SIZE = 9;
    private final ByteBuffer squareUpdateBuffer = ByteBuffer.allocateDirect(1024);
    private boolean bClient;
    private boolean bPaused;
    private boolean bNoSave;
    private MCDThread thread;
    private long lastUpdate;

    private static native void n_init(int var0, int var1, int var2, int var3);

    private static native void n_chunkUpdateTask(int var0, int var1, byte[] var2);

    private static native void n_squareUpdateTask(int var0, ByteBuffer var1);

    private static native int n_pathTask(int var0, int var1, int var2, int var3, int[] var4);

    private static native boolean n_hasDataForThread();

    private static native boolean n_shouldWait();

    private static native void n_update();

    private static native void n_save();

    private static native void n_stop();

    private static native void n_setGameState(String var0, boolean var1);

    private static native void n_setGameState(String var0, double var1);

    private static native void n_setGameState(String var0, float var1);

    private static native void n_setGameState(String var0, int var1);

    private static native void n_setGameState(String var0, String var1);

    private static native void n_initMetaGrid(int var0, int var1, int var2, int var3);

    private static native void n_initMetaCell(int var0, int var1, String var2);

    private static native void n_initMetaChunk(int var0, int var1, int var2, int var3, int var4);

    private static void writeToStdErr(String string) {
        System.err.println(string);
    }

    public void init(IsoMetaGrid isoMetaGrid) {
        this.bClient = GameClient.bClient;
        if (this.bClient) {
            return;
        }
        int n = isoMetaGrid.getMinX();
        int n2 = isoMetaGrid.getMinY();
        int n3 = isoMetaGrid.getWidth();
        int n4 = isoMetaGrid.getHeight();
        MapCollisionData.n_setGameState("Core.GameMode", Core.getInstance().getGameMode());
        MapCollisionData.n_setGameState("Core.GameSaveWorld", Core.GameSaveWorld);
        MapCollisionData.n_setGameState("Core.bLastStand", Core.bLastStand);
        this.bNoSave = Core.getInstance().isNoSave();
        MapCollisionData.n_setGameState("Core.noSave", this.bNoSave);
        MapCollisionData.n_setGameState("GameWindow.CacheDir", ZomboidFileSystem.instance.getCacheDir());
        MapCollisionData.n_setGameState("GameWindow.GameModeCacheDir", ZomboidFileSystem.instance.getGameModeCacheDir() + File.separator);
        MapCollisionData.n_setGameState("GameWindow.SaveDir", ZomboidFileSystem.instance.getSaveDir());
        MapCollisionData.n_setGameState("SandboxOptions.Distribution", SandboxOptions.instance.Distribution.getValue());
        MapCollisionData.n_setGameState("SandboxOptions.Zombies", SandboxOptions.instance.Zombies.getValue());
        MapCollisionData.n_setGameState("World.ZombiesDisabled", IsoWorld.getZombiesDisabled());
        this.bPaused = true;
        MapCollisionData.n_setGameState("PAUSED", true);
        MapCollisionData.n_initMetaGrid(n, n2, n3, n4);
        for (int i = n2; i < n2 + n4; ++i) {
            for (int j = n; j < n + n3; ++j) {
                IsoMetaCell isoMetaCell = isoMetaGrid.getCellData(j, i);
                MapCollisionData.n_initMetaCell(j, i, IsoLot.InfoFileNames.get("chunkdata_" + j + "_" + i + ".bin"));
                if (isoMetaCell == null) continue;
                for (int k = 0; k < 30; ++k) {
                    for (int i2 = 0; i2 < 30; ++i2) {
                        IsoMetaChunk isoMetaChunk = isoMetaCell.getChunk(i2, k);
                        if (isoMetaChunk == null) continue;
                        MapCollisionData.n_initMetaChunk(j, i, i2, k, isoMetaChunk.getUnadjustedZombieIntensity());
                    }
                }
            }
        }
        MapCollisionData.n_init(n, n2, n3, n4);
    }

    public void start() {
        if (this.bClient) {
            return;
        }
        if (this.thread != null) {
            return;
        }
        this.thread = new MCDThread();
        this.thread.setDaemon(true);
        this.thread.setName("MapCollisionDataJNI");
        if (GameServer.bServer) {
            this.thread.start();
        }
    }

    public void startGame() {
        if (GameClient.bClient) {
            return;
        }
        this.updateMain();
        ZombiePopulationManager.instance.updateMain();
        MapCollisionData.n_update();
        ZombiePopulationManager.instance.updateThread();
        this.updateMain();
        ZombiePopulationManager.instance.updateMain();
        this.thread.start();
    }

    public void updateMain() {
        if (this.bClient) {
            return;
        }
        PathTask pathTask = this.pathResultQueue.poll();
        while (pathTask != null) {
            pathTask.result.finished(pathTask.status, pathTask.curX, pathTask.curY);
            pathTask.release();
            pathTask = this.pathResultQueue.poll();
        }
        long l = System.currentTimeMillis();
        if (l - this.lastUpdate > 10000L) {
            this.lastUpdate = l;
            this.notifyThread();
        }
    }

    public boolean hasDataForThread() {
        if (this.squareUpdateBuffer.position() > 0) {
            try {
                MapCollisionData.n_squareUpdateTask(this.squareUpdateBuffer.position() / 9, this.squareUpdateBuffer);
            }
            finally {
                this.squareUpdateBuffer.clear();
            }
        }
        return MapCollisionData.n_hasDataForThread();
    }

    public void updateGameState() {
        boolean bl = Core.getInstance().isNoSave();
        if (this.bNoSave != bl) {
            this.bNoSave = bl;
            MapCollisionData.n_setGameState("Core.noSave", this.bNoSave);
        }
        boolean bl2 = GameTime.isGamePaused();
        if (GameWindow.states.current != IngameState.instance) {
            bl2 = true;
        }
        if (GameServer.bServer) {
            bl2 = IngameState.instance.Paused;
        }
        if (bl2 != this.bPaused) {
            this.bPaused = bl2;
            MapCollisionData.n_setGameState("PAUSED", this.bPaused);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyThread() {
        Object object = this.thread.notifier;
        synchronized (object) {
            this.thread.notifier.notify();
        }
    }

    public void addChunkToWorld(IsoChunk isoChunk) {
        if (this.bClient) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                IsoGridSquare isoGridSquare = isoChunk.getGridSquare(j, i, 0);
                if (isoGridSquare == null) {
                    this.squares[j + i * 10] = 1;
                    continue;
                }
                byte by = 0;
                if (this.isSolid(isoGridSquare)) {
                    by = (byte)(by | 1);
                }
                if (this.isBlockedN(isoGridSquare)) {
                    by = (byte)(by | 2);
                }
                if (this.isBlockedW(isoGridSquare)) {
                    by = (byte)(by | 4);
                }
                if (this.isWater(isoGridSquare)) {
                    by = (byte)(by | 8);
                }
                if (this.isRoom(isoGridSquare)) {
                    by = (byte)(by | 0x10);
                }
                this.squares[j + i * 10] = by;
            }
        }
        MapCollisionData.n_chunkUpdateTask(isoChunk.wx, isoChunk.wy, this.squares);
    }

    public void removeChunkFromWorld(IsoChunk isoChunk) {
        if (this.bClient) {
            return;
        }
    }

    public void squareChanged(IsoGridSquare isoGridSquare) {
        if (this.bClient) {
            return;
        }
        try {
            byte by = 0;
            if (this.isSolid(isoGridSquare)) {
                by = (byte)(by | 1);
            }
            if (this.isBlockedN(isoGridSquare)) {
                by = (byte)(by | 2);
            }
            if (this.isBlockedW(isoGridSquare)) {
                by = (byte)(by | 4);
            }
            if (this.isWater(isoGridSquare)) {
                by = (byte)(by | 8);
            }
            if (this.isRoom(isoGridSquare)) {
                by = (byte)(by | 0x10);
            }
            this.squareUpdateBuffer.putInt(isoGridSquare.x);
            this.squareUpdateBuffer.putInt(isoGridSquare.y);
            this.squareUpdateBuffer.put(by);
            if (this.squareUpdateBuffer.remaining() < 9) {
                MapCollisionData.n_squareUpdateTask(this.squareUpdateBuffer.position() / 9, this.squareUpdateBuffer);
                this.squareUpdateBuffer.clear();
            }
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        if (this.bClient) {
            return;
        }
        ZombiePopulationManager.instance.beginSaveRealZombies();
        if (!this.thread.isAlive()) {
            MapCollisionData.n_save();
            ZombiePopulationManager.instance.save();
            return;
        }
        this.thread.bSave = true;
        Object object = this.thread.notifier;
        synchronized (object) {
            this.thread.notifier.notify();
        }
        while (this.thread.bSave) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {}
        }
        ZombiePopulationManager.instance.endSaveRealZombies();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.bClient) {
            return;
        }
        this.thread.bStop = true;
        Object object = this.thread.notifier;
        synchronized (object) {
            this.thread.notifier.notify();
        }
        while (this.thread.isAlive()) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {}
        }
        MapCollisionData.n_stop();
        this.thread = null;
        this.pathTaskQueue.clear();
        this.pathResultQueue.clear();
        this.squareUpdateBuffer.clear();
    }

    private boolean isSolid(IsoGridSquare isoGridSquare) {
        boolean bl;
        boolean bl2 = bl = isoGridSquare.isSolid() || isoGridSquare.isSolidTrans();
        if (isoGridSquare.HasStairs()) {
            bl = true;
        }
        if (isoGridSquare.Is(IsoFlagType.water)) {
            bl = false;
        }
        if (isoGridSquare.Has(IsoObjectType.tree)) {
            bl = false;
        }
        return bl;
    }

    private boolean isBlockedN(IsoGridSquare isoGridSquare) {
        if (isoGridSquare.Is(IsoFlagType.HoppableN)) {
            return false;
        }
        boolean bl = isoGridSquare.Is(IsoFlagType.collideN);
        if (isoGridSquare.Has(IsoObjectType.doorFrN)) {
            bl = true;
        }
        if (isoGridSquare.getProperties().Is(IsoFlagType.DoorWallN)) {
            bl = true;
        }
        if (isoGridSquare.Has(IsoObjectType.windowFN)) {
            bl = true;
        }
        if (isoGridSquare.Is(IsoFlagType.windowN)) {
            bl = true;
        }
        if (isoGridSquare.getProperties().Is(IsoFlagType.WindowN)) {
            bl = true;
        }
        return bl;
    }

    private boolean isBlockedW(IsoGridSquare isoGridSquare) {
        if (isoGridSquare.Is(IsoFlagType.HoppableW)) {
            return false;
        }
        boolean bl = isoGridSquare.Is(IsoFlagType.collideW);
        if (isoGridSquare.Has(IsoObjectType.doorFrW)) {
            bl = true;
        }
        if (isoGridSquare.getProperties().Is(IsoFlagType.DoorWallW)) {
            bl = true;
        }
        if (isoGridSquare.Has(IsoObjectType.windowFW)) {
            bl = true;
        }
        if (isoGridSquare.Is(IsoFlagType.windowW)) {
            bl = true;
        }
        if (isoGridSquare.getProperties().Is(IsoFlagType.WindowW)) {
            bl = true;
        }
        return bl;
    }

    private boolean isWater(IsoGridSquare isoGridSquare) {
        boolean bl = isoGridSquare.Is(IsoFlagType.water);
        return bl;
    }

    private boolean isRoom(IsoGridSquare isoGridSquare) {
        return isoGridSquare.getRoom() != null;
    }

    static class Sync {
        private int fps = 10;
        private long period = 1000000000L / (long)this.fps;
        private long excess;
        private long beforeTime = System.nanoTime();
        private long overSleepTime = 0L;

        Sync() {
        }

        void begin() {
            this.beforeTime = System.nanoTime();
            this.overSleepTime = 0L;
        }

        void startFrame() {
            this.excess = 0L;
        }

        void endFrame() {
            long l = System.nanoTime();
            long l2 = l - this.beforeTime;
            long l3 = this.period - l2 - this.overSleepTime;
            if (l3 > 0L) {
                try {
                    Thread.sleep(l3 / 1000000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.overSleepTime = System.nanoTime() - l - l3;
            } else {
                this.excess -= l3;
                this.overSleepTime = 0L;
            }
            this.beforeTime = System.nanoTime();
        }
    }

    private final class MCDThread
    extends Thread {
        public final Object notifier = new Object();
        public boolean bStop;
        public volatile boolean bSave;
        public volatile boolean bWaiting;
        public Queue<PathTask> pathTasks = new ArrayDeque<PathTask>();

        private MCDThread() {
        }

        @Override
        public void run() {
            while (!this.bStop) {
                try {
                    this.runInner();
                }
                catch (Exception exception) {
                    ExceptionLogger.logException(exception);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runInner() {
            MPStatistic.getInstance().MapCollisionThread.Start();
            MapCollisionData.this.sync.startFrame();
            Object object = MapCollisionData.this.renderLock;
            synchronized (object) {
                PathTask pathTask = MapCollisionData.this.pathTaskQueue.poll();
                while (pathTask != null) {
                    pathTask.execute();
                    pathTask.release();
                    pathTask = MapCollisionData.this.pathTaskQueue.poll();
                }
                if (this.bSave) {
                    MapCollisionData.n_save();
                    ZombiePopulationManager.instance.save();
                    this.bSave = false;
                }
                MapCollisionData.n_update();
                ZombiePopulationManager.instance.updateThread();
            }
            MapCollisionData.this.sync.endFrame();
            MPStatistic.getInstance().MapCollisionThread.End();
            while (this.shouldWait()) {
                object = this.notifier;
                synchronized (object) {
                    this.bWaiting = true;
                    try {
                        this.notifier.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            this.bWaiting = false;
        }

        private boolean shouldWait() {
            if (this.bStop || this.bSave) {
                return false;
            }
            if (!MapCollisionData.n_shouldWait()) {
                return false;
            }
            if (!ZombiePopulationManager.instance.shouldWait()) {
                return false;
            }
            return MapCollisionData.this.pathTaskQueue.isEmpty() && this.pathTasks.isEmpty();
        }
    }

    private final class PathTask {
        public int startX;
        public int startY;
        public int endX;
        public int endY;
        public int curX;
        public int curY;
        public int status;
        public IPathResult result;
        public boolean myThread;

        private PathTask() {
        }

        public void init(int n, int n2, int n3, int n4, IPathResult iPathResult) {
            this.startX = n;
            this.startY = n2;
            this.endX = n3;
            this.endY = n4;
            this.status = 0;
            this.result = iPathResult;
        }

        public void execute() {
            this.status = MapCollisionData.n_pathTask(this.startX, this.startY, this.endX, this.endY, curXY);
            this.curX = curXY[0];
            this.curY = curXY[1];
            if (this.myThread) {
                this.result.finished(this.status, this.curX, this.curY);
            } else {
                MapCollisionData.this.pathResultQueue.add(this);
            }
        }

        public void release() {
            MapCollisionData.this.freePathTasks.push(this);
        }
    }

    public static interface IPathResult {
        public void finished(int var1, int var2, int var3);
    }
}

