/*
 * Decompiled with CFR 0.152.
 */
package zombie.Lua;

import gnu.trove.list.array.TShortArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import se.krka.kahlua.vm.KahluaTable;
import se.krka.kahlua.vm.KahluaTableIterator;
import se.krka.kahlua.vm.LuaClosure;
import se.krka.kahlua.vm.Prototype;
import zombie.Lua.LuaManager;
import zombie.core.Core;
import zombie.core.logger.ExceptionLogger;
import zombie.iso.IsoChunk;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.objects.IsoWorldInventoryObject;
import zombie.network.GameServer;
import zombie.network.ServerMap;

public final class MapObjects {
    private static final HashMap<String, Callback> onNew = new HashMap();
    private static final HashMap<String, Callback> onLoad = new HashMap();
    private static final ArrayList<IsoObject> tempObjects = new ArrayList();
    private static final Object[] params = new Object[1];

    private static Callback getOnNew(String string) {
        Callback callback = onNew.get(string);
        if (callback == null) {
            callback = new Callback(string);
            onNew.put(string, callback);
        }
        return callback;
    }

    public static void OnNewWithSprite(String string, LuaClosure luaClosure, int n) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("invalid sprite name");
        }
        if (luaClosure == null) {
            throw new NullPointerException("function is null");
        }
        Callback callback = MapObjects.getOnNew(string);
        for (int i = 0; i < callback.functions.size(); ++i) {
            if (callback.priority.get(i) < n) {
                callback.functions.add(i, luaClosure);
                callback.priority.insert(i, (short)n);
                return;
            }
            if (callback.priority.get(i) != n) continue;
            callback.functions.set(i, luaClosure);
            callback.priority.set(i, (short)n);
            return;
        }
        callback.functions.add(luaClosure);
        callback.priority.add((short)n);
    }

    public static void OnNewWithSprite(KahluaTable kahluaTable, LuaClosure luaClosure, int n) {
        if (kahluaTable == null || kahluaTable.isEmpty()) {
            throw new IllegalArgumentException("invalid sprite-name table");
        }
        if (luaClosure == null) {
            throw new NullPointerException("function is null");
        }
        KahluaTableIterator kahluaTableIterator = kahluaTable.iterator();
        while (kahluaTableIterator.advance()) {
            Object object = kahluaTableIterator.getValue();
            if (!(object instanceof String)) {
                throw new IllegalArgumentException("expected string but got \"" + object + "\"");
            }
            MapObjects.OnNewWithSprite((String)object, luaClosure, n);
        }
    }

    public static void newGridSquare(IsoGridSquare isoGridSquare) {
        int n;
        if (isoGridSquare == null || isoGridSquare.getObjects().isEmpty()) {
            return;
        }
        tempObjects.clear();
        for (n = 0; n < isoGridSquare.getObjects().size(); ++n) {
            tempObjects.add(isoGridSquare.getObjects().get(n));
        }
        block3: for (n = 0; n < tempObjects.size(); ++n) {
            Callback callback;
            String string;
            IsoObject isoObject = tempObjects.get(n);
            if (!isoGridSquare.getObjects().contains(isoObject) || isoObject instanceof IsoWorldInventoryObject || isoObject == null || isoObject.sprite == null) continue;
            String string2 = string = isoObject.sprite.name == null ? isoObject.spriteName : isoObject.sprite.name;
            if (string == null || string.isEmpty() || (callback = onNew.get(string)) == null) continue;
            MapObjects.params[0] = isoObject;
            for (int i = 0; i < callback.functions.size(); ++i) {
                try {
                    LuaManager.caller.protectedCallVoid(LuaManager.thread, (Object)callback.functions.get(i), params);
                }
                catch (Throwable throwable) {
                    ExceptionLogger.logException(throwable);
                }
                String string3 = string = isoObject.sprite == null || isoObject.sprite.name == null ? isoObject.spriteName : isoObject.sprite.name;
                if (!isoGridSquare.getObjects().contains(isoObject) || isoObject.sprite == null || !callback.spriteName.equals(string)) continue block3;
            }
        }
    }

    private static Callback getOnLoad(String string) {
        Callback callback = onLoad.get(string);
        if (callback == null) {
            callback = new Callback(string);
            onLoad.put(string, callback);
        }
        return callback;
    }

    public static void OnLoadWithSprite(String string, LuaClosure luaClosure, int n) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("invalid sprite name");
        }
        if (luaClosure == null) {
            throw new NullPointerException("function is null");
        }
        Callback callback = MapObjects.getOnLoad(string);
        for (int i = 0; i < callback.functions.size(); ++i) {
            if (callback.priority.get(i) < n) {
                callback.functions.add(i, luaClosure);
                callback.priority.insert(i, (short)n);
                return;
            }
            if (callback.priority.get(i) != n) continue;
            callback.functions.set(i, luaClosure);
            callback.priority.set(i, (short)n);
            return;
        }
        callback.functions.add(luaClosure);
        callback.priority.add((short)n);
    }

    public static void OnLoadWithSprite(KahluaTable kahluaTable, LuaClosure luaClosure, int n) {
        if (kahluaTable == null || kahluaTable.isEmpty()) {
            throw new IllegalArgumentException("invalid sprite-name table");
        }
        if (luaClosure == null) {
            throw new NullPointerException("function is null");
        }
        KahluaTableIterator kahluaTableIterator = kahluaTable.iterator();
        while (kahluaTableIterator.advance()) {
            Object object = kahluaTableIterator.getValue();
            if (!(object instanceof String)) {
                throw new IllegalArgumentException("expected string but got \"" + object + "\"");
            }
            MapObjects.OnLoadWithSprite((String)object, luaClosure, n);
        }
    }

    public static void loadGridSquare(IsoGridSquare isoGridSquare) {
        int n;
        if (isoGridSquare == null || isoGridSquare.getObjects().isEmpty()) {
            return;
        }
        tempObjects.clear();
        for (n = 0; n < isoGridSquare.getObjects().size(); ++n) {
            tempObjects.add(isoGridSquare.getObjects().get(n));
        }
        block3: for (n = 0; n < tempObjects.size(); ++n) {
            Callback callback;
            String string;
            IsoObject isoObject = tempObjects.get(n);
            if (!isoGridSquare.getObjects().contains(isoObject) || isoObject instanceof IsoWorldInventoryObject || isoObject == null || isoObject.sprite == null) continue;
            String string2 = string = isoObject.sprite.name == null ? isoObject.spriteName : isoObject.sprite.name;
            if (string == null || string.isEmpty() || (callback = onLoad.get(string)) == null) continue;
            MapObjects.params[0] = isoObject;
            for (int i = 0; i < callback.functions.size(); ++i) {
                try {
                    LuaManager.caller.protectedCallVoid(LuaManager.thread, (Object)callback.functions.get(i), params);
                }
                catch (Throwable throwable) {
                    ExceptionLogger.logException(throwable);
                }
                String string3 = string = isoObject.sprite == null || isoObject.sprite.name == null ? isoObject.spriteName : isoObject.sprite.name;
                if (!isoGridSquare.getObjects().contains(isoObject) || isoObject.sprite == null || !callback.spriteName.equals(string)) continue block3;
            }
        }
    }

    public static void debugNewSquare(int n, int n2, int n3) {
        if (!Core.bDebug) {
            return;
        }
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n, n2, n3);
        if (isoGridSquare == null) {
            return;
        }
        MapObjects.newGridSquare(isoGridSquare);
    }

    public static void debugLoadSquare(int n, int n2, int n3) {
        if (!Core.bDebug) {
            return;
        }
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n, n2, n3);
        if (isoGridSquare == null) {
            return;
        }
        MapObjects.loadGridSquare(isoGridSquare);
    }

    public static void debugLoadChunk(int n, int n2) {
        IsoChunk isoChunk;
        if (!Core.bDebug) {
            return;
        }
        IsoChunk isoChunk2 = isoChunk = GameServer.bServer ? ServerMap.instance.getChunk(n, n2) : IsoWorld.instance.CurrentCell.getChunk(n, n2);
        if (isoChunk == null) {
            return;
        }
        for (int i = 0; i <= isoChunk.maxLevel; ++i) {
            for (int j = 0; j < 10; ++j) {
                for (int k = 0; k < 10; ++k) {
                    IsoGridSquare isoGridSquare = isoChunk.getGridSquare(j, k, i);
                    if (isoGridSquare == null || isoGridSquare.getObjects().isEmpty()) continue;
                    MapObjects.loadGridSquare(isoGridSquare);
                }
            }
        }
    }

    public static void reroute(Prototype prototype, LuaClosure luaClosure) {
        for (Callback callback : onNew.values()) {
            for (int i = 0; i < callback.functions.size(); ++i) {
                LuaClosure luaClosure2 = callback.functions.get(i);
                if (!luaClosure2.prototype.filename.equals(prototype.filename) || !luaClosure2.prototype.name.equals(prototype.name)) continue;
                callback.functions.set(i, luaClosure);
            }
        }
    }

    public static void Reset() {
        onNew.clear();
        onLoad.clear();
    }

    private static final class Callback {
        final String spriteName;
        final ArrayList<LuaClosure> functions = new ArrayList();
        final TShortArrayList priority = new TShortArrayList();

        Callback(String string) {
            this.spriteName = string;
        }
    }
}

