/*
 * Decompiled with CFR 0.152.
 */
package zombie.Lua;

import java.util.ArrayList;
import se.krka.kahlua.integration.LuaCaller;
import se.krka.kahlua.luaj.compiler.LuaCompiler;
import se.krka.kahlua.vm.JavaFunction;
import se.krka.kahlua.vm.KahluaTable;
import se.krka.kahlua.vm.LuaCallFrame;
import se.krka.kahlua.vm.LuaClosure;
import se.krka.kahlua.vm.Platform;
import zombie.Lua.LuaManager;
import zombie.core.logger.ExceptionLogger;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;

public final class Event {
    public static final int ADD = 0;
    public static final int NUM_FUNCTIONS = 1;
    private final Add add;
    private final Remove remove;
    public final ArrayList<LuaClosure> callbacks = new ArrayList();
    public String name;
    private int index = 0;

    public boolean trigger(KahluaTable kahluaTable, LuaCaller luaCaller, Object[] objectArray) {
        if (this.callbacks.isEmpty()) {
            return false;
        }
        if (DebugOptions.instance.Checks.SlowLuaEvents.getValue()) {
            for (int i = 0; i < this.callbacks.size(); ++i) {
                try {
                    LuaClosure luaClosure = this.callbacks.get(i);
                    long l = System.nanoTime();
                    luaCaller.protectedCallVoid(LuaManager.thread, (Object)luaClosure, objectArray);
                    double d = (double)(System.nanoTime() - l) / 1000000.0;
                    if (!(d > 250.0)) continue;
                    DebugLog.Lua.warn("SLOW Lua event callback %s %s %dms", luaClosure.prototype.file, luaClosure, (int)d);
                    continue;
                }
                catch (Exception exception) {
                    ExceptionLogger.logException(exception);
                }
            }
            return true;
        }
        for (int i = 0; i < this.callbacks.size(); ++i) {
            try {
                luaCaller.protectedCallVoid(LuaManager.thread, (Object)this.callbacks.get(i), objectArray);
                continue;
            }
            catch (Exception exception) {
                ExceptionLogger.logException(exception);
            }
        }
        return true;
    }

    public Event(String string, int n) {
        this.index = n;
        this.name = string;
        this.add = new Add(this);
        this.remove = new Remove(this);
    }

    public void register(Platform platform, KahluaTable kahluaTable) {
        KahluaTable kahluaTable2 = platform.newTable();
        kahluaTable2.rawset("Add", (Object)this.add);
        kahluaTable2.rawset("Remove", (Object)this.remove);
        kahluaTable.rawset(this.name, (Object)kahluaTable2);
    }

    public static final class Add
    implements JavaFunction {
        Event e;

        public Add(Event event) {
            this.e = event;
        }

        @Override
        public int call(LuaCallFrame luaCallFrame, int n) {
            if (LuaCompiler.rewriteEvents) {
                return 0;
            }
            Object object = luaCallFrame.get(0);
            if (this.e.name.contains("CreateUI")) {
                boolean bl = false;
            }
            if (object instanceof LuaClosure) {
                LuaClosure luaClosure = (LuaClosure)object;
                this.e.callbacks.add(luaClosure);
            }
            return 0;
        }
    }

    public static final class Remove
    implements JavaFunction {
        Event e;

        public Remove(Event event) {
            this.e = event;
        }

        @Override
        public int call(LuaCallFrame luaCallFrame, int n) {
            if (LuaCompiler.rewriteEvents) {
                return 0;
            }
            Object object = luaCallFrame.get(0);
            if (object instanceof LuaClosure) {
                LuaClosure luaClosure = (LuaClosure)object;
                this.e.callbacks.remove(luaClosure);
            }
            return 0;
        }
    }
}

