/*
 * Decompiled with CFR 0.152.
 */
package zombie;

import java.util.ArrayList;
import zombie.GameTime;
import zombie.SandboxOptions;
import zombie.characters.IsoPlayer;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.inventory.CompressIdenticalItems;
import zombie.inventory.InventoryItem;
import zombie.inventory.ItemContainer;
import zombie.inventory.ItemPickerJava;
import zombie.iso.BuildingDef;
import zombie.iso.IsoChunk;
import zombie.iso.IsoChunkMap;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMetaGrid;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.objects.IsoCompost;
import zombie.iso.objects.IsoDeadBody;
import zombie.iso.objects.IsoThumpable;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.PacketTypes;
import zombie.network.ServerMap;
import zombie.network.ServerOptions;

public final class LootRespawn {
    private static int LastRespawnHour = -1;
    private static final ArrayList<InventoryItem> existingItems = new ArrayList();
    private static final ArrayList<InventoryItem> newItems = new ArrayList();

    public static void update() {
        if (GameClient.bClient) {
            return;
        }
        int n = LootRespawn.getRespawnInterval();
        if (n <= 0) {
            return;
        }
        int n2 = 7 + (int)(GameTime.getInstance().getWorldAgeHours() / (double)n) * n;
        if (LastRespawnHour >= n2) {
            return;
        }
        LastRespawnHour = n2;
        if (GameServer.bServer) {
            for (int i = 0; i < ServerMap.instance.LoadedCells.size(); ++i) {
                ServerMap.ServerCell serverCell = ServerMap.instance.LoadedCells.get(i);
                if (!serverCell.bLoaded) continue;
                for (int j = 0; j < 5; ++j) {
                    for (int k = 0; k < 5; ++k) {
                        IsoChunk isoChunk = serverCell.chunks[k][j];
                        LootRespawn.checkChunk(isoChunk);
                    }
                }
            }
        } else {
            for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                IsoChunkMap isoChunkMap = IsoWorld.instance.CurrentCell.ChunkMap[i];
                if (isoChunkMap.ignore) continue;
                for (int j = 0; j < IsoChunkMap.ChunkGridWidth; ++j) {
                    for (int k = 0; k < IsoChunkMap.ChunkGridWidth; ++k) {
                        IsoChunk isoChunk = isoChunkMap.getChunk(k, j);
                        LootRespawn.checkChunk(isoChunk);
                    }
                }
            }
        }
    }

    public static void Reset() {
        LastRespawnHour = -1;
    }

    public static void chunkLoaded(IsoChunk isoChunk) {
        if (GameClient.bClient) {
            return;
        }
        LootRespawn.checkChunk(isoChunk);
    }

    private static void checkChunk(IsoChunk isoChunk) {
        if (isoChunk == null) {
            return;
        }
        int n = LootRespawn.getRespawnInterval();
        if (n <= 0) {
            return;
        }
        if (GameTime.getInstance().getWorldAgeHours() < (double)n) {
            return;
        }
        int n2 = 7 + (int)(GameTime.getInstance().getWorldAgeHours() / (double)n) * n;
        if (isoChunk.lootRespawnHour > n2) {
            isoChunk.lootRespawnHour = n2;
        }
        if (isoChunk.lootRespawnHour >= n2) {
            return;
        }
        isoChunk.lootRespawnHour = n2;
        LootRespawn.respawnInChunk(isoChunk);
    }

    private static int getRespawnInterval() {
        if (GameServer.bServer) {
            return ServerOptions.instance.HoursForLootRespawn.getValue();
        }
        if (!GameClient.bClient) {
            int n = SandboxOptions.instance.LootRespawn.getValue();
            if (n == 1) {
                return 0;
            }
            if (n == 2) {
                return 24;
            }
            if (n == 3) {
                return 168;
            }
            if (n == 4) {
                return 720;
            }
            if (n == 5) {
                return 1440;
            }
        }
        return 0;
    }

    private static void respawnInChunk(IsoChunk isoChunk) {
        boolean bl = GameServer.bServer && ServerOptions.instance.ConstructionPreventsLootRespawn.getValue();
        int n = SandboxOptions.instance.SeenHoursPreventLootRespawn.getValue();
        double d = GameTime.getInstance().getWorldAgeHours();
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                BuildingDef buildingDef;
                IsoMetaGrid.Zone zone;
                IsoGridSquare isoGridSquare = isoChunk.getGridSquare(j, i, 0);
                IsoMetaGrid.Zone zone2 = zone = isoGridSquare == null ? null : isoGridSquare.getZone();
                if (zone == null || !"TownZone".equals(zone.getType()) && !"TownZones".equals(zone.getType()) && !"TrailerPark".equals(zone.getType()) || bl && zone.haveConstruction || n > 0 && zone.getHoursSinceLastSeen() <= (float)n) continue;
                if (isoGridSquare.getBuilding() != null && (buildingDef = isoGridSquare.getBuilding().getDef()) != null) {
                    if ((double)buildingDef.lootRespawnHour > d) {
                        buildingDef.lootRespawnHour = 0;
                    }
                    if (buildingDef.lootRespawnHour < isoChunk.lootRespawnHour) {
                        buildingDef.setKeySpawned(0);
                        buildingDef.lootRespawnHour = isoChunk.lootRespawnHour;
                    }
                }
                for (int k = 0; k < 8; ++k) {
                    isoGridSquare = isoChunk.getGridSquare(j, i, k);
                    if (isoGridSquare == null) continue;
                    int n2 = isoGridSquare.getObjects().size();
                    IsoObject[] isoObjectArray = isoGridSquare.getObjects().getElements();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        IsoObject isoObject = isoObjectArray[i2];
                        if (isoObject instanceof IsoDeadBody || isoObject instanceof IsoThumpable || isoObject instanceof IsoCompost) continue;
                        for (int i3 = 0; i3 < isoObject.getContainerCount(); ++i3) {
                            ItemContainer itemContainer = isoObject.getContainerByIndex(i3);
                            if (!itemContainer.bExplored || !itemContainer.isHasBeenLooted()) continue;
                            LootRespawn.respawnInContainer(isoObject, itemContainer);
                        }
                    }
                }
            }
        }
    }

    private static void respawnInContainer(IsoObject isoObject, ItemContainer itemContainer) {
        Object object;
        int n;
        if (itemContainer == null || itemContainer.getItems() == null) {
            return;
        }
        int n2 = itemContainer.getItems().size();
        int n3 = 5;
        if (GameServer.bServer) {
            n3 = ServerOptions.instance.MaxItemsForLootRespawn.getValue();
        }
        if (n2 >= n3) {
            return;
        }
        existingItems.clear();
        existingItems.addAll(itemContainer.getItems());
        ItemPickerJava.fillContainer(itemContainer, null);
        ArrayList<InventoryItem> arrayList = itemContainer.getItems();
        if (arrayList == null || n2 == arrayList.size()) {
            return;
        }
        itemContainer.setHasBeenLooted(false);
        newItems.clear();
        for (n = 0; n < arrayList.size(); ++n) {
            object = arrayList.get(n);
            if (existingItems.contains(object)) continue;
            newItems.add((InventoryItem)object);
            ((InventoryItem)object).setAge(0.0f);
        }
        ItemPickerJava.updateOverlaySprite(isoObject);
        if (GameServer.bServer) {
            for (n = 0; n < GameServer.udpEngine.connections.size(); ++n) {
                object = GameServer.udpEngine.connections.get(n);
                if (!((UdpConnection)object).RelevantTo(isoObject.square.x, isoObject.square.y)) continue;
                ByteBufferWriter byteBufferWriter = ((UdpConnection)object).startPacket();
                PacketTypes.PacketType.AddInventoryItemToContainer.doPacket(byteBufferWriter);
                byteBufferWriter.putShort((short)2);
                byteBufferWriter.putInt((int)isoObject.getX());
                byteBufferWriter.putInt((int)isoObject.getY());
                byteBufferWriter.putInt((int)isoObject.getZ());
                byteBufferWriter.putByte((byte)isoObject.getObjectIndex());
                byteBufferWriter.putByte((byte)isoObject.getContainerIndex(itemContainer));
                try {
                    CompressIdenticalItems.save(byteBufferWriter.bb, newItems, null);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                PacketTypes.PacketType.AddInventoryItemToContainer.send((UdpConnection)object);
            }
        }
    }
}

