/*
 * Decompiled with CFR 0.152.
 */
package zombie;

import fmod.fmod.FMODManager;
import fmod.fmod.FMODSoundBank;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjglx.LWJGLException;
import org.lwjglx.input.Controller;
import org.lwjglx.opengl.Display;
import org.lwjglx.opengl.DisplayMode;
import org.lwjglx.opengl.OpenGLException;
import zombie.AmbientStreamManager;
import zombie.DebugFileWatcher;
import zombie.DummyAmbientStreamManager;
import zombie.DummySoundManager;
import zombie.FPSTracking;
import zombie.GameProfiler;
import zombie.GameTime;
import zombie.Lua.LuaEventManager;
import zombie.Lua.LuaManager;
import zombie.MapCollisionData;
import zombie.SandboxOptions;
import zombie.SoundManager;
import zombie.ZombieSpawnRecorder;
import zombie.ZomboidFileSystem;
import zombie.ZomboidGlobals;
import zombie.asset.AssetManagers;
import zombie.audio.BaseSoundBank;
import zombie.audio.DummySoundBank;
import zombie.characters.IsoPlayer;
import zombie.characters.professions.ProfessionFactory;
import zombie.characters.skills.CustomPerks;
import zombie.characters.skills.PerkFactory;
import zombie.characters.traits.TraitFactory;
import zombie.core.Core;
import zombie.core.Languages;
import zombie.core.PerformanceSettings;
import zombie.core.Rand;
import zombie.core.SpriteRenderer;
import zombie.core.ThreadGroups;
import zombie.core.Translator;
import zombie.core.input.Input;
import zombie.core.logger.ExceptionLogger;
import zombie.core.logger.ZipLogs;
import zombie.core.math.PZMath;
import zombie.core.opengl.RenderThread;
import zombie.core.particle.MuzzleFlash;
import zombie.core.physics.Bullet;
import zombie.core.profiling.PerformanceProfileFrameProbe;
import zombie.core.profiling.PerformanceProfileProbe;
import zombie.core.raknet.RakNetPeerInterface;
import zombie.core.raknet.VoiceManager;
import zombie.core.skinnedmodel.ModelManager;
import zombie.core.skinnedmodel.population.BeardStyles;
import zombie.core.skinnedmodel.population.ClothingDecals;
import zombie.core.skinnedmodel.population.HairStyles;
import zombie.core.skinnedmodel.population.OutfitManager;
import zombie.core.textures.Texture;
import zombie.core.textures.TextureID;
import zombie.core.textures.TexturePackPage;
import zombie.core.znet.ServerBrowser;
import zombie.core.znet.SteamFriends;
import zombie.core.znet.SteamUtils;
import zombie.core.znet.SteamWorkshop;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.debug.LineDrawer;
import zombie.fileSystem.FileSystem;
import zombie.fileSystem.FileSystemImpl;
import zombie.gameStates.GameLoadingState;
import zombie.gameStates.GameStateMachine;
import zombie.gameStates.IngameState;
import zombie.gameStates.MainScreenState;
import zombie.gameStates.TISLogoState;
import zombie.gameStates.TermsOfServiceState;
import zombie.globalObjects.SGlobalObjects;
import zombie.input.GameKeyboard;
import zombie.input.JoypadManager;
import zombie.input.Mouse;
import zombie.inventory.types.MapItem;
import zombie.iso.IsoCamera;
import zombie.iso.IsoObjectPicker;
import zombie.iso.IsoWorld;
import zombie.iso.LightingJNI;
import zombie.iso.LightingThread;
import zombie.iso.SliceY;
import zombie.iso.WorldStreamer;
import zombie.network.CoopMaster;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.popman.ZombiePopulationManager;
import zombie.radio.ZomboidRadio;
import zombie.sandbox.CustomSandboxOptions;
import zombie.savefile.ClientPlayerDB;
import zombie.savefile.PlayerDB;
import zombie.savefile.SavefileThumbnail;
import zombie.scripting.ScriptManager;
import zombie.spnetwork.SinglePlayerClient;
import zombie.spnetwork.SinglePlayerServer;
import zombie.ui.TextManager;
import zombie.ui.UIDebugConsole;
import zombie.ui.UIManager;
import zombie.util.PZSQLUtils;
import zombie.util.PublicServerUtil;
import zombie.vehicles.Clipper;
import zombie.vehicles.PolygonalMap2;
import zombie.world.moddata.GlobalModData;
import zombie.worldMap.WorldMapJNI;
import zombie.worldMap.WorldMapVisited;

public final class GameWindow {
    private static final String GAME_TITLE = "Project Zomboid";
    private static final FPSTracking s_fpsTracking = new FPSTracking();
    private static final ThreadLocal<StringUTF> stringUTF = ThreadLocal.withInitial(StringUTF::new);
    public static final Input GameInput = new Input();
    public static boolean DEBUG_SAVE = false;
    public static boolean OkToSaveOnExit = false;
    public static String lastP = null;
    public static GameStateMachine states = new GameStateMachine();
    public static boolean bServerDisconnected;
    public static boolean bLoadedAsClient;
    public static String kickReason;
    public static boolean DrawReloadingLua;
    public static JoypadManager.Joypad ActivatedJoyPad;
    public static String version;
    public static volatile boolean closeRequested;
    public static float averageFPS;
    private static boolean doRenderEvent;
    public static boolean bLuaDebuggerKeyDown;
    public static FileSystem fileSystem;
    public static AssetManagers assetManagers;
    public static boolean bGameThreadExited;
    public static Thread GameThread;
    public static final ArrayList<TexturePack> texturePacks;
    public static final FileSystem.TexturePackTextures texturePackTextures;

    private static void initShared() throws Exception {
        String string = ZomboidFileSystem.instance.getCacheDir() + File.separator;
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        TexturePackPage.bIgnoreWorldItemTextures = true;
        int n = 2;
        GameWindow.LoadTexturePack("UI", n);
        GameWindow.LoadTexturePack("UI2", n);
        GameWindow.LoadTexturePack("IconsMoveables", n);
        GameWindow.LoadTexturePack("RadioIcons", n);
        GameWindow.LoadTexturePack("ApComUI", n);
        GameWindow.LoadTexturePack("Mechanics", n);
        GameWindow.LoadTexturePack("WeatherFx", n);
        GameWindow.setTexturePackLookup();
        PerkFactory.init();
        CustomPerks.instance.init();
        GameWindow.DoLoadingText(Translator.getText("UI_Loading_Scripts"));
        ScriptManager.instance.Load();
        GameWindow.DoLoadingText(Translator.getText("UI_Loading_Clothing"));
        ClothingDecals.init();
        BeardStyles.init();
        HairStyles.init();
        OutfitManager.init();
        GameWindow.DoLoadingText("");
        TraitFactory.init();
        ProfessionFactory.init();
        Rand.init();
        TexturePackPage.bIgnoreWorldItemTextures = false;
        TextureID.bUseCompression = TextureID.bUseCompressionOption;
        MuzzleFlash.init();
        Mouse.initCustomCursor();
        if (!Core.bDebug) {
            GameWindow.states.States.add(new TISLogoState());
        }
        GameWindow.states.States.add(new TermsOfServiceState());
        GameWindow.states.States.add(new MainScreenState());
        if (!Core.bDebug) {
            GameWindow.states.LoopToState = 1;
        }
        GameInput.initControllers();
        if (Core.getInstance().isDefaultOptions() && SteamUtils.isSteamModeEnabled() && SteamUtils.isRunningOnSteamDeck()) {
            Core.getInstance().setOptionActiveController(0, true);
        }
        int n2 = GameInput.getControllerCount();
        DebugLog.Input.println("----------------------------------------------");
        DebugLog.Input.println("--    Information about controllers     ");
        DebugLog.Input.println("----------------------------------------------");
        for (int i = 0; i < n2; ++i) {
            String string2;
            int n3;
            Controller controller = GameInput.getController(i);
            if (controller == null) continue;
            DebugLog.Input.println("----------------------------------------------");
            DebugLog.Input.println("--  Joypad: " + controller.getGamepadName());
            DebugLog.Input.println("----------------------------------------------");
            int n4 = controller.getAxisCount();
            if (n4 > 1) {
                DebugLog.Input.println("----------------------------------------------");
                DebugLog.Input.println("--    Axis definitions for controller " + i);
                DebugLog.Input.println("----------------------------------------------");
                for (n3 = 0; n3 < n4; ++n3) {
                    string2 = controller.getAxisName(n3);
                    DebugLog.Input.println("Axis: " + string2);
                }
            }
            if ((n4 = controller.getButtonCount()) <= 1) continue;
            DebugLog.Input.println("----------------------------------------------");
            DebugLog.Input.println("--    Button definitions for controller " + i);
            DebugLog.Input.println("----------------------------------------------");
            for (n3 = 0; n3 < n4; ++n3) {
                string2 = controller.getButtonName(n3);
                DebugLog.Input.println("Button: " + string2);
            }
        }
    }

    private static void logic() {
        if (GameClient.bClient) {
            try {
                GameClient.instance.update();
            }
            catch (Exception exception) {
                ExceptionLogger.logException(exception);
            }
        }
        try {
            SinglePlayerServer.update();
            SinglePlayerClient.update();
        }
        catch (Throwable throwable) {
            ExceptionLogger.logException(throwable);
        }
        SteamUtils.runLoop();
        Mouse.update();
        GameKeyboard.update();
        GameInput.updateGameThread();
        if (CoopMaster.instance != null) {
            CoopMaster.instance.update();
        }
        if (IsoPlayer.players[0] != null) {
            IsoPlayer.setInstance(IsoPlayer.players[0]);
            IsoCamera.CamCharacter = IsoPlayer.players[0];
        }
        UIManager.update();
        VoiceManager.instance.update();
        LineDrawer.clear();
        if (JoypadManager.instance.isAPressed(-1)) {
            for (int i = 0; i < JoypadManager.instance.JoypadList.size(); ++i) {
                JoypadManager.Joypad joypad = JoypadManager.instance.JoypadList.get(i);
                if (!joypad.isAPressed()) continue;
                if (ActivatedJoyPad == null) {
                    ActivatedJoyPad = joypad;
                }
                if (IsoPlayer.getInstance() != null) {
                    LuaEventManager.triggerEvent("OnJoypadActivate", joypad.getID());
                    break;
                }
                LuaEventManager.triggerEvent("OnJoypadActivateUI", joypad.getID());
                break;
            }
        }
        SoundManager.instance.Update();
        boolean bl = true;
        if (GameTime.isGamePaused()) {
            bl = false;
        }
        MapCollisionData.instance.updateGameState();
        Mouse.setCursorVisible(true);
        if (bl) {
            states.update();
        } else {
            IsoCamera.updateAll();
            if (IngameState.instance != null && (GameWindow.states.current == IngameState.instance || GameWindow.states.States.contains(IngameState.instance))) {
                LuaEventManager.triggerEvent("OnTickEvenPaused", 0.0);
            }
        }
        UIManager.resize();
        fileSystem.updateAsyncTransactions();
        if (GameKeyboard.isKeyPressed(Core.getInstance().getKey("Take screenshot"))) {
            Core.getInstance().TakeFullScreenshot(null);
        }
    }

    public static void render() {
        ++IsoCamera.frameState.frameCount;
        GameWindow.renderInternal();
    }

    protected static void renderInternal() {
        if (!PerformanceSettings.LightingThread && LightingJNI.init && !LightingJNI.WaitingForMain()) {
            LightingJNI.DoLightingUpdateNew(System.nanoTime());
        }
        IsoObjectPicker.Instance.StartRender();
        s_performance.statesRender.invokeAndMeasure(states, GameStateMachine::render);
    }

    public static void InitDisplay() throws IOException, LWJGLException {
        int n;
        Display.setTitle(GAME_TITLE);
        if (!Core.getInstance().loadOptions()) {
            n = Runtime.getRuntime().availableProcessors();
            if (n == 1) {
                PerformanceSettings.LightingFrameSkip = 3;
            } else if (n == 2) {
                PerformanceSettings.LightingFrameSkip = 2;
            } else if (n <= 4) {
                PerformanceSettings.LightingFrameSkip = 1;
            }
            Core.setFullScreen(true);
            Display.setFullscreen(true);
            Display.setResizable(false);
            DisplayMode displayMode = Display.getDesktopDisplayMode();
            Core.getInstance().init(displayMode.getWidth(), displayMode.getHeight());
            if (!GL.getCapabilities().GL_ATI_meminfo && !GL.getCapabilities().GL_NVX_gpu_memory_info) {
                DebugLog.General.warn("Unable to determine available GPU memory, texture compression defaults to on");
                TextureID.bUseCompressionOption = true;
                TextureID.bUseCompression = true;
            }
            DebugLog.log("Init language : " + System.getProperty("user.language"));
            Core.getInstance().setOptionLanguageName(System.getProperty("user.language").toUpperCase());
            Core.getInstance().saveOptions();
        } else {
            Core.getInstance().init(Core.getInstance().getScreenWidth(), Core.getInstance().getScreenHeight());
        }
        if (GL.getCapabilities().GL_ATI_meminfo) {
            n = GL11.glGetInteger((int)34812);
            DebugLog.log("ATI: available texture memory is " + n / 1024 + " MB");
        }
        if (GL.getCapabilities().GL_NVX_gpu_memory_info) {
            n = GL11.glGetInteger((int)36937);
            DebugLog.log("NVIDIA: current available GPU memory is " + n / 1024 + " MB");
            n = GL11.glGetInteger((int)36935);
            DebugLog.log("NVIDIA: dedicated available GPU memory is " + n / 1024 + " MB");
            n = GL11.glGetInteger((int)36936);
            DebugLog.log("NVIDIA: total available GPU memory is " + n / 1024 + " MB");
        }
        SpriteRenderer.instance.create();
    }

    public static void InitGameThread() {
        Thread.setDefaultUncaughtExceptionHandler(GameWindow::uncaughtGlobalException);
        Thread thread = new Thread(ThreadGroups.Main, GameWindow::mainThread, "MainThread");
        thread.setUncaughtExceptionHandler(GameWindow::uncaughtExceptionMainThread);
        GameThread = thread;
        thread.start();
    }

    private static void uncaughtExceptionMainThread(Thread thread, Throwable throwable) {
        if (throwable instanceof ThreadDeath) {
            DebugLog.General.println("Game Thread exited: ", thread.getName());
            return;
        }
        try {
            GameWindow.uncaughtException(thread, throwable);
        }
        finally {
            GameWindow.onGameThreadExited();
        }
    }

    private static void uncaughtGlobalException(Thread thread, Throwable throwable) {
        if (throwable instanceof ThreadDeath) {
            DebugLog.General.println("External Thread exited: ", thread.getName());
            return;
        }
        GameWindow.uncaughtException(thread, throwable);
    }

    public static void uncaughtException(Thread thread, Throwable throwable) {
        if (throwable instanceof ThreadDeath) {
            DebugLog.General.println("Internal Thread exited: ", thread.getName());
            return;
        }
        String string = String.format("Unhandled %s thrown by thread %s.", throwable.getClass().getName(), thread.getName());
        DebugLog.General.error(string);
        ExceptionLogger.logException(throwable, string);
    }

    private static void mainThread() {
        GameWindow.mainThreadInit();
        GameWindow.enter();
        RenderThread.setWaitForRenderState(true);
        GameWindow.run_ez();
    }

    private static void mainThreadInit() {
        String string = System.getProperty("debug");
        String string2 = System.getProperty("nosave");
        if (string2 != null) {
            Core.getInstance().setNoSave(true);
        }
        if (string != null) {
            Core.bDebug = true;
        }
        if (!Core.SoundDisabled) {
            FMODManager.instance.init();
        }
        DebugOptions.instance.init();
        GameProfiler.init();
        SoundManager.instance = Core.SoundDisabled ? new DummySoundManager() : new SoundManager();
        AmbientStreamManager.instance = Core.SoundDisabled ? new DummyAmbientStreamManager() : new AmbientStreamManager();
        BaseSoundBank.instance = Core.SoundDisabled ? new DummySoundBank() : new FMODSoundBank();
        VoiceManager.instance.loadConfig();
        TextureID.bUseCompression = TextureID.bUseCompressionOption = Core.SafeModeForced || Core.getInstance().getOptionTextureCompression();
        SoundManager.instance.setSoundVolume((float)Core.getInstance().getOptionSoundVolume() / 10.0f);
        SoundManager.instance.setMusicVolume((float)Core.getInstance().getOptionMusicVolume() / 10.0f);
        SoundManager.instance.setAmbientVolume((float)Core.getInstance().getOptionAmbientVolume() / 10.0f);
        SoundManager.instance.setVehicleEngineVolume((float)Core.getInstance().getOptionVehicleEngineVolume() / 10.0f);
        try {
            ZomboidFileSystem.instance.init();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        DebugFileWatcher.instance.init();
        String string3 = System.getProperty("server");
        String string4 = System.getProperty("client");
        String string5 = System.getProperty("nozombies");
        if (string5 != null) {
            IsoWorld.NoZombies = true;
        }
        if (string3 != null && string3.equals("true")) {
            GameServer.bServer = true;
        }
        try {
            GameWindow.renameSaveFolders();
            GameWindow.init();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static void renameSaveFolders() {
        String string = ZomboidFileSystem.instance.getSaveDir();
        File file = new File(string);
        if (!file.exists() || !file.isDirectory()) {
            return;
        }
        File file2 = new File(file, "Fighter");
        File file3 = new File(file, "Survivor");
        if (!(file2.exists() && file2.isDirectory() && file3.exists() && file3.isDirectory())) {
            return;
        }
        DebugLog.log("RENAMING Saves/Survivor to Saves/Apocalypse");
        DebugLog.log("RENAMING Saves/Fighter to Saves/Survivor");
        file3.renameTo(new File(file, "Apocalypse"));
        file2.renameTo(new File(file, "Survivor"));
        File file4 = new File(ZomboidFileSystem.instance.getCacheDir() + File.separator + "latestSave.ini");
        if (file4.exists()) {
            file4.delete();
        }
    }

    public static long readLong(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = dataInputStream.read();
        if ((n8 | (n7 = dataInputStream.read()) | (n6 = dataInputStream.read()) | (n5 = dataInputStream.read()) | (n4 = dataInputStream.read()) | (n3 = dataInputStream.read()) | (n2 = dataInputStream.read()) | (n = dataInputStream.read())) < 0) {
            throw new EOFException();
        }
        return n8 + (n7 << 8) + (n6 << 16) + (n5 << 24) + (n4 << 32) + (n3 << 40) + (n2 << 48) + (n << 56);
    }

    public static int readInt(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = dataInputStream.read();
        if ((n4 | (n3 = dataInputStream.read()) | (n2 = dataInputStream.read()) | (n = dataInputStream.read())) < 0) {
            throw new EOFException();
        }
        return n4 + (n3 << 8) + (n2 << 16) + (n << 24);
    }

    private static void run_ez() {
        long l = System.nanoTime();
        long l2 = 0L;
        while (!RenderThread.isCloseRequested() && !closeRequested) {
            long l3 = System.nanoTime();
            if (l3 < l) {
                l = l3;
                continue;
            }
            long l4 = l3 - l;
            l = l3;
            if (PerformanceSettings.isUncappedFPS()) {
                GameWindow.frameStep();
            } else {
                long l5 = PZMath.secondsToNanos / (long)PerformanceSettings.getLockFPS();
                if ((l2 += l4) >= l5) {
                    GameWindow.frameStep();
                    l2 %= l5;
                }
            }
            if (Core.bDebug && DebugOptions.instance.ThreadCrash_Enabled.getValue()) {
                DebugOptions.testThreadCrash(0);
                RenderThread.invokeOnRenderContext(() -> DebugOptions.testThreadCrash(1));
            }
            Thread.yield();
        }
        GameWindow.exit();
    }

    private static void enter() {
        int n = Core.TileScale = Core.getInstance().getOptionTexture2x() ? 2 : 1;
        if (Core.SafeModeForced) {
            Core.TileScale = 1;
        }
        IsoCamera.init();
        int n2 = TextureID.bUseCompression ? 4 : 0;
        n2 |= 0x40;
        if (Core.TileScale == 1) {
            GameWindow.LoadTexturePack("Tiles1x", n2);
            GameWindow.LoadTexturePack("Overlays1x", n2);
            GameWindow.LoadTexturePack("JumboTrees1x", n2);
            GameWindow.LoadTexturePack("Tiles1x.floor", n2 & 0xFFFFFFFB);
        }
        if (Core.TileScale == 2) {
            GameWindow.LoadTexturePack("Tiles2x", n2);
            GameWindow.LoadTexturePack("Overlays2x", n2);
            GameWindow.LoadTexturePack("JumboTrees2x", n2);
            GameWindow.LoadTexturePack("Tiles2x.floor", n2 & 0xFFFFFFFB);
        }
        GameWindow.setTexturePackLookup();
        if (Texture.getSharedTexture("TileIndieStoneTentFrontLeft") == null) {
            throw new RuntimeException("Rebuild Tiles.pack with \"1 Include This in .pack\" as individual images not tilesheets");
        }
        DebugLog.log("LOADED UP A TOTAL OF " + Texture.totalTextureID + " TEXTURES");
        s_fpsTracking.init();
        GameWindow.DoLoadingText(Translator.getText("UI_Loading_ModelsAnimations"));
        ModelManager.instance.create();
        if (!SteamUtils.isSteamModeEnabled()) {
            GameWindow.DoLoadingText(Translator.getText("UI_Loading_InitPublicServers"));
            PublicServerUtil.init();
        }
        VoiceManager.instance.InitVMClient();
        GameWindow.DoLoadingText(Translator.getText("UI_Loading_OnGameBoot"));
        LuaEventManager.triggerEvent("OnGameBoot");
    }

    private static void frameStep() {
        try {
            ++IsoCamera.frameState.frameCount;
            s_performance.frameStep.start();
            s_fpsTracking.frameStep();
            s_performance.logic.invokeAndMeasure(GameWindow::logic);
            Core.getInstance().setScreenSize(RenderThread.getDisplayWidth(), RenderThread.getDisplayHeight());
            GameWindow.renderInternal();
            if (doRenderEvent) {
                LuaEventManager.triggerEvent("OnRenderTick");
            }
            Core.getInstance().DoFrameReady();
            LightingThread.instance.update();
            if (Core.bDebug) {
                UIDebugConsole uIDebugConsole;
                if (GameKeyboard.isKeyDown(Core.getInstance().getKey("Toggle Lua Debugger"))) {
                    if (!bLuaDebuggerKeyDown) {
                        UIManager.setShowLuaDebuggerOnError(true);
                        LuaManager.thread.bStep = true;
                        LuaManager.thread.bStepInto = true;
                        bLuaDebuggerKeyDown = true;
                        if (GameClient.bClient && GameWindow.states.current == IngameState.instance) {
                            GameClient.sendServerPing(-1L);
                        }
                    }
                } else {
                    bLuaDebuggerKeyDown = false;
                }
                if (GameKeyboard.isKeyPressed(Core.getInstance().getKey("ToggleLuaConsole")) && (uIDebugConsole = UIManager.getDebugConsole()) != null) {
                    uIDebugConsole.setVisible(uIDebugConsole.isVisible() == false);
                }
            }
        }
        catch (OpenGLException openGLException) {
            RenderThread.logGLException(openGLException);
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
        }
        finally {
            s_performance.frameStep.end();
        }
    }

    private static void exit() {
        DebugLog.log("EXITDEBUG: GameWindow.exit 1");
        if (GameClient.bClient) {
            for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                IsoPlayer isoPlayer = IsoPlayer.players[i];
                if (isoPlayer == null) continue;
                ClientPlayerDB.getInstance().clientSendNetworkPlayerInt(isoPlayer);
            }
            WorldStreamer.instance.stop();
            GameClient.instance.doDisconnect("exit");
            VoiceManager.instance.DeinitVMClient();
        }
        if (OkToSaveOnExit) {
            try {
                WorldStreamer.instance.quit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (PlayerDB.isAllow()) {
                PlayerDB.getInstance().saveLocalPlayersForce();
                PlayerDB.getInstance().m_canSavePlayers = false;
            }
            if (ClientPlayerDB.isAllow()) {
                ClientPlayerDB.getInstance().canSavePlayers = false;
            }
            try {
                if (GameClient.bClient && GameClient.connection != null) {
                    GameClient.connection.username = null;
                }
                GameWindow.save(true);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            try {
                if (IsoWorld.instance.CurrentCell != null) {
                    LuaEventManager.triggerEvent("OnPostSave");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                if (IsoWorld.instance.CurrentCell != null) {
                    LuaEventManager.triggerEvent("OnPostSave");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                LightingThread.instance.stop();
                MapCollisionData.instance.stop();
                ZombiePopulationManager.instance.stop();
                PolygonalMap2.instance.stop();
                ZombieSpawnRecorder.instance.quit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        DebugLog.log("EXITDEBUG: GameWindow.exit 2");
        if (GameClient.bClient) {
            WorldStreamer.instance.stop();
            GameClient.instance.doDisconnect("exit-saving");
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        DebugLog.log("EXITDEBUG: GameWindow.exit 3");
        if (PlayerDB.isAvailable()) {
            PlayerDB.getInstance().close();
        }
        if (ClientPlayerDB.isAvailable()) {
            ClientPlayerDB.getInstance().close();
        }
        DebugLog.log("EXITDEBUG: GameWindow.exit 4");
        GameClient.instance.Shutdown();
        SteamUtils.shutdown();
        ZipLogs.addZipFile(true);
        GameWindow.onGameThreadExited();
        DebugLog.log("EXITDEBUG: GameWindow.exit 5");
    }

    private static void onGameThreadExited() {
        bGameThreadExited = true;
        RenderThread.onGameThreadExited();
    }

    public static void setTexturePackLookup() {
        texturePackTextures.clear();
        for (int i = texturePacks.size() - 1; i >= 0; --i) {
            TexturePack texturePack = texturePacks.get(i);
            if (texturePack.modID != null) continue;
            texturePackTextures.putAll(texturePack.textures);
        }
        ArrayList<String> arrayList = ZomboidFileSystem.instance.getModIDs();
        for (int i = texturePacks.size() - 1; i >= 0; --i) {
            TexturePack texturePack = texturePacks.get(i);
            if (texturePack.modID == null || !arrayList.contains(texturePack.modID)) continue;
            texturePackTextures.putAll(texturePack.textures);
        }
        Texture.onTexturePacksChanged();
    }

    public static void LoadTexturePack(String string, int n) {
        GameWindow.LoadTexturePack(string, n, null);
    }

    public static void LoadTexturePack(String string, int n, String string2) {
        DebugLog.General.println("texturepack: loading " + string);
        GameWindow.DoLoadingText(Translator.getText("UI_Loading_Texturepack", string));
        String string3 = ZomboidFileSystem.instance.getString("media/texturepacks/" + string + ".pack");
        TexturePack texturePack = new TexturePack();
        texturePack.packName = string;
        texturePack.fileName = string3;
        texturePack.modID = string2;
        fileSystem.mountTexturePack(string, texturePack.textures, n);
        texturePacks.add(texturePack);
    }

    @Deprecated
    public static void LoadTexturePackDDS(String string) {
        DebugLog.log("texturepack: loading " + string);
        if (SpriteRenderer.instance != null) {
            Core.getInstance().StartFrame();
            Core.getInstance().EndFrame(0);
            Core.getInstance().StartFrameUI();
            SpriteRenderer.instance.renderi(null, 0, 0, Core.getInstance().getScreenWidth(), Core.getInstance().getScreenHeight(), 0.0f, 0.0f, 0.0f, 1.0f, null);
            TextManager.instance.DrawStringCentre(Core.getInstance().getScreenWidth() / 2, Core.getInstance().getScreenHeight() / 2, Translator.getText("UI_Loading_Texturepack", string), 1.0, 1.0, 1.0, 1.0);
            Core.getInstance().EndFrameUI();
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(ZomboidFileSystem.instance.getString("media/texturepacks/" + string + ".pack"));
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger(GameLoadingState.class.getName()).log(Level.SEVERE, null, fileNotFoundException);
        }
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
            int n = TexturePackPage.readInt(bufferedInputStream);
            for (int i = 0; i < n; ++i) {
                TexturePackPage texturePackPage = new TexturePackPage();
                if (i % 100 == 0 && SpriteRenderer.instance != null) {
                    Core.getInstance().StartFrame();
                    Core.getInstance().EndFrame();
                    Core.getInstance().StartFrameUI();
                    TextManager.instance.DrawStringCentre(Core.getInstance().getScreenWidth() / 2, Core.getInstance().getScreenHeight() / 2, Translator.getText("UI_Loading_Texturepack", string), 1.0, 1.0, 1.0, 1.0);
                    Core.getInstance().EndFrameUI();
                    RenderThread.invokeOnRenderContext(Display::update);
                }
                texturePackPage.loadFromPackFileDDS(bufferedInputStream);
            }
            DebugLog.log("texturepack: finished loading " + string);
        }
        catch (Exception exception) {
            DebugLog.log("media/texturepacks/" + string + ".pack");
            exception.printStackTrace();
        }
        Texture.nullTextures.clear();
    }

    private static void installRequiredLibrary(String string, String string2) {
        if (new File(string).exists()) {
            DebugLog.log("Attempting to install " + string2);
            DebugLog.log("Running " + string + ".");
            ProcessBuilder processBuilder = new ProcessBuilder(string, "/quiet", "/norestart");
            try {
                Process process = processBuilder.start();
                int n = process.waitFor();
                DebugLog.log("Process exited with code " + n);
                return;
            }
            catch (IOException | InterruptedException exception) {
                exception.printStackTrace();
            }
        }
        DebugLog.log("Please install " + string2);
    }

    private static void checkRequiredLibraries() {
        if (System.getProperty("os.name").startsWith("Win")) {
            String string;
            String string2;
            String string3;
            Object object;
            if (System.getProperty("sun.arch.data.model").equals("64")) {
                object = "Lighting64";
                string3 = "_CommonRedist\\vcredist\\2010\\vcredist_x64.exe";
                string2 = "_CommonRedist\\vcredist\\2012\\vcredist_x64.exe";
                string = "_CommonRedist\\vcredist\\2013\\vcredist_x64.exe";
            } else {
                object = "Lighting32";
                string3 = "_CommonRedist\\vcredist\\2010\\vcredist_x86.exe";
                string2 = "_CommonRedist\\vcredist\\2012\\vcredist_x86.exe";
                string = "_CommonRedist\\vcredist\\2013\\vcredist_x86.exe";
            }
            if ("1".equals(System.getProperty("zomboid.debuglibs.lighting"))) {
                DebugLog.log("***** Loading debug version of Lighting");
                object = (String)object + "d";
            }
            try {
                System.loadLibrary((String)object);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                DebugLog.log("Error loading " + (String)object + ".dll.  Your system may be missing a required DLL.");
                GameWindow.installRequiredLibrary(string3, "the Microsoft Visual C++ 2010 Redistributable.");
                GameWindow.installRequiredLibrary(string2, "the Microsoft Visual C++ 2012 Redistributable.");
                GameWindow.installRequiredLibrary(string, "the Microsoft Visual C++ 2013 Redistributable.");
            }
        }
    }

    private static void init() throws Exception {
        GameWindow.initFonts();
        GameWindow.checkRequiredLibraries();
        SteamUtils.init();
        ServerBrowser.init();
        SteamFriends.init();
        SteamWorkshop.init();
        RakNetPeerInterface.init();
        LightingJNI.init();
        ZombiePopulationManager.init();
        PZSQLUtils.init();
        Clipper.init();
        WorldMapJNI.init();
        Bullet.init();
        int n = Runtime.getRuntime().availableProcessors();
        String string = ZomboidFileSystem.instance.getCacheDir() + File.separator;
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        GameWindow.DoLoadingText("Loading Mods");
        ZomboidFileSystem.instance.resetDefaultModsForNewRelease("41_51");
        ZomboidFileSystem.instance.loadMods("default");
        ZomboidFileSystem.instance.loadModPackFiles();
        if (Core.getInstance().isDefaultOptions() && SteamUtils.isSteamModeEnabled() && SteamUtils.isRunningOnSteamDeck()) {
            Core.getInstance().setOptionFontSize(2);
            Core.getInstance().setOptionSingleContextMenu(0, true);
            Core.getInstance().setOptionShoulderButtonContainerSwitch(1);
            Core.getInstance().setAutoZoom(0, true);
            Core.getInstance().setOptionZoomLevels2x("75;125;150;175;200;225");
            Core.getInstance().setOptionPanCameraWhileAiming(true);
            Core.getInstance().setOptionPanCameraWhileDriving(true);
            Core.getInstance().setOptionTextureCompression(true);
            Core.getInstance();
            Core.OptionVoiceEnable = false;
        }
        GameWindow.DoLoadingText("Loading Translations");
        Languages.instance.init();
        Translator.language = null;
        GameWindow.initFonts();
        Translator.loadFiles();
        GameWindow.initShared();
        GameWindow.DoLoadingText(Translator.getText("UI_Loading_Lua"));
        LuaManager.init();
        CustomPerks.instance.initLua();
        CustomSandboxOptions.instance.init();
        CustomSandboxOptions.instance.initInstance(SandboxOptions.instance);
        LuaManager.LoadDirBase();
        ZomboidGlobals.Load();
        LuaEventManager.triggerEvent("OnLoadSoundBanks");
    }

    private static void initFonts() throws FileNotFoundException {
        TextManager.instance.Init();
        while (TextManager.instance.font.isEmpty()) {
            fileSystem.updateAsyncTransactions();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static void save(boolean bl) throws IOException {
        FilterOutputStream filterOutputStream;
        if (Core.getInstance().isNoSave()) {
            return;
        }
        if (IsoWorld.instance.CurrentCell == null || "LastStand".equals(Core.getInstance().getGameMode()) || "Tutorial".equals(Core.getInstance().getGameMode())) {
            return;
        }
        File file = ZomboidFileSystem.instance.getFileInCurrentSave("map_ver.bin");
        try (Object object = new FileOutputStream(file);){
            filterOutputStream = new DataOutputStream((OutputStream)object);
            try {
                ((DataOutputStream)filterOutputStream).writeInt(195);
                GameWindow.WriteString((DataOutputStream)filterOutputStream, Core.GameMap);
                GameWindow.WriteString((DataOutputStream)filterOutputStream, IsoWorld.instance.getDifficulty());
            }
            finally {
                filterOutputStream.close();
            }
        }
        file = ZomboidFileSystem.instance.getFileInCurrentSave("map_sand.bin");
        object = new FileOutputStream(file);
        try {
            filterOutputStream = new BufferedOutputStream((OutputStream)object);
            try {
                SliceY.SliceBuffer.clear();
                SandboxOptions.instance.save(SliceY.SliceBuffer);
                ((BufferedOutputStream)filterOutputStream).write(SliceY.SliceBuffer.array(), 0, SliceY.SliceBuffer.position());
            }
            finally {
                filterOutputStream.close();
            }
        }
        finally {
            ((FileOutputStream)object).close();
        }
        LuaEventManager.triggerEvent("OnSave");
        try {
            try {
                try {
                    if (Thread.currentThread() == GameThread) {
                        SavefileThumbnail.create();
                    }
                }
                catch (Exception exception) {
                    ExceptionLogger.logException(exception);
                }
                file = ZomboidFileSystem.instance.getFileInCurrentSave("map.bin");
                try {
                    object = new FileOutputStream(file);
                    try {
                        filterOutputStream = new DataOutputStream((OutputStream)object);
                        IsoWorld.instance.CurrentCell.save((DataOutputStream)filterOutputStream, bl);
                    }
                    finally {
                        ((FileOutputStream)object).close();
                    }
                }
                catch (Exception exception) {
                    ExceptionLogger.logException(exception);
                }
                try {
                    MapCollisionData.instance.save();
                    if (!bLoadedAsClient) {
                        SGlobalObjects.save();
                    }
                }
                catch (Exception exception) {
                    ExceptionLogger.logException(exception);
                }
                ZomboidRadio.getInstance().Save();
                GlobalModData.instance.save();
                MapItem.SaveWorldMap();
                WorldMapVisited.SaveAll();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException.getCause();
            if (object instanceof IOException) {
                throw (IOException)object;
            }
            throw runtimeException;
        }
    }

    public static String getCoopServerHome() {
        File file = new File(ZomboidFileSystem.instance.getCacheDir());
        return file.getParent();
    }

    public static void WriteString(ByteBuffer byteBuffer, String string) {
        GameWindow.WriteStringUTF(byteBuffer, string);
    }

    public static void WriteStringUTF(ByteBuffer byteBuffer, String string) {
        stringUTF.get().save(byteBuffer, string);
    }

    public static void WriteString(DataOutputStream dataOutputStream, String string) throws IOException {
        if (string == null) {
            dataOutputStream.writeInt(0);
            return;
        }
        dataOutputStream.writeInt(string.length());
        if (string != null && string.length() >= 0) {
            dataOutputStream.writeChars(string);
        }
    }

    public static String ReadStringUTF(ByteBuffer byteBuffer) {
        return stringUTF.get().load(byteBuffer);
    }

    public static String ReadString(ByteBuffer byteBuffer) {
        return GameWindow.ReadStringUTF(byteBuffer);
    }

    public static String ReadString(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n == 0) {
            return "";
        }
        if (n > 65536) {
            throw new RuntimeException("GameWindow.ReadString: string is too long, corrupted save?");
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(dataInputStream.readChar());
        }
        return stringBuilder.toString();
    }

    public static void doRenderEvent(boolean bl) {
        doRenderEvent = bl;
    }

    public static void DoLoadingText(String string) {
        if (SpriteRenderer.instance != null && TextManager.instance.font != null) {
            Core.getInstance().StartFrame();
            Core.getInstance().EndFrame();
            Core.getInstance().StartFrameUI();
            SpriteRenderer.instance.renderi(null, 0, 0, Core.getInstance().getScreenWidth(), Core.getInstance().getScreenHeight(), 0.0f, 0.0f, 0.0f, 1.0f, null);
            TextManager.instance.DrawStringCentre(Core.getInstance().getScreenWidth() / 2, Core.getInstance().getScreenHeight() / 2, string, 1.0, 1.0, 1.0, 1.0);
            Core.getInstance().EndFrameUI();
        }
    }

    static {
        bLoadedAsClient = false;
        DrawReloadingLua = false;
        ActivatedJoyPad = null;
        version = "RC3";
        averageFPS = PerformanceSettings.getLockFPS();
        doRenderEvent = false;
        bLuaDebuggerKeyDown = false;
        fileSystem = new FileSystemImpl();
        assetManagers = new AssetManagers(fileSystem);
        bGameThreadExited = false;
        texturePacks = new ArrayList();
        texturePackTextures = new FileSystem.TexturePackTextures();
    }

    private static class s_performance {
        static final PerformanceProfileFrameProbe frameStep = new PerformanceProfileFrameProbe("GameWindow.frameStep");
        static final PerformanceProfileProbe statesRender = new PerformanceProfileProbe("GameWindow.states.render");
        static final PerformanceProfileProbe logic = new PerformanceProfileProbe("GameWindow.logic");

        private s_performance() {
        }
    }

    private static final class TexturePack {
        String packName;
        String fileName;
        String modID;
        final FileSystem.TexturePackTextures textures = new FileSystem.TexturePackTextures();

        private TexturePack() {
        }
    }

    private static class StringUTF {
        private char[] chars;
        private ByteBuffer byteBuffer;
        private CharBuffer charBuffer;
        private CharsetEncoder ce;
        private CharsetDecoder cd;

        private StringUTF() {
        }

        private int encode(String string) {
            int n;
            if (this.chars == null || this.chars.length < string.length()) {
                n = (string.length() + 128 - 1) / 128 * 128;
                this.chars = new char[n];
                this.charBuffer = CharBuffer.wrap(this.chars);
            }
            string.getChars(0, string.length(), this.chars, 0);
            this.charBuffer.limit(string.length());
            this.charBuffer.position(0);
            if (this.ce == null) {
                this.ce = StandardCharsets.UTF_8.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            }
            this.ce.reset();
            n = (int)((double)string.length() * (double)this.ce.maxBytesPerChar());
            n = (n + 128 - 1) / 128 * 128;
            if (this.byteBuffer == null || this.byteBuffer.capacity() < n) {
                this.byteBuffer = ByteBuffer.allocate(n);
            }
            this.byteBuffer.clear();
            CoderResult coderResult = this.ce.encode(this.charBuffer, this.byteBuffer, true);
            return this.byteBuffer.position();
        }

        private String decode(int n) {
            if (this.cd == null) {
                this.cd = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            }
            this.cd.reset();
            int n2 = (int)((double)n * (double)this.cd.maxCharsPerByte());
            if (this.chars == null || this.chars.length < n2) {
                int n3 = (n2 + 128 - 1) / 128 * 128;
                this.chars = new char[n3];
                this.charBuffer = CharBuffer.wrap(this.chars);
            }
            this.charBuffer.clear();
            CoderResult coderResult = this.cd.decode(this.byteBuffer, this.charBuffer, true);
            return new String(this.chars, 0, this.charBuffer.position());
        }

        void save(ByteBuffer byteBuffer, String string) {
            if (string == null || string.isEmpty()) {
                byteBuffer.putShort((short)0);
                return;
            }
            int n = this.encode(string);
            byteBuffer.putShort((short)n);
            this.byteBuffer.flip();
            byteBuffer.put(this.byteBuffer);
        }

        String load(ByteBuffer byteBuffer) {
            short s = byteBuffer.getShort();
            if (s <= 0) {
                return "";
            }
            int n = (s + 128 - 1) / 128 * 128;
            if (this.byteBuffer == null || this.byteBuffer.capacity() < n) {
                this.byteBuffer = ByteBuffer.allocate(n);
            }
            this.byteBuffer.clear();
            if (byteBuffer.remaining() < s) {
                DebugLog.General.error("GameWindow.StringUTF.load> numBytes:" + s + " is higher than the remaining bytes in the buffer:" + byteBuffer.remaining());
            }
            int n2 = byteBuffer.limit();
            byteBuffer.limit(byteBuffer.position() + s);
            this.byteBuffer.put(byteBuffer);
            byteBuffer.limit(n2);
            this.byteBuffer.flip();
            return this.decode(s);
        }
    }

    public static class OSValidator {
        private static String OS = System.getProperty("os.name").toLowerCase();

        public static boolean isWindows() {
            return OS.indexOf("win") >= 0;
        }

        public static boolean isMac() {
            return OS.indexOf("mac") >= 0;
        }

        public static boolean isUnix() {
            return OS.indexOf("nix") >= 0 || OS.indexOf("nux") >= 0 || OS.indexOf("aix") > 0;
        }

        public static boolean isSolaris() {
            return OS.indexOf("sunos") >= 0;
        }
    }
}

