/*
 * Decompiled with CFR 0.152.
 */
package zombie;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.concurrent.TimeUnit;
import se.krka.kahlua.vm.KahluaTable;
import zombie.AmbientStreamManager;
import zombie.GameWindow;
import zombie.Lua.LuaEventManager;
import zombie.Lua.LuaManager;
import zombie.SandboxOptions;
import zombie.ZomboidFileSystem;
import zombie.ai.sadisticAIDirector.SleepingEvent;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.core.Core;
import zombie.core.PerformanceSettings;
import zombie.core.Rand;
import zombie.core.Translator;
import zombie.core.logger.ExceptionLogger;
import zombie.core.math.PZMath;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.erosion.ErosionMain;
import zombie.iso.IsoWorld;
import zombie.iso.SliceY;
import zombie.iso.weather.ClimateManager;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.PacketTypes;
import zombie.network.ServerOptions;
import zombie.radio.ZomboidRadio;
import zombie.ui.SpeedControls;
import zombie.ui.UIManager;
import zombie.util.PZCalendar;

public final class GameTime {
    public static GameTime instance = new GameTime();
    public static final float MULTIPLIER = 0.8f;
    private static long serverTimeShift = 0L;
    private static boolean serverTimeShiftIsSet = false;
    private static boolean isUTest = false;
    public float TimeOfDay = 9.0f;
    public int NightsSurvived = 0;
    public PZCalendar Calender;
    public float FPSMultiplier = 1.0f;
    public float Moon = 0.0f;
    public float ServerTimeOfDay;
    public float ServerLastTimeOfDay;
    public int ServerNewDays;
    public float lightSourceUpdate = 0.0f;
    public float multiplierBias = 1.0f;
    public float LastLastTimeOfDay = 0.0f;
    private int HelicopterTime1Start = 0;
    public float PerObjectMultiplier = 1.0f;
    private int HelicopterTime1End = 0;
    private int HelicopterDay1 = 0;
    private float Ambient = 0.9f;
    private float AmbientMax = 1.0f;
    private float AmbientMin = 0.24f;
    private int Day = 22;
    private int StartDay = 22;
    private float MaxZombieCountStart = 750.0f;
    private float MinZombieCountStart = 750.0f;
    private float MaxZombieCount = 750.0f;
    private float MinZombieCount = 750.0f;
    private int Month = 7;
    private int StartMonth = 7;
    private float StartTimeOfDay = 9.0f;
    private float ViewDistMax = 42.0f;
    private float ViewDistMin = 19.0f;
    private int Year = 2012;
    private int StartYear = 2012;
    private double HoursSurvived = 0.0;
    private float MinutesPerDayStart;
    private float MinutesPerDay = this.MinutesPerDayStart = 30.0f;
    private float LastTimeOfDay;
    private int TargetZombies = (int)this.MinZombieCountStart;
    private boolean RainingToday = true;
    private boolean bGunFireEventToday = false;
    private float[] GunFireTimes = new float[5];
    private int NumGunFireEvents = 1;
    private long lastPing = 0L;
    private long lastClockSync = 0L;
    private KahluaTable table = null;
    private int minutesMod = -1;
    private boolean thunderDay = true;
    private boolean randomAmbientToday = true;
    private float Multiplier = 1.0f;
    private int dusk = 3;
    private int dawn = 12;
    private float NightMin = 0.0f;
    private float NightMax = 1.0f;
    private long minutesStamp = 0L;
    private long previousMinuteStamp = 0L;

    public GameTime() {
        serverTimeShift = 0L;
        serverTimeShiftIsSet = false;
    }

    public static GameTime getInstance() {
        return instance;
    }

    public static void setInstance(GameTime gameTime) {
        instance = gameTime;
    }

    public static void syncServerTime(long l, long l2, long l3) {
        long l4 = l3 - l;
        long l5 = l2 - l3 + l4 / 2L;
        long l6 = serverTimeShift;
        serverTimeShift = !serverTimeShiftIsSet ? l5 : (serverTimeShift += (l5 - serverTimeShift) / 100L);
        long l7 = 10000000L;
        if (Math.abs(serverTimeShift - l6) > l7) {
            GameTime.sendTimeSync();
        } else {
            serverTimeShiftIsSet = true;
        }
    }

    public static long getServerTime() {
        if (isUTest) {
            return System.nanoTime() + serverTimeShift;
        }
        if (GameServer.bServer) {
            return System.nanoTime();
        }
        if (GameClient.bClient) {
            if (!serverTimeShiftIsSet) {
                return 0L;
            }
            return System.nanoTime() + serverTimeShift;
        }
        return 0L;
    }

    public static long getServerTimeMills() {
        return TimeUnit.NANOSECONDS.toMillis(GameTime.getServerTime());
    }

    public static boolean getServerTimeShiftIsSet() {
        return serverTimeShiftIsSet;
    }

    public static void setServerTimeShift(long l) {
        isUTest = true;
        serverTimeShift = l;
        serverTimeShiftIsSet = true;
    }

    private static void sendTimeSync() {
        ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
        PacketTypes.PacketType.TimeSync.doPacket(byteBufferWriter);
        byteBufferWriter.putLong(System.nanoTime());
        byteBufferWriter.putFloat(GameTime.instance.Multiplier);
        PacketTypes.PacketType.TimeSync.send(GameClient.connection);
    }

    public static void receiveTimeSync(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        long l;
        long l2;
        if (GameServer.bServer) {
            l2 = byteBuffer.getLong();
            l = System.nanoTime();
            float f = byteBuffer.getFloat();
            if (GameServer.bServer && !GameServer.bFastForward) {
                if (GameTime.instance.Multiplier != f) {
                    udpConnection.validator.failTimeMultiplier(f);
                } else {
                    udpConnection.validator.successTimeMultiplier();
                }
            }
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.TimeSync.doPacket(byteBufferWriter);
            byteBufferWriter.putLong(l2);
            byteBufferWriter.putLong(l);
            PacketTypes.PacketType.TimeSync.send(udpConnection);
        }
        if (GameClient.bClient) {
            l2 = byteBuffer.getLong();
            l = byteBuffer.getLong();
            long l3 = System.nanoTime();
            GameTime.syncServerTime(l2, l, l3);
            DebugLog.printServerTime = true;
        }
    }

    public float getRealworldSecondsSinceLastUpdate() {
        return 0.016666668f * this.FPSMultiplier;
    }

    public float getMultipliedSecondsSinceLastUpdate() {
        return 0.016666668f * this.getUnmoddedMultiplier();
    }

    public float getGameWorldSecondsSinceLastUpdate() {
        float f = 1440.0f / this.getMinutesPerDay();
        return this.getTimeDelta() * f;
    }

    public int daysInMonth(int n, int n2) {
        if (this.Calender == null) {
            this.updateCalendar(this.getYear(), this.getMonth(), this.getDay(), (int)this.getTimeOfDay(), this.getMinutes());
        }
        int[] nArray = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        nArray[1] = nArray[1] + (this.getCalender().isLeapYear(n) ? 1 : 0);
        return nArray[n2];
    }

    public String getDeathString(IsoPlayer isoPlayer) {
        return Translator.getText("IGUI_Gametime_SurvivedFor", this.getTimeSurvived(isoPlayer));
    }

    public int getDaysSurvived() {
        int n;
        float f = 0.0f;
        for (n = 0; n < IsoPlayer.numPlayers; ++n) {
            IsoPlayer isoPlayer = IsoPlayer.players[n];
            if (isoPlayer == null) continue;
            f = Math.max(f, (float)isoPlayer.getHoursSurvived());
        }
        n = (int)f / 24;
        return n %= 30;
    }

    public String getTimeSurvived(IsoPlayer isoPlayer) {
        Object object = "";
        float f = (float)isoPlayer.getHoursSurvived();
        Integer n = (int)f % 24;
        Integer n2 = (int)f / 24;
        Integer n3 = n2 / 30;
        n2 = n2 % 30;
        Integer n4 = n3 / 12;
        n3 = n3 % 12;
        String string = Translator.getText("IGUI_Gametime_day");
        String string2 = Translator.getText("IGUI_Gametime_year");
        String string3 = Translator.getText("IGUI_Gametime_hour");
        String string4 = Translator.getText("IGUI_Gametime_month");
        if (n4 != 0) {
            if (n4 > 1) {
                string2 = Translator.getText("IGUI_Gametime_years");
            }
            object = (String)object + n4 + " " + string2;
        }
        if (n3 != 0) {
            if (n3 > 1) {
                string4 = Translator.getText("IGUI_Gametime_months");
            }
            if (((String)object).length() > 0) {
                object = (String)object + ", ";
            }
            object = (String)object + n3 + " " + string4;
        }
        if (n2 != 0) {
            if (n2 > 1) {
                string = Translator.getText("IGUI_Gametime_days");
            }
            if (((String)object).length() > 0) {
                object = (String)object + ", ";
            }
            object = (String)object + n2 + " " + string;
        }
        if (n != 0) {
            if (n > 1) {
                string3 = Translator.getText("IGUI_Gametime_hours");
            }
            if (((String)object).length() > 0) {
                object = (String)object + ", ";
            }
            object = (String)object + n + " " + string3;
        }
        if (((String)object).trim().length() == 0) {
            int n5 = (int)(f * 60.0f);
            int n6 = (int)(f * 60.0f * 60.0f) - n5 * 60;
            object = n5 + " " + Translator.getText("IGUI_Gametime_minutes") + ", " + n6 + " " + Translator.getText("IGUI_Gametime_secondes");
        }
        return object;
    }

    public String getZombieKilledText(IsoPlayer isoPlayer) {
        int n = isoPlayer.getZombieKills();
        if (n == 0 || n > 1) {
            return Translator.getText("IGUI_Gametime_zombiesCount", n);
        }
        if (n == 1) {
            return Translator.getText("IGUI_Gametime_zombieCount", n);
        }
        return null;
    }

    public String getGameModeText() {
        Object object;
        String string = Translator.getTextOrNull("IGUI_Gametime_" + Core.GameMode);
        if (string == null) {
            string = Core.GameMode;
        }
        if ((object = Translator.getTextOrNull("IGUI_Gametime_GameMode", string)) == null) {
            object = "Game mode: " + string;
        }
        if (Core.bDebug) {
            object = (String)object + " (DEBUG)";
        }
        return object;
    }

    public void init() {
        this.setDay(this.getStartDay());
        this.setTimeOfDay(this.getStartTimeOfDay());
        this.setMonth(this.getStartMonth());
        this.setYear(this.getStartYear());
        if (SandboxOptions.instance.Helicopter.getValue() != 1) {
            this.HelicopterDay1 = Rand.Next(6, 10);
            this.HelicopterTime1Start = Rand.Next(9, 19);
            this.HelicopterTime1End = this.HelicopterTime1Start + Rand.Next(4) + 1;
        }
        this.setMinutesStamp();
    }

    public float Lerp(float f, float f2, float f3) {
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f3 >= 1.0f) {
            f3 = 1.0f;
        }
        float f4 = f2 - f;
        float f5 = f4 * f3;
        return f + f5;
    }

    public void RemoveZombiesIndiscriminate(int n) {
        if (n == 0) {
            return;
        }
        for (int i = 0; i < IsoWorld.instance.CurrentCell.getZombieList().size(); ++i) {
            IsoZombie isoZombie = IsoWorld.instance.CurrentCell.getZombieList().get(0);
            IsoWorld.instance.CurrentCell.getZombieList().remove(i);
            IsoWorld.instance.CurrentCell.getRemoveList().add(isoZombie);
            isoZombie.getCurrentSquare().getMovingObjects().remove(isoZombie);
            --i;
            if (--n != 0 && !IsoWorld.instance.CurrentCell.getZombieList().isEmpty()) continue;
            return;
        }
    }

    public float TimeLerp(float f, float f2, float f3, float f4) {
        float f5;
        float f6 = GameTime.getInstance().getTimeOfDay();
        if (f4 < f3) {
            f4 += 24.0f;
        }
        boolean bl = false;
        if (f6 > f4 && f6 > f3 || f6 < f4 && f6 < f3) {
            bl = true;
            f5 = f3 += 24.0f;
            f3 = f4;
            f4 = f5;
            if (f6 < f3) {
                f6 += 24.0f;
            }
        }
        f5 = f4 - f3;
        float f7 = f6 - f3;
        float f8 = 0.0f;
        if (f7 > f5) {
            f8 = 1.0f;
        }
        if (f7 < f5 && f7 > 0.0f) {
            f8 = f7 / f5;
        }
        if (bl) {
            f8 = 1.0f - f8;
        }
        float f9 = 0.0f;
        f9 = (double)(f8 = (f8 - 0.5f) * 2.0f) < 0.0 ? -1.0f : 1.0f;
        f8 = Math.abs(f8);
        f8 = 1.0f - f8;
        f8 = (float)Math.pow(f8, 8.0);
        f8 = 1.0f - f8;
        f8 *= f9;
        f8 = f8 * 0.5f + 0.5f;
        return this.Lerp(f, f2, f8);
    }

    public float getDeltaMinutesPerDay() {
        return this.MinutesPerDayStart / this.MinutesPerDay;
    }

    public float getNightMin() {
        return 1.0f - this.NightMin;
    }

    public void setNightMin(float f) {
        this.NightMin = 1.0f - f;
    }

    public float getNightMax() {
        return 1.0f - this.NightMax;
    }

    public void setNightMax(float f) {
        this.NightMax = 1.0f - f;
    }

    public int getMinutes() {
        return (int)((this.getTimeOfDay() - (float)((int)this.getTimeOfDay())) * 60.0f);
    }

    public void setMoon(float f) {
        this.Moon = f;
    }

    public void update(boolean bl) {
        int n;
        float f;
        int n2;
        long l = System.currentTimeMillis();
        if (GameClient.bClient && (this.lastPing == 0L || l - this.lastPing > 10000L)) {
            GameTime.sendTimeSync();
            this.lastPing = l;
        }
        int n3 = 9000;
        if (SandboxOptions.instance.MetaEvent.getValue() == 1) {
            n3 = -1;
        }
        if (SandboxOptions.instance.MetaEvent.getValue() == 3) {
            n3 = 6000;
        }
        if (!GameClient.bClient && this.randomAmbientToday && n3 != -1 && Rand.Next(Rand.AdjustForFramerate(n3)) == 0 && !GameTime.isGamePaused()) {
            AmbientStreamManager.instance.addRandomAmbient();
            boolean bl2 = this.randomAmbientToday = SandboxOptions.instance.MetaEvent.getValue() == 3 && Rand.Next(3) == 0;
        }
        if (GameServer.bServer && UIManager.getSpeedControls() != null) {
            UIManager.getSpeedControls().SetCurrentGameSpeed(1);
        }
        if (GameServer.bServer || !GameClient.bClient) {
            if (this.bGunFireEventToday) {
                for (n2 = 0; n2 < this.NumGunFireEvents; ++n2) {
                    if (!(this.TimeOfDay > this.GunFireTimes[n2]) || !(this.LastLastTimeOfDay < this.GunFireTimes[n2])) continue;
                    AmbientStreamManager.instance.doGunEvent();
                }
            }
            if (this.NightsSurvived == this.HelicopterDay1 && this.TimeOfDay > (float)this.HelicopterTime1Start && this.TimeOfDay < (float)this.HelicopterTime1End && !IsoWorld.instance.helicopter.isActive() && Rand.Next((int)(800.0f * this.getInvMultiplier())) == 0) {
                this.HelicopterTime1Start = (int)((float)this.HelicopterTime1Start + 0.5f);
                IsoWorld.instance.helicopter.pickRandomTarget();
            }
            if (this.NightsSurvived > this.HelicopterDay1 && (SandboxOptions.instance.Helicopter.getValue() == 3 || SandboxOptions.instance.Helicopter.getValue() == 4)) {
                if (SandboxOptions.instance.Helicopter.getValue() == 3) {
                    this.HelicopterDay1 = this.NightsSurvived + Rand.Next(10, 16);
                }
                if (SandboxOptions.instance.Helicopter.getValue() == 4) {
                    this.HelicopterDay1 = this.NightsSurvived + Rand.Next(6, 10);
                }
                this.HelicopterTime1Start = Rand.Next(9, 19);
                this.HelicopterTime1End = this.HelicopterTime1Start + Rand.Next(4) + 1;
            }
        }
        n2 = this.getHour();
        this.updateCalendar(this.getYear(), this.getMonth(), this.getDay(), (int)this.getTimeOfDay(), (int)((this.getTimeOfDay() - (float)((int)this.getTimeOfDay())) * 60.0f));
        float f2 = this.getTimeOfDay();
        if (!GameTime.isGamePaused()) {
            IsoPlayer isoPlayer;
            f = 1.0f / this.getMinutesPerDay() / 60.0f * this.getMultiplier() / 2.0f;
            if (Core.bLastStand) {
                f = 1.0f / this.getMinutesPerDay() / 60.0f * this.getUnmoddedMultiplier() / 2.0f;
            }
            this.setTimeOfDay(this.getTimeOfDay() + f);
            if (this.getHour() != n2) {
                LuaEventManager.triggerEvent("EveryHours");
            }
            if (!GameServer.bServer) {
                for (n = 0; n < IsoPlayer.numPlayers; ++n) {
                    IsoPlayer isoPlayer2 = IsoPlayer.players[n];
                    if (isoPlayer2 == null || !isoPlayer2.isAlive()) continue;
                    isoPlayer2.setHoursSurvived(isoPlayer2.getHoursSurvived() + (double)f);
                }
            }
            if (GameServer.bServer) {
                ArrayList<IsoPlayer> arrayList = GameClient.instance.getPlayers();
                for (int i = 0; i < arrayList.size(); ++i) {
                    isoPlayer = arrayList.get(i);
                    isoPlayer.setHoursSurvived(isoPlayer.getHoursSurvived() + (double)f);
                }
            }
            if (GameClient.bClient) {
                ArrayList<IsoPlayer> arrayList = GameClient.instance.getPlayers();
                for (int i = 0; i < arrayList.size(); ++i) {
                    isoPlayer = arrayList.get(i);
                    if (isoPlayer == null || isoPlayer.isDead() || isoPlayer.isLocalPlayer()) continue;
                    isoPlayer.setHoursSurvived(isoPlayer.getHoursSurvived() + (double)f);
                }
            }
            for (n = 0; n < IsoPlayer.numPlayers; ++n) {
                IsoPlayer isoPlayer3 = IsoPlayer.players[n];
                if (isoPlayer3 == null) continue;
                if (isoPlayer3.isAsleep()) {
                    isoPlayer3.setAsleepTime(isoPlayer3.getAsleepTime() + f);
                    SleepingEvent.instance.update(isoPlayer3);
                    continue;
                }
                isoPlayer3.setAsleepTime(0.0f);
            }
        }
        if (!GameClient.bClient && f2 <= 7.0f && this.getTimeOfDay() > 7.0f) {
            this.setNightsSurvived(this.getNightsSurvived() + 1);
            this.doMetaEvents();
        }
        if (GameClient.bClient) {
            if (this.getTimeOfDay() >= 24.0f) {
                this.setTimeOfDay(this.getTimeOfDay() - 24.0f);
            }
            while (this.ServerNewDays > 0) {
                --this.ServerNewDays;
                this.setDay(this.getDay() + 1);
                if (this.getDay() >= this.daysInMonth(this.getYear(), this.getMonth())) {
                    this.setDay(0);
                    this.setMonth(this.getMonth() + 1);
                    if (this.getMonth() >= 12) {
                        this.setMonth(0);
                        this.setYear(this.getYear() + 1);
                    }
                }
                this.updateCalendar(this.getYear(), this.getMonth(), this.getDay(), (int)this.getTimeOfDay(), this.getMinutes());
                LuaEventManager.triggerEvent("EveryDays");
            }
        } else if (this.getTimeOfDay() >= 24.0f) {
            this.setTimeOfDay(this.getTimeOfDay() - 24.0f);
            this.setDay(this.getDay() + 1);
            if (this.getDay() >= this.daysInMonth(this.getYear(), this.getMonth())) {
                this.setDay(0);
                this.setMonth(this.getMonth() + 1);
                if (this.getMonth() >= 12) {
                    this.setMonth(0);
                    this.setYear(this.getYear() + 1);
                }
            }
            this.updateCalendar(this.getYear(), this.getMonth(), this.getDay(), (int)this.getTimeOfDay(), this.getMinutes());
            LuaEventManager.triggerEvent("EveryDays");
            if (GameServer.bServer) {
                GameServer.syncClock();
                this.lastClockSync = l;
            }
        }
        f = this.Moon * 20.0f;
        if (!ClimateManager.getInstance().getThunderStorm().isModifyingNight()) {
            this.setAmbient(this.TimeLerp(this.getAmbientMin(), this.getAmbientMax(), this.getDusk(), this.getDawn()));
        }
        if (Core.getInstance().RenderShader != null && Core.getInstance().getOffscreenBuffer() != null) {
            this.setNightTint(0.0f);
        }
        this.setMinutesStamp();
        n = (int)((this.getTimeOfDay() - (float)((int)this.getTimeOfDay())) * 60.0f);
        if (n / 10 != this.minutesMod) {
            IsoPlayer[] isoPlayerArray = IsoPlayer.players;
            for (int i = 0; i < isoPlayerArray.length; ++i) {
                IsoPlayer isoPlayer = isoPlayerArray[i];
                if (isoPlayer == null) continue;
                isoPlayer.dirtyRecalcGridStackTime = 1.0f;
            }
            ErosionMain.EveryTenMinutes();
            ClimateManager.getInstance().updateEveryTenMins();
            GameTime.getInstance().updateRoomLight();
            LuaEventManager.triggerEvent("EveryTenMinutes");
            this.minutesMod = n / 10;
            ZomboidRadio.getInstance().UpdateScripts(this.getHour(), n);
        }
        if (this.previousMinuteStamp != this.minutesStamp) {
            LuaEventManager.triggerEvent("EveryOneMinute");
            this.previousMinuteStamp = this.minutesStamp;
        }
        if (GameServer.bServer && (l - this.lastClockSync > 10000L || GameServer.bFastForward)) {
            GameServer.syncClock();
            this.lastClockSync = l;
        }
    }

    private void updateRoomLight() {
    }

    private void setMinutesStamp() {
        this.minutesStamp = (long)this.getWorldAgeHours() * 60L + (long)this.getMinutes();
    }

    public long getMinutesStamp() {
        return this.minutesStamp;
    }

    public boolean getThunderStorm() {
        return ClimateManager.getInstance().getIsThunderStorming();
    }

    private void doMetaEvents() {
        int n = 3;
        if (SandboxOptions.instance.MetaEvent.getValue() == 1) {
            n = -1;
        }
        if (SandboxOptions.instance.MetaEvent.getValue() == 3) {
            n = 2;
        }
        boolean bl = this.bGunFireEventToday = n != -1 && Rand.Next(n) == 0;
        if (this.bGunFireEventToday) {
            this.NumGunFireEvents = 1;
            for (int i = 0; i < this.NumGunFireEvents; ++i) {
                this.GunFireTimes[i] = (float)Rand.Next(18000) / 1000.0f + 7.0f;
            }
        }
        this.randomAmbientToday = true;
    }

    @Deprecated
    public float getAmbient() {
        return ClimateManager.getInstance().getAmbient();
    }

    public void setAmbient(float f) {
        this.Ambient = f;
    }

    public float getAmbientMax() {
        return this.AmbientMax;
    }

    public void setAmbientMax(float f) {
        f = Math.min(1.0f, f);
        this.AmbientMax = f = Math.max(0.0f, f);
    }

    public float getAmbientMin() {
        return this.AmbientMin;
    }

    public void setAmbientMin(float f) {
        f = Math.min(1.0f, f);
        this.AmbientMin = f = Math.max(0.0f, f);
    }

    public int getDay() {
        return this.Day;
    }

    public int getDayPlusOne() {
        return this.Day + 1;
    }

    public void setDay(int n) {
        this.Day = n;
    }

    public int getStartDay() {
        return this.StartDay;
    }

    public void setStartDay(int n) {
        this.StartDay = n;
    }

    public float getMaxZombieCountStart() {
        return 0.0f;
    }

    public void setMaxZombieCountStart(float f) {
        this.MaxZombieCountStart = f;
    }

    public float getMinZombieCountStart() {
        return 0.0f;
    }

    public void setMinZombieCountStart(float f) {
        this.MinZombieCountStart = f;
    }

    public float getMaxZombieCount() {
        return this.MaxZombieCount;
    }

    public void setMaxZombieCount(float f) {
        this.MaxZombieCount = f;
    }

    public float getMinZombieCount() {
        return this.MinZombieCount;
    }

    public void setMinZombieCount(float f) {
        this.MinZombieCount = f;
    }

    public int getMonth() {
        return this.Month;
    }

    public void setMonth(int n) {
        this.Month = n;
    }

    public int getStartMonth() {
        return this.StartMonth;
    }

    public void setStartMonth(int n) {
        this.StartMonth = n;
    }

    public float getNightTint() {
        return ClimateManager.getInstance().getNightStrength();
    }

    public void setNightTint(float f) {
    }

    public float getNight() {
        return ClimateManager.getInstance().getNightStrength();
    }

    public void setNight(float f) {
    }

    public float getTimeOfDay() {
        return this.TimeOfDay;
    }

    public void setTimeOfDay(float f) {
        this.TimeOfDay = f;
    }

    public float getStartTimeOfDay() {
        return this.StartTimeOfDay;
    }

    public void setStartTimeOfDay(float f) {
        this.StartTimeOfDay = f;
    }

    public float getViewDist() {
        return ClimateManager.getInstance().getViewDistance();
    }

    public float getViewDistMax() {
        return this.ViewDistMax;
    }

    public void setViewDistMax(float f) {
        this.ViewDistMax = f;
    }

    public float getViewDistMin() {
        return this.ViewDistMin;
    }

    public void setViewDistMin(float f) {
        this.ViewDistMin = f;
    }

    public int getYear() {
        return this.Year;
    }

    public void setYear(int n) {
        this.Year = n;
    }

    public int getStartYear() {
        return this.StartYear;
    }

    public void setStartYear(int n) {
        this.StartYear = n;
    }

    public int getNightsSurvived() {
        return this.NightsSurvived;
    }

    public void setNightsSurvived(int n) {
        this.NightsSurvived = n;
    }

    public double getWorldAgeHours() {
        float f = this.getNightsSurvived() * 24;
        f = this.getTimeOfDay() >= 7.0f ? (f += this.getTimeOfDay() - 7.0f) : (f += this.getTimeOfDay() + 17.0f);
        return f;
    }

    public double getHoursSurvived() {
        DebugLog.log("GameTime.getHoursSurvived() has no meaning, use IsoPlayer.getHourSurvived() instead");
        return this.HoursSurvived;
    }

    public void setHoursSurvived(double d) {
        DebugLog.log("GameTime.getHoursSurvived() has no meaning, use IsoPlayer.getHourSurvived() instead");
        this.HoursSurvived = d;
    }

    public int getHour() {
        double d = Math.floor(this.getTimeOfDay() * 3600.0f);
        return (int)Math.floor(d / 3600.0);
    }

    public PZCalendar getCalender() {
        this.updateCalendar(this.getYear(), this.getMonth(), this.getDay(), (int)this.getTimeOfDay(), (int)((this.getTimeOfDay() - (float)((int)this.getTimeOfDay())) * 60.0f));
        return this.Calender;
    }

    public void setCalender(PZCalendar pZCalendar) {
        this.Calender = pZCalendar;
    }

    public void updateCalendar(int n, int n2, int n3, int n4, int n5) {
        if (this.Calender == null) {
            this.Calender = new PZCalendar(new GregorianCalendar());
        }
        this.Calender.set(n, n2, n3, n4, n5);
    }

    public float getMinutesPerDay() {
        return this.MinutesPerDay;
    }

    public void setMinutesPerDay(float f) {
        this.MinutesPerDay = f;
    }

    public float getLastTimeOfDay() {
        return this.LastTimeOfDay;
    }

    public void setLastTimeOfDay(float f) {
        this.LastTimeOfDay = f;
    }

    public void setTargetZombies(int n) {
        this.TargetZombies = n;
    }

    public boolean isRainingToday() {
        return this.RainingToday;
    }

    public float getMultiplier() {
        if (!GameServer.bServer && !GameClient.bClient && IsoPlayer.getInstance() != null && IsoPlayer.allPlayersAsleep()) {
            return 200.0f * (30.0f / (float)PerformanceSettings.getLockFPS());
        }
        float f = 1.0f;
        if (GameServer.bServer && GameServer.bFastForward) {
            f = (float)ServerOptions.instance.FastForwardMultiplier.getValue() / this.getDeltaMinutesPerDay();
        } else if (GameClient.bClient && GameClient.bFastForward) {
            f = (float)ServerOptions.instance.FastForwardMultiplier.getValue() / this.getDeltaMinutesPerDay();
        }
        f *= this.Multiplier;
        f *= this.FPSMultiplier;
        f *= this.multiplierBias;
        f *= this.PerObjectMultiplier;
        if (DebugOptions.instance.GameTimeSpeedQuarter.getValue()) {
            f *= 0.25f;
        }
        if (DebugOptions.instance.GameTimeSpeedHalf.getValue()) {
            f *= 0.5f;
        }
        return f *= 0.8f;
    }

    public float getTimeDelta() {
        return this.getMultiplier() / (0.8f * this.multiplierBias) / 60.0f;
    }

    public static float getAnimSpeedFix() {
        return 0.8f;
    }

    public void setMultiplier(float f) {
        this.Multiplier = f;
    }

    public float getServerMultiplier() {
        float f = 10.0f / GameWindow.averageFPS / (float)(PerformanceSettings.ManualFrameSkips + 1);
        float f2 = this.Multiplier * f;
        f2 *= 0.5f;
        if (!GameServer.bServer && !GameClient.bClient && IsoPlayer.getInstance() != null && IsoPlayer.allPlayersAsleep()) {
            return 200.0f * (30.0f / (float)PerformanceSettings.getLockFPS());
        }
        f2 *= 1.6f;
        return f2 *= this.multiplierBias;
    }

    public float getUnmoddedMultiplier() {
        if (!GameServer.bServer && !GameClient.bClient && IsoPlayer.getInstance() != null && IsoPlayer.allPlayersAsleep()) {
            return 200.0f * (30.0f / (float)PerformanceSettings.getLockFPS());
        }
        float f = this.Multiplier * this.FPSMultiplier * this.PerObjectMultiplier;
        return f;
    }

    public float getInvMultiplier() {
        return 1.0f / this.getMultiplier();
    }

    public float getTrueMultiplier() {
        return this.Multiplier * this.PerObjectMultiplier;
    }

    public void save() {
        File file = new File(ZomboidFileSystem.instance.getFileNameInCurrentSave("map_t.bin"));
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return;
        }
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream));
        try {
            instance.save(dataOutputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            dataOutputStream.flush();
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(71);
        dataOutputStream.writeByte(77);
        dataOutputStream.writeByte(84);
        dataOutputStream.writeByte(77);
        dataOutputStream.writeInt(195);
        dataOutputStream.writeFloat(this.Multiplier);
        dataOutputStream.writeInt(this.NightsSurvived);
        dataOutputStream.writeInt(this.TargetZombies);
        dataOutputStream.writeFloat(this.LastTimeOfDay);
        dataOutputStream.writeFloat(this.TimeOfDay);
        dataOutputStream.writeInt(this.Day);
        dataOutputStream.writeInt(this.Month);
        dataOutputStream.writeInt(this.Year);
        dataOutputStream.writeFloat(0.0f);
        dataOutputStream.writeFloat(0.0f);
        dataOutputStream.writeInt(0);
        if (this.table != null) {
            dataOutputStream.writeByte(1);
            this.table.save(dataOutputStream);
        } else {
            dataOutputStream.writeByte(0);
        }
        GameWindow.WriteString(dataOutputStream, Core.getInstance().getPoisonousBerry());
        GameWindow.WriteString(dataOutputStream, Core.getInstance().getPoisonousMushroom());
        dataOutputStream.writeInt(this.HelicopterDay1);
        dataOutputStream.writeInt(this.HelicopterTime1Start);
        dataOutputStream.writeInt(this.HelicopterTime1End);
        ClimateManager.getInstance().save(dataOutputStream);
    }

    public void save(ByteBuffer byteBuffer) throws IOException {
        byteBuffer.putFloat(this.Multiplier);
        byteBuffer.putInt(this.NightsSurvived);
        byteBuffer.putInt(this.TargetZombies);
        byteBuffer.putFloat(this.LastTimeOfDay);
        byteBuffer.putFloat(this.TimeOfDay);
        byteBuffer.putInt(this.Day);
        byteBuffer.putInt(this.Month);
        byteBuffer.putInt(this.Year);
        byteBuffer.putFloat(0.0f);
        byteBuffer.putFloat(0.0f);
        byteBuffer.putInt(0);
        if (this.table != null) {
            byteBuffer.put((byte)1);
            this.table.save(byteBuffer);
        } else {
            byteBuffer.put((byte)0);
        }
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        int n = IsoWorld.SavedWorldVersion;
        if (n == -1) {
            n = 195;
        }
        dataInputStream.mark(0);
        byte by = dataInputStream.readByte();
        byte by2 = dataInputStream.readByte();
        byte by3 = dataInputStream.readByte();
        byte by4 = dataInputStream.readByte();
        if (by == 71 && by2 == 77 && by3 == 84 && by4 == 77) {
            n = dataInputStream.readInt();
        } else {
            dataInputStream.reset();
        }
        this.Multiplier = dataInputStream.readFloat();
        this.NightsSurvived = dataInputStream.readInt();
        this.TargetZombies = dataInputStream.readInt();
        this.LastTimeOfDay = dataInputStream.readFloat();
        this.TimeOfDay = dataInputStream.readFloat();
        this.Day = dataInputStream.readInt();
        this.Month = dataInputStream.readInt();
        this.Year = dataInputStream.readInt();
        dataInputStream.readFloat();
        dataInputStream.readFloat();
        int n2 = dataInputStream.readInt();
        if (dataInputStream.readByte() == 1) {
            if (this.table == null) {
                this.table = LuaManager.platform.newTable();
            }
            this.table.load(dataInputStream, n);
        }
        if (n >= 74) {
            Core.getInstance().setPoisonousBerry(GameWindow.ReadString(dataInputStream));
            Core.getInstance().setPoisonousMushroom(GameWindow.ReadString(dataInputStream));
        }
        if (n >= 90) {
            this.HelicopterDay1 = dataInputStream.readInt();
            this.HelicopterTime1Start = dataInputStream.readInt();
            this.HelicopterTime1End = dataInputStream.readInt();
        }
        if (n >= 135) {
            ClimateManager.getInstance().load(dataInputStream, n);
        }
        this.setMinutesStamp();
    }

    public void load(ByteBuffer byteBuffer) throws IOException {
        int n = 195;
        this.Multiplier = byteBuffer.getFloat();
        this.NightsSurvived = byteBuffer.getInt();
        this.TargetZombies = byteBuffer.getInt();
        this.LastTimeOfDay = byteBuffer.getFloat();
        this.TimeOfDay = byteBuffer.getFloat();
        this.Day = byteBuffer.getInt();
        this.Month = byteBuffer.getInt();
        this.Year = byteBuffer.getInt();
        byteBuffer.getFloat();
        byteBuffer.getFloat();
        int n2 = byteBuffer.getInt();
        if (byteBuffer.get() == 1) {
            if (this.table == null) {
                this.table = LuaManager.platform.newTable();
            }
            this.table.load(byteBuffer, n);
        }
        this.setMinutesStamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        File file = ZomboidFileSystem.instance.getFileInCurrentSave("map_t.bin");
        try (FileInputStream fileInputStream = new FileInputStream(file);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
            Object object = SliceY.SliceBufferLock;
            synchronized (object) {
                SliceY.SliceBuffer.clear();
                int n = bufferedInputStream.read(SliceY.SliceBuffer.array());
                SliceY.SliceBuffer.limit(n);
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(SliceY.SliceBuffer.array(), 0, n));
                this.load(dataInputStream);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
        }
    }

    public int getDawn() {
        return this.dawn;
    }

    public void setDawn(int n) {
        this.dawn = n;
    }

    public int getDusk() {
        return this.dusk;
    }

    public void setDusk(int n) {
        this.dusk = n;
    }

    public KahluaTable getModData() {
        if (this.table == null) {
            this.table = LuaManager.platform.newTable();
        }
        return this.table;
    }

    public boolean isThunderDay() {
        return this.thunderDay;
    }

    public void setThunderDay(boolean bl) {
        this.thunderDay = bl;
    }

    public void saveToPacket(ByteBuffer byteBuffer) throws IOException {
        KahluaTable kahluaTable = GameTime.getInstance().getModData();
        Object object = kahluaTable.rawget("camping");
        Object object2 = kahluaTable.rawget("farming");
        Object object3 = kahluaTable.rawget("trapping");
        kahluaTable.rawset("camping", null);
        kahluaTable.rawset("farming", null);
        kahluaTable.rawset("trapping", null);
        this.save(byteBuffer);
        kahluaTable.rawset("camping", object);
        kahluaTable.rawset("farming", object2);
        kahluaTable.rawset("trapping", object3);
    }

    public int getHelicopterDay1() {
        return this.HelicopterDay1;
    }

    public int getHelicopterDay() {
        return this.HelicopterDay1;
    }

    public void setHelicopterDay(int n) {
        this.HelicopterDay1 = PZMath.max(n, 0);
    }

    public int getHelicopterStartHour() {
        return this.HelicopterTime1Start;
    }

    public void setHelicopterStartHour(int n) {
        this.HelicopterTime1Start = PZMath.clamp(n, 0, 24);
    }

    public int getHelicopterEndHour() {
        return this.HelicopterTime1End;
    }

    public void setHelicopterEndHour(int n) {
        this.HelicopterTime1End = PZMath.clamp(n, 0, 24);
    }

    public static boolean isGamePaused() {
        if (GameServer.bServer) {
            return GameServer.Players.isEmpty() && ServerOptions.instance.PauseEmpty.getValue();
        }
        if (GameClient.bClient) {
            return GameClient.IsClientPaused();
        }
        SpeedControls speedControls = UIManager.getSpeedControls();
        return speedControls != null && speedControls.getCurrentGameSpeed() == 0;
    }

    public static class AnimTimer {
        public float Elapsed;
        public float Duration;
        public boolean Finished = true;
        public int Ticks;

        public void init(int n) {
            this.Ticks = n;
            this.Elapsed = 0.0f;
            this.Duration = (float)(n * 1) / 30.0f;
            this.Finished = false;
        }

        public void update() {
            this.Elapsed += instance.getMultipliedSecondsSinceLastUpdate() * 60.0f / 30.0f;
            if (this.Elapsed >= this.Duration) {
                this.Elapsed = this.Duration;
                this.Finished = true;
            }
        }

        public float ratio() {
            return this.Elapsed / this.Duration;
        }

        public boolean finished() {
            return this.Finished;
        }
    }
}

