/*
 * Decompiled with CFR 0.152.
 */
package zombie;

import fmod.fmod.FMODFootstep;
import fmod.fmod.FMODManager;
import fmod.fmod.FMODSoundBank;
import fmod.fmod.FMODVoice;
import fmod.fmod.FMOD_STUDIO_EVENT_DESCRIPTION;
import fmod.fmod.FMOD_STUDIO_PLAYBACK_STATE;
import fmod.javafmod;
import fmod.javafmodJNI;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import zombie.ZomboidFileSystem;
import zombie.audio.BaseSoundBank;
import zombie.audio.GameSound;
import zombie.audio.GameSoundClip;
import zombie.characters.IsoPlayer;
import zombie.config.ConfigFile;
import zombie.config.ConfigOption;
import zombie.config.DoubleConfigOption;
import zombie.core.Core;
import zombie.core.logger.ExceptionLogger;
import zombie.core.math.PZMath;
import zombie.debug.DebugLog;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.GameSoundScript;
import zombie.util.StringUtils;

public final class GameSounds {
    public static final int VERSION = 1;
    protected static final HashMap<String, GameSound> soundByName = new HashMap();
    protected static final ArrayList<GameSound> sounds = new ArrayList();
    private static final BankPreviewSound previewBank = new BankPreviewSound();
    private static final FilePreviewSound previewFile = new FilePreviewSound();
    public static boolean soundIsPaused = false;
    private static IPreviewSound previewSound;

    public static void addSound(GameSound gameSound) {
        GameSounds.initClipEvents(gameSound);
        assert (!sounds.contains(gameSound));
        int n = sounds.size();
        if (soundByName.containsKey(gameSound.getName())) {
            for (n = 0; n < sounds.size() && !sounds.get(n).getName().equals(gameSound.getName()); ++n) {
            }
            sounds.remove(n);
        }
        sounds.add(n, gameSound);
        soundByName.put(gameSound.getName(), gameSound);
    }

    private static void initClipEvents(GameSound gameSound) {
        if (GameServer.bServer) {
            return;
        }
        for (GameSoundClip gameSoundClip : gameSound.clips) {
            if (gameSoundClip.event == null || gameSoundClip.eventDescription != null) continue;
            gameSoundClip.eventDescription = FMODManager.instance.getEventDescription("event:/" + gameSoundClip.event);
            if (gameSoundClip.eventDescription == null) {
                DebugLog.Sound.warn("No such FMOD event \"%s\" for GameSound \"%s\"", gameSoundClip.event, gameSound.getName());
            }
            gameSoundClip.eventDescriptionMP = FMODManager.instance.getEventDescription("event:/Remote/" + gameSoundClip.event);
            if (gameSoundClip.eventDescriptionMP == null) continue;
            DebugLog.Sound.println("MP event %s", gameSoundClip.eventDescriptionMP.path);
        }
    }

    public static boolean isKnownSound(String string) {
        return soundByName.containsKey(string);
    }

    public static GameSound getSound(String string) {
        return GameSounds.getOrCreateSound(string);
    }

    public static GameSound getOrCreateSound(String string) {
        if (StringUtils.isNullOrEmpty(string)) {
            return null;
        }
        GameSound gameSound = soundByName.get(string);
        if (gameSound == null) {
            DebugLog.General.warn("no GameSound called \"" + string + "\", adding a new one");
            gameSound = new GameSound();
            gameSound.name = string;
            gameSound.category = "AUTO";
            GameSoundClip gameSoundClip = new GameSoundClip(gameSound);
            gameSound.clips.add(gameSoundClip);
            sounds.add(gameSound);
            soundByName.put(string.replace(".wav", "").replace(".ogg", ""), gameSound);
            if (BaseSoundBank.instance instanceof FMODSoundBank) {
                FMOD_STUDIO_EVENT_DESCRIPTION fMOD_STUDIO_EVENT_DESCRIPTION = FMODManager.instance.getEventDescription("event:/" + string);
                if (fMOD_STUDIO_EVENT_DESCRIPTION != null) {
                    gameSoundClip.event = string;
                    gameSoundClip.eventDescription = fMOD_STUDIO_EVENT_DESCRIPTION;
                    gameSoundClip.eventDescriptionMP = FMODManager.instance.getEventDescription("event:/Remote/" + string);
                } else {
                    long l;
                    String string2 = null;
                    if (ZomboidFileSystem.instance.getAbsolutePath("media/sound/" + string + ".ogg") != null) {
                        string2 = "media/sound/" + string + ".ogg";
                    } else if (ZomboidFileSystem.instance.getAbsolutePath("media/sound/" + string + ".wav") != null) {
                        string2 = "media/sound/" + string + ".wav";
                    }
                    if (string2 != null && (l = FMODManager.instance.loadSound(string2)) != 0L) {
                        gameSoundClip.file = string2;
                    }
                }
                if (gameSoundClip.event == null && gameSoundClip.file == null) {
                    DebugLog.General.warn("couldn't find an FMOD event or .ogg or .wav file for sound \"" + string + "\"");
                }
            }
        }
        return gameSound;
    }

    private static void loadNonBankSounds() {
        if (!(BaseSoundBank.instance instanceof FMODSoundBank)) {
            return;
        }
        for (GameSound gameSound : sounds) {
            for (GameSoundClip gameSoundClip : gameSound.clips) {
                if (gameSoundClip.getFile() != null && !gameSoundClip.getFile().isEmpty()) continue;
            }
        }
    }

    public static void ScriptsLoaded() {
        Object object;
        ArrayList<GameSoundScript> arrayList = ScriptManager.instance.getAllGameSounds();
        for (int i = 0; i < arrayList.size(); ++i) {
            object = arrayList.get(i);
            if (((GameSoundScript)object).gameSound.clips.isEmpty()) continue;
            GameSounds.addSound(((GameSoundScript)object).gameSound);
        }
        arrayList.clear();
        GameSounds.loadNonBankSounds();
        GameSounds.loadINI();
        if (Core.bDebug && BaseSoundBank.instance instanceof FMODSoundBank) {
            HashSet<String> hashSet = new HashSet<String>();
            for (GameSound object42 : sounds) {
                for (GameSoundClip gameSoundClip : object42.clips) {
                    if (gameSoundClip.getEvent() == null || gameSoundClip.getEvent().isEmpty()) continue;
                    hashSet.add(gameSoundClip.getEvent());
                }
            }
            object = (FMODSoundBank)BaseSoundBank.instance;
            for (FMODFootstep fMODFootstep : ((FMODSoundBank)object).footstepMap.values()) {
                hashSet.add(fMODFootstep.wood);
                hashSet.add(fMODFootstep.concrete);
                hashSet.add(fMODFootstep.grass);
                hashSet.add(fMODFootstep.upstairs);
                hashSet.add(fMODFootstep.woodCreak);
            }
            for (FMODVoice fMODVoice : ((FMODSoundBank)object).voiceMap.values()) {
                hashSet.add(fMODVoice.sound);
            }
            ArrayList<String> arrayList2 = new ArrayList<String>();
            long[] lArray = new long[32];
            long[] lArray2 = new long[1024];
            int n = javafmodJNI.FMOD_Studio_System_GetBankList(lArray);
            for (int i = 0; i < n; ++i) {
                int n2 = javafmodJNI.FMOD_Studio_Bank_GetEventList(lArray[i], lArray2);
                for (int j = 0; j < n2; ++j) {
                    try {
                        String string = javafmodJNI.FMOD_Studio_EventDescription_GetPath(lArray2[j]);
                        string = string.replace("event:/", "");
                        if (hashSet.contains(string)) continue;
                        arrayList2.add(string);
                        continue;
                    }
                    catch (Exception exception) {
                        DebugLog.General.warn("FMOD cannot get path for " + lArray2[j] + " event");
                    }
                }
            }
            arrayList2.sort(String::compareTo);
            for (String string : arrayList2) {
                DebugLog.General.warn("FMOD event \"%s\" not used by any GameSound", string);
            }
        }
    }

    public static void ReloadFile(String string) {
        try {
            ScriptManager.instance.LoadFile(string, true);
            ArrayList<GameSoundScript> arrayList = ScriptManager.instance.getAllGameSounds();
            for (int i = 0; i < arrayList.size(); ++i) {
                GameSoundScript gameSoundScript = arrayList.get(i);
                if (sounds.contains(gameSoundScript.gameSound)) {
                    GameSounds.initClipEvents(gameSoundScript.gameSound);
                    continue;
                }
                if (gameSoundScript.gameSound.clips.isEmpty()) continue;
                GameSounds.addSound(gameSoundScript.gameSound);
            }
        }
        catch (Throwable throwable) {
            ExceptionLogger.logException(throwable);
        }
    }

    public static ArrayList<String> getCategories() {
        HashSet<String> hashSet = new HashSet<String>();
        for (GameSound gameSound : sounds) {
            hashSet.add(gameSound.getCategory());
        }
        ArrayList arrayList = new ArrayList(hashSet);
        Collections.sort(arrayList);
        return arrayList;
    }

    public static ArrayList<GameSound> getSoundsInCategory(String string) {
        ArrayList<GameSound> arrayList = new ArrayList<GameSound>();
        for (GameSound gameSound : sounds) {
            if (!gameSound.getCategory().equals(string)) continue;
            arrayList.add(gameSound);
        }
        return arrayList;
    }

    public static void loadINI() {
        ConfigFile configFile = new ConfigFile();
        String string = ZomboidFileSystem.instance.getCacheDir() + File.separator + "sounds.ini";
        if (!configFile.read(string)) {
            return;
        }
        if (configFile.getVersion() > 1) {
            return;
        }
        for (ConfigOption configOption : configFile.getOptions()) {
            GameSound gameSound = soundByName.get(configOption.getName());
            if (gameSound == null) continue;
            gameSound.setUserVolume(PZMath.tryParseFloat(configOption.getValueAsString(), 1.0f));
        }
    }

    public static void saveINI() {
        ArrayList<DoubleConfigOption> arrayList = new ArrayList<DoubleConfigOption>();
        for (GameSound object2 : sounds) {
            DoubleConfigOption doubleConfigOption = new DoubleConfigOption(object2.getName(), 0.0, 2.0, 0.0);
            doubleConfigOption.setValue(object2.getUserVolume());
            arrayList.add(doubleConfigOption);
        }
        ConfigFile configFile = new ConfigFile();
        String string = ZomboidFileSystem.instance.getCacheDir() + File.separator + "sounds.ini";
        if (!configFile.write(string, 1, arrayList)) {
            return;
        }
        arrayList.clear();
    }

    public static void previewSound(String string) {
        if (Core.SoundDisabled) {
            return;
        }
        if (!GameSounds.isKnownSound(string)) {
            return;
        }
        GameSound gameSound = GameSounds.getSound(string);
        if (gameSound == null) {
            DebugLog.log("no such GameSound " + string);
            return;
        }
        GameSoundClip gameSoundClip = gameSound.getRandomClip();
        if (gameSoundClip == null) {
            DebugLog.log("GameSound.clips is empty");
            return;
        }
        if (soundIsPaused) {
            if (!GameClient.bClient) {
                long l = javafmod.FMOD_System_GetMasterChannelGroup();
                javafmod.FMOD_ChannelGroup_SetVolume(l, 1.0f);
            }
            soundIsPaused = false;
        }
        if (previewSound != null) {
            previewSound.stop();
        }
        if (gameSoundClip.getEvent() != null) {
            if (previewBank.play(gameSoundClip)) {
                previewSound = previewBank;
            }
        } else if (gameSoundClip.getFile() != null && previewFile.play(gameSoundClip)) {
            previewSound = previewFile;
        }
    }

    public static void stopPreview() {
        if (previewSound == null) {
            return;
        }
        previewSound.stop();
        previewSound = null;
    }

    public static boolean isPreviewPlaying() {
        if (previewSound == null) {
            return false;
        }
        if (previewSound.update()) {
            previewSound = null;
            return false;
        }
        return previewSound.isPlaying();
    }

    public static void fix3DListenerPosition(boolean bl) {
        if (Core.SoundDisabled) {
            return;
        }
        if (bl) {
            javafmod.FMOD_Studio_Listener3D(0, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        } else {
            for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                IsoPlayer isoPlayer = IsoPlayer.players[i];
                if (isoPlayer == null || isoPlayer.Traits.Deaf.isSet()) continue;
                javafmod.FMOD_Studio_Listener3D(i, isoPlayer.x, isoPlayer.y, isoPlayer.z * 3.0f, 0.0f, 0.0f, 0.0f, -1.0f / (float)Math.sqrt(2.0), -1.0f / (float)Math.sqrt(2.0), 0.0f, 0.0f, 0.0f, 1.0f);
            }
        }
    }

    public static void Reset() {
        sounds.clear();
        soundByName.clear();
        if (previewSound != null) {
            previewSound.stop();
            previewSound = null;
        }
    }

    private static interface IPreviewSound {
        public boolean play(GameSoundClip var1);

        public boolean isPlaying();

        public boolean update();

        public void stop();
    }

    private static final class BankPreviewSound
    implements IPreviewSound {
        long instance;
        GameSoundClip clip;
        float effectiveGain;

        private BankPreviewSound() {
        }

        @Override
        public boolean play(GameSoundClip gameSoundClip) {
            if (gameSoundClip.eventDescription == null) {
                DebugLog.log("failed to get event " + gameSoundClip.getEvent());
                return false;
            }
            this.instance = javafmod.FMOD_Studio_System_CreateEventInstance(gameSoundClip.eventDescription.address);
            if (this.instance < 0L) {
                DebugLog.log("failed to create EventInstance: error=" + this.instance);
                this.instance = 0L;
                return false;
            }
            this.clip = gameSoundClip;
            this.effectiveGain = gameSoundClip.getEffectiveVolumeInMenu();
            javafmod.FMOD_Studio_EventInstance_SetVolume(this.instance, this.effectiveGain);
            javafmod.FMOD_Studio_EventInstance_SetParameterByName(this.instance, "Occlusion", 0.0f);
            javafmod.FMOD_Studio_StartEvent(this.instance);
            if (gameSoundClip.gameSound.master == GameSound.MasterVolume.Music) {
                javafmod.FMOD_Studio_EventInstance_SetParameterByName(this.instance, "Volume", 10.0f);
            }
            return true;
        }

        @Override
        public boolean isPlaying() {
            if (this.instance == 0L) {
                return false;
            }
            int n = javafmod.FMOD_Studio_GetPlaybackState(this.instance);
            if (n == FMOD_STUDIO_PLAYBACK_STATE.FMOD_STUDIO_PLAYBACK_STOPPING.index) {
                return true;
            }
            return n != FMOD_STUDIO_PLAYBACK_STATE.FMOD_STUDIO_PLAYBACK_STOPPED.index;
        }

        @Override
        public boolean update() {
            if (this.instance == 0L) {
                return false;
            }
            int n = javafmod.FMOD_Studio_GetPlaybackState(this.instance);
            if (n == FMOD_STUDIO_PLAYBACK_STATE.FMOD_STUDIO_PLAYBACK_STOPPING.index) {
                return false;
            }
            if (n == FMOD_STUDIO_PLAYBACK_STATE.FMOD_STUDIO_PLAYBACK_STOPPED.index) {
                javafmod.FMOD_Studio_ReleaseEventInstance(this.instance);
                this.instance = 0L;
                this.clip = null;
                return true;
            }
            float f = this.clip.getEffectiveVolumeInMenu();
            if (this.effectiveGain != f) {
                this.effectiveGain = f;
                javafmod.FMOD_Studio_EventInstance_SetVolume(this.instance, this.effectiveGain);
            }
            return false;
        }

        @Override
        public void stop() {
            if (this.instance == 0L) {
                return;
            }
            javafmod.FMOD_Studio_EventInstance_Stop(this.instance, false);
            javafmod.FMOD_Studio_ReleaseEventInstance(this.instance);
            this.instance = 0L;
            this.clip = null;
        }
    }

    private static final class FilePreviewSound
    implements IPreviewSound {
        long channel;
        GameSoundClip clip;
        float effectiveGain;

        private FilePreviewSound() {
        }

        @Override
        public boolean play(GameSoundClip gameSoundClip) {
            GameSound gameSound = gameSoundClip.gameSound;
            long l = FMODManager.instance.loadSound(gameSoundClip.getFile(), gameSound.isLooped());
            if (l == 0L) {
                return false;
            }
            this.channel = javafmod.FMOD_System_PlaySound(l, true);
            this.clip = gameSoundClip;
            this.effectiveGain = gameSoundClip.getEffectiveVolumeInMenu();
            javafmod.FMOD_Channel_SetVolume(this.channel, this.effectiveGain);
            javafmod.FMOD_Channel_SetPitch(this.channel, gameSoundClip.pitch);
            if (gameSound.isLooped()) {
                javafmod.FMOD_Channel_SetMode(this.channel, FMODManager.FMOD_LOOP_NORMAL);
            }
            javafmod.FMOD_Channel_SetPaused(this.channel, false);
            return true;
        }

        @Override
        public boolean isPlaying() {
            if (this.channel == 0L) {
                return false;
            }
            return javafmod.FMOD_Channel_IsPlaying(this.channel);
        }

        @Override
        public boolean update() {
            if (this.channel == 0L) {
                return false;
            }
            if (!javafmod.FMOD_Channel_IsPlaying(this.channel)) {
                this.channel = 0L;
                this.clip = null;
                return true;
            }
            float f = this.clip.getEffectiveVolumeInMenu();
            if (this.effectiveGain != f) {
                this.effectiveGain = f;
                javafmod.FMOD_Channel_SetVolume(this.channel, this.effectiveGain);
            }
            return false;
        }

        @Override
        public void stop() {
            if (this.channel == 0L) {
                return;
            }
            javafmod.FMOD_Channel_Stop(this.channel);
            this.channel = 0L;
            this.clip = null;
        }
    }
}

